# Makefile used to compile ADMS C++ output into a dynamic loadable library

# PREFIX can be passed as parameter to make:
# $make -f cpp2lib.make PREFIX='/qucs/prefix/'

# TODO
# * use -O3 by default?
# * set correct flags in each supported platform
# * check library linker flags

######################
## Makefile Parameters
######################

# Module name
MODEL=

# Project dir
PROJDIR=

# Please define
PREFIX=

# Installed headers path
INC=$(PREFIX)/include/qucsator

# Link to Qucs library
LIBS=-lqucsator

ifeq ($(OS),Windows_NT)
  DLLEXT=.dll
  CXX=g++
  CXXFLAGS=-std=gnu++11 -shared -DHAVE_CONFIG_H -DQUCSADMS_DYLOAD -I./  -I$(INC)

  # handle deletion if Windows cmd.exe or MinGW MSYS terminal
  RM=del
  ifeq ($(MSYSTEM),MINGW32)
	RM=rm -f
  endif

else
  UNAME_S := $(shell uname -s)
  ifeq ($(UNAME_S),Linux)
    DLLEXT=.so
    CXX=g++
    CXXFLAGS=-std=gnu++11 -fPIC -shared -rdynamic
    CXXFLAGS:=$(CXXFLAGS) -Wl,-soname,$(MODEL)$(DLLEXT)
    CXXFLAGS:=$(CXXFLAGS) -DHAVE_CONFIG_H -DQUCSADMS_DYLOAD -I./  -I$(INC)
  endif

  ifeq ($(UNAME_S),Darwin)
    DLLEXT=.dylib
    CXX=clang++
    CXXFLAGS=-stdlib=libc++ -dynamiclib -flat_namespace
    CXXFLAGS:=$(CXXFLAGS) -undefined dynamic_lookup -Wl,-headerpad_max_install_names
    CXXFLAGS:=$(CXXFLAGS) -DHAVE_CONFIG_H -DQUCSADMS_DYLOAD -I./  -I$(INC)
  endif

  # common to Linux, Darwin
  LIBS:=$(LIBS) -ldl
endif

# Linker flags
LDFLAGS=-L$(PREFIX)/lib -Wl,-rpath -Wl,$(PROJDIR)

# Required (admsXml generated) sources
SRC=$(MODEL).cpp

# Generated headers
HDR=$(MODEL).h $(MODEL).*.h

# Default
.PHONY: cpp2lib

# Main target
cpp2lib: $(MODEL)$(DLLEXT)

# Build library
.SUFFIXES: .cpp .dll .dylib .so

.cpp.so:
	$(CXX)  $(CXXFLAGS) -o $@ $(SRC) $(LDFLAGS) $(LIBS)

.cpp.dll:
	$(CXX)  $(CXXFLAGS) -o $@ $(SRC) $(LDFLAGS) $(LIBS)

.cpp.dylib:
	$(CXX)  $(CXXFLAGS) -o $@ $(SRC) $(LDFLAGS) $(LIBS)

clean:
	@echo '# cpp2lib - Removing autogenerated files.'
	- $(RM) $(MODEL)$(DLLEXT)
	@echo ''
