/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <DApplication>
#include <DGuiApplicationHelper>
#include <DLog>
#include <DPlatformWindowHandle>
#include <DWidget>
#include <DWidgetUtil>
#include <DWindowManagerHelper>
#include <QDBusInterface>
#include <QDebug>
#include "mainwindow.h"
//#include "normalwindow.h"
#include "environments.h"

#ifndef DISABLE_VIDEO
#include <compositing_manager.h>
#endif

DWIDGET_USE_NAMESPACE

int main(int argc, char *argv[])
{
    using namespace Dtk::Core;

    if (!QString(qgetenv("XDG_CURRENT_DESKTOP")).toLower().startsWith("deepin")) {
        setenv("XDG_CURRENT_DESKTOP", "Deepin", 1);
    }

    /* 平台支持播放时才对播放视频做相关设置 */
    #ifndef DISABLE_VIDEO
    /* 规避兼容103x环境下编译构建失败的问题，因为103x环境无dmr::utils::first_check_wayland_env()接口 */
    #if (DTK_VERSION > DTK_VERSION_CHECK(5, 4, 1, 0))
    /* 适配wayland系统环境 */
    if (dmr::utils::first_check_wayland_env()) {
        setenv("PULSE_PROP_media.role", "video", 1);
#ifndef __x86_64__
        QSurfaceFormat format;
        format.setRenderableType(QSurfaceFormat::OpenGLES);
        format.setDefaultFormat(format);
#endif
    }
    #endif
    #endif

    QDateTime current = QDateTime::currentDateTime();
    qDebug() << "LOG_FLAG"
             << QDateTime::currentDateTime().toString(Qt::ISODateWithMs)
             << "start to initaalize app";
    qint64 initializeAppStartMs = current.toMSecsSinceEpoch();

    QGuiApplication::setAttribute(Qt::AA_UseHighDpiPixmaps);
    DApplication *a = nullptr;

    #if (DTK_VERSION < DTK_VERSION_CHECK(5, 4, 0, 0))
        a = new DApplication(argc, argv);
    #else
        a = DApplication::globalApplication(argc, argv);
    #endif

    a->setAttribute(Qt::AA_UseHighDpiPixmaps);
    a->setApplicationName("dde-introduction");
    a->setAttribute(Qt::AA_ForceRasterWidgets, false);

    // dapplication default setting is true

    if (!a->setSingleInstance(a->applicationName(), DApplication::UserScope)) {
        qWarning() << QString("There is a %1 running!!").arg(a->applicationName());
        return -1;
    }

    a->setAutoActivateWindows(true);
    a->setOrganizationName("deepin");
    a->setApplicationVersion(VERSION);
    //因为快速启动turbo原因，loadTranslator函数需要放在所有QObject::tr之前，setApplicationName之后
    a->loadTranslator();
    a->setApplicationDisplayName(QObject::tr("Welcome"));

    /* 必须在setOrganizationName("deepin")之后设置才生效 */
    Dtk::Core::DLogManager::registerConsoleAppender();
    Dtk::Core::DLogManager::registerFileAppender();

    QDBusConnection dbus = QDBusConnection::sessionBus();
    dbus.registerService("com.deepin.introduction");

    QCommandLineParser cmdParser;
    cmdParser.setApplicationDescription("dde-introduction");
    cmdParser.addHelpOption();
    cmdParser.addVersionOption();
    cmdParser.process(*a);

    DGuiApplicationHelper::instance()->setPaletteType(DGuiApplicationHelper::LightType);

    static const QDate buildDate = QLocale(QLocale::English).toDate(QString(__DATE__).replace("  ", " 0"), "MMM dd yyyy");
    QString t_date = buildDate.toString("MMdd");
    // Version Time
    a->setApplicationVersion(DApplication::buildVersion(t_date));
    QSettings setting("deepin", "dde-introduction");
    bool isFirst = setting.value("IsFirst", true).toBool();
    if (isFirst) {
        int maxTest = 0;
        QString comStr;
        QString filePath = "/usr/bin/gpuinfo";
        QFile file(filePath);
        if (file.exists()) {
            while (comStr.isEmpty()) {
                QProcess process;
                QStringList list;
                list << "-c" << "gpuinfo";
                process.start("gpuinfo");
                process.waitForFinished();
                process.waitForReadyRead();

                comStr = process.readAllStandardOutput();
                if (!comStr.isEmpty())
                    break;
                maxTest++;
                if (maxTest > 5)
                    break;
                QThread::msleep(500);
            }
        } else {
            while (comStr.isEmpty()) {
                QProcess process;
                QStringList list;
                list << "-c" << "lspci | grep -i vga";
                process.start("/bin/bash", list);
                process.waitForFinished();
                process.waitForReadyRead();

                comStr = process.readAllStandardOutput();
                if (!comStr.isEmpty())
                    break;
                maxTest++;
                if (maxTest > 5)
                    break;
                QThread::msleep(500);
            }

        }
        qInfo() << comStr;

        if (comStr.isEmpty())
            QThread::sleep(3);
    }

    setlocale(LC_NUMERIC, "C");

    MainWindow w;
    moveToCenter(&w);
    w.show();
    w.delayInitVideo();

    dbus.registerObject("/com/deepin/introduction", &w, QDBusConnection::ExportScriptableSlots);

    current = QDateTime::currentDateTime();
    qDebug() << "LOG_FLAG"
             << QDateTime::currentDateTime().toString(Qt::ISODateWithMs)
             << " finish to initialize app";

    qint64 inittalizeApoFinishMs = current.toMSecsSinceEpoch();
    qint64 time = inittalizeApoFinishMs - initializeAppStartMs;
    qInfo() << QString("[GRABPOINT] POINT-01  time=%1ms").arg(time);


    return a->exec();
}
