/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WIDGETMANAGER_H
#define WIDGETMANAGER_H

#include "basemodulewidget.h"
#include "modules/videowidget.h"
#include "modules/desktopmodemodule.h"
#include "modules/iconmodule.h"

#include <QObject>
#include <QJsonDocument>
#include <QProcess>

#include <DWindowManagerHelper>

enum PageType {
    UnknownType = 0,
    videoType,
    StyleType,
    FinishType
};

struct IntroductionWidget {
    BaseModuleWidget* w;
    PageType type;

    IntroductionWidget () {
        w = nullptr;
        type = PageType::UnknownType;
    }
};

struct WidgetStruct {
    QList<IntroductionWidget> videoWidgetList;
    QList<IntroductionWidget> otherWidgetList;
    int currentVideo;
    int current;
    int size;

    QList<QUrl> videoFileList;

    void append(IntroductionWidget w) {
        if (w.w) {
            (w.type == PageType::videoType ? videoWidgetList : otherWidgetList).append(w);
            size = videoWidgetList.size() + otherWidgetList.size();
        }
    }

    WidgetStruct () {
        current = -1;
        currentVideo = -1;
    }
};

DGUI_USE_NAMESPACE
//发送信息到DBUS改变电脑的桌面样式、运行模式、图标主题类
class WidgetManager : public QObject
{
    Q_OBJECT

public:
    static WidgetManager* Instance();
    void setParents(QWidget*);
    int getWidgetSize();
    bool canHandoff();
    void finishedInit();

    IntroductionWidget getCurrentWidget();
    IntroductionWidget handoffNextWidget();
    IntroductionWidget handoffPrevWidget();

    void setVideoMute(IntroductionWidget &introWidget, bool b);

public slots:
    void delayInit();

private slots:
    void slotShowMore();

signals:
    void showMore();

private:
    explicit WidgetManager(QObject *parent = nullptr);
    void initPageType();

    IntroductionWidget initVideoModule(QUrl file);
    IntroductionWidget initDesktopModeModule();
    IntroductionWidget initIconModule();

private:
    QWidget *m_fakerWidget {nullptr};
    WidgetStruct m_widgetList;
    QEventLoop m_loop;
};

#endif // WORKER_H
