#!/bin/bash

set -ex

SOROUCE_DIR=$1
OUTPUT_DIR=$2

echo "Starting cuda generate script"
if [ -z "${CUDACXX}" ]; then
    if [ -x /usr/local/cuda/bin/nvcc ]; then
        export CUDACXX=/usr/local/cuda/bin/nvcc
    else
        # Try the default location in case it exists
        export CUDACXX=$(command -v nvcc)
    fi
fi

#https://docs.nvidia.com/cuda/cuda-c-programming-guide/index.html?highlight=compute_#ptx-compatibility
#or nvcc --help #--gpu-architecture <arch>
CMAKE_DEFS="-DBUILD_SHARED_LIBS=ON -DLLAMA_NATIVE=OFF -DLLAMA_CUDA=ON -DLLAMA_AVX=ON -DLLAMA_AVX2=ON -DLLAMA_AVX512=OFF -DLLAMA_FMA=ON -DLLAMA_F16C=ON -DLLAMA_BUILD_EXAMPLES=OFF -DLLAMA_BUILD_TESTS=OFF -DCMAKE_CUDA_ARCHITECTURES=all"
mkdir -p build
cd build
cmake ${SOROUCE_DIR} ${CMAKE_DEFS}
make -j8
mv libllama.so ${OUTPUT_DIR}/libllama-cuda.so
echo "end cuda generate script"