// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef OVPLUGIN_H
#define OVPLUGIN_H

#include "inferenceplugin.h"

namespace ov {
class Core;
}

GLOBAL_BEGIN_NAMESPACE

class OVPlugin : public QObject, public InferencePlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID InferencePlugin_Meta_IID FILE "plugin.json")
    Q_INTERFACES(GLOBAL_NAMESPACE::InferencePlugin)
public:
    explicit OVPlugin(QObject *parent = nullptr);
    ~OVPlugin();
    bool initialize(const QVariantHash &params) override;
    ModelProxy* loadModel(const QString &name, const QString &imgDir, const QVariantHash &params);
signals:

public slots:
private:
    ov::Core *ovCore = nullptr;
};

GLOBAL_END_NAMESPACE

#endif // OVPLUGIN_H
