// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "backendloader_p.h"
#include "inferenceplugin.h"

#include <QJsonArray>

#include <iostream>

GLOBAL_USE_NAMESPACE

BackendMetaObjectPrivate::BackendMetaObjectPrivate(BackendMetaObject *parent) : q(parent)
{

}

QJsonValue BackendMetaObjectPrivate::metaData(const QString &key) const
{
    if (key.isEmpty() || loader.isNull())
        return QString();

    QJsonObject &&metaJson = loader->metaData();
    QJsonObject &&dataJson = metaJson.value("MetaData").toObject();
    return dataJson.value(key);
}

BackendMetaObject::BackendMetaObject() : d(new BackendMetaObjectPrivate(this))
{

}

QString BackendMetaObject::fileName() const
{
    QString ret;
    if (d->loader)
        ret = d->loader->fileName();
    return ret;
}

QString BackendMetaObject::iid() const
{
    QJsonObject &&metaJson = d->loader->metaData();
    QString &&value = metaJson.value("IID").toString();
    return value;
}

QString BackendMetaObject::name() const
{
    return d->metaData("name").toString();
}

QString BackendMetaObject::version() const
{
    return d->metaData("version").toString();
}

QStringList BackendMetaObject::suportedArchitectures() const
{
    QStringList ret;
    auto array =  d->metaData("model").toObject().value("architectures").toArray();
    for (const QJsonValue &value : array) {
        QString str = value.toString();
        if (!str.isEmpty())
            ret.append(str);
    }

    return ret;
}

QStringList BackendMetaObject::suportedFormats() const
{
    QStringList ret;
    auto array =  d->metaData("model").toObject().value("formats").toArray();
    for (const QJsonValue &value : array) {
        QString str = value.toString();
        if (!str.isEmpty())
            ret.append(str);
    }

    return ret;
}

void BackendMetaObject::setExtra(const QString &key, const QVariant &value)
{
    if (key.isEmpty())
        return;

    d->extra.insert(key, value);
}

QVariant BackendMetaObject::extra(const QString &key, const QVariant &defaultValue) const
{
    return d->extra.value(key, defaultValue);
}

