package coremodules

import (
	"encoding/json"
	"fmt"
	"runtime"
	"strings"

	"github.com/go-resty/resty/v2"
	"github.com/heysion/deepin-system-update-tools/internal/config/cache"
	"github.com/heysion/deepin-system-update-tools/internal/controller/check"
	"github.com/heysion/deepin-system-update-tools/pkg/log"
	runcmd "github.com/heysion/deepin-system-update-tools/pkg/utils/cmd"
	"github.com/heysion/deepin-system-update-tools/pkg/utils/fs"
	response "github.com/heysion/deepin-system-update-tools/pkg/utils/http"
	"github.com/spf13/cobra"
)

// versionCmd represents the version command
var fetchCmd = &cobra.Command{
	Use:   "fetch",
	Short: "Fetch update meta data",
	Long:  `Fetch update meta data with system update platform.`,
	Run: func(cmd *cobra.Command, args []string) {
		log.Debugln("fetch")
		client := resty.New()

		resp, err := client.R().
			SetHeader("Content-Type", "application/json").
			SetBody(`{"username":"testuser", "password":"testpass"}`).
			SetResult(&response.Response{}). // or SetResult(AuthSuccess{}).
			Post("http://127.0.0.1:8080" + "/fetch")

		if err != nil {
			log.Errorln(err)
			if flags, _ := ThisCacheInfo.UpdateMetaInfo.IsEmpty(); flags {
				log.Fatalf("Have not found update meta info!")
				return
			}
		}
		// log.Debugln(resp)
		log.Debugln(resp.StatusCode())
		// log.Debugln(resp.Result())
		respResult := resp.Result().(*response.Response)
		if respResult != nil {
			log.Debugln(respResult)
			if flags, _ := ThisCacheInfo.UpdateMetaInfo.IsEmpty(); flags {
				log.Fatalf("Have not found update meta info!")
				return
			}
		} else {
			ThisCacheInfo.UpdateTime = respResult.Time
			//CacheCfg.UUID = respResult.UUID
		}
		convertResponseData, err := json.Marshal(respResult.Data)
		if err != nil {
			log.Errorln(err)
		}
		updateResult := cache.UpdateInfo{}
		if err := json.Unmarshal(convertResponseData, &updateResult); err != nil {
			log.Debugln(err)
			if flags, _ := ThisCacheInfo.UpdateMetaInfo.IsEmpty(); flags {
				log.Fatalf("Have not found update meta info!")
				return
			}
		} else {
			ThisCacheInfo.UpdateMetaInfo = updateResult
		}

		// log.Debugln(updateResult)

		// bash -c "dpkg -l | tail -n +6 | awk '{print $1,$2,$3}'"
		outputStream, err := runcmd.RunnerOutput(10, "bash", "-c", "dpkg -l | tail -n +6 | awk '{print $1,$2,$3}'")
		if err != nil {
			log.Errorln(err)
		}
		// log.Debugln(outputStream)

		appInstalledList := make([]cache.AppState, 1000)
		appHoldedList := make([]cache.AppState, 10)
		appFailedList := make([]cache.AppState, 10)

		outputLines := strings.Split(outputStream, "\n")

		for _, line := range outputLines {
			spv := strings.Split(line, " ")
			if len(spv) != 3 {
				log.Debugf("failed format: %s len: %d", spv, len(spv))
				continue
			}
			appState := cache.AppState{}
			appState.Name = strings.Split(spv[1], ":")[0]
			appState.Version = spv[2]
			// log.Debugf("%s,%s\n", string(spv[1]), string(spv[2]))
			switch spv[0] {
			case "ii":
				appState.State = "ii"
				appInstalledList = append(appInstalledList, appState)
			case "hi":
				appState := cache.AppState{}
				appState.State = "hi"
				appHoldedList = append(appHoldedList, appState)
			case "":
				fallthrough
			default:
				appState := cache.AppState{}
				appState.State = cache.PkgState(spv[0])
				appFailedList = append(appFailedList, appState)
			}

		}

		// check network status
		for idx, repoInfo := range ThisCacheInfo.UpdateMetaInfo.RepoBackend {
			if err := response.DialUrlHttpGet(repoInfo.URL, 5); err != nil {
				if err := ThisCacheInfo.UpdateMetaInfo.RemovedRepoInfo(idx); err != nil {
					log.Errorf("RemovedRepoInfo error: %+v", err)
				}
				log.Errorf("Error connecting: %+v", err)
			}
			log.Debugf("check network status:[%d] info:%+v", idx, repoInfo)
		}

		log.Debugf("repolist: %+v", ThisCacheInfo.UpdateMetaInfo.RepoBackend)

		// TODO:(heysion) if the repo is local skip this check
		// repoUrl.Type == local
		// fetch repo data
		// http://pools.uniontech.com/desktop-professional/dists/eagle/1050/main/binary-amd64/Packages.gz
		// outputStream, err := runcmd.RunnerOutput(
		// TODO:(heysion) push to hash (name+version){appinfo} search by applist with update

		appinfoHash := make(map[string]cache.AppInfo, 100)
		for _, repoInfo := range ThisCacheInfo.UpdateMetaInfo.RepoBackend {
			for _, component := range repoInfo.Components {
				PackagesInfo := fmt.Sprintf("%s/dists/%s/%s/binary-%s/Packages.gz",
					repoInfo.URL,
					repoInfo.Suite,
					component,
					runtime.GOARCH)
				log.Debugf("PackagesInfo: %+v [%d]", PackagesInfo, len(appinfoHash))

				if _, filepath, err := response.DownloadFileHttpGet(PackagesInfo, ThisCacheInfo.WorkStation+"/repo/"+component, 60); err != nil {
					log.Errorf("Download: %v faile!", err)
				} else {

					// TODO:(heysion) set download repository packages.gz to cache config
					func() {
						// TODO:(heysion) fix this function
						cmd := fmt.Sprintf(`zcat %s | egrep "^Version:|^Package:|^SHA1:|^SHA256:|^Filename:|^$"`, filepath)

						outputStream, err := runcmd.RunnerOutput(10, "bash", "-c", cmd)
						if err != nil {
							log.Errorln(err)
						}
						// log.Debugf("Read %s", outputStream)
						for _, outStream := range strings.Split(outputStream, "\n\n") {
							// log.Debugf("Read %s", outStream)
							appByGz := cache.AppInfo{}
							for _, outLineString := range strings.Split(outStream, "\n") {
								// log.Debugf("Read %s[%d]", outLine, len(outLine))
								if len(outLineString) > 7 {

									splitValue := func(vstr string) string {
										vlist := strings.Split(vstr, ": ")
										// log.Debugf("splitValue:%+v", vlist)
										return vlist[1]
									}

									if strings.HasPrefix(outLineString, "Version:") {
										appByGz.Version = splitValue(outLineString)
									}

									if strings.HasPrefix(outLineString, "Package:") {
										appByGz.Name = splitValue(outLineString)
									}
									if strings.HasPrefix(outLineString, "SHA1:") {
										appByGz.HashSha1 = splitValue(outLineString)
									}
									if strings.HasPrefix(outLineString, "SHA256:") {
										appByGz.HashSha256 = splitValue(outLineString)
									}

									if strings.HasPrefix(outLineString, "Filename:") {
										appByGz.Filename = splitValue(outLineString)
									}

								} else {
									continue
								}

							}
							// log.Debugf("show : %+v", appByGz)

							appByGz.Url = repoInfo.URL + "/" + appByGz.Filename

							appinfoHash[fmt.Sprintf("%s#%s", appByGz.Name, appByGz.Version)] = appByGz
							// appWithRepo = append(appWithRepo, appByGz)

						}

					}()
					log.Debugf("Download %+v", len(appinfoHash))
				}
			}
		}

		for idx, app := range ThisCacheInfo.UpdateMetaInfo.PkgList {
			appinfo, ok := appinfoHash[fmt.Sprintf("%s#%s", app.Name, app.Version)]
			if ok {
				//log.Debugf("app info : %+v", appinfo)
				ThisCacheInfo.UpdateMetaInfo.PkgList[idx].Url = appinfo.Url
				ThisCacheInfo.UpdateMetaInfo.PkgList[idx].HashSha1 = appinfo.HashSha1
				ThisCacheInfo.UpdateMetaInfo.PkgList[idx].HashSha256 = appinfo.HashSha256
			} else {
				// check failed ,not found app info to backend repo
				log.Errorf("check failed : %+v", app)
			}
		}
		log.Debugf("appinfo hash : %+v", ThisCacheInfo.UpdateMetaInfo.PkgList)

		// release appinfo hash memory
		appinfoHash = map[string]cache.AppInfo{}

		for _, app := range ThisCacheInfo.UpdateMetaInfo.PkgList {

			filename, filepath, err := response.DownloadFileHttpGet(app.Url, ThisCacheInfo.WorkStation+"/deb/", 60)
			if err != nil {
				log.Errorf("download pkg failed : %v", err)
			}

			if err := fs.CheckFileHashSha1(filepath, app.HashSha1); err != nil {
				log.Errorf("download file %s hash failed : %v", filename, err)
			}

			if err := fs.CheckFileHashSha256(filepath, app.HashSha256); err != nil {
				log.Errorf("download file %s hash failed : %v", filename, err)
			}

			log.Debugf("download file %s , %s", filename, filepath)

		}

		// check pkg with overlayfs
		if err := check.EmulationUpdate(&ThisCacheInfo); err != nil {
			log.Debugf("%+v", err)
		}

	},
}

func init() {
	//rootCmd.AddCommand(fetchCmd)
}
