<!--
title: "LiteSpeed monitoring with Netdata"
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/litespeed/README.md"
sidebar_label: "LiteSpeed"
learn_status: "Published"
learn_topic_type: "References"
learn_rel_path: "Integrations/Monitor/Application Performance Monitoring"
-->

# LiteSpeed collector

Collects web server performance metrics for network, connection, requests, and cache.  

It produces:

1.  **Network Throughput HTTP** in kilobits/s

    -   in
    -   out

2.  **Network Throughput HTTPS** in kilobits/s

    -   in
    -   out

3.  **Connections HTTP** in connections

    -   free
    -   used

4.  **Connections HTTPS** in connections

    -   free
    -   used

5.  **Requests** in requests/s

    -   requests

6.  **Requests In Processing** in requests

    -   processing

7.  **Public Cache Hits** in hits/s

    -   hits

8.  **Private Cache Hits** in hits/s

    -   hits

9.  **Static Hits** in hits/s

    -   hits

## Configuration

Edit the `python.d/litespeed.conf` configuration file using `edit-config` from the Netdata [config
directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md), which is typically at `/etc/netdata`.

```bash
cd /etc/netdata   # Replace this path with your Netdata config directory, if different
sudo ./edit-config python.d/litespeed.conf
```

```yaml
local:
  path  : 'PATH'
```

If no configuration is given, module will use "/tmp/lshttpd/".




### Troubleshooting

To troubleshoot issues with the `litespeed` module, run the `python.d.plugin` with the debug option enabled. The 
output will give you the output of the data collection job or error messages on why the collector isn't working.

First, navigate to your plugins directory, usually they are located under `/usr/libexec/netdata/plugins.d/`. If that's 
not the case on your system, open `netdata.conf` and look for the setting `plugins directory`. Once you're in the 
plugin's directory, switch to the `netdata` user.

```bash
cd /usr/libexec/netdata/plugins.d/
sudo su -s /bin/bash netdata
```

Now you can manually run the `litespeed` module in debug mode:

```bash
./python.d.plugin litespeed debug trace
```

