#include "UtilsTest.h"
#include "utils/Utils.h"
#include <QDebug>

TEST_F(UtilsTest, getCpuInfo)
{
    CpuInfo cpu;
    bool ret = Utils::getCpuInfo(cpu);
    EXPECT_TRUE(ret);
}

TEST_F(UtilsTest, lspciVGA)
{
    bool ret = false;
    QString displayDriver = "unKnow";
    QStringList infoList = Utils::getCmdListReturn("lspci | grep VGA");
    if (infoList.size() > 0) {
        displayDriver = infoList.first();
        ret = !displayDriver.isEmpty();
    }
    EXPECT_TRUE(ret);
}

TEST_F(UtilsTest, getLshwInfo)
{
    bool ret = false;
    QMap<QString, QMap<QString, QString>> mapInfo;
    ret = Utils::getLshwInfo(mapInfo);
    EXPECT_TRUE(ret);
}

TEST_F(UtilsTest, getVGAFromLshw)
{
    bool ret = false;
    QString vga;
    ret = Utils::getVGAFromLshw(vga);
    EXPECT_TRUE(ret);
}

TEST_F(UtilsTest, getFsTypeByDir)
{
    bool ret = false;
    QString dir = "/home/ut003822@uos/Desktop/a  11 a"; // not exist
    QString fstype;
    QString devPath;
    ret = Utils::getFsTypeAndDevicePathByDir(dir, fstype, devPath);
    EXPECT_FALSE(ret);

    dir = "/media/ut003822@uos/zxm/test"; // 外接移动硬盘
    ret = Utils::getFsTypeAndDevicePathByDir(dir, fstype, devPath);
    EXPECT_TRUE(ret);

    ret = Utils::isDeviceRemoveble(devPath);
    EXPECT_TRUE(ret);

    dir = "/media/ut003822@uos/data/zxm/soft/install";  // 主机内置的另一块硬盘
    ret = Utils::getFsTypeAndDevicePathByDir(dir, fstype, devPath);
    EXPECT_TRUE(ret);
    ret = Utils::isDeviceRemoveble(devPath);
    EXPECT_FALSE(ret);
}

TEST_F(UtilsTest, isOStree)
{
    bool ret = Utils::isOStree();
    qInfo()<<"1 ret = "<<ret;
    sleep(31);  // deepin-upgrade-manager dbus服务默认30s后退出
    ret = Utils::isOStree(); // 再次调用，验证是否可以成功拉起deepin-upgrade-manager dbus服务
    qInfo()<<"2 ret = "<<ret;

    ret = Utils::isOStree();
    qInfo()<<"3 ret = "<<ret;

    sleep(31);
    ret = Utils::isOStree();
    EXPECT_TRUE(ret);
}

TEST_F(UtilsTest, getUILayoutType)
{
    int modlue = UI::UI_BACKUP_MODULE;
    int ret = Utils::getUILayoutType(modlue);
    qInfo()<<"1 ret = "<<ret<<", modlue = "<<modlue;
    EXPECT_TRUE(ret != -1);

    modlue = UI::UI_RESTORE_MODULE;
    ret = Utils::getUILayoutType(modlue);
    qInfo()<<"2 ret = "<<ret<<", modlue = "<<modlue;
    EXPECT_TRUE(ret != -1);

    modlue = UI::UI_ADVANCE_MODULE;
    ret = Utils::getUILayoutType(modlue);
    qInfo()<<"3 ret = "<<ret<<", modlue = "<<modlue;
    EXPECT_TRUE(ret != -1);
}
