#ifndef UOS_RECOVERY_UIMGOPERATE_H
#define UOS_RECOVERY_UIMGOPERATE_H

#include <QObject>
#include "utils/Device.h"

struct GhostCheckItem {
    int diskNum = 0;
    quint64 diskSize = 0;
    QString bootLoader = "";
    QString arch = "";
    QString displayCard = "";
    QString cpu = "";
    bool readUimg = false;
    bool readFile = false;
    bool installPos = false;

    QJsonObject marshal();
    void unmarshal(const QJsonObject &jsonObject);
};

class RsyncTask;

class UImgOperate : public QObject
{
    Q_OBJECT

public:
    UImgOperate();
    virtual ~UImgOperate();

    enum CheckFileExitCode {
        CanInstall = 0,    // 0---可以安装、1---谨慎安装（架构不同、CPU型号不匹配、显卡不匹配） 、2---不能安装（磁盘大小不足）
        CarefullyInstall,
        CanNotInstall
    };
    enum InstallFileExitCode {
        InstallSuccess = 0,// 0---安装成功、1---MD5校验失败、2---解压失败、3---拷贝失败、4---未知错误
        CheckMD5Failed,
        UnpackFailed,
        Installing,
        CopyFailed,
        UnknowError,
        CopyConfigFailed,
        MountImgFileFailed,
        DoPartFailed,
        DoBindFailed,
        UpdateFstabFailed,
        UpdateGrubFailed,
        SetupUDisksRulesFailed,
        SetSystemLevelFailed,
        UpdateCrypttabFailed
    };

public:
    CheckFileExitCode checkImgFile(const QString& imgFile, const QStringList &destDevices);
    InstallFileExitCode installImgFile(const QString& imgFile, const QStringList &destDevices);
    bool mountFile(const QString &imgFile);
    bool umountFile();
    bool renameVgName(const QString &partitionFile, const QStringList &sysVgNameList);
    static bool updateCrypttab();
    static QMap<QString, DeviceInfoPtr> matchDevices(QList<GhostDiskInfo> &gDiskList, DeviceInfoList &installDeviceList);
    static bool updateUdisksRules(const QString &rootmnt, const QString &fstabPath, const QString &rulePath);

private slots:
    void progressChangeSlot(const QJsonObject &value);
    void doneError();
    void doneSuccess();

private:
    bool updatePolicyDeviceInfo(QString &err);
    bool doPart(QString &err);
    bool doBind(QString &err);
    bool updateFstab(QString &err);
    bool updateGrub(QString &err);
    bool installBootLoader_x86_efi(QString &err);
    bool installBootLoader_x86_legacy(QString &err);
    bool installBootLoader_arm_efi(QString &err);
    bool setupBootLoader(QString &err);
    bool backUpConfFiles(QString &err);
    bool checkImgFileInDisk(const QString &imgFile, const QStringList &devices, QString &err);
    bool checkDiskSize(const qint64 &deviceSize, const QStringList &devices, QString &err);
    bool checkDiskSize(QList<GhostDiskInfo>& srcDiskInfoList, const QStringList &devices, GhostCheckItem &src,
        GhostCheckItem &dest);
    bool getDeletePartList(QJsonArray &partList, QString &err);
    bool updatePartStartEndPoint(QJsonObject &partObj, const QJsonObject &prePartObj, const qint64 &partTotalBytes,
        const qint64 &devBytes, const qint64 &sectorSize, bool isSameDisk);
    bool getPlatformSize(int &size, QString &err);
    bool copyGrubFile(const QString &src, const QString &dest, QString &err);
    void replaceRootUuidContent(const QString &srcFilePath, const QString &destFilePath, const QJsonArray &devInfos);
    static QStringList getUdiskRules(const QString &rootmnt, const QStringList &cryptLuksUuidList,
        const QMap<QString, QString> &sysUuidMountPointMap);
    static int getOSMajorVersion(const QString &rootmnt);

private:
    RsyncTask *m_rsyncTask = nullptr;
    QStringList m_destDevices = {};
    QList<GhostDiskInfo> m_ghostDiskInfoList;
};


#endif //UOS_RECOVERY_UIMGOPERATE_H
