//
// Created by ut003822@uos on 2022/6/20.
//

#ifndef UOS_RECOVERY_USERDATABACKUPSELECTWIDGET_H
#define UOS_RECOVERY_USERDATABACKUPSELECTWIDGET_H

#include "common/SelectFileTreeView.h"
#include "utils/global.h"
#include <DWidget>
#include <DGuiApplicationHelper>
#include <DFileChooserEdit>
#include <DLineEdit>
#include <DTreeWidget>
#include <DSuggestButton>
#include <QStandardItemModel>
#include <DComboBox>
#include <DLabel>
#include <DSpinner>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class UserDataBackupSelectWidget : public DWidget
{
    Q_OBJECT

public:
    explicit UserDataBackupSelectWidget(DWidget *parent = nullptr);
    void initUI();
    void setDestDevice(const QJsonObject &jsonObject);
    QString getDestDeviceUUID();
    void setFiles(const QList<FileItem> &fileItemList);
    QList<FileItem> getExclude();
    void setTips(const QString &tips);
    void setTipsStyleSheet(const QString &styleSheet);
    void setNextBtnEnabled(bool enabled);
    QString getCurComboBoxText();
    void startSpinner();
    void stopSpinner();

Q_SIGNALS:
    void cancel();
    void next();

private Q_SLOTS:
    void onThemeChange();
    void onItemClicked(const QModelIndex &index);
    void onTreeViewItemChanged(QStandardItem * item);
    void onCheckAllChanged(Qt::CheckState checkState);
    void onComboBoxCurrentIndexChanged(int index);

private:
    void setChildState(QStandardItem *curItem, Qt::CheckState checkState);
    void setParentState(QStandardItem *curItem, Qt::CheckState checkState);
    void updateCheckAllState();

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
    SelectFileTreeView *m_treeView = nullptr;
    QStandardItemModel *m_model = nullptr;
    DSpinner *m_spinner = nullptr;
    DLabel *m_tips = nullptr;
    DPushButton *m_cancelBtn = nullptr;
    DSuggestButton *m_nextBtn = nullptr;
    DComboBox *m_comboBox;
    QList<Partition> m_partitionList;
    bool m_itemClicked = false;
    bool m_itemChanged = false;
};

#endif //UOS_RECOVERY_USERDATABACKUPSELECTWIDGET_H
