//
// Created by uos on 2022/3/18.
//

#ifndef UOS_RECOVERY_ITEMFRAME_H
#define UOS_RECOVERY_ITEMFRAME_H

#include <DFrame>
#include <DLabel>
#include <DPushButton>
#include <QStandardItem>
#include <QPixmap>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class ItemFrame : public DFrame
{
    Q_OBJECT
public:
    explicit ItemFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent = nullptr);
    void setCheckState(bool checked);
    bool checkState();
    void showDescription(bool isShow);
    void setLayoutStype(int layout);
    void initLayout();
    void setIconPixmap(const QString &iconRes, const QSize &iconSize);

Q_SIGNALS:
    void clicked(bool checked);

protected:
    bool event(QEvent *e) override;

private:
    void initHorizontalLayout();
    void initVerticalLayout();

private:
    DLabel *m_title = nullptr;
    DLabel *m_description = nullptr;
    DLabel *m_icon = nullptr;
    DLabel *m_checkIcon = nullptr;
    bool m_bChecked = false;
    QPixmap m_radioPixmap;
    int m_layout = -1;
};


#endif //UOS_RECOVERY_ITEMFRAME_H
