//
// Created by zxm on 2022/8/22.
//

#ifndef UOS_RECOVERY_BOOTVERSIONMGR_H
#define UOS_RECOVERY_BOOTVERSIONMGR_H
#include <QString>
#include <QJsonObject>
#include <QList>

struct BootVersion {
    QString version = "";
    QString kernel = "";
    QString initrd = "";
    QString scheme = "";
    QString display = "";
    QString uuid = "";  // backup device uuid

    QJsonObject marshal();
    void unmarshal(const QJsonObject &jsonObject);
};

class BootVersionMgr {
public:
    BootVersionMgr();
    ~BootVersionMgr();

    QString getBootList();

private:
    void getRecoveryBackupUUIDList(QStringList &backupUUIDList);
    void getBootVersionList(const QStringList &backupUUIDList, QList<BootVersion> &versionList);
    void getBootKernelAndInitrd(QString &kernel, QString &initrd);
    QString versionList2Json(const QList<BootVersion> &versionList);

    bool spawnCmd(const QString &cmd, const QStringList &args, QString &output, QString &err);
    bool getMountPointByUUID(const QString &uuid, QString &mountPointPath);
    bool isRootMounted();
    QJsonObject QStringToJson(const QString &jsonString);
};

#endif
