/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:22:13 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureSegment;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FeatureSegment_ESTest extends FeatureSegment_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~oA\"$$c)f\"+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = new Range(0, 2);
      FeatureSegment featureSegment0 = null;
      try {
        featureSegment0 = new FeatureSegment(feature0, range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // misc_feature internal error - unexpected OutOfRangeException for position: 0
         //
         verifyException("uk.ac.sanger.artemis.FeatureSegment", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      FeatureSegment featureSegment0 = new FeatureSegment(feature0, range0);
      featureSegment0.startListening();
      assertEquals(14, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Range range0 = new Range((-5));
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      FeatureSegment featureSegment0 = null;
      try {
        featureSegment0 = new FeatureSegment(feature0, range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // misc_feature internal error - unexpected OutOfRangeException for position: -5
         //
         verifyException("uk.ac.sanger.artemis.FeatureSegment", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature(genbankStreamFeature0);
      Feature feature0 = new Feature(emblStreamFeature0);
      Range range0 = new Range((-72), 5);
      FeatureSegment featureSegment0 = null;
      try {
        featureSegment0 = new FeatureSegment(feature0, range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Feature", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      FeatureSegment featureSegment0 = new FeatureSegment(feature0, range0);
      boolean boolean0 = featureSegment0.canDirectEdit();
      assertTrue(boolean0);
      assertEquals(14, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      Range range0 = new Range(0, 0);
      FeatureSegment featureSegment0 = null;
      try {
        featureSegment0 = new FeatureSegment((Feature) null, range0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureSegment", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      FeatureSegment featureSegment0 = new FeatureSegment(feature0, range0);
      int int0 = featureSegment0.getFrameID();
      assertEquals(14, range0.getCount());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      FeatureSegment featureSegment0 = new FeatureSegment(feature0, range0);
      try { 
        featureSegment0.setEndPosition(2798);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // position: 2798
         //
         verifyException("uk.ac.sanger.artemis.sequence.MarkerInternal", e);
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      FeatureSegment featureSegment0 = new FeatureSegment(feature0, range0);
      String string0 = featureSegment0.getBases();
      assertEquals("nnnndnnncnnnnn", string0);
  }

  @Test(timeout = 4000)
  public void test9()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("AT~Wd\"$$c)f!+/");
      Bases bases0 = new Bases(emblStreamSequence0);
      Entry entry0 = Entry.newEntry(bases0);
      Feature feature0 = entry0.createFeature();
      Range range0 = feature0.getMaxRawRange();
      FeatureSegment featureSegment0 = new FeatureSegment(feature0, range0);
      featureSegment0.setStartPosition(5);
      featureSegment0.getFrameID();
  }
}
