/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#define MOLECULE_CML           "molecule"
#define STRING_CML             "string"
#define ATOM_CML               "atom"
#define BOND_CML               "bond"
#define COORDINATE2_CML        "coordinate2"
#define INTEGER_CML            "integer"
#define FLOAT_CML              "float"
#define BOND_CML               "bond"

#define BUILTIN_CML            "builtin"
#define ID_CML                 "id"
#define ELEMENT_TYPE_CML       "elementType"
#define XY2_CML                "xy2"
#define X2_CML                 "x2"
#define Y2_CML                 "y2"
#define FORMAL_CHARGE_CML      "formalCharge"
#define ORDER_CML              "order"
#define ATOMREFS_CML           "atomRefs"
#define ATOMREF_CML            "atomRef"
#define ORDER_CML              "order"


#define STRING_ARRAY           "stringArray"
#define INTEGER_ARRAY          "integerArray"
#define FLOAT_ARRAY            "floatArray"

#define ATOMARRAY_ID_CML       "atomId"
/**
 *Questa classe  rappresenta un'immagine in  memoria il cui input  e' un
 *file cml1.0
 */

class immagine_cml : public immagine {

public:

  /**
   *Costruttore di default
   */

  immagine_cml();


  /**
   *Costruttore di copia
   */

  immagine_cml(const immagine_cml& altra);

  /**
   *Costruisce, l'oggetto parsando il file passato come argomento.
   */

  immagine_cml(string path);

  virtual ~immagine_cml();


  /**
   *carica in memoria il file di input
   */
  virtual void filebist(string path);

  /**
   *Avvia il parsing
   */
  virtual void start();


  /**
   *Converte l'ordine  di legame cml  nel tipo di  legame corrispondente
   *nel formato bist nativo.
   */

  static int conv_order_cml(string order_cml);


protected:

  static void start_tags(void *userData,
			 const XML_Char *name,
			 const XML_Char **atts);


  static void end_tags(void *userData,
		       const XML_Char *name);

  static void text_hand(void *userData,
			const XML_Char *s,
			int len);


  /**
   *\return una  mappa contenente come  chiavi il nome  dell'attributo e
   *come valore il valore dell'attribbuto.
   */


  static map<string,string> costruct_map_attrb(const XML_Char **atts);


  /**
   *I gruppi  parsati vengono temporaneamente  messi qui, alla  fine del
   *parsing verrabbo copiati in _gruppi
   */

  static vector<gruppo> _gruppi_static;

  /**
   *contiene i  tag aperti pair.first=  nome del tag  pair.second= mappa
   *contenente  come chiavi  il  nome dell'attributo  e  come valore  il
   *valore dell'attribbuto.
   */

  static stack< pair< string, map<string,string> > > _tag_static;

  static string _genitore_cml_static;
  static map<string,string> _genitore_attrb_cml_static;

  static pair<int,int> _atomref_static;
  static int           _bnd_order_static;

  static string        _atomref_array_1_static;
  static string        _atomref_array_2_static;


  /**
   *Conta gli id dei legami nel caso in cui l'elemento bond non contenga
   *un attributo id valido
   */

  static int _id_leg_fallback;

};
