# The Donation Statement of Deepin Store

## Why donate an application?

In the open source community, anyone can obtain, copy and distribute source code for free all the time. Many developers have spent their enthusiasm, ability and spare time on developing a lot of excellent software for Linux users. However, many outstanding open source free application has stopped updating, due to the limited time of developers or the economic pressure for community operation.
Therefore, under the condition of respecting the labor results of developers and community rules, Deepin Store provides the donation channel to help developers and community as users want, hoping that the donation incomes encourage the application authors and offer the necessary operating expenses for the open source community.
In addition, many Linux versions of excellent commercial software are unknown by the public, so various excellent and free (or trial) closed source applications have been collected in Deepin Store based on user recommendations. The donation incomes of these applications present the strong demand of excellent software from Linux community and users, which will be recognized by software companies.
The purpose of donation are specifically as follows:

- Making it possible that the developers and the packagers can get recognition and encouragement from users;
- Obtaining funds to support a variety of practical needs, such as high-level application servers and bandwidth;
- Encouraging community developers and business developers to actively develop, iterate and maintain applications;
- Providing a distribution platform for open source software and Linux commercial software, to attract more developers to participate in constructing the community ecology.

In Deepin Store, whether it is open source or free closed source software, the donation channel is open by default, with the functions of income claiming, extracting, distributing, and so on.

## What is the donation?

To appreciate for the positive contributions of community developers, and let developers get the direct recognition from users, the "Donation" mechanism is developed for individual developers and Linux software companies to get reasonable rewards.

Note: Donation does not mean purchasing applications. Many apps in Deepin Store are free to use without money. Donation is not a mandatory requirement, users can download and use the applications completely for free. To show the approval of the application, users can donate a small amount of money to the authors and the packagers voluntarily.

## How to distribute the donation incomes?

The donation incomes of each application is distributed by 6:2:2 to developer, packager, and operator currently. (Note: The distribution rules may change in the future according to the operation policy)
We will contact the original application developers or organizations proactively, to help them claim their software and provide official installation packages in Deepin Store. If the developer and the packager of an app are the same person or organization, 80% (60% + 20%) of the incomes are owned by that person or organization, and the operator gets the rest 20%.
If the personal income tax is involved in law, in China, Wuhan Deepin Technology Co. Ltd. can help withhold the income tax; in other regions, the author has to declare the tax on his or her own.

## How to extract the donation?

Developers and packagers should register Deepin ID and then log into personal platform: https://dstore-metadata.deepin.cn to view the application list they developed or packaged.
They can also view the summary and the details of the donation amount for each application. When the total amount reaches ￥ 100 CNY (or reaches $20 USD), a withdrawal can be applied for and will be processed within 5 working days after official check. Developers and packagers can track the withdrawal status at any time.
How to deal with the donation incomes not claimed?
If some application developers are unreachable or have not claimed their software, deepin team will summarize and extract this part of donation incomes in December each year, and donate the unclaimed amount to other important open source communities or organizations that need support. (Specific grantees and amount information will be publicly released in November and seek advice from communities)

## How to be an author?

Deliver your own app as an author, or claim to be the author if your app has already been in Deepin Store. Currently there is not an open self-service claiming channel, please contact appstore@deepin.com.
Requirements: The author should be the original personal developer or developer team, and the application should meet the collection rules or has been put in Deepin Store, see: https://www.deepin.org/deliver-applications .

## How to be a packager?

At present, the automatic packaging channel is not open. To be a packager, please provide the package and the metadata in personal platform: https://dstore-metadata.deepin.cn according to the requirements of Deepin Store, and then contact appstore@deepin.com with deepin ID, Github ID, project address, package name, introduction, email and author info. Deepin team will keep contact with you. When the packaging channel is officially open, there will be a notice in community.
(Note: The package name should be unique. For example, dde plugin: dde-\*\*\*-plugin; the application: \*\*\*-music, \*\*\*-movie; icon theme: \*\*\*-icon-theme; gtk theme: gtk-theme-\*\*\*.)
After becoming a packager of a certain app, when the source app is updated, the packager must package and update the app in Deepin Store within one week. If there are three times of delays, or an update is delayed for more than two weeks, the packager will have no permission on the app any longer, and the subsequent donation will no longer belong to the packager.
If the original author provides a qualified package, or there is already a qualified packager, we will not accept a new packager for that app. Application in flatpak format is in priority, so if the app does not have a flatpak package, the packager that delivers it in flatpak format will be accepted.

## Notes

- The donation function is set by default for each application in Deepin Store. If the original developer or the developer company does not want this feature, please contact us at appstore@deepin.com to close the "Donation" channel.
- If the original developer or the company does not permit software distribution in Deepin Store due to the copyright, please contact us at appstore@deepin.com to remove the application.
