/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     wangzhixuan <wangzhixuan@uniontech.com>
*
* Maintainer: wangzhixuan <wangzhixuan@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "PhoneTreeMusicModel.h"

#include <QJsonObject>

#include "TrObject.h"

#define CHECK_COL 0 //CheckBox
#define NAME_COL 1 // 文件名

//#define MARTIST_COL 2 // 演唱者
#define MLENGTH_COL 2 // 时长
#define MSIZE_COL 3 // 文件大小
#define MTYPE_COL 4 // 类型
#define MDATE_COL 5 // 修改时间

PhoneTreeMusicModel::PhoneTreeMusicModel(QObject *parent)
    : BaseItemModel(parent)
{
    setHorizontalHeaderLabels(QStringList()
                              << "" << TrObject::getInstance()->getTreeHeaderText(Header_Name)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Duration)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Size)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Type)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Time_modified));
}

void PhoneTreeMusicModel::appendData(const QVariant &data)
{
    auto fi = data.value<QFileInfo>();

    int nRow = this->rowCount();
    QStandardItem *item = nullptr;

    item = new QStandardItem("");
    this->setItem(nRow, CHECK_COL, item);

    item = new QStandardItem(fi.completeBaseName());
    item->setIcon(getFileIcon(fi.suffix(), fi)); // file.icon, Qt::DecorationRole);
    item->setData(data, ROLE_ITEM_DATA);
    this->setItem(nRow, NAME_COL, item);

    item = new QStandardItem("00:00");
    this->setItem(nRow, MLENGTH_COL, item);

    item = new QStandardItem(dataSizeToString(quint64(fi.size())));
    item->setData(fi.size(), ROLE_ITEM_SIZE);
    this->setItem(nRow, MSIZE_COL, item);

    item = new QStandardItem(fi.suffix());
    this->setItem(nRow, MTYPE_COL, item);

    item = new QStandardItem(fi.lastModified().toString("yyyy/MM/dd hh:mm:ss"));
    this->setItem(nRow, MDATE_COL, item);
}

void PhoneTreeMusicModel::deleteRowByPath(const QString &, const QString &)
{
}

void PhoneTreeMusicModel::updateDataPixmap(const QJsonObject &obj, const QPixmap &)
{
    QString path = obj.value("path").toString();
    QString length = obj.value("length").toString();

    for (int i = 0; i < rowCount(); i++) {
        auto fi = this->index(i, NAME_COL).data(ROLE_ITEM_DATA).value<QFileInfo>();
        if (fi.absoluteFilePath() == path) {
            auto item = this->item(i, MLENGTH_COL);
            item->setText(length);

            break;
        }
    }
}

qint64 PhoneTreeMusicModel::getTotalSize()
{
    int sizeCol = MSIZE_COL;

    qint64 totalSize = 0;

    for (int i = 0; i < rowCount(); i++) {
        totalSize += item(i, sizeCol)->data(ROLE_ITEM_SIZE).value<qint64>();
    }

    return totalSize;
}
