// Copyright (C) 2019 ~ 2020 Deepin Technology Co., Ltd.
// SPDX-FileCopyrightText: 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef AudioWatcher_H
#define AudioWatcher_H

#include <QObject>
#include <com_deepin_daemon_audio.h>
#include <com_deepin_daemon_audio_source.h>
#include <com_deepin_daemon_audio_sink.h>

class AudioWatcher : public QObject
{
    Q_OBJECT
public:
    enum AudioMode { Internal,
                     Micphone
                   };
    Q_ENUM(AudioMode)
    explicit AudioWatcher(QObject *parent = nullptr);
    //获取设备名称
    QString getDeviceName(AudioMode mode);
    //获取设备音量
    double getVolume(AudioMode mode);
    //判断设备是否静音
    bool getMute(AudioMode mode);
    //判断设备是否通过控制中心禁用
    bool getDeviceEnable(AudioMode mode);
signals:
    //音量改变信号
    void sigVolumeChange(AudioMode mode);
    //设备改变信号
    void sigDeviceChange(AudioMode mode);
    //静音状态改变信号
    void sigMuteChanged(AudioMode mode);
    //设备使能情况
    void sigDeviceEnableChanged(AudioMode mode, bool enable);
protected slots:
    //输入设备默认端口改变
    void onDefaultSourceActivePortChanged(AudioPort value);
    //输出设备默认端口改变
    void onDefaultSinkActivePortChanged(AudioPort value);
    //默认输入设备改变
    void onDefaultSourceChanaged(const QDBusObjectPath &value);
    //默认输出设备改变
    void onDefaultSinkChanaged(const QDBusObjectPath &value);
    //默认输入设备音量改变
    void onSourceVolumeChanged(double value);
    //默认输出设备音量改变
    void onSinkVolumeChanged(double value);
    //默认输入设备静音状态改变
    void onSourceMuteChanged(bool value);
    //默认输出设备静音状态改变
    void onSinkMuteChanged(bool value);
    //控制中心中是否更改设备的使能状态
    void onDeviceEnableState(QDBusMessage msg);

private:
    //从参数文件中读取设备检测开启标志，无配置文件，默认开启
    //CheckInputDevice=false,关闭检测
    void initWatcherCofing();
    //初始化获取默认输入/输出设备信息
    void initDeviceWacther();
    //连接相关槽函数
    void initConnections();
    //是否是云平台
    bool isVirtualMachineHw();
    //查询系统信息
    QString vnSystemInfo();
    //更新控制中心中是否更改设备的使能状态
    void updateDeviceEnabled(QString cardsStr, bool isEmitSig);

private:
    const QString m_serviceName {"com.deepin.daemon.Audio"};
    QScopedPointer<com::deepin::daemon::Audio> m_pAudioInterface;
    QScopedPointer<com::deepin::daemon::audio::Source> m_pDefaultSource;
    QScopedPointer<com::deepin::daemon::audio::Sink> m_pDefaultSink;
    AudioPort m_outAudioPort;
    AudioPort m_inAudioPort;
    double m_outAudioPortVolume = 0.0;
    double m_inAudioPortVolume = 0.0;
    bool m_fNeedDeviceChecker {true};
    bool m_inAudioMute {false};
    bool m_outAudioMute {false};
    /**
      * @brief 默认输入设备是否使能
      * 找出默认输入设备在 系统>控制中心>声音>设备管理>输入设备 中的使能情况
      */
    bool m_inIsEnable{false};
    /**
      * @brief 默认输出设备是否使能
      * 找出默认输出设备在 系统>控制中心>声音>设备管理>输入设备 中的使能情况
      */
    bool m_outIsEnable{false};

    bool m_isVirtualMachineHw{false};
};

#endif // AudioWatcher_H
