#ifndef ECORE_COCOA_KEYS_H__
#define ECORE_COCOA_KEYS_H__

/* Prevent innocent devs to include this directly. */
#ifndef _ECORE_COCOA_KEYS_MANUAL_GUARD_
# error This header must be be included directly!
#endif


struct _ecore_cocoa_keys_s
{
   const int         code;
   const char *const name;
   const char *const compose;
};

static const struct _ecore_cocoa_keys_s keystable[] =
{

{ 0,                         "0x00",         "" },
{ 0,                         "First",        "" },
{ 3,                         "Return",       "\015" },
{ 8,                         "Delete",       "\010" },
{ 9,                         "Tab",          "\011" },
{ 12,                        "Clear",        "" },
{ 13,                        "Return",       "\015" },
{ 19,                        "Pause",        "" },
{ 25,                        "BackTab",        ""},
{ 27,                        "Escape",       "" },
{ 32,                        "space",        " " },
{ 33,                        "exclam",       "!" },
{ 34,                        "quotedbl",     "\"" },
{ 35,                        "numbersign",   "#" },
{ 36,                        "dollar",       "$" },
{ 37,                        "percent",      "%" },
{ 38,                        "ampersand",    "&" },
{ 39,                        "apostrophe",   "'" },
{ 40,                        "parenleft",    "(" },
{ 41,                        "parenright",   ")" },
{ 42,                        "asterisk",     "*" },
{ 43,                        "plus",         "+" },
{ 44,                        "comma",        "," },
{ 45,                        "minus",        "-" },
{ 46,                        "period",       "." },
{ 47,                        "slash",        "/" },
{ 48,                        "0",            "0" },
{ 49,                        "1",            "1" },
{ 50,                        "2",            "2" },
{ 51,                        "3",            "3" },
{ 52,                        "4",            "4" },
{ 53,                        "5",            "5" },
{ 54,                        "6",            "6" },
{ 55,                        "7",            "7" },
{ 56,                        "8",            "8" },
{ 57,                        "9",            "9" },
{ 58,                        "colon",        ":" },
{ 59,                        "semicolon",    ";" },
{ 60,                        "less",         "<" },
{ 61,                        "equal",        "=" },
{ 62,                        "greater",      ">" },
{ 63,                        "question",     "?" },
{ 64,                        "at",           "@" },
{ 65,                        "A",            "A" },
{ 66,                        "B",            "B" },
{ 67,                        "C",            "C" },
{ 68,                        "D",            "D" },
{ 69,                        "E",            "E" },
{ 70,                        "F",            "F" },
{ 71,                        "G",            "G" },
{ 72,                        "H",            "H" },
{ 73,                        "I",            "I" },
{ 74,                        "J",            "J" },
{ 75,                        "K",            "K" },
{ 76,                        "L",            "L" },
{ 77,                        "M",            "M" },
{ 78,                        "N",            "N" },
{ 79,                        "O",            "O" },
{ 80,                        "P",            "P" },
{ 81,                        "Q",            "Q" },
{ 82,                        "R",            "R" },
{ 83,                        "S",            "S" },
{ 84,                        "T",            "T" },
{ 85,                        "U",            "U" },
{ 86,                        "V",            "V" },
{ 87,                        "W",            "W" },
{ 88,                        "X",            "X" },
{ 89,                        "Y",            "Y" },
{ 90,                        "Z",            "Z" },
{ 91,                        "bracketleft",  "[" },
{ 92,                        "backslash",    "\\" },
{ 93,                        "bracketright", "]" },
{ 94,                        "asciicircumm", "^" },
{ 95,                        "underscore",   "_" },
{ 96,                        "backquote",    "`" },
{ 97,                        "a",            "a" },
{ 98,                        "b",            "b" },
{ 99,                        "c",            "c" },
{ 100,                       "d",            "d" },
{ 101,                       "e",            "e" },
{ 102,                       "f",            "f" },
{ 103,                       "g",            "g" },
{ 104,                       "h",            "h" },
{ 105,                       "i",            "i" },
{ 106,                       "j",            "j" },
{ 107,                       "k",            "k" },
{ 108,                       "l",            "l" },
{ 109,                       "m",            "m" },
{ 110,                       "n",            "n" },
{ 111,                       "o",            "o" },
{ 112,                       "p",            "p" },
{ 113,                       "q",            "q" },
{ 114,                       "r",            "r" },
{ 115,                       "s",            "s" },
{ 116,                       "t",            "t" },
{ 117,                       "u",            "u" },
{ 118,                       "v",            "v" },
{ 119,                       "w",            "w" },
{ 120,                       "x",            "x" },
{ 121,                       "y",            "y" },
{ 122,                       "z",            "z" },
{ 123,                       "braceleft",    "{" },
{ 124,                       "pipe",         "|" },
{ 125,                       "braceright",   "}" },
{ 127,                       "BackSpace",    "\x08" },
{ 126,                       "asciitilde",   "~" },

{ 160,                       "w0",           "" }, 
{ 161,                       "w1",           "" },
{ 162,                       "w2",           "" },
{ 163,                       "w3",           "" },
{ 164,                       "w4",           "" },
{ 165,                       "w5",           "" },
{ 166,                       "w6",           "" },
{ 167,                       "w7",           "§" },
{ 168,                       "w8",           "" },
{ 169,                       "w9",           "" },
{ 170,                       "w10",          "" },
{ 171,                       "w11",          "" },
{ 172,                       "w12",          "" },
{ 173,                       "w13",          "" },
{ 174,                       "w14",          "" },
{ 175,                       "w15",          "" },
{ 176,                       "w16",          "°" },
{ 177,                       "w17",          "" },
{ 178,                       "w18",          "" },
{ 179,                       "w19",          "" },
{ 180,                       "w20",          "" },
{ 181,                       "w21",          "" },
{ 182,                       "w22",          "" },
{ 183,                       "w23",          "" },
{ 184,                       "w24",          "" },
{ 185,                       "w25",          "" },
{ 186,                       "w26",          "" },
{ 187,                       "w27",          "" },
{ 188,                       "w28",          "" },
{ 189,                       "w29",          "" },
{ 190,                       "w30",          "" },
{ 191,                       "w31",          "" },
{ 192,                       "w32",          "" },
{ 193,                       "w33",          "" },
{ 194,                       "w34",          "" },
{ 195,                       "w35",          "" },
{ 196,                       "w36",          "" },
{ 197,                       "w37",          "" },
{ 198,                       "w38",          "" },
{ 199,                       "w39",          "" },
{ 200,                       "w40",          "" },
{ 201,                       "w41",          "" },
{ 202,                       "w42",          "" },
{ 203,                       "w43",          "" },
{ 204,                       "w44",          "" },
{ 205,                       "w45",          "" },
{ 206,                       "w46",          "" },
{ 207,                       "w47",          "" },
{ 208,                       "w48",          "" },
{ 209,                       "w49",          "" },
{ 210,                       "w50",          "" },
{ 211,                       "w51",          "" },
{ 212,                       "w52",          "" },
{ 213,                       "w53",          "" },
{ 214,                       "w54",          "" },
{ 215,                       "w55",          "" },
{ 216,                       "w56",          "" },
{ 217,                       "w57",          "" },
{ 218,                       "w58",          "" },
{ 219,                       "w59",          "" },
{ 220,                       "w60",          "" },
{ 221,                       "w61",          "" },
{ 222,                       "w62",          "" },
{ 223,                       "w63",          "" },
{ 224,                       "w64",          "à" },
{ 225,                       "w65",          "" },
{ 226,                       "w66",          "â" },
{ 227,                       "w67",          "ã" },
{ 228,                       "w68",          "ä" },
{ 229,                       "w69",          "" },
{ 230,                       "w70",          "" },
{ 231,                       "w71",          "ç" },
{ 232,                       "w72",          "è" },
{ 233,                       "w73",          "é" },
{ 234,                       "w74",          "ê" },
{ 235,                       "w75",          "ë" },
{ 236,                       "w76",          "ì" },
{ 237,                       "w77",          "" },
{ 238,                       "w78",          "î" },
{ 239,                       "w79",          "ï" },
{ 240,                       "w80",          "" },
{ 241,                       "w81",          "" },
{ 242,                       "w82",          "ò" },
{ 243,                       "w83",          "" },
{ 244,                       "w84",          "ô" },
{ 245,                       "w85",          "õ" },
{ 246,                       "w86",          "ö"},
{ 247,                       "w87",          "" },
{ 248,                       "w88",          "" },
{ 249,                       "w89",          "ù" },
{ 250,                       "w90",          "" },
{ 251,                       "w91",          "û" },
{ 252,                       "w92",          "ü" },
{ 253,                       "w93",          "" },
{ 254,                       "w94",          "" },
{ 255,                       "w95",          "ÿ" },

{ 256,                       "KP0",          "0" },
{ 257,                       "KP1",          "1" },
{ 258,                       "KP2",          "2" },
{ 259,                       "KP3",          "3" },
{ 260,                       "KP4",          "4" },
{ 261,                       "KP5",          "5" },
{ 262,                       "KP6",          "6" },
{ 263,                       "KP7",          "7" },
{ 264,                       "KP8",          "8" },
{ 265,                       "KP9",          "9" },
{ 266,                       "period",       "." },
{ 267,                       "KP_Divide",    "/" },
{ 268,                       "KP_Multiply",  "*" },
{ 269,                       "KP_Minus",     "-" },
{ 270,                       "KP_Plus",      "+" },
{ 271,                       "KP_Enter",     "\015" },
{ 272,                       "KP_Equals",    "=" },

{ NSUpArrowFunctionKey,      "Up",           "" },
{ NSDownArrowFunctionKey,    "Down",         "" },
{ NSRightArrowFunctionKey,   "Right",        "" },
{ NSLeftArrowFunctionKey,    "Left",         "" },
{ NSInsertFunctionKey,       "Insert",       "" },
{ NSHomeFunctionKey,         "Home",         "" },
{ NSEndFunctionKey,          "End",          "" },
{ NSPageUpFunctionKey,       "Prior",      "" },
{ NSPageDownFunctionKey,     "Next",    "" },
{ NSDeleteFunctionKey,       "Delete",       "\010"},

{ NSF1FunctionKey,           "F1",           "" },
{ NSF2FunctionKey,           "F2",           "" },
{ NSF3FunctionKey,           "F3",           "" },
{ NSF4FunctionKey,           "F4",           "" },
{ NSF5FunctionKey,           "F5",           "" },
{ NSF6FunctionKey,           "F6",           "" },
{ NSF7FunctionKey,           "F7",           "" },
{ NSF8FunctionKey,           "F8",           "" },
{ NSF9FunctionKey,           "F9",           "" },
{ NSF10FunctionKey,          "F10",          "" },
{ NSF11FunctionKey,          "F11",          "" },
{ NSF12FunctionKey,          "F12",          "" },
{ NSF13FunctionKey,          "F13",          "" },
{ NSF14FunctionKey,          "F14",          "" },
{ NSF15FunctionKey,          "F15",          "" },
{ NSF16FunctionKey,          "F16",          "" },
{ NSF17FunctionKey,          "F17",          "" },
{ NSF18FunctionKey,          "F18",          "" },
{ NSF19FunctionKey,          "F19",          "" },
{ NSF20FunctionKey,          "F20",          "" },
{ NSF21FunctionKey,          "F21",          "" },
{ NSF22FunctionKey,          "F22",          "" },
{ NSF23FunctionKey,          "F23",          "" },
{ NSF24FunctionKey,          "F24",          "" },
{ NSF25FunctionKey,          "F25",          "" },
{ NSF26FunctionKey,          "F26",          "" },
{ NSF27FunctionKey,          "F27",          "" },
{ NSF28FunctionKey,          "F28",          "" },
{ NSF29FunctionKey,          "F29",          "" },
{ NSF30FunctionKey,          "F30",          "" },
{ NSF31FunctionKey,          "F31",          "" },
{ NSF32FunctionKey,          "F32",          "" },
{ NSF33FunctionKey,          "F33",          "" },
{ NSF34FunctionKey,          "F34",          "" },
{ NSF35FunctionKey,          "F35",          "" },

{ NSClearLineFunctionKey,    "Num_Lock",     "" },
{ 301,                       "Caps_Lock",    "" },
{ NSScrollLockFunctionKey,   "Scroll_Lock",  "" },
{ 303,                       "Shift_R",      "Shift_R" },
{ 304,                       "Shift_L",      "Shift_L" },
{ 305,                       "Control_R",    "" },
{ 306,                       "Control_L",    "" },
{ 307,                       "Alt_R",        "" },
{ 308,                       "Alt_L",        "" },
{ 309,                       "Meta_R",       "" },
{ 310,                       "Meta_L",       "" },
{ 311,                       "Super_L",      "" },
{ 312,                       "Super_R",      "" },

{ NSModeSwitchFunctionKey,   "Mode",         "" },
{ 314,                       "Compose",      "" },

{ NSHelpFunctionKey,         "Help",         "" },
{ NSPrintFunctionKey,        "Print",        "" },
{ NSSysReqFunctionKey,       "SysReq",       "" },
{ NSBreakFunctionKey,        "Break",        "" },
{ NSMenuFunctionKey,         "Menu",         "" },
{ 320,                       "Power",        "" },
{ 321,                       "Euro",         "" },
{ NSUndoFunctionKey,         "Undo",         "" }

};

#endif  /* ECORE_COCOA_KEYS_H__ */
