/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifdef STATE

struct {
    unsigned int states[8];
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

#if DEBUG
#define STR(x)   #x
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* DEBUG */

static void
NAME_(create)(struct cpssp *cpssp)
{
    cpssp->NAME.states[0] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[1] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[2] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[4] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[5] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[6] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[7] = SIG_STD_LOGIC_Z;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res = SIG_STD_LOGIC_0;
    int i;
    for(i = 0; i < 8; i++) {
	if(2000 < sig_mV(cpssp->NAME.states[i])) {
	    /* ~0 */
	} else {
	    /* ~1 */
#if DEGUG
	    if(res != SIG_STD_LOGIC_0) {
		SHOW_DEFINE(NAME);
		fprintf(stderr, " WARNING: several inputs are set\n");
	    }
#endif /* DEBUG */
	    res = cpssp->NAME.states[i];
	}
    }

#if DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to %i\n", res);
#endif /* DEBUG */

    /*K
     * FIXME widerstaende und so
     */
    NAME_OUT_PORT_0_(out_set)(cpssp, res);
    NAME_OUT_PORT_1_(out_set)(cpssp, res);
}

#ifdef NAME_IN_PORT_0_
static void
NAME_IN_PORT_0_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[0] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_0_ */

#ifdef NAME_IN_PORT_1_
static void
NAME_IN_PORT_1_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[1] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_1_ */

#ifdef NAME_IN_PORT_2_
static void
NAME_IN_PORT_2_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[2] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_2_ */

#ifdef NAME_IN_PORT_3_
static void
NAME_IN_PORT_3_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[3] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_3_ */

#ifdef NAME_IN_PORT_4_
static void
NAME_IN_PORT_4_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.state[4] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_4_ */


#ifdef NAME_IN_PORT_5_
static void
NAME_IN_PORT_5_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[5] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_5_ */


#ifdef NAME_IN_PORT_6_
static void
NAME_IN_PORT_6_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[6] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_6_ */


#ifdef NAME_IN_PORT_7_
static void
NAME_IN_PORT_7_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[7] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_7_ */

#ifdef NAME_IN_PORT_8_
static void
NAME_IN_PORT_8_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[8] = val;
    NAME_(solve)(cpssp);
}
#endif /* NAME_IN_PORT_8_ */

#endif /*BEHAVIOUR*/
