/*
 * Copyright (C) 2007-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_TRACE_H_INCLUDED
#define __GLUE_TRACE_H_INCLUDED

#define LOG_SIZE	(1*1024*1024)

#include <stdlib.h> /* Needed for "abort". */

#undef assert

#define assert(cond) \
{ \
	log_do(__FUNCTION__, __LINE__); \
	if (! (cond)) { \
		log_dump(); \
		abort(); \
	} \
}

struct log_buf {
	const char *file;
	unsigned int line;
	unsigned long p0;
	unsigned long p1;
};

extern struct log_buf log_buf[];
extern unsigned int log_count;

extern inline void
log_do2(const char *file, unsigned int line, unsigned long p0, unsigned long p1)
{
	unsigned int pos;

	pos = __sync_fetch_and_add(&log_count, 1);
	pos &= LOG_SIZE - 1;
	log_buf[pos].file = file;
	log_buf[pos].line = line;
	log_buf[pos].p0 = p0;
	log_buf[pos].p1 = p1;
}

extern inline void
log_do1(const char *file, unsigned int line, unsigned long p0)
{
	log_do2(file, line, p0, 0UL);
}

extern inline void
log_do(const char *file, unsigned int line)
{
	log_do2(file, line, 0UL, 0UL);
}

extern void
log_dump(void);

#endif /* __GLUE_TRACE_H_INCLUDED */
