/*
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"
#include "compiler.h"

/* ==================== RUNTIME_RM || RUNTIME_PM ==================== */
#if defined(RUNTIME_RM) || defined(RUNTIME_PM)

#ifdef RUNTIME_PM
CODE32;
#else
CODE16;
#endif

#include "debug.h"
#include "stdio.h"
#include "stdarg.h"
#include "io.h"

#if (DEBUGLEVEL > 0)

void
DEBUGPRINT(int level, const char *fmt, ...)
{
	va_list args;
	char buf[64];
	int x;
	
	/* FIXME JOSEF: no reimplement of dprintf */
	/* FIXME JOSEF: found reason: must use va_list as param */

	if (level <= DEBUGLEVEL) {
		va_start(args, fmt);
		vsprintf(buf, fmt, args);
		va_end(args);

		for (x = 0; buf[x] != '\0'; x++) {
			outb(buf[x], 0xffff);
		}
	}
}

#endif /* DEBUGLEVEL > 0 */

#endif /* RUNTIME_RM || RUNTIME_PM */
