;
; Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
; This program is free software. You can redistribute it and/or modify it
; under the terms of the GNU General Public License, either version 2 of
; the License, or (at your option) any later version. See COPYING.
; 

.code16
.text

.global _start
_start:
	/* Switch to vga mode 3. */
	movb $3, %al
	movb $0x00, %ah
	int $0x10

	/* Get values of all palette registers. */
	movw $0, %cx
loop_palette:
	pushw %cx

	movb %cl, %bl
	movw $0x1007, %ax
	int $0x10

	movb %bh, %al
	call hex

	call space

	popw %cx
	incw %cx
	cmpw $0x10, %cx
	jne loop_palette

	movb $'\n', %al
	movb $0x0e, %ah
	int $0x10
	movb $'\r', %al
	movb $0x0e, %ah
	int $0x10

	/* Get values of all color registers. */
	movw $0, %cx
loop_dac:
	pushw %cx

	movb %cl, %bl
	movw $0x1015, %ax
	int $0x10

	pushw %cx
	pushw %dx

	movb %dh, %al
	call hex

	call space

	popw %dx
	popw %cx

	pushw %cx
	pushw %dx

	movb %ch, %al
	call hex

	call space

	popw %dx
	popw %cx

	pushw %cx
	pushw %dx

	movb %cl, %al
	call hex

	call space

	popw %dx
	popw %cx

	call space

	popw %cx
	inc %cx
	cmpw $64, %cx
	jne loop_dac

	movb $'\n', %al
	movb $0x0e, %ah
	int $0x10
	movb $'\r', %al
	movb $0x0e, %ah
	int $0x10
	movb $'d', %al
	movb $0x0e, %ah
	int $0x10
	movb $'o', %al
	movb $0x0e, %ah
	int $0x10
	movb $'n', %al
	movb $0x0e, %ah
	int $0x10
	movb $'e', %al
	movb $0x0e, %ah
	int $0x10

loop:
	jmp loop

space:
	pushw %ax
	movb $' ', %al
	movb $0x0e, %ah
	int $0x10
	popw %ax
	ret

hex:
	pushw %ax
	shrb $4, %al
	andb $0x0f, %al
	call digit
	popw %ax
	pushw %ax
	andb $0x0f, %al
	call digit
	popw %ax
	ret

digit:
	pushw %ax

	cmpb $10, %al
	jge 1f

	addb $'0', %al
	jmp 2f

1:	addb $'A'-10, %al

2:	movb $0x0e, %ah
	int $0x10

	popw %ax
	ret

.org 510
	.word 0xAA55
