/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "event.h"
#include <stdlib.h>
#include <string.h>

typedef struct trigger_event{
  int seq_handle;
  void(* fire)(event *this, sample_producer *target);
} trigger_event;


void fire_trigger(event *this, sample_producer *target) {
  target->trigger(target);
}

event *event_new_trigger(int seq_handle)
{
  trigger_event *out = (trigger_event *)malloc(sizeof(trigger_event));
  out->seq_handle = seq_handle;
  out->fire = fire_trigger;
  return (event *)out;
}




event_list *event_list_new()
{
  event_list *out = (event_list*)malloc(sizeof(event_list));
  out->events = (event**)malloc(sizeof(event*));
  out->length = 0;
  out->size = 1;
  
  return out;
}

void event_list_add(event_list *this,event *e)
{
  if (this->length == this->size)
    this->events = realloc(this->events,sizeof(event *) 
			   * ++this->size);
  
  
  this->events[this->length++] = e;
}


void event_list_remove(event_list *this,event *e)
{

  int i;
  for(i = 0; i < this->size;i++)
    if(e == this->events[i])
      memmove(this->events + i , this->events + i + 1,
	      (this->size - i - 1) * sizeof(event*));
  
  this->length--;

}

void event_list_delete(event_list *this)
{
  int i;
  for(i = 0; i < this->length;i++)
    free(this->events[i]);
  free(this->events);
  free(this);
}



event_bookeeper *e_bookeeper_new(int step, int seq_handle)
{
  event_bookeeper *out = (event_bookeeper *)malloc(sizeof(event_bookeeper));
  out->step = step;
  out->seq_handle = seq_handle;
  out->last_events = event_list_new();

  return out;
}


void clean_bookeeper(event_bookeeper *eb, seq* sequencer)
{
    event_list *el = eb->last_events;
    while(el->length != 0)
    {
      seq_delete_event(sequencer,eb->step,el->events[0]);
      free(el->events[0]);
      event_list_remove(el,el->events[0]);
    }  
}


/*
  Local Variables:
  mode: font-lock
  End:
*/



