// Code generated by "./generator ./org.bluez"; DO NOT EDIT.

package bluez

import (
	"fmt"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/stretchr/testify/mock"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type MockObjectManager struct {
	object_manager.MockInterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	proxy.MockObject
}

type MockManager struct {
	MockInterfaceAgentManager   // interface org.bluez.AgentManager1
	MockInterfaceHealthManager  // interface org.bluez.HealthManager1
	MockInterfaceProfileManager // interface org.bluez.ProfileManager1
	proxy.MockObject
}

type MockInterfaceAgentManager struct {
	mock.Mock
}

// method RegisterAgent

func (v *MockInterfaceAgentManager) GoRegisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath, capability string) *dbus.Call {
	mockArgs := v.Called(flags, ch, agent, capability)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAgentManager) RegisterAgent(flags dbus.Flags, agent dbus.ObjectPath, capability string) error {
	mockArgs := v.Called(flags, agent, capability)

	return mockArgs.Error(0)
}

// method UnregisterAgent

func (v *MockInterfaceAgentManager) GoUnregisterAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, agent)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAgentManager) UnregisterAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	mockArgs := v.Called(flags, agent)

	return mockArgs.Error(0)
}

// method RequestDefaultAgent

func (v *MockInterfaceAgentManager) GoRequestDefaultAgent(flags dbus.Flags, ch chan *dbus.Call, agent dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, agent)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAgentManager) RequestDefaultAgent(flags dbus.Flags, agent dbus.ObjectPath) error {
	mockArgs := v.Called(flags, agent)

	return mockArgs.Error(0)
}

type MockInterfaceHealthManager struct {
	mock.Mock
}

// method CreateApplication

func (v *MockInterfaceHealthManager) GoCreateApplication(flags dbus.Flags, ch chan *dbus.Call, config map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, config)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceHealthManager) CreateApplication(flags dbus.Flags, config map[string]dbus.Variant) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, config)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method DestroyApplication

func (v *MockInterfaceHealthManager) GoDestroyApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, application)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceHealthManager) DestroyApplication(flags dbus.Flags, application dbus.ObjectPath) error {
	mockArgs := v.Called(flags, application)

	return mockArgs.Error(0)
}

type MockInterfaceProfileManager struct {
	mock.Mock
}

// method RegisterProfile

func (v *MockInterfaceProfileManager) GoRegisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, profile, UUID, options)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceProfileManager) RegisterProfile(flags dbus.Flags, profile dbus.ObjectPath, UUID string, options map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, profile, UUID, options)

	return mockArgs.Error(0)
}

// method UnregisterProfile

func (v *MockInterfaceProfileManager) GoUnregisterProfile(flags dbus.Flags, ch chan *dbus.Call, profile dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, profile)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceProfileManager) UnregisterProfile(flags dbus.Flags, profile dbus.ObjectPath) error {
	mockArgs := v.Called(flags, profile)

	return mockArgs.Error(0)
}

type MockHCI struct {
	MockInterfaceAdapter       // interface org.bluez.Adapter1
	MockInterfaceGattManager   // interface org.bluez.GattManager1
	MockInterfaceMedia         // interface org.bluez.Media1
	MockInterfaceNetworkServer // interface org.bluez.NetworkServer1
	proxy.MockObject
}

type MockInterfaceAdapter struct {
	mock.Mock
}

// method StartDiscovery

func (v *MockInterfaceAdapter) GoStartDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAdapter) StartDiscovery(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method SetDiscoveryFilter

func (v *MockInterfaceAdapter) GoSetDiscoveryFilter(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAdapter) SetDiscoveryFilter(flags dbus.Flags, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, properties)

	return mockArgs.Error(0)
}

// method StopDiscovery

func (v *MockInterfaceAdapter) GoStopDiscovery(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAdapter) StopDiscovery(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method RemoveDevice

func (v *MockInterfaceAdapter) GoRemoveDevice(flags dbus.Flags, ch chan *dbus.Call, device dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, device)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceAdapter) RemoveDevice(flags dbus.Flags, device dbus.ObjectPath) error {
	mockArgs := v.Called(flags, device)

	return mockArgs.Error(0)
}

// property Address s

func (v *MockInterfaceAdapter) Address() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Name s

func (v *MockInterfaceAdapter) Name() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Alias s

func (v *MockInterfaceAdapter) Alias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Class u

func (v *MockInterfaceAdapter) Class() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Powered b

func (v *MockInterfaceAdapter) Powered() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Discoverable b

func (v *MockInterfaceAdapter) Discoverable() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property DiscoverableTimeout u

func (v *MockInterfaceAdapter) DiscoverableTimeout() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Pairable b

func (v *MockInterfaceAdapter) Pairable() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PairableTimeout u

func (v *MockInterfaceAdapter) PairableTimeout() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Discovering b

func (v *MockInterfaceAdapter) Discovering() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UUIDs as

func (v *MockInterfaceAdapter) UUIDs() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Modalias s

func (v *MockInterfaceAdapter) Modalias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceGattManager struct {
	mock.Mock
}

// method RegisterApplication

func (v *MockInterfaceGattManager) GoRegisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath, options map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, application, options)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceGattManager) RegisterApplication(flags dbus.Flags, application dbus.ObjectPath, options map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, application, options)

	return mockArgs.Error(0)
}

// method UnregisterApplication

func (v *MockInterfaceGattManager) GoUnregisterApplication(flags dbus.Flags, ch chan *dbus.Call, application dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, application)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceGattManager) UnregisterApplication(flags dbus.Flags, application dbus.ObjectPath) error {
	mockArgs := v.Called(flags, application)

	return mockArgs.Error(0)
}

type MockInterfaceMedia struct {
	mock.Mock
}

// method RegisterEndpoint

func (v *MockInterfaceMedia) GoRegisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, endpoint, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceMedia) RegisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, endpoint, properties)

	return mockArgs.Error(0)
}

// method UnregisterEndpoint

func (v *MockInterfaceMedia) GoUnregisterEndpoint(flags dbus.Flags, ch chan *dbus.Call, endpoint dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, endpoint)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceMedia) UnregisterEndpoint(flags dbus.Flags, endpoint dbus.ObjectPath) error {
	mockArgs := v.Called(flags, endpoint)

	return mockArgs.Error(0)
}

// method RegisterPlayer

func (v *MockInterfaceMedia) GoRegisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, player, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceMedia) RegisterPlayer(flags dbus.Flags, player dbus.ObjectPath, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, player, properties)

	return mockArgs.Error(0)
}

// method UnregisterPlayer

func (v *MockInterfaceMedia) GoUnregisterPlayer(flags dbus.Flags, ch chan *dbus.Call, player dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, player)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceMedia) UnregisterPlayer(flags dbus.Flags, player dbus.ObjectPath) error {
	mockArgs := v.Called(flags, player)

	return mockArgs.Error(0)
}

type MockInterfaceNetworkServer struct {
	mock.Mock
}

// method Register

func (v *MockInterfaceNetworkServer) GoRegister(flags dbus.Flags, ch chan *dbus.Call, uuid string, bridge string) *dbus.Call {
	mockArgs := v.Called(flags, ch, uuid, bridge)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceNetworkServer) Register(flags dbus.Flags, uuid string, bridge string) error {
	mockArgs := v.Called(flags, uuid, bridge)

	return mockArgs.Error(0)
}

// method Unregister

func (v *MockInterfaceNetworkServer) GoUnregister(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call {
	mockArgs := v.Called(flags, ch, uuid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceNetworkServer) Unregister(flags dbus.Flags, uuid string) error {
	mockArgs := v.Called(flags, uuid)

	return mockArgs.Error(0)
}

type MockDevice struct {
	MockInterfaceDevice // interface org.bluez.Device1
	proxy.MockObject
}

type MockInterfaceDevice struct {
	mock.Mock
}

// method Disconnect

func (v *MockInterfaceDevice) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceDevice) Disconnect(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method Connect

func (v *MockInterfaceDevice) GoConnect(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceDevice) Connect(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method ConnectProfile

func (v *MockInterfaceDevice) GoConnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call {
	mockArgs := v.Called(flags, ch, UUID)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceDevice) ConnectProfile(flags dbus.Flags, UUID string) error {
	mockArgs := v.Called(flags, UUID)

	return mockArgs.Error(0)
}

// method DisconnectProfile

func (v *MockInterfaceDevice) GoDisconnectProfile(flags dbus.Flags, ch chan *dbus.Call, UUID string) *dbus.Call {
	mockArgs := v.Called(flags, ch, UUID)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceDevice) DisconnectProfile(flags dbus.Flags, UUID string) error {
	mockArgs := v.Called(flags, UUID)

	return mockArgs.Error(0)
}

// method Pair

func (v *MockInterfaceDevice) GoPair(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceDevice) Pair(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method CancelPairing

func (v *MockInterfaceDevice) GoCancelPairing(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceDevice) CancelPairing(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// property Address s

func (v *MockInterfaceDevice) Address() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property AddressType s

func (v *MockInterfaceDevice) AddressType() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Name s

func (v *MockInterfaceDevice) Name() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Alias s

func (v *MockInterfaceDevice) Alias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Class u

func (v *MockInterfaceDevice) Class() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Appearance q

func (v *MockInterfaceDevice) Appearance() proxy.PropUint16 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint16)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Icon s

func (v *MockInterfaceDevice) Icon() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Paired b

func (v *MockInterfaceDevice) Paired() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Trusted b

func (v *MockInterfaceDevice) Trusted() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Blocked b

func (v *MockInterfaceDevice) Blocked() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property LegacyPairing b

func (v *MockInterfaceDevice) LegacyPairing() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RSSI n

func (v *MockInterfaceDevice) RSSI() proxy.PropInt16 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt16)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Connected b

func (v *MockInterfaceDevice) Connected() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UUIDs as

func (v *MockInterfaceDevice) UUIDs() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Modalias s

func (v *MockInterfaceDevice) Modalias() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Adapter o

func (v *MockInterfaceDevice) Adapter() proxy.PropObjectPath {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropDeviceManufacturerData struct {
	mock.Mock
}

func (p MockPropDeviceManufacturerData) Get(flags dbus.Flags) (value map[uint16]dbus.Variant, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[uint16]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropDeviceManufacturerData) Set(flags dbus.Flags, value map[uint16]dbus.Variant) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropDeviceManufacturerData) ConnectChanged(cb func(hasValue bool, value map[uint16]dbus.Variant)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property ManufacturerData a{qv}

func (v *MockInterfaceDevice) ManufacturerData() PropDeviceManufacturerData {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropDeviceManufacturerData)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropDeviceServiceData struct {
	mock.Mock
}

func (p MockPropDeviceServiceData) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[string]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropDeviceServiceData) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropDeviceServiceData) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property ServiceData a{sv}

func (v *MockInterfaceDevice) ServiceData() PropDeviceServiceData {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropDeviceServiceData)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property TxPower n

func (v *MockInterfaceDevice) TxPower() proxy.PropInt16 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt16)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property ServicesResolved b

func (v *MockInterfaceDevice) ServicesResolved() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}
