// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/ad_group_feed_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [AdGroupFeedService.GetAdGroupFeed][google.ads.googleads.v0.services.AdGroupFeedService.GetAdGroupFeed].
type GetAdGroupFeedRequest struct {
	// The resource name of the ad group feed to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupFeedRequest) Reset()         { *m = GetAdGroupFeedRequest{} }
func (m *GetAdGroupFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupFeedRequest) ProtoMessage()    {}
func (*GetAdGroupFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_feed_service_846fa7679024c025, []int{0}
}
func (m *GetAdGroupFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupFeedRequest.Unmarshal(m, b)
}
func (m *GetAdGroupFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupFeedRequest.Marshal(b, m, deterministic)
}
func (dst *GetAdGroupFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupFeedRequest.Merge(dst, src)
}
func (m *GetAdGroupFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupFeedRequest.Size(m)
}
func (m *GetAdGroupFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupFeedRequest proto.InternalMessageInfo

func (m *GetAdGroupFeedRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupFeedService.MutateAdGroupFeeds][google.ads.googleads.v0.services.AdGroupFeedService.MutateAdGroupFeeds].
type MutateAdGroupFeedsRequest struct {
	// The ID of the customer whose ad group feeds are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual ad group feeds.
	Operations           []*AdGroupFeedOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *MutateAdGroupFeedsRequest) Reset()         { *m = MutateAdGroupFeedsRequest{} }
func (m *MutateAdGroupFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupFeedsRequest) ProtoMessage()    {}
func (*MutateAdGroupFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_feed_service_846fa7679024c025, []int{1}
}
func (m *MutateAdGroupFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupFeedsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupFeedsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupFeedsRequest.Merge(dst, src)
}
func (m *MutateAdGroupFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupFeedsRequest.Size(m)
}
func (m *MutateAdGroupFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupFeedsRequest proto.InternalMessageInfo

func (m *MutateAdGroupFeedsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupFeedsRequest) GetOperations() []*AdGroupFeedOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, update, remove) on an ad group feed.
type AdGroupFeedOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupFeedOperation_Create
	//	*AdGroupFeedOperation_Update
	//	*AdGroupFeedOperation_Remove
	Operation            isAdGroupFeedOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *AdGroupFeedOperation) Reset()         { *m = AdGroupFeedOperation{} }
func (m *AdGroupFeedOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupFeedOperation) ProtoMessage()    {}
func (*AdGroupFeedOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_feed_service_846fa7679024c025, []int{2}
}
func (m *AdGroupFeedOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupFeedOperation.Unmarshal(m, b)
}
func (m *AdGroupFeedOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupFeedOperation.Marshal(b, m, deterministic)
}
func (dst *AdGroupFeedOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupFeedOperation.Merge(dst, src)
}
func (m *AdGroupFeedOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupFeedOperation.Size(m)
}
func (m *AdGroupFeedOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupFeedOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupFeedOperation proto.InternalMessageInfo

func (m *AdGroupFeedOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isAdGroupFeedOperation_Operation interface {
	isAdGroupFeedOperation_Operation()
}

type AdGroupFeedOperation_Create struct {
	Create *resources.AdGroupFeed `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupFeedOperation_Update struct {
	Update *resources.AdGroupFeed `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdGroupFeedOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdGroupFeedOperation_Create) isAdGroupFeedOperation_Operation() {}

func (*AdGroupFeedOperation_Update) isAdGroupFeedOperation_Operation() {}

func (*AdGroupFeedOperation_Remove) isAdGroupFeedOperation_Operation() {}

func (m *AdGroupFeedOperation) GetOperation() isAdGroupFeedOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupFeedOperation) GetCreate() *resources.AdGroupFeed {
	if x, ok := m.GetOperation().(*AdGroupFeedOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupFeedOperation) GetUpdate() *resources.AdGroupFeed {
	if x, ok := m.GetOperation().(*AdGroupFeedOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdGroupFeedOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupFeedOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupFeedOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupFeedOperation_OneofMarshaler, _AdGroupFeedOperation_OneofUnmarshaler, _AdGroupFeedOperation_OneofSizer, []interface{}{
		(*AdGroupFeedOperation_Create)(nil),
		(*AdGroupFeedOperation_Update)(nil),
		(*AdGroupFeedOperation_Remove)(nil),
	}
}

func _AdGroupFeedOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupFeedOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupFeedOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *AdGroupFeedOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *AdGroupFeedOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("AdGroupFeedOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _AdGroupFeedOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupFeedOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroupFeed)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupFeedOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroupFeed)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupFeedOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &AdGroupFeedOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupFeedOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupFeedOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupFeedOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupFeedOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupFeedOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for an ad group feed mutate.
type MutateAdGroupFeedsResponse struct {
	// All results for the mutate.
	Results              []*MutateAdGroupFeedResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *MutateAdGroupFeedsResponse) Reset()         { *m = MutateAdGroupFeedsResponse{} }
func (m *MutateAdGroupFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupFeedsResponse) ProtoMessage()    {}
func (*MutateAdGroupFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_feed_service_846fa7679024c025, []int{3}
}
func (m *MutateAdGroupFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupFeedsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupFeedsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupFeedsResponse.Merge(dst, src)
}
func (m *MutateAdGroupFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupFeedsResponse.Size(m)
}
func (m *MutateAdGroupFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupFeedsResponse proto.InternalMessageInfo

func (m *MutateAdGroupFeedsResponse) GetResults() []*MutateAdGroupFeedResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the ad group feed mutate.
type MutateAdGroupFeedResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupFeedResult) Reset()         { *m = MutateAdGroupFeedResult{} }
func (m *MutateAdGroupFeedResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupFeedResult) ProtoMessage()    {}
func (*MutateAdGroupFeedResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_feed_service_846fa7679024c025, []int{4}
}
func (m *MutateAdGroupFeedResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupFeedResult.Unmarshal(m, b)
}
func (m *MutateAdGroupFeedResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupFeedResult.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupFeedResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupFeedResult.Merge(dst, src)
}
func (m *MutateAdGroupFeedResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupFeedResult.Size(m)
}
func (m *MutateAdGroupFeedResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupFeedResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupFeedResult proto.InternalMessageInfo

func (m *MutateAdGroupFeedResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupFeedRequest)(nil), "google.ads.googleads.v0.services.GetAdGroupFeedRequest")
	proto.RegisterType((*MutateAdGroupFeedsRequest)(nil), "google.ads.googleads.v0.services.MutateAdGroupFeedsRequest")
	proto.RegisterType((*AdGroupFeedOperation)(nil), "google.ads.googleads.v0.services.AdGroupFeedOperation")
	proto.RegisterType((*MutateAdGroupFeedsResponse)(nil), "google.ads.googleads.v0.services.MutateAdGroupFeedsResponse")
	proto.RegisterType((*MutateAdGroupFeedResult)(nil), "google.ads.googleads.v0.services.MutateAdGroupFeedResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AdGroupFeedServiceClient is the client API for AdGroupFeedService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupFeedServiceClient interface {
	// Returns the requested ad group feed in full detail.
	GetAdGroupFeed(ctx context.Context, in *GetAdGroupFeedRequest, opts ...grpc.CallOption) (*resources.AdGroupFeed, error)
	// Creates, updates, or removes ad group feeds. Operation statuses are
	// returned.
	MutateAdGroupFeeds(ctx context.Context, in *MutateAdGroupFeedsRequest, opts ...grpc.CallOption) (*MutateAdGroupFeedsResponse, error)
}

type adGroupFeedServiceClient struct {
	cc *grpc.ClientConn
}

func NewAdGroupFeedServiceClient(cc *grpc.ClientConn) AdGroupFeedServiceClient {
	return &adGroupFeedServiceClient{cc}
}

func (c *adGroupFeedServiceClient) GetAdGroupFeed(ctx context.Context, in *GetAdGroupFeedRequest, opts ...grpc.CallOption) (*resources.AdGroupFeed, error) {
	out := new(resources.AdGroupFeed)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupFeedService/GetAdGroupFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupFeedServiceClient) MutateAdGroupFeeds(ctx context.Context, in *MutateAdGroupFeedsRequest, opts ...grpc.CallOption) (*MutateAdGroupFeedsResponse, error) {
	out := new(MutateAdGroupFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupFeedService/MutateAdGroupFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupFeedServiceServer is the server API for AdGroupFeedService service.
type AdGroupFeedServiceServer interface {
	// Returns the requested ad group feed in full detail.
	GetAdGroupFeed(context.Context, *GetAdGroupFeedRequest) (*resources.AdGroupFeed, error)
	// Creates, updates, or removes ad group feeds. Operation statuses are
	// returned.
	MutateAdGroupFeeds(context.Context, *MutateAdGroupFeedsRequest) (*MutateAdGroupFeedsResponse, error)
}

func RegisterAdGroupFeedServiceServer(s *grpc.Server, srv AdGroupFeedServiceServer) {
	s.RegisterService(&_AdGroupFeedService_serviceDesc, srv)
}

func _AdGroupFeedService_GetAdGroupFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupFeedServiceServer).GetAdGroupFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupFeedService/GetAdGroupFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupFeedServiceServer).GetAdGroupFeed(ctx, req.(*GetAdGroupFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupFeedService_MutateAdGroupFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupFeedServiceServer).MutateAdGroupFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupFeedService/MutateAdGroupFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupFeedServiceServer).MutateAdGroupFeeds(ctx, req.(*MutateAdGroupFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupFeedService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.AdGroupFeedService",
	HandlerType: (*AdGroupFeedServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroupFeed",
			Handler:    _AdGroupFeedService_GetAdGroupFeed_Handler,
		},
		{
			MethodName: "MutateAdGroupFeeds",
			Handler:    _AdGroupFeedService_MutateAdGroupFeeds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/ad_group_feed_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/ad_group_feed_service.proto", fileDescriptor_ad_group_feed_service_846fa7679024c025)
}

var fileDescriptor_ad_group_feed_service_846fa7679024c025 = []byte{
	// 595 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x31, 0x6f, 0xd3, 0x40,
	0x14, 0xc6, 0x0e, 0x2a, 0xea, 0x19, 0x18, 0x4e, 0xa0, 0x1a, 0x0b, 0x89, 0xc8, 0x30, 0x54, 0x19,
	0xce, 0x21, 0x88, 0x22, 0x9a, 0x14, 0x29, 0x19, 0x9a, 0x30, 0x14, 0x2a, 0x57, 0xca, 0x80, 0x22,
	0x59, 0xd7, 0xdc, 0x8b, 0x65, 0x35, 0xf6, 0xb9, 0x3e, 0x3b, 0x4b, 0xd5, 0x85, 0x1f, 0xc0, 0x02,
	0x03, 0x33, 0x23, 0x1b, 0x7f, 0x03, 0x89, 0x89, 0x81, 0x3f, 0xc0, 0x0f, 0x41, 0xf6, 0xf9, 0x82,
	0xa3, 0x24, 0x0a, 0x64, 0x7b, 0x77, 0xf7, 0xbe, 0xef, 0xbd, 0xf7, 0xbd, 0xf7, 0x0e, 0x75, 0x7c,
	0xce, 0xfd, 0x29, 0x38, 0x94, 0x09, 0x47, 0x9a, 0xb9, 0x35, 0x6b, 0x3a, 0x02, 0x92, 0x59, 0x30,
	0x06, 0xe1, 0x50, 0xe6, 0xf9, 0x09, 0xcf, 0x62, 0x6f, 0x02, 0xc0, 0xbc, 0xf2, 0x9a, 0xc4, 0x09,
	0x4f, 0x39, 0xae, 0x4b, 0x08, 0xa1, 0x4c, 0x90, 0x39, 0x9a, 0xcc, 0x9a, 0x44, 0xa1, 0xad, 0xe7,
	0xeb, 0xf8, 0x13, 0x10, 0x3c, 0x4b, 0x96, 0x02, 0x48, 0x62, 0xeb, 0xa1, 0x82, 0xc5, 0x81, 0x43,
	0xa3, 0x88, 0xa7, 0x34, 0x0d, 0x78, 0x24, 0xca, 0xd7, 0x32, 0xac, 0x53, 0x9c, 0xce, 0xb3, 0x89,
	0x33, 0x09, 0x60, 0xca, 0xbc, 0x90, 0x8a, 0x0b, 0xe9, 0x61, 0x77, 0xd0, 0xfd, 0x3e, 0xa4, 0x5d,
	0xd6, 0xcf, 0x89, 0x8f, 0x01, 0x98, 0x0b, 0x97, 0x19, 0x88, 0x14, 0x3f, 0x46, 0x77, 0x54, 0x64,
	0x2f, 0xa2, 0x21, 0x98, 0x5a, 0x5d, 0xdb, 0xdf, 0x75, 0x6f, 0xab, 0xcb, 0x37, 0x34, 0x04, 0xfb,
	0x93, 0x86, 0x1e, 0x9c, 0x64, 0x29, 0x4d, 0xa1, 0xc2, 0x20, 0x14, 0xc5, 0x23, 0x64, 0x8c, 0x33,
	0x91, 0xf2, 0x10, 0x12, 0x2f, 0x60, 0x25, 0x01, 0x52, 0x57, 0xaf, 0x19, 0x1e, 0x22, 0xc4, 0x63,
	0x48, 0x64, 0xca, 0xa6, 0x5e, 0xaf, 0xed, 0x1b, 0xad, 0x03, 0xb2, 0x49, 0x2a, 0x52, 0x89, 0xf5,
	0x56, 0xc1, 0xdd, 0x0a, 0x93, 0xfd, 0x41, 0x47, 0xf7, 0x56, 0x39, 0xe1, 0x36, 0x32, 0xb2, 0x98,
	0xd1, 0x14, 0x0a, 0x09, 0xcc, 0x9b, 0x75, 0x6d, 0xdf, 0x68, 0x59, 0x2a, 0xa2, 0x52, 0x89, 0x1c,
	0xe7, 0x2a, 0x9d, 0x50, 0x71, 0xe1, 0x22, 0xe9, 0x9e, 0xdb, 0x78, 0x80, 0x76, 0xc6, 0x09, 0xd0,
	0x54, 0x4a, 0x61, 0xb4, 0xc8, 0xda, 0x4c, 0xe7, 0x2d, 0xab, 0xa6, 0x3a, 0xb8, 0xe1, 0x96, 0xf8,
	0x9c, 0x49, 0xf2, 0x9a, 0xfa, 0xb6, 0x4c, 0x12, 0x8f, 0x4d, 0xb4, 0x93, 0x40, 0xc8, 0x67, 0x60,
	0xd6, 0x72, 0x75, 0xf3, 0x17, 0x79, 0xee, 0x19, 0x68, 0x77, 0xae, 0x88, 0x7d, 0x89, 0xac, 0x55,
	0x6d, 0x12, 0x31, 0x8f, 0x04, 0xe0, 0x33, 0x74, 0x2b, 0x01, 0x91, 0x4d, 0x53, 0xd5, 0x83, 0x97,
	0x9b, 0x7b, 0xb0, 0x44, 0xe7, 0x16, 0x0c, 0xae, 0x62, 0xb2, 0x5f, 0xa1, 0xbd, 0x35, 0x3e, 0xff,
	0x34, 0x5a, 0xad, 0xcf, 0x35, 0x84, 0x2b, 0xd0, 0x33, 0x19, 0x18, 0x7f, 0xd3, 0xd0, 0xdd, 0xc5,
	0x81, 0xc5, 0x2f, 0x36, 0x67, 0xbb, 0x72, 0xc4, 0xad, 0xff, 0x94, 0xdd, 0x3e, 0x78, 0xff, 0xf3,
	0xf7, 0x47, 0xbd, 0x89, 0x49, 0xbe, 0x96, 0x57, 0x0b, 0x25, 0x1c, 0xa9, 0xa9, 0x16, 0x4e, 0xc3,
	0xa1, 0x15, 0x91, 0x9d, 0xc6, 0x35, 0xfe, 0xa1, 0x21, 0xbc, 0x2c, 0x3f, 0x6e, 0x6f, 0xa1, 0xb2,
	0xda, 0x2d, 0xab, 0xb3, 0x1d, 0x58, 0x76, 0xdc, 0xee, 0x14, 0x95, 0x1c, 0xd8, 0x4f, 0xf3, 0x4a,
	0xfe, 0xa6, 0x7e, 0x55, 0x59, 0xd7, 0xa3, 0xc6, 0xf5, 0x42, 0x21, 0x87, 0x61, 0x41, 0x77, 0xa8,
	0x35, 0x7a, 0xbf, 0x34, 0xf4, 0x64, 0xcc, 0xc3, 0x8d, 0x19, 0xf4, 0xf6, 0x96, 0x1b, 0x78, 0x9a,
	0xef, 0xd8, 0xa9, 0xf6, 0x6e, 0x50, 0x82, 0x7d, 0x3e, 0xa5, 0x91, 0x4f, 0x78, 0xe2, 0x3b, 0x3e,
	0x44, 0xc5, 0x06, 0xaa, 0xef, 0x2f, 0x0e, 0xc4, 0xfa, 0xdf, 0xb6, 0xad, 0x8c, 0x2f, 0x7a, 0xad,
	0xdf, 0xed, 0x7e, 0xd5, 0xeb, 0x7d, 0x49, 0xd8, 0x65, 0x82, 0x48, 0x33, 0xb7, 0x86, 0x4d, 0x52,
	0x06, 0x16, 0xdf, 0x95, 0xcb, 0xa8, 0xcb, 0xc4, 0x68, 0xee, 0x32, 0x1a, 0x36, 0x47, 0xca, 0xe5,
	0x7c, 0xa7, 0x48, 0xe0, 0xd9, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd2, 0x08, 0x96, 0x6e, 0xed,
	0x05, 0x00, 0x00,
}
