/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "../../groonga/lib/grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT
#line 35 "../../groonga/lib/grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    grn_expr_parserCTX_*         As grn_expr_parserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 114
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy217;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_PARAM ,efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi =yypParser->efsi ;
#define grn_expr_parserARG_STORE yypParser->efsi =efsi ;
#define grn_expr_parserCTX_SDECL
#define grn_expr_parserCTX_PDECL
#define grn_expr_parserCTX_PARAM
#define grn_expr_parserCTX_FETCH
#define grn_expr_parserCTX_STORE
#define YYNSTATE             147
#define YYNRULE              137
#define YYNTOKEN             76
#define YY_MAX_SHIFT         146
#define YY_MIN_SHIFTREDUCE   234
#define YY_MAX_SHIFTREDUCE   370
#define YY_ERROR_ACTION      371
#define YY_ACCEPT_ACTION     372
#define YY_NO_ACTION         373
#define YY_MIN_REDUCE        374
#define YY_MAX_REDUCE        510
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1820)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   374,    3,   73,  117,  117,  138,  378,  326,    2,  377,
 /*    10 */    55,   84,  131,    1,  133,   72,  372,   80,  114,   10,
 /*    20 */   383,   80,   76,  114,  114,   92,  128,  127,  141,  140,
 /*    30 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*    40 */   383,  383,   76,   76,  326,   75,  381,   85,   84,  146,
 /*    50 */     9,  380,   72,  464,   67,   66,   54,   53,   52,   70,
 /*    60 */    69,   68,   65,   64,   62,   61,   60,  351,  352,  353,
 /*    70 */   354,  355,    4,  129,   71,   59,   58,   76,  129,  129,
 /*    80 */    92,  128,  127,  141,  140,  139,  122,   89,  105,  118,
 /*    90 */   106,  106,  106,   92,   76,   79,  463,   76,   76,   79,
 /*   100 */   366,  117,  117,  138,  379,  326,    2,   77,   55,   84,
 /*   110 */   131,    1,    5,   72,   79,  120,  112,  506,   79,   76,
 /*   120 */   120,  120,   92,  128,  127,  141,  140,  139,  122,   89,
 /*   130 */   105,  118,  106,  106,  106,   92,   76,  458,  135,   76,
 /*   140 */    76,    7,  303,   63,   78,  349,   74,  112,  135,  442,
 /*   150 */   486,  376,   67,   66,  505,  138,  375,   70,   69,   68,
 /*   160 */    65,   64,   62,   61,   60,  351,  352,  353,  354,  355,
 /*   170 */     4,   51,   50,   49,   48,   47,   46,   45,   44,   43,
 /*   180 */    42,   41,   40,   39,   38,   37,   83,   67,   66,  315,
 /*   190 */    57,   56,   70,   69,   68,   65,   64,   62,   61,   60,
 /*   200 */   351,  352,  353,  354,  355,    4,  113,  320,  316,   76,
 /*   210 */   457,  457,   92,  128,  127,  141,  140,  139,  122,   89,
 /*   220 */   105,  118,  106,  106,  106,   92,   76,   31,   30,   76,
 /*   230 */    76,    7,  132,   63,    6,  349,   74,  452,  319,  360,
 /*   240 */   134,   76,   88,   88,   92,  128,  127,  141,  140,  139,
 /*   250 */   122,   89,  105,  118,  106,  106,  106,   92,   76,  462,
 /*   260 */    32,   76,   76,   11,   88,    7,  242,   63,   28,  349,
 /*   270 */    74,   24,  307,  360,  359,   28,    7,   67,   66,   23,
 /*   280 */   349,   74,   70,   69,   68,   65,   64,   62,   61,   60,
 /*   290 */   351,  352,  353,  354,  355,    4,  357,    7,    8,   63,
 /*   300 */   137,  349,   74,  348,  367,  359,   33,   36,   35,   29,
 /*   310 */    28,   67,   66,  300,  301,   34,   70,   69,   68,   65,
 /*   320 */    64,   62,   61,   60,  351,  352,  353,  354,  355,    4,
 /*   330 */   356,  358,   25,   26,   28,  351,  352,  353,  354,  355,
 /*   340 */     4,  373,  373,   67,   66,  373,  373,  373,   70,   69,
 /*   350 */    68,   65,   64,   62,   61,   60,  351,  352,  353,  354,
 /*   360 */   355,    4,   76,  457,  457,   92,  128,  127,  141,  140,
 /*   370 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   380 */   373,  373,   76,   76,  373,  373,  373,  373,  373,  373,
 /*   390 */   454,  306,  373,  373,  373,   76,  449,  449,   92,  128,
 /*   400 */   127,  141,  140,  139,  122,   89,  105,  118,  106,  106,
 /*   410 */   106,   92,   76,  373,  373,   76,   76,  373,  373,  373,
 /*   420 */   373,  373,  116,  120,  373,  373,  373,   76,  120,  120,
 /*   430 */    92,  128,  127,  141,  140,  139,  122,   89,  105,  118,
 /*   440 */   106,  106,  106,   92,   76,  123,  373,   76,   76,   76,
 /*   450 */   123,  123,   92,  128,  127,  141,  140,  139,  122,   89,
 /*   460 */   105,  118,  106,  106,  106,   92,   76,  373,  373,   76,
 /*   470 */    76,  373,    7,  373,   63,  129,  349,   74,  373,   76,
 /*   480 */   129,  129,   92,  128,  127,  141,  140,  139,  122,   89,
 /*   490 */   105,  118,  106,  106,  106,   92,   76,  373,  373,   76,
 /*   500 */    76,    7,  373,   63,  373,  349,   74,  373,  373,  373,
 /*   510 */   373,  373,  373,  373,  373,  373,  373,  373,   67,   66,
 /*   520 */   373,  373,  373,   70,   69,   68,   65,   64,   62,   61,
 /*   530 */    60,  351,  352,  130,  354,  355,    4,  373,  373,  373,
 /*   540 */   373,  373,  373,  373,  373,  373,  373,   67,   66,  373,
 /*   550 */   373,  373,   70,   69,   68,   65,   64,   62,   61,   60,
 /*   560 */   351,  352,  353,  354,  355,    4,   76,  503,  503,   92,
 /*   570 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   580 */   106,  106,   92,   76,  373,  373,   76,   76,  373,   76,
 /*   590 */   502,  502,   92,  128,  127,  141,  140,  139,  122,   89,
 /*   600 */   105,  118,  106,  106,  106,   92,   76,  373,  373,   76,
 /*   610 */    76,   76,  396,  396,   92,  128,  127,  141,  140,  139,
 /*   620 */   122,   89,  105,  118,  106,  106,  106,   92,   76,  373,
 /*   630 */   373,   76,   76,  373,  373,  373,   76,  395,  395,   92,
 /*   640 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   650 */   106,  106,   92,   76,  373,  373,   76,   76,   76,  394,
 /*   660 */   394,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   670 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   680 */    76,  393,  393,   92,  128,  127,  141,  140,  139,  122,
 /*   690 */    89,  105,  118,  106,  106,  106,   92,   76,  373,  373,
 /*   700 */    76,   76,   76,  392,  392,   92,  128,  127,  141,  140,
 /*   710 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   720 */   373,  373,   76,   76,   76,  391,  391,   92,  128,  127,
 /*   730 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   740 */    92,   76,  373,  373,   76,   76,   76,  390,  390,   92,
 /*   750 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   760 */   106,  106,   92,   76,  373,  373,   76,   76,   76,  389,
 /*   770 */   389,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   780 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   790 */    76,  388,  388,   92,  128,  127,  141,  140,  139,  122,
 /*   800 */    89,  105,  118,  106,  106,  106,   92,   76,  373,  373,
 /*   810 */    76,   76,   76,  387,  387,   92,  128,  127,  141,  140,
 /*   820 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   830 */   373,  373,   76,   76,   76,  386,  386,   92,  128,  127,
 /*   840 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   850 */    92,   76,  373,  373,   76,   76,   76,  450,  450,   92,
 /*   860 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   870 */   106,  106,   92,   76,  373,  373,   76,   76,   76,  445,
 /*   880 */   445,   92,  128,  127,  141,  140,  139,  122,   89,  105,
 /*   890 */   118,  106,  106,  106,   92,   76,  373,  373,   76,   76,
 /*   900 */    76,  397,  397,   92,  128,  127,  141,  140,  139,  122,
 /*   910 */    89,  105,  118,  106,  106,  106,   92,   76,  373,  373,
 /*   920 */    76,   76,   76,  145,  145,   92,  128,  127,  141,  140,
 /*   930 */   139,  122,   89,  105,  118,  106,  106,  106,   92,   76,
 /*   940 */   373,  373,   76,   76,   76,  385,  385,   92,  128,  127,
 /*   950 */   141,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*   960 */    92,   76,  373,  373,   76,   76,   76,  384,  384,   92,
 /*   970 */   128,  127,  141,  140,  139,  122,   89,  105,  118,  106,
 /*   980 */   106,  106,   92,   76,  373,   76,   76,   76,  124,  373,
 /*   990 */   115,  141,  140,  139,  122,   89,  105,  118,  106,  106,
 /*  1000 */   106,  124,   76,  373,   76,   76,   76,  124,  373,  373,
 /*  1010 */   136,  140,  139,  122,   89,  105,  118,  106,  106,  106,
 /*  1020 */   124,   76,  373,   76,   76,   76,  124,  373,  373,  144,
 /*  1030 */   140,  139,  122,   89,  105,  118,  106,  106,  106,  124,
 /*  1040 */    76,  373,   76,   76,   76,  124,  373,  373,  373,  143,
 /*  1050 */   139,  122,   89,  105,  118,  106,  106,  106,  124,   76,
 /*  1060 */   373,   76,   76,   76,  124,  373,  373,  373,  373,  142,
 /*  1070 */   122,   89,  105,  118,  106,  106,  106,  124,   76,  373,
 /*  1080 */   373,   76,   76,  373,  373,  373,  373,   27,   22,   21,
 /*  1090 */    20,   19,   18,   17,   16,   15,   14,   13,   12,   76,
 /*  1100 */   373,  373,  124,  373,  373,  373,  373,  373,  126,   89,
 /*  1110 */   105,  118,  106,  106,  106,  124,   76,  373,  373,   76,
 /*  1120 */    76,  373,   76,  373,  373,  124,  373,  373,  373,  373,
 /*  1130 */   300,  301,   90,  105,  118,  106,  106,  106,  124,   76,
 /*  1140 */   373,   76,   76,   76,  124,  373,  373,  373,  373,  373,
 /*  1150 */   373,   91,  105,  118,  106,  106,  106,  124,   76,  373,
 /*  1160 */   373,   76,   76,  373,  373,   87,   86,   82,   81,  326,
 /*  1170 */    75,  327,   85,   84,  146,    9,  461,   72,  373,   87,
 /*  1180 */    86,   82,   81,  326,   75,  373,   85,   84,  146,    9,
 /*  1190 */   373,   72,   76,  373,  373,  124,  373,  373,  373,  373,
 /*  1200 */   373,  373,  373,   93,  118,  106,  106,  106,  124,   76,
 /*  1210 */   373,  373,   76,   76,   76,  373,  373,  124,  373,  373,
 /*  1220 */   373,  373,  373,  373,  373,   94,  118,  106,  106,  106,
 /*  1230 */   124,   76,  373,  373,   76,   76,   76,  373,  373,  124,
 /*  1240 */   373,  373,  373,  373,  373,  373,  373,   95,  118,  106,
 /*  1250 */   106,  106,  124,   76,  373,   76,   76,   76,  124,  373,
 /*  1260 */   373,  373,  373,  373,  373,  373,   96,  118,  106,  106,
 /*  1270 */   106,  124,   76,  373,  373,   76,   76,  373,  373,   76,
 /*  1280 */   373,  373,  124,  373,  373,  373,  373,  373,  373,  373,
 /*  1290 */    97,  118,  106,  106,  106,  124,   76,  373,   76,   76,
 /*  1300 */    76,  124,  373,  373,  373,  373,  373,  373,  373,   98,
 /*  1310 */   118,  106,  106,  106,  124,   76,  373,  373,   76,   76,
 /*  1320 */    76,  373,  373,  124,  373,  373,  373,  373,  373,  373,
 /*  1330 */   373,   99,  118,  106,  106,  106,  124,   76,  373,   76,
 /*  1340 */    76,   76,  124,  373,  373,  373,  373,  373,  373,  373,
 /*  1350 */   100,  118,  106,  106,  106,  124,   76,  373,  373,   76,
 /*  1360 */    76,  373,  373,   76,  373,  373,  124,  373,  373,  373,
 /*  1370 */   373,  373,  373,  373,  101,  118,  106,  106,  106,  124,
 /*  1380 */    76,  373,   76,   76,   76,  124,  373,  373,  373,  373,
 /*  1390 */   373,  373,  373,  102,  118,  106,  106,  106,  124,   76,
 /*  1400 */   373,  373,   76,   76,   76,  373,  373,  124,  373,  373,
 /*  1410 */   373,  373,  373,  373,  373,  103,  118,  106,  106,  106,
 /*  1420 */   124,   76,  373,   76,   76,   76,  124,  373,  373,  373,
 /*  1430 */   373,  373,  373,  373,  104,  118,  106,  106,  106,  124,
 /*  1440 */    76,  373,  373,   76,   76,  373,  373,   76,  373,  373,
 /*  1450 */   124,  373,  373,  373,  373,  373,  373,  373,  107,  118,
 /*  1460 */   106,  106,  106,  124,   76,  373,   76,   76,   76,  124,
 /*  1470 */   373,  373,  373,  373,  373,  373,  373,  109,  118,  106,
 /*  1480 */   106,  106,  124,   76,  373,  373,   76,   76,   76,  373,
 /*  1490 */   373,  124,  373,  373,  373,  373,  373,  373,  373,  111,
 /*  1500 */   118,  106,  106,  106,  124,   76,  373,   76,   76,   76,
 /*  1510 */   124,  373,  373,  373,  373,  373,  373,  373,  373,  119,
 /*  1520 */   106,  106,  106,  124,   76,  373,  373,   76,   76,  373,
 /*  1530 */   373,   76,  373,  373,  124,  373,  373,  373,  373,  373,
 /*  1540 */   373,  373,  373,  121,  106,  106,  106,  124,   76,  373,
 /*  1550 */    76,   76,   76,  124,  373,  373,  373,  373,  373,  373,
 /*  1560 */   373,  373,  125,  106,  106,  106,  124,   76,  373,  373,
 /*  1570 */    76,   76,  373,  373,  379,   76,  373,  373,  124,  373,
 /*  1580 */   373,  373,  373,  373,   76,  373,  373,  124,  373,  436,
 /*  1590 */   436,  124,   76,  373,  373,   76,   76,  108,  108,  108,
 /*  1600 */   124,   76,  373,   76,   76,   76,  124,  373,  373,  373,
 /*  1610 */   373,   76,  373,  373,  124,  373,  110,  110,  110,  124,
 /*  1620 */    76,  373,  373,   76,   76,  428,  428,  124,   76,  373,
 /*  1630 */    76,   76,   76,  124,  373,  373,  373,  373,  373,  373,
 /*  1640 */   373,  373,  373,  373,  427,  427,  124,   76,  373,   76,
 /*  1650 */    76,   76,  124,  373,  373,  373,  373,  373,   76,  373,
 /*  1660 */   373,  124,  373,  439,  439,  124,   76,  373,   76,   76,
 /*  1670 */    76,  124,  438,  438,  124,   76,  373,  373,   76,   76,
 /*  1680 */   373,  373,  437,  437,  124,   76,  373,   76,   76,   76,
 /*  1690 */   124,  373,  373,  373,  373,   76,  373,  373,  124,  373,
 /*  1700 */   373,  436,  436,  124,   76,  373,  373,   76,   76,  435,
 /*  1710 */   435,  124,   76,  373,   76,   76,   76,  124,  373,  373,
 /*  1720 */   373,  373,  373,  373,  373,  373,  373,  373,  434,  434,
 /*  1730 */   124,   76,  373,   76,   76,   76,  124,  373,  373,  373,
 /*  1740 */   373,  373,   76,  373,  373,  124,  373,  433,  433,  124,
 /*  1750 */    76,  373,   76,   76,   76,  124,  432,  432,  124,   76,
 /*  1760 */   373,  373,   76,   76,  373,  373,  431,  431,  124,   76,
 /*  1770 */   373,   76,   76,   76,  124,  373,  373,  373,  373,   76,
 /*  1780 */   373,  373,  124,  373,  373,  430,  430,  124,   76,  373,
 /*  1790 */   373,   76,   76,  429,  429,  124,   76,  373,   76,   76,
 /*  1800 */    76,  124,  373,  373,  373,  373,  373,  373,  373,  373,
 /*  1810 */   373,  373,  426,  426,  124,   76,  373,  373,   76,   76,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    82,    1,    2,  107,  108,  109,   82,    7,    8,   82,
 /*    10 */    10,   11,   12,   13,   12,   15,   77,   78,   79,  105,
 /*    20 */    83,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*    30 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*    40 */   103,  104,  103,  104,    7,    8,   82,   10,   11,   12,
 /*    50 */    13,   82,   15,    0,   54,   55,   51,   52,   53,   59,
 /*    60 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*    70 */    70,   71,   72,   79,   56,   57,   58,   83,   84,   85,
 /*    80 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*    90 */    96,   97,   98,   99,  100,   78,    0,  103,  104,   82,
 /*   100 */    69,  107,  108,  109,   82,    7,    8,   54,   10,   11,
 /*   110 */    12,   13,   16,   15,   78,   79,   81,   30,   82,   83,
 /*   120 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   130 */    94,   95,   96,   97,   98,   99,  100,  112,  113,  103,
 /*   140 */   104,    8,   14,   10,   16,   12,   13,  112,  113,  101,
 /*   150 */   102,   82,   54,   55,  108,  109,   82,   59,   60,   61,
 /*   160 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   170 */    72,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   180 */    45,   46,   47,   48,   49,   50,   11,   54,   55,   56,
 /*   190 */    54,   55,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   200 */    67,   68,   69,   70,   71,   72,   80,   69,   75,   83,
 /*   210 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   220 */    94,   95,   96,   97,   98,   99,  100,    3,    4,  103,
 /*   230 */   104,    8,   41,   10,    8,   12,   13,  111,   67,   16,
 /*   240 */    56,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   250 */    92,   93,   94,   95,   96,   97,   98,   99,  100,    0,
 /*   260 */    31,  103,  104,  105,  106,    8,   14,   10,   16,   12,
 /*   270 */    13,   30,    9,   16,   16,   16,    8,   54,   55,   16,
 /*   280 */    12,   13,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   290 */    67,   68,   69,   70,   71,   72,   73,    8,   72,   10,
 /*   300 */    74,   12,   13,    9,   12,   16,   32,   34,   35,    5,
 /*   310 */    16,   54,   55,   60,   61,   33,   59,   60,   61,   62,
 /*   320 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   330 */    73,   73,   30,   29,   16,   67,   68,   69,   70,   71,
 /*   340 */    72,  114,  114,   54,   55,  114,  114,  114,   59,   60,
 /*   350 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   360 */    71,   72,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   370 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   380 */   114,  114,  103,  104,  114,  114,  114,  114,  114,  114,
 /*   390 */   111,   73,  114,  114,  114,   83,   84,   85,   86,   87,
 /*   400 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   410 */    98,   99,  100,  114,  114,  103,  104,  114,  114,  114,
 /*   420 */   114,  114,  110,   79,  114,  114,  114,   83,   84,   85,
 /*   430 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   440 */    96,   97,   98,   99,  100,   79,  114,  103,  104,   83,
 /*   450 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   460 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*   470 */   104,  114,    8,  114,   10,   79,   12,   13,  114,   83,
 /*   480 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   490 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*   500 */   104,    8,  114,   10,  114,   12,   13,  114,  114,  114,
 /*   510 */   114,  114,  114,  114,  114,  114,  114,  114,   54,   55,
 /*   520 */   114,  114,  114,   59,   60,   61,   62,   63,   64,   65,
 /*   530 */    66,   67,   68,   69,   70,   71,   72,  114,  114,  114,
 /*   540 */   114,  114,  114,  114,  114,  114,  114,   54,   55,  114,
 /*   550 */   114,  114,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   560 */    67,   68,   69,   70,   71,   72,   83,   84,   85,   86,
 /*   570 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   580 */    97,   98,   99,  100,  114,  114,  103,  104,  114,   83,
 /*   590 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   600 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*   610 */   104,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   620 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*   630 */   114,  103,  104,  114,  114,  114,   83,   84,   85,   86,
 /*   640 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   650 */    97,   98,   99,  100,  114,  114,  103,  104,   83,   84,
 /*   660 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   670 */    95,   96,   97,   98,   99,  100,  114,  114,  103,  104,
 /*   680 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   690 */    93,   94,   95,   96,   97,   98,   99,  100,  114,  114,
 /*   700 */   103,  104,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   710 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   720 */   114,  114,  103,  104,   83,   84,   85,   86,   87,   88,
 /*   730 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   740 */    99,  100,  114,  114,  103,  104,   83,   84,   85,   86,
 /*   750 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   760 */    97,   98,   99,  100,  114,  114,  103,  104,   83,   84,
 /*   770 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   780 */    95,   96,   97,   98,   99,  100,  114,  114,  103,  104,
 /*   790 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   800 */    93,   94,   95,   96,   97,   98,   99,  100,  114,  114,
 /*   810 */   103,  104,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   820 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   830 */   114,  114,  103,  104,   83,   84,   85,   86,   87,   88,
 /*   840 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   850 */    99,  100,  114,  114,  103,  104,   83,   84,   85,   86,
 /*   860 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   870 */    97,   98,   99,  100,  114,  114,  103,  104,   83,   84,
 /*   880 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   890 */    95,   96,   97,   98,   99,  100,  114,  114,  103,  104,
 /*   900 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   910 */    93,   94,   95,   96,   97,   98,   99,  100,  114,  114,
 /*   920 */   103,  104,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   940 */   114,  114,  103,  104,   83,   84,   85,   86,   87,   88,
 /*   950 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   960 */    99,  100,  114,  114,  103,  104,   83,   84,   85,   86,
 /*   970 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   980 */    97,   98,   99,  100,  114,   83,  103,  104,   86,  114,
 /*   990 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  1000 */    98,   99,  100,  114,   83,  103,  104,   86,  114,  114,
 /*  1010 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1020 */    99,  100,  114,   83,  103,  104,   86,  114,  114,   89,
 /*  1030 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*  1040 */   100,  114,   83,  103,  104,   86,  114,  114,  114,   90,
 /*  1050 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1060 */   114,   83,  103,  104,   86,  114,  114,  114,  114,   91,
 /*  1070 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*  1080 */   114,  103,  104,  114,  114,  114,  114,   17,   18,   19,
 /*  1090 */    20,   21,   22,   23,   24,   25,   26,   27,   28,   83,
 /*  1100 */   114,  114,   86,  114,  114,  114,  114,  114,   92,   93,
 /*  1110 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*  1120 */   104,  114,   83,  114,  114,   86,  114,  114,  114,  114,
 /*  1130 */    60,   61,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1140 */   114,   83,  103,  104,   86,  114,  114,  114,  114,  114,
 /*  1150 */   114,   93,   94,   95,   96,   97,   98,   99,  100,  114,
 /*  1160 */   114,  103,  104,  114,  114,    3,    4,    5,    6,    7,
 /*  1170 */     8,    9,   10,   11,   12,   13,    0,   15,  114,    3,
 /*  1180 */     4,    5,    6,    7,    8,  114,   10,   11,   12,   13,
 /*  1190 */   114,   15,   83,  114,  114,   86,  114,  114,  114,  114,
 /*  1200 */   114,  114,  114,   94,   95,   96,   97,   98,   99,  100,
 /*  1210 */   114,  114,  103,  104,   83,  114,  114,   86,  114,  114,
 /*  1220 */   114,  114,  114,  114,  114,   94,   95,   96,   97,   98,
 /*  1230 */    99,  100,  114,  114,  103,  104,   83,  114,  114,   86,
 /*  1240 */   114,  114,  114,  114,  114,  114,  114,   94,   95,   96,
 /*  1250 */    97,   98,   99,  100,  114,   83,  103,  104,   86,  114,
 /*  1260 */   114,  114,  114,  114,  114,  114,   94,   95,   96,   97,
 /*  1270 */    98,   99,  100,  114,  114,  103,  104,  114,  114,   83,
 /*  1280 */   114,  114,   86,  114,  114,  114,  114,  114,  114,  114,
 /*  1290 */    94,   95,   96,   97,   98,   99,  100,  114,   83,  103,
 /*  1300 */   104,   86,  114,  114,  114,  114,  114,  114,  114,   94,
 /*  1310 */    95,   96,   97,   98,   99,  100,  114,  114,  103,  104,
 /*  1320 */    83,  114,  114,   86,  114,  114,  114,  114,  114,  114,
 /*  1330 */   114,   94,   95,   96,   97,   98,   99,  100,  114,   83,
 /*  1340 */   103,  104,   86,  114,  114,  114,  114,  114,  114,  114,
 /*  1350 */    94,   95,   96,   97,   98,   99,  100,  114,  114,  103,
 /*  1360 */   104,  114,  114,   83,  114,  114,   86,  114,  114,  114,
 /*  1370 */   114,  114,  114,  114,   94,   95,   96,   97,   98,   99,
 /*  1380 */   100,  114,   83,  103,  104,   86,  114,  114,  114,  114,
 /*  1390 */   114,  114,  114,   94,   95,   96,   97,   98,   99,  100,
 /*  1400 */   114,  114,  103,  104,   83,  114,  114,   86,  114,  114,
 /*  1410 */   114,  114,  114,  114,  114,   94,   95,   96,   97,   98,
 /*  1420 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1430 */   114,  114,  114,  114,   94,   95,   96,   97,   98,   99,
 /*  1440 */   100,  114,  114,  103,  104,  114,  114,   83,  114,  114,
 /*  1450 */    86,  114,  114,  114,  114,  114,  114,  114,   94,   95,
 /*  1460 */    96,   97,   98,   99,  100,  114,   83,  103,  104,   86,
 /*  1470 */   114,  114,  114,  114,  114,  114,  114,   94,   95,   96,
 /*  1480 */    97,   98,   99,  100,  114,  114,  103,  104,   83,  114,
 /*  1490 */   114,   86,  114,  114,  114,  114,  114,  114,  114,   94,
 /*  1500 */    95,   96,   97,   98,   99,  100,  114,   83,  103,  104,
 /*  1510 */    86,  114,  114,  114,  114,  114,  114,  114,  114,   95,
 /*  1520 */    96,   97,   98,   99,  100,  114,  114,  103,  104,  114,
 /*  1530 */   114,   83,  114,  114,   86,  114,  114,  114,  114,  114,
 /*  1540 */   114,  114,  114,   95,   96,   97,   98,   99,  100,  114,
 /*  1550 */    83,  103,  104,   86,  114,  114,  114,  114,  114,  114,
 /*  1560 */   114,  114,   95,   96,   97,   98,   99,  100,  114,  114,
 /*  1570 */   103,  104,  114,  114,   82,   83,  114,  114,   86,  114,
 /*  1580 */   114,  114,  114,  114,   83,  114,  114,   86,  114,   97,
 /*  1590 */    98,   99,  100,  114,  114,  103,  104,   96,   97,   98,
 /*  1600 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1610 */   114,   83,  114,  114,   86,  114,   96,   97,   98,   99,
 /*  1620 */   100,  114,  114,  103,  104,   97,   98,   99,  100,  114,
 /*  1630 */    83,  103,  104,   86,  114,  114,  114,  114,  114,  114,
 /*  1640 */   114,  114,  114,  114,   97,   98,   99,  100,  114,   83,
 /*  1650 */   103,  104,   86,  114,  114,  114,  114,  114,   83,  114,
 /*  1660 */   114,   86,  114,   97,   98,   99,  100,  114,   83,  103,
 /*  1670 */   104,   86,   97,   98,   99,  100,  114,  114,  103,  104,
 /*  1680 */   114,  114,   97,   98,   99,  100,  114,   83,  103,  104,
 /*  1690 */    86,  114,  114,  114,  114,   83,  114,  114,   86,  114,
 /*  1700 */   114,   97,   98,   99,  100,  114,  114,  103,  104,   97,
 /*  1710 */    98,   99,  100,  114,   83,  103,  104,   86,  114,  114,
 /*  1720 */   114,  114,  114,  114,  114,  114,  114,  114,   97,   98,
 /*  1730 */    99,  100,  114,   83,  103,  104,   86,  114,  114,  114,
 /*  1740 */   114,  114,   83,  114,  114,   86,  114,   97,   98,   99,
 /*  1750 */   100,  114,   83,  103,  104,   86,   97,   98,   99,  100,
 /*  1760 */   114,  114,  103,  104,  114,  114,   97,   98,   99,  100,
 /*  1770 */   114,   83,  103,  104,   86,  114,  114,  114,  114,   83,
 /*  1780 */   114,  114,   86,  114,  114,   97,   98,   99,  100,  114,
 /*  1790 */   114,  103,  104,   97,   98,   99,  100,  114,   83,  103,
 /*  1800 */   104,   86,  114,  114,  114,  114,  114,  114,  114,  114,
 /*  1810 */   114,  114,   97,   98,   99,  100,  114,  114,  103,  104,
};
#define YY_SHIFT_COUNT    (146)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1176)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,  464,   98,  133,  289,  133,  493,  493,  493,  493,
 /*    10 */   223,  257,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    20 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    30 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    40 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    50 */   493,  493,  493,  493,  493,   98,  493,  493,  493,  493,
 /*    60 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    70 */   493,  493,  268,    2,   31,   37,  226,    2,   31, 1162,
 /*    80 */  1176,   37,   37,   37,   37,   37,   37,   37,  258,  135,
 /*    90 */   135,  135, 1070,    5,    5,    5,    5,    5,    5,    5,
 /*   100 */     5,    5,    5,    5,    5,    5,   18,    5,   18,    5,
 /*   110 */    18,    5,   53,   96,  259,  224,  263,  128,  136,  136,
 /*   120 */   294,  136,  273,  318,  253,  136,  273,  224,  304,  252,
 /*   130 */    87,  175,  138,  191,  171,  184,  229,  292,  241,  282,
 /*   140 */   274,  229,  282,  274,  229,  302,  175,
};
#define YY_REDUCE_COUNT (88)
#define YY_REDUCE_MIN   (-104)
#define YY_REDUCE_MAX   (1715)
static const short yy_reduce_ofst[] = {
 /*     0 */   -61,   -6,   36,  126,  158,  279,  312,  344,  366,  396,
 /*    10 */   483,  506,  528,  553,  575,  597,  619,  641,  663,  685,
 /*    20 */   707,  729,  751,  773,  795,  817,  839,  861,  883,  902,
 /*    30 */   921,  940,  959,  978, 1016, 1039, 1058, 1109, 1131, 1153,
 /*    40 */  1172, 1196, 1215, 1237, 1256, 1280, 1299, 1321, 1340, 1364,
 /*    50 */  1383, 1405, 1424, 1448, 1467, 1492, 1501, 1520, 1528, 1547,
 /*    60 */  1566, 1575, 1585, 1604, 1612, 1631, 1650, 1659, 1669, 1688,
 /*    70 */  1696, 1715,  -63,   35, -104,   17,   48,   25,   46,  -82,
 /*    80 */   -82,  -76,  -73,  -36,  -31,   22,   69,   74,  -86,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   371,  444,  371,  451,  371,  453,  448,  371,  371,  371,
 /*    10 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*    20 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*    30 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*    40 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*    50 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*    60 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  371,
 /*    70 */   371,  371,  371,  508,  444,  371,  484,  371,  371,  371,
 /*    80 */   371,  371,  371,  371,  371,  371,  371,  371,  371,  476,
 /*    90 */   405,  404,  482,  420,  419,  418,  417,  416,  415,  414,
 /*   100 */   413,  412,  411,  410,  409,  477,  479,  408,  425,  407,
 /*   110 */   424,  406,  371,  371,  371,  398,  371,  371,  478,  423,
 /*   120 */   371,  422,  475,  371,  482,  421,  403,  471,  470,  371,
 /*   130 */   493,  489,  371,  371,  371,  510,  400,  371,  371,  474,
 /*   140 */   473,  472,  402,  401,  399,  371,  371,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
  grn_expr_parserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "START_OUTPUT_COLUMNS",
  /*    2 */ "START_ADJUSTER",
  /*    3 */ "LOGICAL_AND",
  /*    4 */ "LOGICAL_AND_NOT",
  /*    5 */ "LOGICAL_OR",
  /*    6 */ "NEGATIVE",
  /*    7 */ "QSTRING",
  /*    8 */ "PARENL",
  /*    9 */ "PARENR",
  /*   10 */ "ADJUST",
  /*   11 */ "RELATIVE_OP",
  /*   12 */ "IDENTIFIER",
  /*   13 */ "BRACEL",
  /*   14 */ "BRACER",
  /*   15 */ "EVAL",
  /*   16 */ "COMMA",
  /*   17 */ "ASSIGN",
  /*   18 */ "STAR_ASSIGN",
  /*   19 */ "SLASH_ASSIGN",
  /*   20 */ "MOD_ASSIGN",
  /*   21 */ "PLUS_ASSIGN",
  /*   22 */ "MINUS_ASSIGN",
  /*   23 */ "SHIFTL_ASSIGN",
  /*   24 */ "SHIFTR_ASSIGN",
  /*   25 */ "SHIFTRR_ASSIGN",
  /*   26 */ "AND_ASSIGN",
  /*   27 */ "XOR_ASSIGN",
  /*   28 */ "OR_ASSIGN",
  /*   29 */ "QUESTION",
  /*   30 */ "COLON",
  /*   31 */ "BITWISE_OR",
  /*   32 */ "BITWISE_XOR",
  /*   33 */ "BITWISE_AND",
  /*   34 */ "EQUAL",
  /*   35 */ "NOT_EQUAL",
  /*   36 */ "LESS",
  /*   37 */ "GREATER",
  /*   38 */ "LESS_EQUAL",
  /*   39 */ "GREATER_EQUAL",
  /*   40 */ "IN",
  /*   41 */ "MATCH",
  /*   42 */ "NEAR",
  /*   43 */ "NEAR2",
  /*   44 */ "SIMILAR",
  /*   45 */ "TERM_EXTRACT",
  /*   46 */ "QUORUM",
  /*   47 */ "LCP",
  /*   48 */ "PREFIX",
  /*   49 */ "SUFFIX",
  /*   50 */ "REGEXP",
  /*   51 */ "SHIFTL",
  /*   52 */ "SHIFTR",
  /*   53 */ "SHIFTRR",
  /*   54 */ "PLUS",
  /*   55 */ "MINUS",
  /*   56 */ "STAR",
  /*   57 */ "SLASH",
  /*   58 */ "MOD",
  /*   59 */ "DELETE",
  /*   60 */ "INCR",
  /*   61 */ "DECR",
  /*   62 */ "NOT",
  /*   63 */ "BITWISE_NOT",
  /*   64 */ "EXACT",
  /*   65 */ "PARTIAL",
  /*   66 */ "UNSPLIT",
  /*   67 */ "DECIMAL",
  /*   68 */ "HEX_INTEGER",
  /*   69 */ "STRING",
  /*   70 */ "BOOLEAN",
  /*   71 */ "NULL",
  /*   72 */ "BRACKETL",
  /*   73 */ "BRACKETR",
  /*   74 */ "DOT",
  /*   75 */ "NONEXISTENT_COLUMN",
  /*   76 */ "suppress_unused_variable_warning",
  /*   77 */ "input",
  /*   78 */ "query",
  /*   79 */ "expression",
  /*   80 */ "output_columns",
  /*   81 */ "adjuster",
  /*   82 */ "query_element",
  /*   83 */ "primary_expression",
  /*   84 */ "assignment_expression",
  /*   85 */ "conditional_expression",
  /*   86 */ "lefthand_side_expression",
  /*   87 */ "logical_or_expression",
  /*   88 */ "logical_and_expression",
  /*   89 */ "bitwise_or_expression",
  /*   90 */ "bitwise_xor_expression",
  /*   91 */ "bitwise_and_expression",
  /*   92 */ "equality_expression",
  /*   93 */ "relational_expression",
  /*   94 */ "shift_expression",
  /*   95 */ "additive_expression",
  /*   96 */ "multiplicative_expression",
  /*   97 */ "unary_expression",
  /*   98 */ "postfix_expression",
  /*   99 */ "call_expression",
  /*  100 */ "member_expression",
  /*  101 */ "arguments",
  /*  102 */ "member_expression_part",
  /*  103 */ "object_literal",
  /*  104 */ "array_literal",
  /*  105 */ "elision",
  /*  106 */ "element_list",
  /*  107 */ "property_name_and_value_list",
  /*  108 */ "property_name_and_value",
  /*  109 */ "property_name",
  /*  110 */ "argument_list",
  /*  111 */ "output_column",
  /*  112 */ "adjust_expression",
  /*  113 */ "adjust_match_expression",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  28 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  29 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  30 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  31 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  32 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  33 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  36 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  37 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  38 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  39 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  40 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  41 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  42 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  43 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  44 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  45 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  46 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  47 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  48 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  49 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  50 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  51 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  52 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  53 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  54 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  55 */ "unary_expression ::= DELETE unary_expression",
 /*  56 */ "unary_expression ::= INCR unary_expression",
 /*  57 */ "unary_expression ::= DECR unary_expression",
 /*  58 */ "unary_expression ::= PLUS unary_expression",
 /*  59 */ "unary_expression ::= MINUS unary_expression",
 /*  60 */ "unary_expression ::= NOT unary_expression",
 /*  61 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  62 */ "unary_expression ::= ADJUST unary_expression",
 /*  63 */ "unary_expression ::= EXACT unary_expression",
 /*  64 */ "unary_expression ::= PARTIAL unary_expression",
 /*  65 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  66 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  67 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  68 */ "call_expression ::= member_expression arguments",
 /*  69 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /*  70 */ "property_name_and_value_list ::=",
 /*  71 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /*  72 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  73 */ "arguments ::= PARENL argument_list PARENR",
 /*  74 */ "argument_list ::=",
 /*  75 */ "argument_list ::= assignment_expression",
 /*  76 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  77 */ "output_columns ::=",
 /*  78 */ "output_columns ::= output_column",
 /*  79 */ "output_columns ::= output_columns COMMA",
 /*  80 */ "output_columns ::= output_columns COMMA output_column",
 /*  81 */ "output_column ::= STAR",
 /*  82 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  83 */ "output_column ::= assignment_expression",
 /*  84 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  85 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  86 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  87 */ "input ::= query",
 /*  88 */ "input ::= expression",
 /*  89 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*  90 */ "input ::= START_ADJUSTER adjuster",
 /*  91 */ "query ::= query_element",
 /*  92 */ "query_element ::= QSTRING",
 /*  93 */ "query_element ::= PARENL query PARENR",
 /*  94 */ "expression ::= assignment_expression",
 /*  95 */ "assignment_expression ::= conditional_expression",
 /*  96 */ "conditional_expression ::= logical_or_expression",
 /*  97 */ "logical_or_expression ::= logical_and_expression",
 /*  98 */ "logical_and_expression ::= bitwise_or_expression",
 /*  99 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 100 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 101 */ "bitwise_and_expression ::= equality_expression",
 /* 102 */ "equality_expression ::= relational_expression",
 /* 103 */ "relational_expression ::= shift_expression",
 /* 104 */ "shift_expression ::= additive_expression",
 /* 105 */ "additive_expression ::= multiplicative_expression",
 /* 106 */ "multiplicative_expression ::= unary_expression",
 /* 107 */ "unary_expression ::= postfix_expression",
 /* 108 */ "postfix_expression ::= lefthand_side_expression",
 /* 109 */ "lefthand_side_expression ::= call_expression",
 /* 110 */ "lefthand_side_expression ::= member_expression",
 /* 111 */ "member_expression ::= primary_expression",
 /* 112 */ "member_expression ::= member_expression member_expression_part",
 /* 113 */ "primary_expression ::= object_literal",
 /* 114 */ "primary_expression ::= PARENL expression PARENR",
 /* 115 */ "primary_expression ::= IDENTIFIER",
 /* 116 */ "primary_expression ::= array_literal",
 /* 117 */ "primary_expression ::= DECIMAL",
 /* 118 */ "primary_expression ::= HEX_INTEGER",
 /* 119 */ "primary_expression ::= STRING",
 /* 120 */ "primary_expression ::= BOOLEAN",
 /* 121 */ "primary_expression ::= NULL",
 /* 122 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 123 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 124 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 125 */ "elision ::= COMMA",
 /* 126 */ "elision ::= elision COMMA",
 /* 127 */ "element_list ::= assignment_expression",
 /* 128 */ "element_list ::= elision assignment_expression",
 /* 129 */ "element_list ::= element_list elision assignment_expression",
 /* 130 */ "property_name_and_value_list ::= property_name_and_value",
 /* 131 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 132 */ "property_name ::= STRING",
 /* 133 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 134 */ "adjuster ::=",
 /* 135 */ "adjuster ::= adjust_expression",
 /* 136 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypRawParser grn_expr_parserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  grn_expr_parserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) grn_expr_parserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    grn_expr_parserCTX_STORE
    grn_expr_parserInit(yypParser grn_expr_parserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 76: /* suppress_unused_variable_warning */
{
#line 14 "../../groonga/lib/grn_ecmascript.lemon"

  (void)efsi;

#line 1111 "../../groonga/lib/grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int grn_expr_parserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH
   grn_expr_parserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument var */
   grn_expr_parserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {   78,   -2 }, /* (0) query ::= query query_element */
  {   78,   -3 }, /* (1) query ::= query LOGICAL_AND query_element */
  {   78,   -3 }, /* (2) query ::= query LOGICAL_AND_NOT query_element */
  {   78,   -3 }, /* (3) query ::= query LOGICAL_OR query_element */
  {   78,   -3 }, /* (4) query ::= query NEGATIVE query_element */
  {   82,   -2 }, /* (5) query_element ::= ADJUST query_element */
  {   82,   -2 }, /* (6) query_element ::= RELATIVE_OP query_element */
  {   82,   -3 }, /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
  {   82,   -3 }, /* (8) query_element ::= BRACEL expression BRACER */
  {   82,   -2 }, /* (9) query_element ::= EVAL primary_expression */
  {   79,   -3 }, /* (10) expression ::= expression COMMA assignment_expression */
  {   84,   -3 }, /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
  {   84,   -3 }, /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
  {   84,   -3 }, /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
  {   84,   -3 }, /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
  {   84,   -3 }, /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
  {   84,   -3 }, /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
  {   84,   -3 }, /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
  {   84,   -3 }, /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
  {   84,   -3 }, /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
  {   84,   -3 }, /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
  {   84,   -3 }, /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
  {   84,   -3 }, /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
  {   85,   -5 }, /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
  {   87,   -3 }, /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
  {   88,   -3 }, /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
  {   88,   -3 }, /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
  {   89,   -3 }, /* (27) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
  {   90,   -3 }, /* (28) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
  {   91,   -3 }, /* (29) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
  {   92,   -3 }, /* (30) equality_expression ::= equality_expression EQUAL relational_expression */
  {   92,   -3 }, /* (31) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
  {   93,   -3 }, /* (32) relational_expression ::= relational_expression LESS shift_expression */
  {   93,   -3 }, /* (33) relational_expression ::= relational_expression GREATER shift_expression */
  {   93,   -3 }, /* (34) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
  {   93,   -3 }, /* (35) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
  {   93,   -3 }, /* (36) relational_expression ::= relational_expression IN shift_expression */
  {   93,   -3 }, /* (37) relational_expression ::= relational_expression MATCH shift_expression */
  {   93,   -3 }, /* (38) relational_expression ::= relational_expression NEAR shift_expression */
  {   93,   -3 }, /* (39) relational_expression ::= relational_expression NEAR2 shift_expression */
  {   93,   -3 }, /* (40) relational_expression ::= relational_expression SIMILAR shift_expression */
  {   93,   -3 }, /* (41) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
  {   93,   -3 }, /* (42) relational_expression ::= relational_expression QUORUM shift_expression */
  {   93,   -3 }, /* (43) relational_expression ::= relational_expression LCP shift_expression */
  {   93,   -3 }, /* (44) relational_expression ::= relational_expression PREFIX shift_expression */
  {   93,   -3 }, /* (45) relational_expression ::= relational_expression SUFFIX shift_expression */
  {   93,   -3 }, /* (46) relational_expression ::= relational_expression REGEXP shift_expression */
  {   94,   -3 }, /* (47) shift_expression ::= shift_expression SHIFTL additive_expression */
  {   94,   -3 }, /* (48) shift_expression ::= shift_expression SHIFTR additive_expression */
  {   94,   -3 }, /* (49) shift_expression ::= shift_expression SHIFTRR additive_expression */
  {   95,   -3 }, /* (50) additive_expression ::= additive_expression PLUS multiplicative_expression */
  {   95,   -3 }, /* (51) additive_expression ::= additive_expression MINUS multiplicative_expression */
  {   96,   -3 }, /* (52) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
  {   96,   -3 }, /* (53) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
  {   96,   -3 }, /* (54) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
  {   97,   -2 }, /* (55) unary_expression ::= DELETE unary_expression */
  {   97,   -2 }, /* (56) unary_expression ::= INCR unary_expression */
  {   97,   -2 }, /* (57) unary_expression ::= DECR unary_expression */
  {   97,   -2 }, /* (58) unary_expression ::= PLUS unary_expression */
  {   97,   -2 }, /* (59) unary_expression ::= MINUS unary_expression */
  {   97,   -2 }, /* (60) unary_expression ::= NOT unary_expression */
  {   97,   -2 }, /* (61) unary_expression ::= BITWISE_NOT unary_expression */
  {   97,   -2 }, /* (62) unary_expression ::= ADJUST unary_expression */
  {   97,   -2 }, /* (63) unary_expression ::= EXACT unary_expression */
  {   97,   -2 }, /* (64) unary_expression ::= PARTIAL unary_expression */
  {   97,   -2 }, /* (65) unary_expression ::= UNSPLIT unary_expression */
  {   98,   -2 }, /* (66) postfix_expression ::= lefthand_side_expression INCR */
  {   98,   -2 }, /* (67) postfix_expression ::= lefthand_side_expression DECR */
  {   99,   -2 }, /* (68) call_expression ::= member_expression arguments */
  {  103,   -3 }, /* (69) object_literal ::= BRACEL property_name_and_value_list BRACER */
  {  107,    0 }, /* (70) property_name_and_value_list ::= */
  {  108,   -3 }, /* (71) property_name_and_value ::= property_name COLON assignment_expression */
  {  102,   -3 }, /* (72) member_expression_part ::= BRACKETL expression BRACKETR */
  {  101,   -3 }, /* (73) arguments ::= PARENL argument_list PARENR */
  {  110,    0 }, /* (74) argument_list ::= */
  {  110,   -1 }, /* (75) argument_list ::= assignment_expression */
  {  110,   -3 }, /* (76) argument_list ::= argument_list COMMA assignment_expression */
  {   80,    0 }, /* (77) output_columns ::= */
  {   80,   -1 }, /* (78) output_columns ::= output_column */
  {   80,   -2 }, /* (79) output_columns ::= output_columns COMMA */
  {   80,   -3 }, /* (80) output_columns ::= output_columns COMMA output_column */
  {  111,   -1 }, /* (81) output_column ::= STAR */
  {  111,   -1 }, /* (82) output_column ::= NONEXISTENT_COLUMN */
  {  111,   -1 }, /* (83) output_column ::= assignment_expression */
  {   81,   -3 }, /* (84) adjuster ::= adjuster PLUS adjust_expression */
  {  112,   -3 }, /* (85) adjust_expression ::= adjust_match_expression STAR DECIMAL */
  {  113,   -3 }, /* (86) adjust_match_expression ::= IDENTIFIER MATCH STRING */
  {   77,   -1 }, /* (87) input ::= query */
  {   77,   -1 }, /* (88) input ::= expression */
  {   77,   -2 }, /* (89) input ::= START_OUTPUT_COLUMNS output_columns */
  {   77,   -2 }, /* (90) input ::= START_ADJUSTER adjuster */
  {   78,   -1 }, /* (91) query ::= query_element */
  {   82,   -1 }, /* (92) query_element ::= QSTRING */
  {   82,   -3 }, /* (93) query_element ::= PARENL query PARENR */
  {   79,   -1 }, /* (94) expression ::= assignment_expression */
  {   84,   -1 }, /* (95) assignment_expression ::= conditional_expression */
  {   85,   -1 }, /* (96) conditional_expression ::= logical_or_expression */
  {   87,   -1 }, /* (97) logical_or_expression ::= logical_and_expression */
  {   88,   -1 }, /* (98) logical_and_expression ::= bitwise_or_expression */
  {   89,   -1 }, /* (99) bitwise_or_expression ::= bitwise_xor_expression */
  {   90,   -1 }, /* (100) bitwise_xor_expression ::= bitwise_and_expression */
  {   91,   -1 }, /* (101) bitwise_and_expression ::= equality_expression */
  {   92,   -1 }, /* (102) equality_expression ::= relational_expression */
  {   93,   -1 }, /* (103) relational_expression ::= shift_expression */
  {   94,   -1 }, /* (104) shift_expression ::= additive_expression */
  {   95,   -1 }, /* (105) additive_expression ::= multiplicative_expression */
  {   96,   -1 }, /* (106) multiplicative_expression ::= unary_expression */
  {   97,   -1 }, /* (107) unary_expression ::= postfix_expression */
  {   98,   -1 }, /* (108) postfix_expression ::= lefthand_side_expression */
  {   86,   -1 }, /* (109) lefthand_side_expression ::= call_expression */
  {   86,   -1 }, /* (110) lefthand_side_expression ::= member_expression */
  {  100,   -1 }, /* (111) member_expression ::= primary_expression */
  {  100,   -2 }, /* (112) member_expression ::= member_expression member_expression_part */
  {   83,   -1 }, /* (113) primary_expression ::= object_literal */
  {   83,   -3 }, /* (114) primary_expression ::= PARENL expression PARENR */
  {   83,   -1 }, /* (115) primary_expression ::= IDENTIFIER */
  {   83,   -1 }, /* (116) primary_expression ::= array_literal */
  {   83,   -1 }, /* (117) primary_expression ::= DECIMAL */
  {   83,   -1 }, /* (118) primary_expression ::= HEX_INTEGER */
  {   83,   -1 }, /* (119) primary_expression ::= STRING */
  {   83,   -1 }, /* (120) primary_expression ::= BOOLEAN */
  {   83,   -1 }, /* (121) primary_expression ::= NULL */
  {  104,   -3 }, /* (122) array_literal ::= BRACKETL elision BRACKETR */
  {  104,   -4 }, /* (123) array_literal ::= BRACKETL element_list elision BRACKETR */
  {  104,   -3 }, /* (124) array_literal ::= BRACKETL element_list BRACKETR */
  {  105,   -1 }, /* (125) elision ::= COMMA */
  {  105,   -2 }, /* (126) elision ::= elision COMMA */
  {  106,   -1 }, /* (127) element_list ::= assignment_expression */
  {  106,   -2 }, /* (128) element_list ::= elision assignment_expression */
  {  106,   -3 }, /* (129) element_list ::= element_list elision assignment_expression */
  {  107,   -1 }, /* (130) property_name_and_value_list ::= property_name_and_value */
  {  107,   -3 }, /* (131) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */
  {  109,   -1 }, /* (132) property_name ::= STRING */
  {  102,   -2 }, /* (133) member_expression_part ::= DOT IDENTIFIER */
  {   81,    0 }, /* (134) adjuster ::= */
  {   81,   -1 }, /* (135) adjuster ::= adjust_expression */
  {  112,   -1 }, /* (136) adjust_expression ::= adjust_match_expression */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  grn_expr_parserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  grn_expr_parserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 55 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1636 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 58 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1644 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 61 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1652 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 64 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1660 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 67 "../../groonga/lib/grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 1669 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 76 "../../groonga/lib/grn_ecmascript.lemon"
{
  int weight;
  GRN_INT32_POP(&efsi->weight_stack, weight);
}
#line 1677 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 80 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1685 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 84 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1718 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 113 "../../groonga/lib/grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1726 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 121 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1733 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 126 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1740 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 129 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1747 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 132 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1754 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 135 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1761 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 138 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1768 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 141 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1775 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 144 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1782 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 147 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1789 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 150 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1796 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 153 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1803 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 156 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1810 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 159 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1817 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 164 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1826 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 27: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 184 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1833 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 28: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 189 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1840 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 29: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 194 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1847 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 30: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 199 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1854 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 31: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 202 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1861 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 32: /* relational_expression ::= relational_expression LESS shift_expression */
#line 207 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1868 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 33: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 210 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1875 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 213 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1882 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 216 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1889 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression IN shift_expression */
#line 219 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1896 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 86: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==86);
#line 222 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1904 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 225 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 1917 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 234 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1924 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 237 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 1937 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 246 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1944 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 249 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 1957 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression LCP shift_expression */
#line 258 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1964 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 261 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1971 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 264 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1978 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 267 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 1985 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 47: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 272 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1992 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 48: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 275 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1999 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 49: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 278 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 2006 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 50: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 84: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==84);
#line 283 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 2014 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 51: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 286 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 2021 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 52: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 85: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==85);
#line 291 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 2029 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 53: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 294 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 2036 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 54: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 297 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 2043 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 55: /* unary_expression ::= DELETE unary_expression */
#line 302 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 2050 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 56: /* unary_expression ::= INCR unary_expression */
#line 305 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 2071 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 57: /* unary_expression ::= DECR unary_expression */
#line 322 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 2092 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 58: /* unary_expression ::= PLUS unary_expression */
#line 339 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 2099 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= MINUS unary_expression */
#line 342 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 2106 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= NOT unary_expression */
#line 345 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 2113 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 348 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 2120 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= ADJUST unary_expression */
#line 351 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 2127 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= EXACT unary_expression */
#line 354 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 2134 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= PARTIAL unary_expression */
#line 357 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 2141 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= UNSPLIT unary_expression */
#line 360 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 2148 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 66: /* postfix_expression ::= lefthand_side_expression INCR */
#line 365 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2169 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 67: /* postfix_expression ::= lefthand_side_expression DECR */
#line 382 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2190 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 68: /* call_expression ::= member_expression arguments */
#line 403 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2197 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 69: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 431 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 2208 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 70: /* property_name_and_value_list ::= */
#line 439 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 2224 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 71: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 454 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        grn_expr_dfi_pop(e);
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 2269 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 72: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 498 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2276 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 73: /* arguments ::= PARENL argument_list PARENR */
#line 503 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2281 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 74: /* argument_list ::= */
#line 504 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2286 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 75: /* argument_list ::= assignment_expression */
#line 505 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2291 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 76: /* argument_list ::= argument_list COMMA assignment_expression */
#line 506 "../../groonga/lib/grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2296 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 77: /* output_columns ::= */
#line 508 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2304 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 78: /* output_columns ::= output_column */
#line 511 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2311 "../../groonga/lib/grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 79: /* output_columns ::= output_columns COMMA */
#line 516 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2319 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 80: /* output_columns ::= output_columns COMMA output_column */
#line 521 "../../groonga/lib/grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2336 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 81: /* output_column ::= STAR */
#line 534 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      if (column->header.type == GRN_ACCESSOR) {
        grn_expr_take_obj(ctx, expr, column);
      }
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        if (column->header.type == GRN_ACCESSOR) {
          grn_expr_take_obj(ctx, expr, column);
        }
      }
    }

    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2391 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 82: /* output_column ::= NONEXISTENT_COLUMN */
#line 584 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2398 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 83: /* output_column ::= assignment_expression */
#line 587 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2405 "../../groonga/lib/grn_ecmascript.c"
        break;
      default:
      /* (87) input ::= query */ yytestcase(yyruleno==87);
      /* (88) input ::= expression */ yytestcase(yyruleno==88);
      /* (89) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==89);
      /* (90) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==90);
      /* (91) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=91);
      /* (92) query_element ::= QSTRING */ yytestcase(yyruleno==92);
      /* (93) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==93);
      /* (94) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=94);
      /* (95) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=95);
      /* (96) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==96);
      /* (97) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==97);
      /* (98) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==98);
      /* (99) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==99);
      /* (100) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==100);
      /* (101) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==101);
      /* (102) equality_expression ::= relational_expression */ yytestcase(yyruleno==102);
      /* (103) relational_expression ::= shift_expression */ yytestcase(yyruleno==103);
      /* (104) shift_expression ::= additive_expression */ yytestcase(yyruleno==104);
      /* (105) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==105);
      /* (106) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=106);
      /* (107) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=107);
      /* (108) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==108);
      /* (109) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=109);
      /* (110) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==110);
      /* (111) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=111);
      /* (112) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==112);
      /* (113) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=113);
      /* (114) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==114);
      /* (115) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==115);
      /* (116) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=116);
      /* (117) primary_expression ::= DECIMAL */ yytestcase(yyruleno==117);
      /* (118) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==118);
      /* (119) primary_expression ::= STRING */ yytestcase(yyruleno==119);
      /* (120) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==120);
      /* (121) primary_expression ::= NULL */ yytestcase(yyruleno==121);
      /* (122) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==122);
      /* (123) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==123);
      /* (124) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==124);
      /* (125) elision ::= COMMA */ yytestcase(yyruleno==125);
      /* (126) elision ::= elision COMMA */ yytestcase(yyruleno==126);
      /* (127) element_list ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=127);
      /* (128) element_list ::= elision assignment_expression */ yytestcase(yyruleno==128);
      /* (129) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==129);
      /* (130) property_name_and_value_list ::= property_name_and_value (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==131);
      /* (132) property_name ::= STRING */ yytestcase(yyruleno==132);
      /* (133) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==133);
      /* (134) adjuster ::= */ yytestcase(yyruleno==134);
      /* (135) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=135);
      /* (136) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==136);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 20 "../../groonga/lib/grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      char errbuf[GRN_CTX_MSGSIZE];
      grn_strcpy(errbuf, GRN_CTX_MSGSIZE, ctx->errbuf);
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2545 "../../groonga/lib/grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  grn_expr_parserCTX_FETCH
  grn_expr_parserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor grn_expr_parserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int grn_expr_parserFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
