/*-
 * Copyright (c) 2013-2015, Mellanox Technologies, Ltd.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS `AS IS' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$

   Autogenerated file.
   Date: 2015-04-13 14:59
   Source Document Name: Mellanox <Doc Name>
   Source Document Version: 0.28
   Generated by adb_to_c.py (EAT.ME Version: 1.0.70)
*/
#ifndef MLX5_IFC_H
#define MLX5_IFC_H

enum {
	MLX5_EVENT_TYPE_COMP                                       = 0x0,
	MLX5_EVENT_TYPE_PATH_MIG                                   = 0x1,
	MLX5_EVENT_TYPE_COMM_EST                                   = 0x2,
	MLX5_EVENT_TYPE_SQ_DRAINED                                 = 0x3,
	MLX5_EVENT_TYPE_SRQ_LAST_WQE                               = 0x13,
	MLX5_EVENT_TYPE_SRQ_RQ_LIMIT                               = 0x14,
	MLX5_EVENT_TYPE_DCT_DRAINED                                = 0x1c,
	MLX5_EVENT_TYPE_DCT_KEY_VIOLATION                          = 0x1d,
	MLX5_EVENT_TYPE_CQ_ERROR                                   = 0x4,
	MLX5_EVENT_TYPE_WQ_CATAS_ERROR                             = 0x5,
	MLX5_EVENT_TYPE_PATH_MIG_FAILED                            = 0x7,
	MLX5_EVENT_TYPE_PAGE_FAULT                                 = 0xc,
	MLX5_EVENT_TYPE_WQ_INVAL_REQ_ERROR                         = 0x10,
	MLX5_EVENT_TYPE_WQ_ACCESS_ERROR                            = 0x11,
	MLX5_EVENT_TYPE_SRQ_CATAS_ERROR                            = 0x12,
	MLX5_EVENT_TYPE_INTERNAL_ERROR                             = 0x8,
	MLX5_EVENT_TYPE_PORT_CHANGE                                = 0x9,
	MLX5_EVENT_TYPE_GPIO_EVENT                                 = 0x15,
	MLX5_EVENT_TYPE_CODING_PORT_MODULE_EVENT                   = 0x16,
	MLX5_EVENT_TYPE_REMOTE_CONFIG                              = 0x19,
	MLX5_EVENT_TYPE_DB_BF_CONGESTION                           = 0x1a,
	MLX5_EVENT_TYPE_STALL_EVENT                                = 0x1b,
	MLX5_EVENT_TYPE_DROPPED_PACKET_LOGGED_EVENT                = 0x1f,
	MLX5_EVENT_TYPE_CMD                                        = 0xa,
	MLX5_EVENT_TYPE_PAGE_REQUEST                               = 0xb,
	MLX5_EVENT_TYPE_NIC_VPORT_CHANGE                           = 0xd
};

enum {
	MLX5_MODIFY_TIR_BITMASK_LRO                                                                                                         = 0x0,
	MLX5_MODIFY_TIR_BITMASK_INDIRECT_TABLE                                                                                              = 0x1,
	MLX5_MODIFY_TIR_BITMASK_HASH                                                                                                        = 0x2,
	MLX5_MODIFY_TIR_BITMASK_TUNNELED_OFFLOAD_EN                                                                                         = 0x3
};

enum {
	MLX5_MODIFY_RQT_BITMASK_RQN_LIST          = 0x1,
};

enum {
	MLX5_CMD_OP_QUERY_HCA_CAP                 = 0x100,
	MLX5_CMD_OP_QUERY_ADAPTER                 = 0x101,
	MLX5_CMD_OP_INIT_HCA                      = 0x102,
	MLX5_CMD_OP_TEARDOWN_HCA                  = 0x103,
	MLX5_CMD_OP_ENABLE_HCA                    = 0x104,
	MLX5_CMD_OP_DISABLE_HCA                   = 0x105,
	MLX5_CMD_OP_QUERY_PAGES                   = 0x107,
	MLX5_CMD_OP_MANAGE_PAGES                  = 0x108,
	MLX5_CMD_OP_SET_HCA_CAP                   = 0x109,
	MLX5_CMD_OP_QUERY_ISSI                    = 0x10a,
	MLX5_CMD_OP_SET_ISSI                      = 0x10b,
	MLX5_CMD_OP_SET_DRIVER_VERSION            = 0x10d,
	MLX5_CMD_OP_CREATE_MKEY                   = 0x200,
	MLX5_CMD_OP_QUERY_MKEY                    = 0x201,
	MLX5_CMD_OP_DESTROY_MKEY                  = 0x202,
	MLX5_CMD_OP_QUERY_SPECIAL_CONTEXTS        = 0x203,
	MLX5_CMD_OP_PAGE_FAULT_RESUME             = 0x204,
	MLX5_CMD_OP_CREATE_EQ                     = 0x301,
	MLX5_CMD_OP_DESTROY_EQ                    = 0x302,
	MLX5_CMD_OP_QUERY_EQ                      = 0x303,
	MLX5_CMD_OP_GEN_EQE                       = 0x304,
	MLX5_CMD_OP_CREATE_CQ                     = 0x400,
	MLX5_CMD_OP_DESTROY_CQ                    = 0x401,
	MLX5_CMD_OP_QUERY_CQ                      = 0x402,
	MLX5_CMD_OP_MODIFY_CQ                     = 0x403,
	MLX5_CMD_OP_CREATE_QP                     = 0x500,
	MLX5_CMD_OP_DESTROY_QP                    = 0x501,
	MLX5_CMD_OP_RST2INIT_QP                   = 0x502,
	MLX5_CMD_OP_INIT2RTR_QP                   = 0x503,
	MLX5_CMD_OP_RTR2RTS_QP                    = 0x504,
	MLX5_CMD_OP_RTS2RTS_QP                    = 0x505,
	MLX5_CMD_OP_SQERR2RTS_QP                  = 0x506,
	MLX5_CMD_OP_2ERR_QP                       = 0x507,
	MLX5_CMD_OP_2RST_QP                       = 0x50a,
	MLX5_CMD_OP_QUERY_QP                      = 0x50b,
	MLX5_CMD_OP_SQD_RTS_QP                    = 0x50c,
	MLX5_CMD_OP_INIT2INIT_QP                  = 0x50e,
	MLX5_CMD_OP_CREATE_PSV                    = 0x600,
	MLX5_CMD_OP_DESTROY_PSV                   = 0x601,
	MLX5_CMD_OP_CREATE_SRQ                    = 0x700,
	MLX5_CMD_OP_DESTROY_SRQ                   = 0x701,
	MLX5_CMD_OP_QUERY_SRQ                     = 0x702,
	MLX5_CMD_OP_ARM_RQ                        = 0x703,
	MLX5_CMD_OP_CREATE_XRC_SRQ                = 0x705,
	MLX5_CMD_OP_DESTROY_XRC_SRQ               = 0x706,
	MLX5_CMD_OP_QUERY_XRC_SRQ                 = 0x707,
	MLX5_CMD_OP_ARM_XRC_SRQ                   = 0x708,
	MLX5_CMD_OP_CREATE_DCT                    = 0x710,
	MLX5_CMD_OP_DESTROY_DCT                   = 0x711,
	MLX5_CMD_OP_DRAIN_DCT                     = 0x712,
	MLX5_CMD_OP_QUERY_DCT                     = 0x713,
	MLX5_CMD_OP_ARM_DCT_FOR_KEY_VIOLATION     = 0x714,
	MLX5_CMD_OP_SET_DC_CNAK_TRACE             = 0x715,
	MLX5_CMD_OP_QUERY_DC_CNAK_TRACE           = 0x716,
	MLX5_CMD_OP_QUERY_VPORT_STATE             = 0x750,
	MLX5_CMD_OP_MODIFY_VPORT_STATE            = 0x751,
	MLX5_CMD_OP_QUERY_ESW_VPORT_CONTEXT       = 0x752,
	MLX5_CMD_OP_MODIFY_ESW_VPORT_CONTEXT      = 0x753,
	MLX5_CMD_OP_QUERY_NIC_VPORT_CONTEXT       = 0x754,
	MLX5_CMD_OP_MODIFY_NIC_VPORT_CONTEXT      = 0x755,
	MLX5_CMD_OP_QUERY_ROCE_ADDRESS            = 0x760,
	MLX5_CMD_OP_SET_ROCE_ADDRESS              = 0x761,
	MLX5_CMD_OP_QUERY_HCA_VPORT_CONTEXT       = 0x762,
	MLX5_CMD_OP_MODIFY_HCA_VPORT_CONTEXT      = 0x763,
	MLX5_CMD_OP_QUERY_HCA_VPORT_GID           = 0x764,
	MLX5_CMD_OP_QUERY_HCA_VPORT_PKEY          = 0x765,
	MLX5_CMD_OP_QUERY_VPORT_COUNTER           = 0x770,
	MLX5_CMD_OP_ALLOC_Q_COUNTER               = 0x771,
	MLX5_CMD_OP_DEALLOC_Q_COUNTER             = 0x772,
	MLX5_CMD_OP_QUERY_Q_COUNTER               = 0x773,
	MLX5_CMD_OP_ALLOC_PD                      = 0x800,
	MLX5_CMD_OP_DEALLOC_PD                    = 0x801,
	MLX5_CMD_OP_ALLOC_UAR                     = 0x802,
	MLX5_CMD_OP_DEALLOC_UAR                   = 0x803,
	MLX5_CMD_OP_CONFIG_INT_MODERATION         = 0x804,
	MLX5_CMD_OP_ACCESS_REG                    = 0x805,
	MLX5_CMD_OP_ATTACH_TO_MCG                 = 0x806,
	MLX5_CMD_OP_DETACH_FROM_MCG               = 0x807,
	MLX5_CMD_OP_GET_DROPPED_PACKET_LOG        = 0x80a,
	MLX5_CMD_OP_MAD_IFC                       = 0x50d,
	MLX5_CMD_OP_QUERY_MAD_DEMUX               = 0x80b,
	MLX5_CMD_OP_SET_MAD_DEMUX                 = 0x80c,
	MLX5_CMD_OP_NOP                           = 0x80d,
	MLX5_CMD_OP_ALLOC_XRCD                    = 0x80e,
	MLX5_CMD_OP_DEALLOC_XRCD                  = 0x80f,
	MLX5_CMD_OP_SET_BURST_SIZE                = 0x812,
	MLX5_CMD_OP_QUERY_BURST_SIZE              = 0x813,
	MLX5_CMD_OP_ACTIVATE_TRACER               = 0x814,
	MLX5_CMD_OP_DEACTIVATE_TRACER             = 0x815,
	MLX5_CMD_OP_ALLOC_TRANSPORT_DOMAIN        = 0x816,
	MLX5_CMD_OP_DEALLOC_TRANSPORT_DOMAIN      = 0x817,
	MLX5_CMD_OP_QUERY_CONG_STATUS             = 0x822,
	MLX5_CMD_OP_MODIFY_CONG_STATUS            = 0x823,
	MLX5_CMD_OP_QUERY_CONG_PARAMS             = 0x824,
	MLX5_CMD_OP_MODIFY_CONG_PARAMS            = 0x825,
	MLX5_CMD_OP_QUERY_CONG_STATISTICS         = 0x826,
	MLX5_CMD_OP_ADD_VXLAN_UDP_DPORT           = 0x827,
	MLX5_CMD_OP_DELETE_VXLAN_UDP_DPORT        = 0x828,
	MLX5_CMD_OP_SET_L2_TABLE_ENTRY            = 0x829,
	MLX5_CMD_OP_QUERY_L2_TABLE_ENTRY          = 0x82a,
	MLX5_CMD_OP_DELETE_L2_TABLE_ENTRY         = 0x82b,
	MLX5_CMD_OP_SET_WOL_ROL                   = 0x830,
	MLX5_CMD_OP_QUERY_WOL_ROL                 = 0x831,
	MLX5_CMD_OP_CREATE_TIR                    = 0x900,
	MLX5_CMD_OP_MODIFY_TIR                    = 0x901,
	MLX5_CMD_OP_DESTROY_TIR                   = 0x902,
	MLX5_CMD_OP_QUERY_TIR                     = 0x903,
	MLX5_CMD_OP_CREATE_SQ                     = 0x904,
	MLX5_CMD_OP_MODIFY_SQ                     = 0x905,
	MLX5_CMD_OP_DESTROY_SQ                    = 0x906,
	MLX5_CMD_OP_QUERY_SQ                      = 0x907,
	MLX5_CMD_OP_CREATE_RQ                     = 0x908,
	MLX5_CMD_OP_MODIFY_RQ                     = 0x909,
	MLX5_CMD_OP_DESTROY_RQ                    = 0x90a,
	MLX5_CMD_OP_QUERY_RQ                      = 0x90b,
	MLX5_CMD_OP_CREATE_RMP                    = 0x90c,
	MLX5_CMD_OP_MODIFY_RMP                    = 0x90d,
	MLX5_CMD_OP_DESTROY_RMP                   = 0x90e,
	MLX5_CMD_OP_QUERY_RMP                     = 0x90f,
	MLX5_CMD_OP_CREATE_TIS                    = 0x912,
	MLX5_CMD_OP_MODIFY_TIS                    = 0x913,
	MLX5_CMD_OP_DESTROY_TIS                   = 0x914,
	MLX5_CMD_OP_QUERY_TIS                     = 0x915,
	MLX5_CMD_OP_CREATE_RQT                    = 0x916,
	MLX5_CMD_OP_MODIFY_RQT                    = 0x917,
	MLX5_CMD_OP_DESTROY_RQT                   = 0x918,
	MLX5_CMD_OP_QUERY_RQT                     = 0x919,
	MLX5_CMD_OP_SET_FLOW_TABLE_ROOT           = 0x92f,
	MLX5_CMD_OP_CREATE_FLOW_TABLE             = 0x930,
	MLX5_CMD_OP_DESTROY_FLOW_TABLE            = 0x931,
	MLX5_CMD_OP_QUERY_FLOW_TABLE              = 0x932,
	MLX5_CMD_OP_CREATE_FLOW_GROUP             = 0x933,
	MLX5_CMD_OP_DESTROY_FLOW_GROUP            = 0x934,
	MLX5_CMD_OP_QUERY_FLOW_GROUP              = 0x935,
	MLX5_CMD_OP_SET_FLOW_TABLE_ENTRY          = 0x936,
	MLX5_CMD_OP_QUERY_FLOW_TABLE_ENTRY        = 0x937,
	MLX5_CMD_OP_DELETE_FLOW_TABLE_ENTRY       = 0x938,
	MLX5_CMD_OP_ALLOC_FLOW_COUNTER            = 0x939,
	MLX5_CMD_OP_DEALLOC_FLOW_COUNTER          = 0x93a,
	MLX5_CMD_OP_QUERY_FLOW_COUNTER            = 0x93b
};

enum {
	MLX5_ICMD_CMDS_OPCODE_ICMD_OPCODE_QUERY_FW_INFO     = 0x8007,
	MLX5_ICMD_CMDS_OPCODE_ICMD_QUERY_CAPABILITY         = 0x8400,
	MLX5_ICMD_CMDS_OPCODE_ICMD_ACCESS_REGISTER          = 0x9001,
	MLX5_ICMD_CMDS_OPCODE_ICMD_QUERY_VIRTUAL_MAC        = 0x9003,
	MLX5_ICMD_CMDS_OPCODE_ICMD_SET_VIRTUAL_MAC          = 0x9004,
	MLX5_ICMD_CMDS_OPCODE_ICMD_QUERY_WOL_ROL            = 0x9005,
	MLX5_ICMD_CMDS_OPCODE_ICMD_SET_WOL_ROL              = 0x9006,
	MLX5_ICMD_CMDS_OPCODE_ICMD_OCBB_INIT                = 0x9007,
	MLX5_ICMD_CMDS_OPCODE_ICMD_OCBB_QUERY_HEADER_STATUS = 0x9008,
	MLX5_ICMD_CMDS_OPCODE_ICMD_OCBB_QUERY_ETOC_STATUS   = 0x9009,
	MLX5_ICMD_CMDS_OPCODE_ICMD_OCBB_SET_EVENT           = 0x900a,
	MLX5_ICMD_CMDS_OPCODE_ICMD_OPCODE_INIT_OCSD         = 0xf004
};

struct mlx5_ifc_flow_table_fields_supported_bits {
	u8         outer_dmac[0x1];
	u8         outer_smac[0x1];
	u8         outer_ether_type[0x1];
	u8         reserved_0[0x1];
	u8         outer_first_prio[0x1];
	u8         outer_first_cfi[0x1];
	u8         outer_first_vid[0x1];
	u8         reserved_1[0x1];
	u8         outer_second_prio[0x1];
	u8         outer_second_cfi[0x1];
	u8         outer_second_vid[0x1];
	u8         outer_ipv6_flow_label[0x1];
	u8         outer_sip[0x1];
	u8         outer_dip[0x1];
	u8         outer_frag[0x1];
	u8         outer_ip_protocol[0x1];
	u8         outer_ip_ecn[0x1];
	u8         outer_ip_dscp[0x1];
	u8         outer_udp_sport[0x1];
	u8         outer_udp_dport[0x1];
	u8         outer_tcp_sport[0x1];
	u8         outer_tcp_dport[0x1];
	u8         outer_tcp_flags[0x1];
	u8         outer_gre_protocol[0x1];
	u8         outer_gre_key[0x1];
	u8         outer_vxlan_vni[0x1];
	u8         reserved_2[0x5];
	u8         source_eswitch_port[0x1];

	u8         inner_dmac[0x1];
	u8         inner_smac[0x1];
	u8         inner_ether_type[0x1];
	u8         reserved_3[0x1];
	u8         inner_first_prio[0x1];
	u8         inner_first_cfi[0x1];
	u8         inner_first_vid[0x1];
	u8         reserved_4[0x1];
	u8         inner_second_prio[0x1];
	u8         inner_second_cfi[0x1];
	u8         inner_second_vid[0x1];
	u8         inner_ipv6_flow_label[0x1];
	u8         inner_sip[0x1];
	u8         inner_dip[0x1];
	u8         inner_frag[0x1];
	u8         inner_ip_protocol[0x1];
	u8         inner_ip_ecn[0x1];
	u8         inner_ip_dscp[0x1];
	u8         inner_udp_sport[0x1];
	u8         inner_udp_dport[0x1];
	u8         inner_tcp_sport[0x1];
	u8         inner_tcp_dport[0x1];
	u8         inner_tcp_flags[0x1];
	u8         reserved_5[0x9];

	u8         reserved_6[0x1f];
	u8         source_sqn[0x1];

	u8         reserved_7[0x20];
};

struct mlx5_ifc_flow_table_prop_layout_bits {
	u8         ft_support[0x1];
	u8         flow_tag[0x1];
	u8         flow_counter[0x1];
	u8         flow_modify_en[0x1];
	u8         modify_root[0x1];
	u8         reserved_0[0x1b];

	u8         reserved_1[0x2];
	u8         log_max_ft_size[0x6];
	u8         reserved_2[0x10];
	u8         max_ft_level[0x8];

	u8         reserved_3[0x20];

	u8         reserved_4[0x18];
	u8         log_max_ft_num[0x8];

	u8         reserved_5[0x10];
	u8         log_max_flow_counter[0x8];
	u8         log_max_destination[0x8];

	u8         reserved_6[0x18];
	u8         log_max_flow[0x8];

	u8         reserved_7[0x40];

	struct mlx5_ifc_flow_table_fields_supported_bits ft_field_support;

	struct mlx5_ifc_flow_table_fields_supported_bits ft_field_bitmask_support;
};

struct mlx5_ifc_odp_per_transport_service_cap_bits {
	u8         send[0x1];
	u8         receive[0x1];
	u8         write[0x1];
	u8         read[0x1];
	u8         atomic[0x1];
	u8         srq_receive[0x1];
	u8         reserved_0[0x1a];
};

struct mlx5_ifc_flow_counter_list_bits {
	u8         reserved_0[0x10];
	u8         flow_counter_id[0x10];

	u8         reserved_1[0x20];
};

enum {
	MLX5_FLOW_CONTEXT_DEST_TYPE_VPORT                    = 0x0,
	MLX5_FLOW_CONTEXT_DEST_TYPE_FLOW_TABLE               = 0x1,
	MLX5_FLOW_CONTEXT_DEST_TYPE_TIR                      = 0x2,
};

struct mlx5_ifc_dest_format_struct_bits {
	u8         destination_type[0x8];
	u8         destination_id[0x18];

	u8         reserved_0[0x20];
};

struct mlx5_ifc_fte_match_set_lyr_2_4_bits {
	u8         smac_47_16[0x20];

	u8         smac_15_0[0x10];
	u8         ethertype[0x10];

	u8         dmac_47_16[0x20];

	u8         dmac_15_0[0x10];
	u8         first_prio[0x3];
	u8         first_cfi[0x1];
	u8         first_vid[0xc];

	u8         ip_protocol[0x8];
	u8         ip_dscp[0x6];
	u8         ip_ecn[0x2];
	u8         vlan_tag[0x1];
	u8         reserved_0[0x1];
	u8         frag[0x1];
	u8         reserved_1[0x4];
	u8         tcp_flags[0x9];

	u8         tcp_sport[0x10];
	u8         tcp_dport[0x10];

	u8         reserved_2[0x20];

	u8         udp_sport[0x10];
	u8         udp_dport[0x10];

	u8         src_ip[4][0x20];

	u8         dst_ip[4][0x20];
};

struct mlx5_ifc_fte_match_set_misc_bits {
	u8         reserved_0[0x8];
	u8         source_sqn[0x18];

	u8         reserved_1[0x10];
	u8         source_port[0x10];

	u8         outer_second_prio[0x3];
	u8         outer_second_cfi[0x1];
	u8         outer_second_vid[0xc];
	u8         inner_second_prio[0x3];
	u8         inner_second_cfi[0x1];
	u8         inner_second_vid[0xc];

	u8         outer_second_vlan_tag[0x1];
	u8         inner_second_vlan_tag[0x1];
	u8         reserved_2[0xe];
	u8         gre_protocol[0x10];

	u8         gre_key_h[0x18];
	u8         gre_key_l[0x8];

	u8         vxlan_vni[0x18];
	u8         reserved_3[0x8];

	u8         reserved_4[0x20];

	u8         reserved_5[0xc];
	u8         outer_ipv6_flow_label[0x14];

	u8         reserved_6[0xc];
	u8         inner_ipv6_flow_label[0x14];

	u8         reserved_7[0xe0];
};

struct mlx5_ifc_cmd_pas_bits {
	u8         pa_h[0x20];

	u8         pa_l[0x14];
	u8         reserved_0[0xc];
};

struct mlx5_ifc_uint64_bits {
	u8         hi[0x20];

	u8         lo[0x20];
};

struct mlx5_ifc_nodnic_ring_doorbell_bits {
	u8         reserved_0[0x8];
	u8         ring_pi[0x10];
	u8         reserved_1[0x8];
};

enum {
	MLX5_ADS_STAT_RATE_NO_LIMIT  = 0x0,
	MLX5_ADS_STAT_RATE_2_5GBPS   = 0x7,
	MLX5_ADS_STAT_RATE_10GBPS    = 0x8,
	MLX5_ADS_STAT_RATE_30GBPS    = 0x9,
	MLX5_ADS_STAT_RATE_5GBPS     = 0xa,
	MLX5_ADS_STAT_RATE_20GBPS    = 0xb,
	MLX5_ADS_STAT_RATE_40GBPS    = 0xc,
	MLX5_ADS_STAT_RATE_60GBPS    = 0xd,
	MLX5_ADS_STAT_RATE_80GBPS    = 0xe,
	MLX5_ADS_STAT_RATE_120GBPS   = 0xf,
};

struct mlx5_ifc_ads_bits {
	u8         fl[0x1];
	u8         free_ar[0x1];
	u8         reserved_0[0xe];
	u8         pkey_index[0x10];

	u8         reserved_1[0x8];
	u8         grh[0x1];
	u8         mlid[0x7];
	u8         rlid[0x10];

	u8         ack_timeout[0x5];
	u8         reserved_2[0x3];
	u8         src_addr_index[0x8];
	u8         log_rtm[0x4];
	u8         stat_rate[0x4];
	u8         hop_limit[0x8];

	u8         reserved_3[0x4];
	u8         tclass[0x8];
	u8         flow_label[0x14];

	u8         rgid_rip[16][0x8];

	u8         reserved_4[0x4];
	u8         f_dscp[0x1];
	u8         f_ecn[0x1];
	u8         reserved_5[0x1];
	u8         f_eth_prio[0x1];
	u8         ecn[0x2];
	u8         dscp[0x6];
	u8         udp_sport[0x10];

	u8         dei_cfi[0x1];
	u8         eth_prio[0x3];
	u8         sl[0x4];
	u8         port[0x8];
	u8         rmac_47_32[0x10];

	u8         rmac_31_0[0x20];
};

struct mlx5_ifc_e_switch_cap_bits {
	u8         vport_svlan_strip[0x1];
	u8         vport_cvlan_strip[0x1];
	u8         vport_svlan_insert[0x1];
	u8         vport_cvlan_insert_if_not_exist[0x1];
	u8         vport_cvlan_insert_overwrite[0x1];
	u8         reserved_0[0x1b];

	u8         reserved_1[0x7e0];
};

struct mlx5_ifc_flow_table_eswitch_cap_bits {
	u8         reserved_0[0x200];

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_esw_fdb;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_esw_acl_ingress;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_esw_acl_egress;

	u8         reserved_1[0x7800];
};

struct mlx5_ifc_flow_table_nic_cap_bits {
	u8         reserved_0[0x200];

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_receive;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_receive_rdma;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_receive_sniffer;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_transmit;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_transmit_rdma;

	struct mlx5_ifc_flow_table_prop_layout_bits flow_table_properties_nic_transmit_sniffer;

	u8         reserved_1[0x7200];
};

struct mlx5_ifc_per_protocol_networking_offload_caps_bits {
	u8         csum_cap[0x1];
	u8         vlan_cap[0x1];
	u8         lro_cap[0x1];
	u8         lro_psh_flag[0x1];
	u8         lro_time_stamp[0x1];
	u8         lro_max_msg_sz_mode[0x2];
	u8         reserved_0[0x2];
	u8         self_lb_mc[0x1];
	u8         self_lb_uc[0x1];
	u8         max_lso_cap[0x5];
	u8         multi_pkt_send_wqe[0x2];
	u8         wqe_inline_mode[0x2];
	u8         rss_ind_tbl_cap[0x4];
	u8         reserved_1[0x3];
	u8         tunnel_lso_const_out_ip_id[0x1];
	u8         tunnel_lro_gre[0x1];
	u8         tunnel_lro_vxlan[0x1];
	u8         tunnel_statless_gre[0x1];
	u8         tunnel_stateless_vxlan[0x1];

	u8         reserved_2[0x20];

	u8         reserved_3[0x10];
	u8         lro_min_mss_size[0x10];

	u8         reserved_4[0x120];

	u8         lro_timer_supported_periods[4][0x20];

	u8         reserved_5[0x600];
};

enum {
	MLX5_ROCE_CAP_L3_TYPE_GRH   = 0x1,
	MLX5_ROCE_CAP_L3_TYPE_IPV4  = 0x2,
	MLX5_ROCE_CAP_L3_TYPE_IPV6  = 0x4,
};

struct mlx5_ifc_roce_cap_bits {
	u8         roce_apm[0x1];
	u8         eth_prio_primary_in_rts2rts[0x1];
	u8         reserved_0[0x1e];

	u8         reserved_1[0x60];

	u8         reserved_2[0xc];
	u8         l3_type[0x4];
	u8         reserved_3[0x8];
	u8         roce_version[0x8];

	u8         reserved_4[0x10];
	u8         r_roce_dest_udp_port[0x10];

	u8         r_roce_max_src_udp_port[0x10];
	u8         r_roce_min_src_udp_port[0x10];

	u8         reserved_5[0x10];
	u8         roce_address_table_size[0x10];

	u8         reserved_6[0x700];
};

enum {
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_1_BYTE     = 0x1,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_2_BYTES    = 0x2,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_4_BYTES    = 0x4,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_8_BYTES    = 0x8,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_16_BYTES   = 0x10,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_32_BYTES   = 0x20,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_64_BYTES   = 0x40,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_128_BYTES  = 0x80,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_QP_256_BYTES  = 0x100,
};

enum {
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_1_BYTE     = 0x1,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_2_BYTES    = 0x2,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_4_BYTES    = 0x4,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_8_BYTES    = 0x8,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_16_BYTES   = 0x10,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_32_BYTES   = 0x20,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_64_BYTES   = 0x40,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_128_BYTES  = 0x80,
	MLX5_ATOMIC_CAPS_ATOMIC_SIZE_DC_256_BYTES  = 0x100,
};

struct mlx5_ifc_atomic_caps_bits {
	u8         reserved_0[0x40];

	u8         atomic_req_endianess[0x1];
	u8         reserved_1[0x1f];

	u8         reserved_2[0x20];

	u8         reserved_3[0x10];
	u8         atomic_operations[0x10];

	u8         reserved_4[0x10];
	u8         atomic_size_qp[0x10];

	u8         reserved_5[0x10];
	u8         atomic_size_dc[0x10];

	u8         reserved_6[0x720];
};

struct mlx5_ifc_odp_cap_bits {
	u8         reserved_0[0x40];

	u8         sig[0x1];
	u8         reserved_1[0x1f];

	u8         reserved_2[0x20];

	struct mlx5_ifc_odp_per_transport_service_cap_bits rc_odp_caps;

	struct mlx5_ifc_odp_per_transport_service_cap_bits uc_odp_caps;

	struct mlx5_ifc_odp_per_transport_service_cap_bits ud_odp_caps;

	struct mlx5_ifc_odp_per_transport_service_cap_bits xrc_odp_caps;

	struct mlx5_ifc_odp_per_transport_service_cap_bits dc_odp_caps;

	u8         reserved_3[0x6e0];
};

enum {
	MLX5_CMD_HCA_CAP_GID_TABLE_SIZE_8_GID_ENTRIES    = 0x0,
	MLX5_CMD_HCA_CAP_GID_TABLE_SIZE_16_GID_ENTRIES   = 0x1,
	MLX5_CMD_HCA_CAP_GID_TABLE_SIZE_32_GID_ENTRIES   = 0x2,
	MLX5_CMD_HCA_CAP_GID_TABLE_SIZE_64_GID_ENTRIES   = 0x3,
	MLX5_CMD_HCA_CAP_GID_TABLE_SIZE_128_GID_ENTRIES  = 0x4,
};

enum {
	MLX5_CMD_HCA_CAP_PKEY_TABLE_SIZE_128_ENTRIES  = 0x0,
	MLX5_CMD_HCA_CAP_PKEY_TABLE_SIZE_256_ENTRIES  = 0x1,
	MLX5_CMD_HCA_CAP_PKEY_TABLE_SIZE_512_ENTRIES  = 0x2,
	MLX5_CMD_HCA_CAP_PKEY_TABLE_SIZE_1K_ENTRIES   = 0x3,
	MLX5_CMD_HCA_CAP_PKEY_TABLE_SIZE_2K_ENTRIES   = 0x4,
	MLX5_CMD_HCA_CAP_PKEY_TABLE_SIZE_4K_ENTRIES   = 0x5,
};

enum {
	MLX5_CMD_HCA_CAP_PORT_TYPE_IB        = 0x0,
	MLX5_CMD_HCA_CAP_PORT_TYPE_ETHERNET  = 0x1,
};

enum {
	MLX5_CMD_HCA_CAP_CMDIF_CHECKSUM_DISABLED       = 0x0,
	MLX5_CMD_HCA_CAP_CMDIF_CHECKSUM_INITIAL_STATE  = 0x1,
	MLX5_CMD_HCA_CAP_CMDIF_CHECKSUM_ENABLED        = 0x3,
};

struct mlx5_ifc_cmd_hca_cap_bits {
	u8         reserved_0[0x80];

	u8         log_max_srq_sz[0x8];
	u8         log_max_qp_sz[0x8];
	u8         reserved_1[0xb];
	u8         log_max_qp[0x5];

	u8         reserved_2[0xb];
	u8         log_max_srq[0x5];
	u8         reserved_3[0x10];

	u8         reserved_4[0x8];
	u8         log_max_cq_sz[0x8];
	u8         reserved_5[0xb];
	u8         log_max_cq[0x5];

	u8         log_max_eq_sz[0x8];
	u8         reserved_6[0x2];
	u8         log_max_mkey[0x6];
	u8         reserved_7[0xc];
	u8         log_max_eq[0x4];

	u8         max_indirection[0x8];
	u8         reserved_8[0x1];
	u8         log_max_mrw_sz[0x7];
	u8         reserved_9[0x2];
	u8         log_max_bsf_list_size[0x6];
	u8         reserved_10[0x2];
	u8         log_max_klm_list_size[0x6];

	u8         reserved_11[0xa];
	u8         log_max_ra_req_dc[0x6];
	u8         reserved_12[0xa];
	u8         log_max_ra_res_dc[0x6];

	u8         reserved_13[0xa];
	u8         log_max_ra_req_qp[0x6];
	u8         reserved_14[0xa];
	u8         log_max_ra_res_qp[0x6];

	u8         pad_cap[0x1];
	u8         cc_query_allowed[0x1];
	u8         cc_modify_allowed[0x1];
	u8         reserved_15[0xd];
	u8         gid_table_size[0x10];

	u8         out_of_seq_cnt[0x1];
	u8         vport_counters[0x1];
	u8         reserved_16[0x4];
	u8         max_qp_cnt[0xa];
	u8         pkey_table_size[0x10];

	u8         vport_group_manager[0x1];
	u8         vhca_group_manager[0x1];
	u8         ib_virt[0x1];
	u8         eth_virt[0x1];
	u8         reserved_17[0x1];
	u8         ets[0x1];
	u8         nic_flow_table[0x1];
	u8         eswitch_flow_table[0x1];
	u8         reserved_18[0x3];
	u8         local_ca_ack_delay[0x5];
	u8         port_module_event[0x1];
	u8         reserved_19[0x5];
	u8         port_type[0x2];
	u8         num_ports[0x8];

	u8         snapshot[0x1];
	u8         reserved_20[0x2];
	u8         log_max_msg[0x5];
	u8         reserved_21[0x4];
	u8         max_tc[0x4];
	u8         reserved_22[0x6];
	u8         rol_s[0x1];
	u8         rol_g[0x1];
	u8         reserved_23[0x1];
	u8         wol_s[0x1];
	u8         wol_g[0x1];
	u8         wol_a[0x1];
	u8         wol_b[0x1];
	u8         wol_m[0x1];
	u8         wol_u[0x1];
	u8         wol_p[0x1];

	u8         stat_rate_support[0x10];
	u8         reserved_24[0xc];
	u8         cqe_version[0x4];

	u8         compact_address_vector[0x1];
	u8         striding_rq[0x1];
	u8         reserved_25[0xc];
	u8         dc_cnak_trace[0x1];
	u8         drain_sigerr[0x1];
	u8         cmdif_checksum[0x2];
	u8         sigerr_cqe[0x1];
	u8         reserved_26[0x1];
	u8         wq_signature[0x1];
	u8         sctr_data_cqe[0x1];
	u8         reserved_27[0x1];
	u8         sho[0x1];
	u8         tph[0x1];
	u8         rf[0x1];
	u8         dct[0x1];
	u8         reserved_28[0x1];
	u8         eth_net_offloads[0x1];
	u8         roce[0x1];
	u8         atomic[0x1];
	u8         reserved_29[0x1];

	u8         cq_oi[0x1];
	u8         cq_resize[0x1];
	u8         cq_moderation[0x1];
	u8         reserved_30[0x3];
	u8         cq_eq_remap[0x1];
	u8         pg[0x1];
	u8         block_lb_mc[0x1];
	u8         exponential_backoff[0x1];
	u8         scqe_break_moderation[0x1];
	u8         cq_period_start_from_cqe[0x1];
	u8         cd[0x1];
	u8         atm[0x1];
	u8         apm[0x1];
	u8         reserved_31[0x7];
	u8         qkv[0x1];
	u8         pkv[0x1];
	u8         reserved_32[0x4];
	u8         xrc[0x1];
	u8         ud[0x1];
	u8         uc[0x1];
	u8         rc[0x1];

	u8         reserved_33[0xa];
	u8         uar_sz[0x6];
	u8         reserved_34[0x8];
	u8         log_pg_sz[0x8];

	u8         bf[0x1];
	u8         driver_version[0x1];
	u8         pad_tx_eth_packet[0x1];
	u8         reserved_35[0x8];
	u8         log_bf_reg_size[0x5];
	u8         reserved_36[0x10];

	u8         reserved_37[0x10];
	u8         max_wqe_sz_sq[0x10];

	u8         reserved_38[0x10];
	u8         max_wqe_sz_rq[0x10];

	u8         reserved_39[0x10];
	u8         max_wqe_sz_sq_dc[0x10];

	u8         reserved_40[0x7];
	u8         max_qp_mcg[0x19];

	u8         reserved_41[0x18];
	u8         log_max_mcg[0x8];

	u8         reserved_42[0x3];
	u8         log_max_transport_domain[0x5];
	u8         reserved_43[0x3];
	u8         log_max_pd[0x5];
	u8         reserved_44[0xb];
	u8         log_max_xrcd[0x5];

	u8         reserved_45[0x10];
	u8         max_flow_counter[0x10];

	u8         reserved_46[0x3];
	u8         log_max_rq[0x5];
	u8         reserved_47[0x3];
	u8         log_max_sq[0x5];
	u8         reserved_48[0x3];
	u8         log_max_tir[0x5];
	u8         reserved_49[0x3];
	u8         log_max_tis[0x5];

	u8         basic_cyclic_rcv_wqe[0x1];
	u8         reserved_50[0x2];
	u8         log_max_rmp[0x5];
	u8         reserved_51[0x3];
	u8         log_max_rqt[0x5];
	u8         reserved_52[0x3];
	u8         log_max_rqt_size[0x5];
	u8         reserved_53[0x3];
	u8         log_max_tis_per_sq[0x5];

	u8         reserved_54[0x3];
	u8         log_max_stride_sz_rq[0x5];
	u8         reserved_55[0x3];
	u8         log_min_stride_sz_rq[0x5];
	u8         reserved_56[0x3];
	u8         log_max_stride_sz_sq[0x5];
	u8         reserved_57[0x3];
	u8         log_min_stride_sz_sq[0x5];

	u8         reserved_58[0x1b];
	u8         log_max_wq_sz[0x5];

	u8         nic_vport_change_event[0x1];
	u8         reserved_59[0xa];
	u8         log_max_vlan_list[0x5];
	u8         reserved_60[0x3];
	u8         log_max_current_mc_list[0x5];
	u8         reserved_61[0x3];
	u8         log_max_current_uc_list[0x5];

	u8         reserved_62[0x80];

	u8         reserved_63[0x3];
	u8         log_max_l2_table[0x5];
	u8         reserved_64[0x8];
	u8         log_uar_page_sz[0x10];

	u8         reserved_65[0x20];

	u8         device_frequency[0x20];

	u8         reserved_66[0xa0];

	u8         log_max_atomic_size_qp[0x8];
	u8         reserved_67[0x10];
	u8         log_max_atomic_size_dc[0x8];

	u8         reserved_68[0x1f];
	u8         cqe_compression[0x1];

	u8         cqe_compression_timeout[0x10];
	u8         cqe_compression_max_num[0x10];

	u8         reserved_69[0x220];
};

union mlx5_ifc_dest_format_struct_flow_counter_list_auto_bits {
	struct mlx5_ifc_dest_format_struct_bits dest_format_struct;
	struct mlx5_ifc_flow_counter_list_bits flow_counter_list;
	u8         reserved_0[0x40];
};

struct mlx5_ifc_fte_match_param_bits {
	struct mlx5_ifc_fte_match_set_lyr_2_4_bits outer_headers;

	struct mlx5_ifc_fte_match_set_misc_bits misc_parameters;

	struct mlx5_ifc_fte_match_set_lyr_2_4_bits inner_headers;

	u8         reserved_0[0xa00];
};

enum {
	MLX5_RX_HASH_FIELD_SELECT_SELECTED_FIELDS_SRC_IP     = 0x0,
	MLX5_RX_HASH_FIELD_SELECT_SELECTED_FIELDS_DST_IP     = 0x1,
	MLX5_RX_HASH_FIELD_SELECT_SELECTED_FIELDS_L4_SPORT   = 0x2,
	MLX5_RX_HASH_FIELD_SELECT_SELECTED_FIELDS_L4_DPORT   = 0x3,
	MLX5_RX_HASH_FIELD_SELECT_SELECTED_FIELDS_IPSEC_SPI  = 0x4,
};

struct mlx5_ifc_rx_hash_field_select_bits {
	u8         l3_prot_type[0x1];
	u8         l4_prot_type[0x1];
	u8         selected_fields[0x1e];
};

enum {
	MLX5_WQ_TYPE_LINKED_LIST                 = 0x0,
	MLX5_WQ_TYPE_CYCLIC                      = 0x1,
	MLX5_WQ_TYPE_STRQ_LINKED_LIST            = 0x2,
	MLX5_WQ_TYPE_STRQ_CYCLIC                 = 0x3,
};

enum {
	MLX5_WQ_END_PAD_MODE_NONE               = 0x0,
	MLX5_WQ_END_PAD_MODE_ALIGN              = 0x1,
};

struct mlx5_ifc_wq_bits {
	u8         wq_type[0x4];
	u8         wq_signature[0x1];
	u8         end_padding_mode[0x2];
	u8         cd_slave[0x1];
	u8         reserved_0[0x18];

	u8         hds_skip_first_sge[0x1];
	u8         log2_hds_buf_size[0x3];
	u8         reserved_1[0x7];
	u8         page_offset[0x5];
	u8         lwm[0x10];

	u8         reserved_2[0x8];
	u8         pd[0x18];

	u8         reserved_3[0x8];
	u8         uar_page[0x18];

	u8         dbr_addr[0x40];

	u8         hw_counter[0x20];

	u8         sw_counter[0x20];

	u8         reserved_4[0xc];
	u8         log_wq_stride[0x4];
	u8         reserved_5[0x3];
	u8         log_wq_pg_sz[0x5];
	u8         reserved_6[0x3];
	u8         log_wq_sz[0x5];

	u8         reserved_7[0x15];
	u8         single_wqe_log_num_of_strides[0x3];
	u8         two_byte_shift_en[0x1];
	u8         reserved_8[0x4];
	u8         single_stride_log_num_of_bytes[0x3];

	u8         reserved_9[0x4c0];

	struct mlx5_ifc_cmd_pas_bits pas[0];
};

struct mlx5_ifc_rq_num_bits {
	u8         reserved_0[0x8];
	u8         rq_num[0x18];
};

struct mlx5_ifc_mac_address_layout_bits {
	u8         reserved_0[0x10];
	u8         mac_addr_47_32[0x10];

	u8         mac_addr_31_0[0x20];
};

struct mlx5_ifc_cong_control_r_roce_ecn_np_bits {
	u8         reserved_0[0xa0];

	u8         min_time_between_cnps[0x20];

	u8         reserved_1[0x12];
	u8         cnp_dscp[0x6];
	u8         reserved_2[0x4];
	u8         cnp_prio_mode[0x1];
	u8         cnp_802p_prio[0x3];

	u8         reserved_3[0x720];
};

struct mlx5_ifc_cong_control_r_roce_ecn_rp_bits {
	u8         reserved_0[0x60];

	u8         reserved_1[0x4];
	u8         clamp_tgt_rate[0x1];
	u8         reserved_2[0x3];
	u8         clamp_tgt_rate_after_time_inc[0x1];
	u8         reserved_3[0x17];

	u8         reserved_4[0x20];

	u8         rpg_time_reset[0x20];

	u8         rpg_byte_reset[0x20];

	u8         rpg_threshold[0x20];

	u8         rpg_max_rate[0x20];

	u8         rpg_ai_rate[0x20];

	u8         rpg_hai_rate[0x20];

	u8         rpg_gd[0x20];

	u8         rpg_min_dec_fac[0x20];

	u8         rpg_min_rate[0x20];

	u8         reserved_5[0xe0];

	u8         rate_to_set_on_first_cnp[0x20];

	u8         dce_tcp_g[0x20];

	u8         dce_tcp_rtt[0x20];

	u8         rate_reduce_monitor_period[0x20];

	u8         reserved_6[0x20];

	u8         initial_alpha_value[0x20];

	u8         reserved_7[0x4a0];
};

struct mlx5_ifc_cong_control_802_1qau_rp_bits {
	u8         reserved_0[0x80];

	u8         rppp_max_rps[0x20];

	u8         rpg_time_reset[0x20];

	u8         rpg_byte_reset[0x20];

	u8         rpg_threshold[0x20];

	u8         rpg_max_rate[0x20];

	u8         rpg_ai_rate[0x20];

	u8         rpg_hai_rate[0x20];

	u8         rpg_gd[0x20];

	u8         rpg_min_dec_fac[0x20];

	u8         rpg_min_rate[0x20];

	u8         reserved_1[0x640];
};

enum {
	MLX5_RESIZE_FIELD_SELECT_RESIZE_FIELD_SELECT_LOG_CQ_SIZE    = 0x1,
	MLX5_RESIZE_FIELD_SELECT_RESIZE_FIELD_SELECT_PAGE_OFFSET    = 0x2,
	MLX5_RESIZE_FIELD_SELECT_RESIZE_FIELD_SELECT_LOG_PAGE_SIZE  = 0x4,
};

struct mlx5_ifc_resize_field_select_bits {
	u8         resize_field_select[0x20];
};

enum {
	MLX5_MODIFY_FIELD_SELECT_MODIFY_FIELD_SELECT_CQ_PERIOD     = 0x1,
	MLX5_MODIFY_FIELD_SELECT_MODIFY_FIELD_SELECT_CQ_MAX_COUNT  = 0x2,
	MLX5_MODIFY_FIELD_SELECT_MODIFY_FIELD_SELECT_OI            = 0x4,
	MLX5_MODIFY_FIELD_SELECT_MODIFY_FIELD_SELECT_C_EQN         = 0x8,
};

struct mlx5_ifc_modify_field_select_bits {
	u8         modify_field_select[0x20];
};

struct mlx5_ifc_field_select_r_roce_np_bits {
	u8         field_select_r_roce_np[0x20];
};

enum {
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_CLAMP_TGT_RATE                 = 0x2,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_CLAMP_TGT_RATE_AFTER_TIME_INC  = 0x4,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_TIME_RESET                 = 0x8,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_BYTE_RESET                 = 0x10,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_THRESHOLD                  = 0x20,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_MAX_RATE                   = 0x40,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_AI_RATE                    = 0x80,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_HAI_RATE                   = 0x100,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_MIN_DEC_FAC                = 0x200,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RPG_MIN_RATE                   = 0x400,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RATE_TO_SET_ON_FIRST_CNP       = 0x800,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_DCE_TCP_G                      = 0x1000,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_DCE_TCP_RTT                    = 0x2000,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_RATE_REDUCE_MONITOR_PERIOD     = 0x4000,
	MLX5_FIELD_SELECT_R_ROCE_RP_FIELD_SELECT_R_ROCE_RP_INITIAL_ALPHA_VALUE            = 0x8000,
};

struct mlx5_ifc_field_select_r_roce_rp_bits {
	u8         field_select_r_roce_rp[0x20];
};

enum {
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPPP_MAX_RPS     = 0x4,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_TIME_RESET   = 0x8,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_BYTE_RESET   = 0x10,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_THRESHOLD    = 0x20,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_MAX_RATE     = 0x40,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_AI_RATE      = 0x80,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_HAI_RATE     = 0x100,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_GD           = 0x200,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_MIN_DEC_FAC  = 0x400,
	MLX5_FIELD_SELECT_802_1QAU_RP_FIELD_SELECT_8021QAURP_RPG_MIN_RATE     = 0x800,
};

struct mlx5_ifc_field_select_802_1qau_rp_bits {
	u8         field_select_8021qaurp[0x20];
};

struct mlx5_ifc_nodnic_ring_config_reg_bits {
	u8         queue_address_63_32[0x20];

	u8         queue_address_31_12[0x14];
	u8         reserved_0[0x6];
	u8         log_size[0x6];

	struct mlx5_ifc_nodnic_ring_doorbell_bits doorbell;

	u8         reserved_1[0x8];
	u8         queue_number[0x18];

	u8         q_key[0x20];

	u8         reserved_2[0x10];
	u8         pkey_index[0x10];

	u8         reserved_3[0x40];
};

struct mlx5_ifc_nodnic_cq_arming_word_bits {
	u8         reserved_0[0x8];
	u8         cq_ci[0x10];
	u8         reserved_1[0x8];
};

enum {
	MLX5_NODNIC_EVENT_WORD_LINK_TYPE_INFINIBAND  = 0x0,
	MLX5_NODNIC_EVENT_WORD_LINK_TYPE_ETHERNET    = 0x1,
};

enum {
	MLX5_NODNIC_EVENT_WORD_PORT_STATE_DOWN        = 0x0,
	MLX5_NODNIC_EVENT_WORD_PORT_STATE_INITIALIZE  = 0x1,
	MLX5_NODNIC_EVENT_WORD_PORT_STATE_ARMED       = 0x2,
	MLX5_NODNIC_EVENT_WORD_PORT_STATE_ACTIVE      = 0x3,
};

struct mlx5_ifc_nodnic_event_word_bits {
	u8         driver_reset_needed[0x1];
	u8         port_management_change_event[0x1];
	u8         reserved_0[0x19];
	u8         link_type[0x1];
	u8         port_state[0x4];
};

struct mlx5_ifc_nic_vport_change_event_bits {
	u8         reserved_0[0x10];
	u8         vport_num[0x10];

	u8         reserved_1[0xc0];
};

struct mlx5_ifc_pages_req_event_bits {
	u8         reserved_0[0x10];
	u8         function_id[0x10];

	u8         num_pages[0x20];

	u8         reserved_1[0xa0];
};

struct mlx5_ifc_cmd_inter_comp_event_bits {
	u8         command_completion_vector[0x20];

	u8         reserved_0[0xc0];
};

struct mlx5_ifc_stall_vl_event_bits {
	u8         reserved_0[0x18];
	u8         port_num[0x1];
	u8         reserved_1[0x3];
	u8         vl[0x4];

	u8         reserved_2[0xa0];
};

struct mlx5_ifc_db_bf_congestion_event_bits {
	u8         event_subtype[0x8];
	u8         reserved_0[0x8];
	u8         congestion_level[0x8];
	u8         reserved_1[0x8];

	u8         reserved_2[0xa0];
};

struct mlx5_ifc_gpio_event_bits {
	u8         reserved_0[0x60];

	u8         gpio_event_hi[0x20];

	u8         gpio_event_lo[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_port_state_change_event_bits {
	u8         reserved_0[0x40];

	u8         port_num[0x4];
	u8         reserved_1[0x1c];

	u8         reserved_2[0x80];
};

struct mlx5_ifc_dropped_packet_logged_bits {
	u8         reserved_0[0xe0];
};

enum {
	MLX5_CQ_ERROR_SYNDROME_CQ_OVERRUN                 = 0x1,
	MLX5_CQ_ERROR_SYNDROME_CQ_ACCESS_VIOLATION_ERROR  = 0x2,
};

struct mlx5_ifc_cq_error_bits {
	u8         reserved_0[0x8];
	u8         cqn[0x18];

	u8         reserved_1[0x20];

	u8         reserved_2[0x18];
	u8         syndrome[0x8];

	u8         reserved_3[0x80];
};

struct mlx5_ifc_rdma_page_fault_event_bits {
	u8         bytes_commited[0x20];

	u8         r_key[0x20];

	u8         reserved_0[0x10];
	u8         packet_len[0x10];

	u8         rdma_op_len[0x20];

	u8         rdma_va[0x40];

	u8         reserved_1[0x5];
	u8         rdma[0x1];
	u8         write[0x1];
	u8         requestor[0x1];
	u8         qp_number[0x18];
};

struct mlx5_ifc_wqe_associated_page_fault_event_bits {
	u8         bytes_committed[0x20];

	u8         reserved_0[0x10];
	u8         wqe_index[0x10];

	u8         reserved_1[0x10];
	u8         len[0x10];

	u8         reserved_2[0x60];

	u8         reserved_3[0x5];
	u8         rdma[0x1];
	u8         write_read[0x1];
	u8         requestor[0x1];
	u8         qpn[0x18];
};

enum {
	MLX5_QP_EVENTS_TYPE_QP  = 0x0,
	MLX5_QP_EVENTS_TYPE_RQ  = 0x1,
	MLX5_QP_EVENTS_TYPE_SQ  = 0x2,
};

struct mlx5_ifc_qp_events_bits {
	u8         reserved_0[0xa0];

	u8         type[0x8];
	u8         reserved_1[0x18];

	u8         reserved_2[0x8];
	u8         qpn_rqn_sqn[0x18];
};

struct mlx5_ifc_dct_events_bits {
	u8         reserved_0[0xc0];

	u8         reserved_1[0x8];
	u8         dct_number[0x18];
};

struct mlx5_ifc_comp_event_bits {
	u8         reserved_0[0xc0];

	u8         reserved_1[0x8];
	u8         cq_number[0x18];
};

struct mlx5_ifc_fw_version_bits {
	u8         major[0x10];
	u8         reserved_0[0x10];

	u8         minor[0x10];
	u8         subminor[0x10];

	u8         second[0x8];
	u8         minute[0x8];
	u8         hour[0x8];
	u8         reserved_1[0x8];

	u8         year[0x10];
	u8         month[0x8];
	u8         day[0x8];
};

enum {
	MLX5_QPC_STATE_RST        = 0x0,
	MLX5_QPC_STATE_INIT       = 0x1,
	MLX5_QPC_STATE_RTR        = 0x2,
	MLX5_QPC_STATE_RTS        = 0x3,
	MLX5_QPC_STATE_SQER       = 0x4,
	MLX5_QPC_STATE_SQD        = 0x5,
	MLX5_QPC_STATE_ERR        = 0x6,
	MLX5_QPC_STATE_SUSPENDED  = 0x9,
};

enum {
	MLX5_QPC_ST_RC            = 0x0,
	MLX5_QPC_ST_UC            = 0x1,
	MLX5_QPC_ST_UD            = 0x2,
	MLX5_QPC_ST_XRC           = 0x3,
	MLX5_QPC_ST_DCI           = 0x5,
	MLX5_QPC_ST_QP0           = 0x7,
	MLX5_QPC_ST_QP1           = 0x8,
	MLX5_QPC_ST_RAW_DATAGRAM  = 0x9,
	MLX5_QPC_ST_REG_UMR       = 0xc,
};

enum {
	MLX5_QP_PM_ARMED            = 0x0,
	MLX5_QP_PM_REARM            = 0x1,
	MLX5_QPC_PM_STATE_RESERVED  = 0x2,
	MLX5_QP_PM_MIGRATED         = 0x3,
};

enum {
	MLX5_QPC_END_PADDING_MODE_SCATTER_AS_IS                = 0x0,
	MLX5_QPC_END_PADDING_MODE_PAD_TO_CACHE_LINE_ALIGNMENT  = 0x1,
};

enum {
	MLX5_QPC_MTU_256_BYTES        = 0x1,
	MLX5_QPC_MTU_512_BYTES        = 0x2,
	MLX5_QPC_MTU_1K_BYTES         = 0x3,
	MLX5_QPC_MTU_2K_BYTES         = 0x4,
	MLX5_QPC_MTU_4K_BYTES         = 0x5,
	MLX5_QPC_MTU_RAW_ETHERNET_QP  = 0x7,
};

enum {
	MLX5_QPC_ATOMIC_MODE_IB_SPEC     = 0x1,
	MLX5_QPC_ATOMIC_MODE_ONLY_8B     = 0x2,
	MLX5_QPC_ATOMIC_MODE_UP_TO_8B    = 0x3,
	MLX5_QPC_ATOMIC_MODE_UP_TO_16B   = 0x4,
	MLX5_QPC_ATOMIC_MODE_UP_TO_32B   = 0x5,
	MLX5_QPC_ATOMIC_MODE_UP_TO_64B   = 0x6,
	MLX5_QPC_ATOMIC_MODE_UP_TO_128B  = 0x7,
	MLX5_QPC_ATOMIC_MODE_UP_TO_256B  = 0x8,
};

enum {
	MLX5_QPC_CS_REQ_DISABLE    = 0x0,
	MLX5_QPC_CS_REQ_UP_TO_32B  = 0x11,
	MLX5_QPC_CS_REQ_UP_TO_64B  = 0x22,
};

enum {
	MLX5_QPC_CS_RES_DISABLE    = 0x0,
	MLX5_QPC_CS_RES_UP_TO_32B  = 0x1,
	MLX5_QPC_CS_RES_UP_TO_64B  = 0x2,
};

struct mlx5_ifc_qpc_bits {
	u8         state[0x4];
	u8         reserved_0[0x4];
	u8         st[0x8];
	u8         reserved_1[0x3];
	u8         pm_state[0x2];
	u8         reserved_2[0x7];
	u8         end_padding_mode[0x2];
	u8         reserved_3[0x2];

	u8         wq_signature[0x1];
	u8         block_lb_mc[0x1];
	u8         atomic_like_write_en[0x1];
	u8         latency_sensitive[0x1];
	u8         reserved_4[0x1];
	u8         drain_sigerr[0x1];
	u8         reserved_5[0x2];
	u8         pd[0x18];

	u8         mtu[0x3];
	u8         log_msg_max[0x5];
	u8         reserved_6[0x1];
	u8         log_rq_size[0x4];
	u8         log_rq_stride[0x3];
	u8         no_sq[0x1];
	u8         log_sq_size[0x4];
	u8         reserved_7[0x6];
	u8         rlky[0x1];
	u8         reserved_8[0x4];

	u8         counter_set_id[0x8];
	u8         uar_page[0x18];

	u8         reserved_9[0x8];
	u8         user_index[0x18];

	u8         reserved_10[0x3];
	u8         log_page_size[0x5];
	u8         remote_qpn[0x18];

	struct mlx5_ifc_ads_bits primary_address_path;

	struct mlx5_ifc_ads_bits secondary_address_path;

	u8         log_ack_req_freq[0x4];
	u8         reserved_11[0x4];
	u8         log_sra_max[0x3];
	u8         reserved_12[0x2];
	u8         retry_count[0x3];
	u8         rnr_retry[0x3];
	u8         reserved_13[0x1];
	u8         fre[0x1];
	u8         cur_rnr_retry[0x3];
	u8         cur_retry_count[0x3];
	u8         reserved_14[0x5];

	u8         reserved_15[0x20];

	u8         reserved_16[0x8];
	u8         next_send_psn[0x18];

	u8         reserved_17[0x8];
	u8         cqn_snd[0x18];

	u8         reserved_18[0x40];

	u8         reserved_19[0x8];
	u8         last_acked_psn[0x18];

	u8         reserved_20[0x8];
	u8         ssn[0x18];

	u8         reserved_21[0x8];
	u8         log_rra_max[0x3];
	u8         reserved_22[0x1];
	u8         atomic_mode[0x4];
	u8         rre[0x1];
	u8         rwe[0x1];
	u8         rae[0x1];
	u8         reserved_23[0x1];
	u8         page_offset[0x6];
	u8         reserved_24[0x3];
	u8         cd_slave_receive[0x1];
	u8         cd_slave_send[0x1];
	u8         cd_master[0x1];

	u8         reserved_25[0x3];
	u8         min_rnr_nak[0x5];
	u8         next_rcv_psn[0x18];

	u8         reserved_26[0x8];
	u8         xrcd[0x18];

	u8         reserved_27[0x8];
	u8         cqn_rcv[0x18];

	u8         dbr_addr[0x40];

	u8         q_key[0x20];

	u8         reserved_28[0x5];
	u8         rq_type[0x3];
	u8         srqn_rmpn[0x18];

	u8         reserved_29[0x8];
	u8         rmsn[0x18];

	u8         hw_sq_wqebb_counter[0x10];
	u8         sw_sq_wqebb_counter[0x10];

	u8         hw_rq_counter[0x20];

	u8         sw_rq_counter[0x20];

	u8         reserved_30[0x20];

	u8         reserved_31[0xf];
	u8         cgs[0x1];
	u8         cs_req[0x8];
	u8         cs_res[0x8];

	u8         dc_access_key[0x40];

	u8         rdma_active[0x1];
	u8         comm_est[0x1];
	u8         suspended[0x1];
	u8         reserved_32[0x5];
	u8         send_msg_psn[0x18];

	u8         reserved_33[0x8];
	u8         rcv_msg_psn[0x18];

	u8         rdma_va[0x40];

	u8         rdma_key[0x20];

	u8         reserved_34[0x20];
};

struct mlx5_ifc_roce_addr_layout_bits {
	u8         source_l3_address[16][0x8];

	u8         reserved_0[0x3];
	u8         vlan_valid[0x1];
	u8         vlan_id[0xc];
	u8         source_mac_47_32[0x10];

	u8         source_mac_31_0[0x20];

	u8         reserved_1[0x14];
	u8         roce_l3_type[0x4];
	u8         roce_version[0x8];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_rdbc_bits {
	u8         reserved_0[0x1c];
	u8         type[0x4];

	u8         reserved_1[0x20];

	u8         reserved_2[0x8];
	u8         psn[0x18];

	u8         rkey[0x20];

	u8         address[0x40];

	u8         byte_count[0x20];

	u8         reserved_3[0x20];

	u8         atomic_resp[32][0x8];
};

enum {
	MLX5_FLOW_CONTEXT_ACTION_ALLOW     = 0x1,
	MLX5_FLOW_CONTEXT_ACTION_DROP      = 0x2,
	MLX5_FLOW_CONTEXT_ACTION_FWD_DEST  = 0x4,
	MLX5_FLOW_CONTEXT_ACTION_COUNT     = 0x8,
};

struct mlx5_ifc_flow_context_bits {
	u8         reserved_0[0x20];

	u8         group_id[0x20];

	u8         reserved_1[0x8];
	u8         flow_tag[0x18];

	u8         reserved_2[0x10];
	u8         action[0x10];

	u8         reserved_3[0x8];
	u8         destination_list_size[0x18];

	u8         reserved_4[0x8];
	u8         flow_counter_list_size[0x18];

	u8         reserved_5[0x140];

	struct mlx5_ifc_fte_match_param_bits match_value;

	u8         reserved_6[0x600];

	union mlx5_ifc_dest_format_struct_flow_counter_list_auto_bits destination[0];
};

enum {
	MLX5_XRC_SRQC_STATE_GOOD   = 0x0,
	MLX5_XRC_SRQC_STATE_ERROR  = 0x1,
};

struct mlx5_ifc_xrc_srqc_bits {
	u8         state[0x4];
	u8         log_xrc_srq_size[0x4];
	u8         reserved_0[0x18];

	u8         wq_signature[0x1];
	u8         cont_srq[0x1];
	u8         reserved_1[0x1];
	u8         rlky[0x1];
	u8         basic_cyclic_rcv_wqe[0x1];
	u8         log_rq_stride[0x3];
	u8         xrcd[0x18];

	u8         page_offset[0x6];
	u8         reserved_2[0x2];
	u8         cqn[0x18];

	u8         reserved_3[0x20];

	u8         reserved_4[0x2];
	u8         log_page_size[0x6];
	u8         user_index[0x18];

	u8         reserved_5[0x20];

	u8         reserved_6[0x8];
	u8         pd[0x18];

	u8         lwm[0x10];
	u8         wqe_cnt[0x10];

	u8         reserved_7[0x40];

	u8         db_record_addr_h[0x20];

	u8         db_record_addr_l[0x1e];
	u8         reserved_8[0x2];

	u8         reserved_9[0x80];
};

struct mlx5_ifc_traffic_counter_bits {
	u8         packets[0x40];

	u8         octets[0x40];
};

struct mlx5_ifc_tisc_bits {
	u8         reserved_0[0xc];
	u8         prio[0x4];
	u8         reserved_1[0x10];

	u8         reserved_2[0x100];

	u8         reserved_3[0x8];
	u8         transport_domain[0x18];

	u8         reserved_4[0x3c0];
};

enum {
	MLX5_TIRC_DISP_TYPE_DIRECT    = 0x0,
	MLX5_TIRC_DISP_TYPE_INDIRECT  = 0x1,
};

enum {
	MLX5_TIRC_LRO_ENABLE_MASK_IPV4_LRO  = 0x1,
	MLX5_TIRC_LRO_ENABLE_MASK_IPV6_LRO  = 0x2,
};

enum {
	MLX5_TIRC_RX_HASH_FN_HASH_NONE           = 0x0,
	MLX5_TIRC_RX_HASH_FN_HASH_INVERTED_XOR8  = 0x1,
	MLX5_TIRC_RX_HASH_FN_HASH_TOEPLITZ       = 0x2,
};

enum {
	MLX5_TIRC_SELF_LB_EN_ENABLE_UNICAST    = 0x1,
	MLX5_TIRC_SELF_LB_EN_ENABLE_MULTICAST  = 0x2,
};

struct mlx5_ifc_tirc_bits {
	u8         reserved_0[0x20];

	u8         disp_type[0x4];
	u8         reserved_1[0x1c];

	u8         reserved_2[0x40];

	u8         reserved_3[0x4];
	u8         lro_timeout_period_usecs[0x10];
	u8         lro_enable_mask[0x4];
	u8         lro_max_msg_sz[0x8];

	u8         reserved_4[0x40];

	u8         reserved_5[0x8];
	u8         inline_rqn[0x18];

	u8         rx_hash_symmetric[0x1];
	u8         reserved_6[0x1];
	u8         tunneled_offload_en[0x1];
	u8         reserved_7[0x5];
	u8         indirect_table[0x18];

	u8         rx_hash_fn[0x4];
	u8         reserved_8[0x2];
	u8         self_lb_en[0x2];
	u8         transport_domain[0x18];

	u8         rx_hash_toeplitz_key[10][0x20];

	struct mlx5_ifc_rx_hash_field_select_bits rx_hash_field_selector_outer;

	struct mlx5_ifc_rx_hash_field_select_bits rx_hash_field_selector_inner;

	u8         reserved_9[0x4c0];
};

enum {
	MLX5_SRQC_STATE_GOOD   = 0x0,
	MLX5_SRQC_STATE_ERROR  = 0x1,
};

struct mlx5_ifc_srqc_bits {
	u8         state[0x4];
	u8         log_srq_size[0x4];
	u8         reserved_0[0x18];

	u8         wq_signature[0x1];
	u8         cont_srq[0x1];
	u8         reserved_1[0x1];
	u8         rlky[0x1];
	u8         reserved_2[0x1];
	u8         log_rq_stride[0x3];
	u8         xrcd[0x18];

	u8         page_offset[0x6];
	u8         reserved_3[0x2];
	u8         cqn[0x18];

	u8         reserved_4[0x20];

	u8         reserved_5[0x2];
	u8         log_page_size[0x6];
	u8         reserved_6[0x18];

	u8         reserved_7[0x20];

	u8         reserved_8[0x8];
	u8         pd[0x18];

	u8         lwm[0x10];
	u8         wqe_cnt[0x10];

	u8         reserved_9[0x40];

	u8         db_record_addr_h[0x20];

	u8         db_record_addr_l[0x1e];
	u8         reserved_10[0x2];

	u8         reserved_11[0x80];
};

enum {
	MLX5_SQC_STATE_RST  = 0x0,
	MLX5_SQC_STATE_RDY  = 0x1,
	MLX5_SQC_STATE_ERR  = 0x3,
};

struct mlx5_ifc_sqc_bits {
	u8         rlky[0x1];
	u8         cd_master[0x1];
	u8         fre[0x1];
	u8         flush_in_error_en[0x1];
	u8         allow_multi_pkt_send_wqe[0x1];
	u8         min_wqe_inline_mode[0x3];
	u8         state[0x4];
	u8         reserved_0[0x14];

	u8         reserved_1[0x8];
	u8         user_index[0x18];

	u8         reserved_2[0x8];
	u8         cqn[0x18];

	u8         reserved_3[0xa0];

	u8         tis_lst_sz[0x10];
	u8         reserved_4[0x10];

	u8         reserved_5[0x40];

	u8         reserved_6[0x8];
	u8         tis_num_0[0x18];

	struct mlx5_ifc_wq_bits wq;
};

struct mlx5_ifc_rqtc_bits {
	u8         reserved_0[0xa0];

	u8         reserved_1[0x10];
	u8         rqt_max_size[0x10];

	u8         reserved_2[0x10];
	u8         rqt_actual_size[0x10];

	u8         reserved_3[0x6a0];

	struct mlx5_ifc_rq_num_bits rq_num[0];
};

enum {
	MLX5_RQC_RQ_TYPE_MEMORY_RQ_INLINE      = 0x0,
	MLX5_RQC_RQ_TYPE_MEMORY_RQ_RMP         = 0x1,
};

enum {
	MLX5_RQC_STATE_RST  = 0x0,
	MLX5_RQC_STATE_RDY  = 0x1,
	MLX5_RQC_STATE_ERR  = 0x3,
};

struct mlx5_ifc_rqc_bits {
	u8         rlky[0x1];
	u8         reserved_0[0x2];
	u8         vlan_strip_disable[0x1];
	u8         mem_rq_type[0x4];
	u8         state[0x4];
	u8         reserved_1[0x1];
	u8         flush_in_error_en[0x1];
	u8         reserved_2[0x12];

	u8         reserved_3[0x8];
	u8         user_index[0x18];

	u8         reserved_4[0x8];
	u8         cqn[0x18];

	u8         counter_set_id[0x8];
	u8         reserved_5[0x18];

	u8         reserved_6[0x8];
	u8         rmpn[0x18];

	u8         reserved_7[0xe0];

	struct mlx5_ifc_wq_bits wq;
};

enum {
	MLX5_RMPC_STATE_RDY  = 0x1,
	MLX5_RMPC_STATE_ERR  = 0x3,
};

struct mlx5_ifc_rmpc_bits {
	u8         reserved_0[0x8];
	u8         state[0x4];
	u8         reserved_1[0x14];

	u8         basic_cyclic_rcv_wqe[0x1];
	u8         reserved_2[0x1f];

	u8         reserved_3[0x140];

	struct mlx5_ifc_wq_bits wq;
};

enum {
	MLX5_NIC_VPORT_CONTEXT_ALLOWED_LIST_TYPE_CURRENT_UC_MAC_ADDRESS  = 0x0,
	MLX5_NIC_VPORT_CONTEXT_ALLOWED_LIST_TYPE_CURRENT_MC_MAC_ADDRESS  = 0x1,
	MLX5_NIC_VPORT_CONTEXT_ALLOWED_LIST_TYPE_VLAN_LIST               = 0x2,
};

struct mlx5_ifc_nic_vport_context_bits {
	u8         reserved_0[0x5];
	u8         min_wqe_inline_mode[0x3];
	u8         reserved_1[0x17];
	u8         roce_en[0x1];

	u8         arm_change_event[0x1];
	u8         reserved_2[0x1a];
	u8         event_on_mtu[0x1];
	u8         event_on_promisc_change[0x1];
	u8         event_on_vlan_change[0x1];
	u8         event_on_mc_address_change[0x1];
	u8         event_on_uc_address_change[0x1];

	u8         reserved_3[0xe0];

	u8         reserved_4[0x10];
	u8         mtu[0x10];

	u8         system_image_guid[0x40];

	u8         port_guid[0x40];

	u8         node_guid[0x40];

	u8         reserved_5[0x140];

	u8         qkey_violation_counter[0x10];
	u8         reserved_6[0x10];

	u8         reserved_7[0x420];

	u8         promisc_uc[0x1];
	u8         promisc_mc[0x1];
	u8         promisc_all[0x1];
	u8         reserved_8[0x2];
	u8         allowed_list_type[0x3];
	u8         reserved_9[0xc];
	u8         allowed_list_size[0xc];

	struct mlx5_ifc_mac_address_layout_bits permanent_address;

	u8         reserved_10[0x20];

	u8         current_uc_mac_address[0][0x40];
};

enum {
	MLX5_ACCESS_MODE_PA        = 0x0,
	MLX5_ACCESS_MODE_MTT       = 0x1,
	MLX5_ACCESS_MODE_KLM       = 0x2,
};

struct mlx5_ifc_mkc_bits {
	u8         reserved_0[0x1];
	u8         free[0x1];
	u8         reserved_1[0xd];
	u8         small_fence_on_rdma_read_response[0x1];
	u8         umr_en[0x1];
	u8         a[0x1];
	u8         rw[0x1];
	u8         rr[0x1];
	u8         lw[0x1];
	u8         lr[0x1];
	u8         access_mode[0x2];
	u8         reserved_2[0x8];

	u8         qpn[0x18];
	u8         mkey_7_0[0x8];

	u8         reserved_3[0x20];

	u8         length64[0x1];
	u8         bsf_en[0x1];
	u8         sync_umr[0x1];
	u8         reserved_4[0x2];
	u8         expected_sigerr_count[0x1];
	u8         reserved_5[0x1];
	u8         en_rinval[0x1];
	u8         pd[0x18];

	u8         start_addr[0x40];

	u8         len[0x40];

	u8         bsf_octword_size[0x20];

	u8         reserved_6[0x80];

	u8         translations_octword_size[0x20];

	u8         reserved_7[0x1b];
	u8         log_page_size[0x5];

	u8         reserved_8[0x20];
};

struct mlx5_ifc_pkey_bits {
	u8         reserved_0[0x10];
	u8         pkey[0x10];
};

struct mlx5_ifc_array128_auto_bits {
	u8         array128_auto[16][0x8];
};

enum {
	MLX5_HCA_VPORT_CONTEXT_FIELD_SELECT_PORT_GUID           = 0x0,
	MLX5_HCA_VPORT_CONTEXT_FIELD_SELECT_NODE_GUID           = 0x1,
	MLX5_HCA_VPORT_CONTEXT_FIELD_SELECT_VPORT_STATE_POLICY  = 0x2,
};

enum {
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_SLEEP                      = 0x1,
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_POLLING                    = 0x2,
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_DISABLED                   = 0x3,
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_PORTCONFIGURATIONTRAINING  = 0x4,
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_LINKUP                     = 0x5,
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_LINKERRORRECOVERY          = 0x6,
	MLX5_HCA_VPORT_CONTEXT_PORT_PHYSICAL_STATE_PHYTEST                    = 0x7,
};

enum {
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_POLICY_DOWN    = 0x0,
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_POLICY_UP      = 0x1,
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_POLICY_FOLLOW  = 0x2,
};

enum {
	MLX5_HCA_VPORT_CONTEXT_PORT_STATE_DOWN    = 0x1,
	MLX5_HCA_VPORT_CONTEXT_PORT_STATE_INIT    = 0x2,
	MLX5_HCA_VPORT_CONTEXT_PORT_STATE_ARM     = 0x3,
	MLX5_HCA_VPORT_CONTEXT_PORT_STATE_ACTIVE  = 0x4,
};

enum {
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_DOWN    = 0x1,
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_INIT    = 0x2,
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_ARM     = 0x3,
	MLX5_HCA_VPORT_CONTEXT_VPORT_STATE_ACTIVE  = 0x4,
};

struct mlx5_ifc_hca_vport_context_bits {
	u8         field_select[0x20];

	u8         reserved_0[0xe0];

	u8         sm_virt_aware[0x1];
	u8         has_smi[0x1];
	u8         has_raw[0x1];
	u8         grh_required[0x1];
	u8         reserved_1[0xc];
	u8         port_physical_state[0x4];
	u8         vport_state_policy[0x4];
	u8         port_state[0x4];
	u8         vport_state[0x4];

	u8         reserved_2[0x20];

	u8         system_image_guid[0x40];

	u8         port_guid[0x40];

	u8         node_guid[0x40];

	u8         cap_mask1[0x20];

	u8         cap_mask1_field_select[0x20];

	u8         cap_mask2[0x20];

	u8         cap_mask2_field_select[0x20];

	u8         reserved_3[0x80];

	u8         lid[0x10];
	u8         reserved_4[0x4];
	u8         init_type_reply[0x4];
	u8         lmc[0x3];
	u8         subnet_timeout[0x5];

	u8         sm_lid[0x10];
	u8         sm_sl[0x4];
	u8         reserved_5[0xc];

	u8         qkey_violation_counter[0x10];
	u8         pkey_violation_counter[0x10];

	u8         reserved_6[0xca0];
};

union mlx5_ifc_hca_cap_union_bits {
	struct mlx5_ifc_cmd_hca_cap_bits cmd_hca_cap;
	struct mlx5_ifc_odp_cap_bits odp_cap;
	struct mlx5_ifc_atomic_caps_bits atomic_caps;
	struct mlx5_ifc_roce_cap_bits roce_cap;
	struct mlx5_ifc_per_protocol_networking_offload_caps_bits per_protocol_networking_offload_caps;
	struct mlx5_ifc_flow_table_nic_cap_bits flow_table_nic_cap;
	struct mlx5_ifc_flow_table_eswitch_cap_bits flow_table_eswitch_cap;
	struct mlx5_ifc_e_switch_cap_bits e_switch_cap;
	u8         reserved_0[0x8000];
};

struct mlx5_ifc_esw_vport_context_bits {
	u8         reserved_0[0x3];
	u8         vport_svlan_strip[0x1];
	u8         vport_cvlan_strip[0x1];
	u8         vport_svlan_insert[0x1];
	u8         vport_cvlan_insert[0x2];
	u8         reserved_1[0x18];

	u8         reserved_2[0x20];

	u8         svlan_cfi[0x1];
	u8         svlan_pcp[0x3];
	u8         svlan_id[0xc];
	u8         cvlan_cfi[0x1];
	u8         cvlan_pcp[0x3];
	u8         cvlan_id[0xc];

	u8         reserved_3[0x7a0];
};

enum {
	MLX5_EQC_STATUS_OK                = 0x0,
	MLX5_EQC_STATUS_EQ_WRITE_FAILURE  = 0xa,
};

enum {
	MLX5_EQ_STATE_ARMED = 0x9,
	MLX5_EQ_STATE_FIRED = 0xa,
};

struct mlx5_ifc_eqc_bits {
	u8         status[0x4];
	u8         reserved_0[0x9];
	u8         ec[0x1];
	u8         oi[0x1];
	u8         reserved_1[0x5];
	u8         st[0x4];
	u8         reserved_2[0x8];

	u8         reserved_3[0x20];

	u8         reserved_4[0x14];
	u8         page_offset[0x6];
	u8         reserved_5[0x6];

	u8         reserved_6[0x3];
	u8         log_eq_size[0x5];
	u8         uar_page[0x18];

	u8         reserved_7[0x20];

	u8         reserved_8[0x18];
	u8         intr[0x8];

	u8         reserved_9[0x3];
	u8         log_page_size[0x5];
	u8         reserved_10[0x18];

	u8         reserved_11[0x60];

	u8         reserved_12[0x8];
	u8         consumer_counter[0x18];

	u8         reserved_13[0x8];
	u8         producer_counter[0x18];

	u8         reserved_14[0x80];
};

enum {
	MLX5_DCTC_STATE_ACTIVE    = 0x0,
	MLX5_DCTC_STATE_DRAINING  = 0x1,
	MLX5_DCTC_STATE_DRAINED   = 0x2,
};

enum {
	MLX5_DCTC_CS_RES_DISABLE    = 0x0,
	MLX5_DCTC_CS_RES_NA         = 0x1,
	MLX5_DCTC_CS_RES_UP_TO_64B  = 0x2,
};

enum {
	MLX5_DCTC_MTU_256_BYTES  = 0x1,
	MLX5_DCTC_MTU_512_BYTES  = 0x2,
	MLX5_DCTC_MTU_1K_BYTES   = 0x3,
	MLX5_DCTC_MTU_2K_BYTES   = 0x4,
	MLX5_DCTC_MTU_4K_BYTES   = 0x5,
};

struct mlx5_ifc_dctc_bits {
	u8         reserved_0[0x4];
	u8         state[0x4];
	u8         reserved_1[0x18];

	u8         reserved_2[0x8];
	u8         user_index[0x18];

	u8         reserved_3[0x8];
	u8         cqn[0x18];

	u8         counter_set_id[0x8];
	u8         atomic_mode[0x4];
	u8         rre[0x1];
	u8         rwe[0x1];
	u8         rae[0x1];
	u8         atomic_like_write_en[0x1];
	u8         latency_sensitive[0x1];
	u8         rlky[0x1];
	u8         reserved_4[0xe];

	u8         reserved_5[0x8];
	u8         cs_res[0x8];
	u8         reserved_6[0x3];
	u8         min_rnr_nak[0x5];
	u8         reserved_7[0x8];

	u8         reserved_8[0x8];
	u8         srqn[0x18];

	u8         reserved_9[0x8];
	u8         pd[0x18];

	u8         tclass[0x8];
	u8         reserved_10[0x4];
	u8         flow_label[0x14];

	u8         dc_access_key[0x40];

	u8         reserved_11[0x5];
	u8         mtu[0x3];
	u8         port[0x8];
	u8         pkey_index[0x10];

	u8         reserved_12[0x8];
	u8         my_addr_index[0x8];
	u8         reserved_13[0x8];
	u8         hop_limit[0x8];

	u8         dc_access_key_violation_count[0x20];

	u8         reserved_14[0x14];
	u8         dei_cfi[0x1];
	u8         eth_prio[0x3];
	u8         ecn[0x2];
	u8         dscp[0x6];

	u8         reserved_15[0x40];
};

enum {
	MLX5_CQC_STATUS_OK             = 0x0,
	MLX5_CQC_STATUS_CQ_OVERFLOW    = 0x9,
	MLX5_CQC_STATUS_CQ_WRITE_FAIL  = 0xa,
};

enum {
	CQE_SIZE_64                = 0x0,
	CQE_SIZE_128               = 0x1,
};

enum {
	MLX5_CQ_PERIOD_MODE_START_FROM_EQE  = 0x0,
	MLX5_CQ_PERIOD_MODE_START_FROM_CQE  = 0x1,
};

enum {
	MLX5_CQ_STATE_SOLICITED_ARMED                     = 0x6,
	MLX5_CQ_STATE_ARMED                               = 0x9,
	MLX5_CQ_STATE_FIRED                               = 0xa,
};

struct mlx5_ifc_cqc_bits {
	u8         status[0x4];
	u8         reserved_0[0x4];
	u8         cqe_sz[0x3];
	u8         cc[0x1];
	u8         reserved_1[0x1];
	u8         scqe_break_moderation_en[0x1];
	u8         oi[0x1];
	u8         cq_period_mode[0x2];
	u8         cqe_compression_en[0x1];
	u8         mini_cqe_res_format[0x2];
	u8         st[0x4];
	u8         reserved_2[0x8];

	u8         reserved_3[0x20];

	u8         reserved_4[0x14];
	u8         page_offset[0x6];
	u8         reserved_5[0x6];

	u8         reserved_6[0x3];
	u8         log_cq_size[0x5];
	u8         uar_page[0x18];

	u8         reserved_7[0x4];
	u8         cq_period[0xc];
	u8         cq_max_count[0x10];

	u8         reserved_8[0x18];
	u8         c_eqn[0x8];

	u8         reserved_9[0x3];
	u8         log_page_size[0x5];
	u8         reserved_10[0x18];

	u8         reserved_11[0x20];

	u8         reserved_12[0x8];
	u8         last_notified_index[0x18];

	u8         reserved_13[0x8];
	u8         last_solicit_index[0x18];

	u8         reserved_14[0x8];
	u8         consumer_counter[0x18];

	u8         reserved_15[0x8];
	u8         producer_counter[0x18];

	u8         reserved_16[0x40];

	u8         dbr_addr[0x40];
};

union mlx5_ifc_cong_control_roce_ecn_auto_bits {
	struct mlx5_ifc_cong_control_802_1qau_rp_bits cong_control_802_1qau_rp;
	struct mlx5_ifc_cong_control_r_roce_ecn_rp_bits cong_control_r_roce_ecn_rp;
	struct mlx5_ifc_cong_control_r_roce_ecn_np_bits cong_control_r_roce_ecn_np;
	u8         reserved_0[0x800];
};

struct mlx5_ifc_query_adapter_param_block_bits {
	u8         reserved_0[0xc0];

	u8         reserved_1[0x8];
	u8         ieee_vendor_id[0x18];

	u8         reserved_2[0x10];
	u8         vsd_vendor_id[0x10];

	u8         vsd[208][0x8];

	u8         vsd_contd_psid[16][0x8];
};

union mlx5_ifc_modify_field_select_resize_field_select_auto_bits {
	struct mlx5_ifc_modify_field_select_bits modify_field_select;
	struct mlx5_ifc_resize_field_select_bits resize_field_select;
	u8         reserved_0[0x20];
};

union mlx5_ifc_field_select_802_1_r_roce_auto_bits {
	struct mlx5_ifc_field_select_802_1qau_rp_bits field_select_802_1qau_rp;
	struct mlx5_ifc_field_select_r_roce_rp_bits field_select_r_roce_rp;
	struct mlx5_ifc_field_select_r_roce_np_bits field_select_r_roce_np;
	u8         reserved_0[0x20];
};

struct mlx5_ifc_bufferx_reg_bits {
	u8         reserved_0[0x6];
	u8         lossy[0x1];
	u8         epsb[0x1];
	u8         reserved_1[0xc];
	u8         size[0xc];

	u8         xoff_threshold[0x10];
	u8         xon_threshold[0x10];
};

struct mlx5_ifc_config_item_bits {
	u8         valid[0x2];
	u8         reserved_0[0x2];
	u8         header_type[0x2];
	u8         reserved_1[0x2];
	u8         default_location[0x1];
	u8         reserved_2[0x7];
	u8         version[0x4];
	u8         reserved_3[0x3];
	u8         length[0x9];

	u8         type[0x20];

	u8         reserved_4[0x10];
	u8         crc16[0x10];
};

struct mlx5_ifc_nodnic_port_config_reg_bits {
	struct mlx5_ifc_nodnic_event_word_bits event;

	u8         network_en[0x1];
	u8         dma_en[0x1];
	u8         promisc_en[0x1];
	u8         promisc_multicast_en[0x1];
	u8         reserved_0[0x17];
	u8         receive_filter_en[0x5];

	u8         reserved_1[0x10];
	u8         mac_47_32[0x10];

	u8         mac_31_0[0x20];

	u8         receive_filters_mgid_mac[64][0x8];

	u8         gid[16][0x8];

	u8         reserved_2[0x10];
	u8         lid[0x10];

	u8         reserved_3[0xc];
	u8         sm_sl[0x4];
	u8         sm_lid[0x10];

	u8         completion_address_63_32[0x20];

	u8         completion_address_31_12[0x14];
	u8         reserved_4[0x6];
	u8         log_cq_size[0x6];

	u8         working_buffer_address_63_32[0x20];

	u8         working_buffer_address_31_12[0x14];
	u8         reserved_5[0xc];

	struct mlx5_ifc_nodnic_cq_arming_word_bits arm_cq;

	u8         pkey_index[0x10];
	u8         pkey[0x10];

	struct mlx5_ifc_nodnic_ring_config_reg_bits send_ring0;

	struct mlx5_ifc_nodnic_ring_config_reg_bits send_ring1;

	struct mlx5_ifc_nodnic_ring_config_reg_bits receive_ring0;

	struct mlx5_ifc_nodnic_ring_config_reg_bits receive_ring1;

	u8         reserved_6[0x400];
};

union mlx5_ifc_event_auto_bits {
	struct mlx5_ifc_comp_event_bits comp_event;
	struct mlx5_ifc_dct_events_bits dct_events;
	struct mlx5_ifc_qp_events_bits qp_events;
	struct mlx5_ifc_wqe_associated_page_fault_event_bits wqe_associated_page_fault_event;
	struct mlx5_ifc_rdma_page_fault_event_bits rdma_page_fault_event;
	struct mlx5_ifc_cq_error_bits cq_error;
	struct mlx5_ifc_dropped_packet_logged_bits dropped_packet_logged;
	struct mlx5_ifc_port_state_change_event_bits port_state_change_event;
	struct mlx5_ifc_gpio_event_bits gpio_event;
	struct mlx5_ifc_db_bf_congestion_event_bits db_bf_congestion_event;
	struct mlx5_ifc_stall_vl_event_bits stall_vl_event;
	struct mlx5_ifc_cmd_inter_comp_event_bits cmd_inter_comp_event;
	struct mlx5_ifc_pages_req_event_bits pages_req_event;
	struct mlx5_ifc_nic_vport_change_event_bits nic_vport_change_event;
	u8         reserved_0[0xe0];
};

struct mlx5_ifc_health_buffer_bits {
	u8         reserved_0[0x100];

	u8         assert_existptr[0x20];

	u8         assert_callra[0x20];

	u8         reserved_1[0x40];

	u8         fw_version[0x20];

	u8         hw_id[0x20];

	u8         reserved_2[0x20];

	u8         irisc_index[0x8];
	u8         synd[0x8];
	u8         ext_synd[0x10];
};

struct mlx5_ifc_register_loopback_control_bits {
	u8         no_lb[0x1];
	u8         reserved_0[0x7];
	u8         port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x60];
};

struct mlx5_ifc_icmd_set_wol_rol_out_bits {
	u8         reserved_0[0x40];

	u8         reserved_1[0x10];
	u8         rol_mode[0x8];
	u8         wol_mode[0x8];
};

struct mlx5_ifc_icmd_set_wol_rol_in_bits {
	u8         reserved_0[0x40];

	u8         rol_mode_valid[0x1];
	u8         wol_mode_valid[0x1];
	u8         reserved_1[0xe];
	u8         rol_mode[0x8];
	u8         wol_mode[0x8];

	u8         reserved_2[0x7a0];
};

struct mlx5_ifc_icmd_set_virtual_mac_in_bits {
	u8         virtual_mac_en[0x1];
	u8         mac_aux_v[0x1];
	u8         reserved_0[0x1e];

	u8         reserved_1[0x40];

	struct mlx5_ifc_mac_address_layout_bits virtual_mac;

	u8         reserved_2[0x760];
};

struct mlx5_ifc_icmd_query_virtual_mac_out_bits {
	u8         virtual_mac_en[0x1];
	u8         mac_aux_v[0x1];
	u8         reserved_0[0x1e];

	struct mlx5_ifc_mac_address_layout_bits permanent_mac;

	struct mlx5_ifc_mac_address_layout_bits virtual_mac;

	u8         reserved_1[0x760];
};

struct mlx5_ifc_icmd_query_fw_info_out_bits {
	struct mlx5_ifc_fw_version_bits fw_version;

	u8         reserved_0[0x10];
	u8         hash_signature[0x10];

	u8         psid[16][0x8];

	u8         reserved_1[0x6e0];
};

struct mlx5_ifc_icmd_query_cap_in_bits {
	u8         reserved_0[0x10];
	u8         capability_group[0x10];
};

struct mlx5_ifc_icmd_query_cap_general_bits {
	u8         nv_access[0x1];
	u8         fw_info_psid[0x1];
	u8         reserved_0[0x1e];

	u8         reserved_1[0x16];
	u8         rol_s[0x1];
	u8         rol_g[0x1];
	u8         reserved_2[0x1];
	u8         wol_s[0x1];
	u8         wol_g[0x1];
	u8         wol_a[0x1];
	u8         wol_b[0x1];
	u8         wol_m[0x1];
	u8         wol_u[0x1];
	u8         wol_p[0x1];
};

struct mlx5_ifc_icmd_ocbb_query_header_stats_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         reserved_1[0x7e0];
};

struct mlx5_ifc_icmd_ocbb_query_etoc_stats_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         reserved_1[0x7e0];
};

struct mlx5_ifc_icmd_ocbb_init_in_bits {
	u8         address_hi[0x20];

	u8         address_lo[0x20];

	u8         reserved_0[0x7c0];
};

struct mlx5_ifc_icmd_init_ocsd_in_bits {
	u8         reserved_0[0x20];

	u8         address_hi[0x20];

	u8         address_lo[0x20];

	u8         reserved_1[0x7a0];
};

struct mlx5_ifc_icmd_access_reg_out_bits {
	u8         reserved_0[0x11];
	u8         status[0x7];
	u8         reserved_1[0x8];

	u8         register_id[0x10];
	u8         reserved_2[0x10];

	u8         reserved_3[0x40];

	u8         reserved_4[0x5];
	u8         len[0xb];
	u8         reserved_5[0x10];

	u8         register_data[0][0x20];
};

enum {
	MLX5_ICMD_ACCESS_REG_IN_METHOD_QUERY  = 0x1,
	MLX5_ICMD_ACCESS_REG_IN_METHOD_WRITE  = 0x2,
};

struct mlx5_ifc_icmd_access_reg_in_bits {
	u8         constant_1[0x5];
	u8         constant_2[0xb];
	u8         reserved_0[0x10];

	u8         register_id[0x10];
	u8         reserved_1[0x1];
	u8         method[0x7];
	u8         constant_3[0x8];

	u8         reserved_2[0x40];

	u8         constant_4[0x5];
	u8         len[0xb];
	u8         reserved_3[0x10];

	u8         register_data[0][0x20];
};

struct mlx5_ifc_teardown_hca_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_TEARDOWN_HCA_IN_PROFILE_GRACEFUL_CLOSE  = 0x0,
	MLX5_TEARDOWN_HCA_IN_PROFILE_PANIC_CLOSE     = 0x1,
};

struct mlx5_ifc_teardown_hca_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         profile[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_suspend_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_suspend_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_sqerr2rts_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_sqerr2rts_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_sqd2rts_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_sqd2rts_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_snapshot_cap_bits {
	u8         reserved_0[0x1d];
	u8         suspend_qp_uc[0x1];
	u8         suspend_qp_ud[0x1];
	u8         suspend_qp_rc[0x1];

	u8         reserved_1[0x1c];
	u8         restore_pd[0x1];
	u8         restore_uar[0x1];
	u8         restore_mkey[0x1];
	u8         restore_qp[0x1];

	u8         reserved_2[0x1e];
	u8         named_mkey[0x1];
	u8         named_qp[0x1];

	u8         reserved_3[0x7a0];
};

struct mlx5_ifc_set_wol_rol_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_wol_rol_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         rol_mode_valid[0x1];
	u8         wol_mode_valid[0x1];
	u8         reserved_2[0xe];
	u8         rol_mode[0x8];
	u8         wol_mode[0x8];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_set_roce_address_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_roce_address_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         roce_address_index[0x10];
	u8         reserved_2[0x10];

	u8         reserved_3[0x20];

	struct mlx5_ifc_roce_addr_layout_bits roce_address;
};

struct mlx5_ifc_set_rdb_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_rdb_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x18];
	u8         rdb_list_size[0x8];

	struct mlx5_ifc_rdbc_bits rdb_context[0];
};

struct mlx5_ifc_set_mad_demux_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_SET_MAD_DEMUX_IN_DEMUX_MODE_PASS_ALL   = 0x0,
	MLX5_SET_MAD_DEMUX_IN_DEMUX_MODE_SELECTIVE  = 0x2,
};

struct mlx5_ifc_set_mad_demux_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x20];

	u8         reserved_3[0x6];
	u8         demux_mode[0x2];
	u8         reserved_4[0x18];
};

struct mlx5_ifc_set_l2_table_entry_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_l2_table_entry_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x60];

	u8         reserved_3[0x8];
	u8         table_index[0x18];

	u8         reserved_4[0x20];

	u8         reserved_5[0x13];
	u8         vlan_valid[0x1];
	u8         vlan[0xc];

	struct mlx5_ifc_mac_address_layout_bits mac_address;

	u8         reserved_6[0xc0];
};

struct mlx5_ifc_set_issi_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_issi_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         current_issi[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_set_hca_cap_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_hca_cap_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	union mlx5_ifc_hca_cap_union_bits capability;
};

struct mlx5_ifc_set_flow_table_root_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_flow_table_root_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x140];
};

struct mlx5_ifc_set_fte_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_fte_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x18];
	u8         modify_enable_mask[0x8];

	u8         reserved_7[0x20];

	u8         flow_index[0x20];

	u8         reserved_8[0xe0];

	struct mlx5_ifc_flow_context_bits flow_context;
};

struct mlx5_ifc_set_driver_version_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_driver_version_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	u8         driver_version[64][0x8];
};

struct mlx5_ifc_set_dc_cnak_trace_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_dc_cnak_trace_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         enable[0x1];
	u8         reserved_2[0x1f];

	u8         reserved_3[0x160];

	struct mlx5_ifc_cmd_pas_bits pas;
};

struct mlx5_ifc_set_burst_size_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_set_burst_size_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x20];

	u8         reserved_3[0x9];
	u8         device_burst_size[0x17];
};

struct mlx5_ifc_rts2rts_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_rts2rts_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_rtr2rts_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_rtr2rts_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_rst2init_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_rst2init_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_resume_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_resume_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_xrc_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_xrc_srqc_bits xrc_srq_context_entry;

	u8         reserved_2[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_query_xrc_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         xrc_srqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_wol_rol_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x10];
	u8         rol_mode[0x8];
	u8         wol_mode[0x8];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_query_wol_rol_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

enum {
	MLX5_QUERY_VPORT_STATE_OUT_STATE_DOWN  = 0x0,
	MLX5_QUERY_VPORT_STATE_OUT_STATE_UP    = 0x1,
};

struct mlx5_ifc_query_vport_state_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];

	u8         reserved_2[0x18];
	u8         admin_state[0x4];
	u8         state[0x4];
};

enum {
	MLX5_QUERY_VPORT_STATE_IN_OP_MOD_VNIC_VPORT  = 0x0,
	MLX5_QUERY_VPORT_STATE_IN_OP_MOD_ESW_VPORT   = 0x1,
	MLX5_QUERY_VPORT_STATE_IN_OP_MOD_UPLINK      = 0x2,
};

struct mlx5_ifc_query_vport_state_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_vport_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_traffic_counter_bits received_errors;

	struct mlx5_ifc_traffic_counter_bits transmit_errors;

	struct mlx5_ifc_traffic_counter_bits received_ib_unicast;

	struct mlx5_ifc_traffic_counter_bits transmitted_ib_unicast;

	struct mlx5_ifc_traffic_counter_bits received_ib_multicast;

	struct mlx5_ifc_traffic_counter_bits transmitted_ib_multicast;

	struct mlx5_ifc_traffic_counter_bits received_eth_broadcast;

	struct mlx5_ifc_traffic_counter_bits transmitted_eth_broadcast;

	struct mlx5_ifc_traffic_counter_bits received_eth_unicast;

	struct mlx5_ifc_traffic_counter_bits transmitted_eth_unicast;

	struct mlx5_ifc_traffic_counter_bits received_eth_multicast;

	struct mlx5_ifc_traffic_counter_bits transmitted_eth_multicast;

	u8         reserved_2[0xa00];
};

enum {
	MLX5_QUERY_VPORT_COUNTER_IN_OP_MOD_VPORT_COUNTERS  = 0x0,
};

struct mlx5_ifc_query_vport_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xb];
	u8         port_num[0x4];
	u8         vport_number[0x10];

	u8         reserved_3[0x60];

	u8         clear[0x1];
	u8         reserved_4[0x1f];

	u8         reserved_5[0x20];
};

struct mlx5_ifc_query_tis_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_tisc_bits tis_context;
};

struct mlx5_ifc_query_tis_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         tisn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_tir_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xc0];

	struct mlx5_ifc_tirc_bits tir_context;
};

struct mlx5_ifc_query_tir_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         tirn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_srqc_bits srq_context_entry;

	u8         reserved_2[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_query_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         srqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_sq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xc0];

	struct mlx5_ifc_sqc_bits sq_context;
};

struct mlx5_ifc_query_sq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         sqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_special_contexts_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];

	u8         resd_lkey[0x20];
};

struct mlx5_ifc_query_special_contexts_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_query_rqt_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xc0];

	struct mlx5_ifc_rqtc_bits rqt_context;
};

struct mlx5_ifc_query_rqt_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rqtn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_rq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xc0];

	struct mlx5_ifc_rqc_bits rq_context;
};

struct mlx5_ifc_query_rq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_roce_address_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_roce_addr_layout_bits roce_address;
};

struct mlx5_ifc_query_roce_address_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         roce_address_index[0x10];
	u8         reserved_2[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_rmp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xc0];

	struct mlx5_ifc_rmpc_bits rmp_context;
};

struct mlx5_ifc_query_rmp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rmpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_rdb_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];

	u8         reserved_2[0x18];
	u8         rdb_list_size[0x8];

	struct mlx5_ifc_rdbc_bits rdb_context[0];
};

struct mlx5_ifc_query_rdb_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         opt_param_mask[0x20];

	u8         reserved_2[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_3[0x80];

	u8         pas[0][0x40];
};

struct mlx5_ifc_query_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_q_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         rx_write_requests[0x20];

	u8         reserved_2[0x20];

	u8         rx_read_requests[0x20];

	u8         reserved_3[0x20];

	u8         rx_atomic_requests[0x20];

	u8         reserved_4[0x20];

	u8         rx_dct_connect[0x20];

	u8         reserved_5[0x20];

	u8         out_of_buffer[0x20];

	u8         reserved_6[0x20];

	u8         out_of_sequence[0x20];

	u8         reserved_7[0x620];
};

struct mlx5_ifc_query_q_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x80];

	u8         clear[0x1];
	u8         reserved_3[0x1f];

	u8         reserved_4[0x18];
	u8         counter_set_id[0x8];
};

struct mlx5_ifc_query_pages_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x10];
	u8         function_id[0x10];

	u8         num_pages[0x20];
};

enum {
	MLX5_BOOT_PAGES                           = 0x1,
	MLX5_INIT_PAGES                           = 0x2,
	MLX5_POST_INIT_PAGES                      = 0x3,
};

struct mlx5_ifc_query_pages_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         function_id[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_nic_vport_context_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_nic_vport_context_bits nic_vport_context;
};

struct mlx5_ifc_query_nic_vport_context_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x5];
	u8         allowed_list_type[0x3];
	u8         reserved_4[0x18];
};

struct mlx5_ifc_query_mkey_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_mkc_bits memory_key_mkey_entry;

	u8         reserved_2[0x600];

	u8         bsf0_klm0_pas_mtt0_1[16][0x8];

	u8         bsf1_klm1_pas_mtt2_3[16][0x8];
};

struct mlx5_ifc_query_mkey_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         mkey_index[0x18];

	u8         pg_access[0x1];
	u8         reserved_3[0x1f];
};

struct mlx5_ifc_query_mad_demux_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         mad_dumux_parameters_block[0x20];
};

struct mlx5_ifc_query_mad_demux_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_query_l2_table_entry_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xa0];

	u8         reserved_2[0x13];
	u8         vlan_valid[0x1];
	u8         vlan[0xc];

	struct mlx5_ifc_mac_address_layout_bits mac_address;

	u8         reserved_3[0xc0];
};

struct mlx5_ifc_query_l2_table_entry_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x60];

	u8         reserved_3[0x8];
	u8         table_index[0x18];

	u8         reserved_4[0x140];
};

struct mlx5_ifc_query_issi_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x10];
	u8         current_issi[0x10];

	u8         reserved_2[0xa0];

	u8         supported_issi_reserved[76][0x8];
	u8         supported_issi_dw0[0x20];
};

struct mlx5_ifc_query_issi_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_query_hca_vport_pkey_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_pkey_bits pkey[0];
};

struct mlx5_ifc_query_hca_vport_pkey_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xb];
	u8         port_num[0x4];
	u8         vport_number[0x10];

	u8         reserved_3[0x10];
	u8         pkey_index[0x10];
};

struct mlx5_ifc_query_hca_vport_gid_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];

	u8         gids_num[0x10];
	u8         reserved_2[0x10];

	struct mlx5_ifc_array128_auto_bits gid[0];
};

struct mlx5_ifc_query_hca_vport_gid_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xb];
	u8         port_num[0x4];
	u8         vport_number[0x10];

	u8         reserved_3[0x10];
	u8         gid_index[0x10];
};

struct mlx5_ifc_query_hca_vport_context_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_hca_vport_context_bits hca_vport_context;
};

struct mlx5_ifc_query_hca_vport_context_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xb];
	u8         port_num[0x4];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_hca_cap_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	union mlx5_ifc_hca_cap_union_bits capability;
};

struct mlx5_ifc_query_hca_cap_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_query_flow_table_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x80];

	u8         reserved_2[0x8];
	u8         level[0x8];
	u8         reserved_3[0x8];
	u8         log_size[0x8];

	u8         reserved_4[0x120];
};

struct mlx5_ifc_query_flow_table_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x140];
};

struct mlx5_ifc_query_fte_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x1c0];

	struct mlx5_ifc_flow_context_bits flow_context;
};

struct mlx5_ifc_query_fte_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x40];

	u8         flow_index[0x20];

	u8         reserved_7[0xe0];
};

enum {
	MLX5_QUERY_FLOW_GROUP_OUT_MATCH_CRITERIA_ENABLE_OUTER_HEADERS    = 0x0,
	MLX5_QUERY_FLOW_GROUP_OUT_MATCH_CRITERIA_ENABLE_MISC_PARAMETERS  = 0x1,
	MLX5_QUERY_FLOW_GROUP_OUT_MATCH_CRITERIA_ENABLE_INNER_HEADERS    = 0x2,
};

struct mlx5_ifc_query_flow_group_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0xa0];

	u8         start_flow_index[0x20];

	u8         reserved_2[0x20];

	u8         end_flow_index[0x20];

	u8         reserved_3[0xa0];

	u8         reserved_4[0x18];
	u8         match_criteria_enable[0x8];

	struct mlx5_ifc_fte_match_param_bits match_criteria;

	u8         reserved_5[0xe00];
};

struct mlx5_ifc_query_flow_group_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         group_id[0x20];

	u8         reserved_6[0x120];
};

struct mlx5_ifc_query_flow_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_traffic_counter_bits flow_statistics;

	u8         reserved_2[0x700];
};

struct mlx5_ifc_query_flow_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x80];

	u8         clear[0x1];
	u8         reserved_3[0x1f];

	u8         reserved_4[0x10];
	u8         flow_counter_id[0x10];
};

struct mlx5_ifc_query_esw_vport_context_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_esw_vport_context_bits esw_vport_context;
};

struct mlx5_ifc_query_esw_vport_context_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_eq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_eqc_bits eq_context_entry;

	u8         reserved_2[0x40];

	u8         event_bitmask[0x40];

	u8         reserved_3[0x580];

	u8         pas[0][0x40];
};

struct mlx5_ifc_query_eq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x18];
	u8         eq_number[0x8];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_dct_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_dctc_bits dct_context_entry;

	u8         reserved_2[0x180];
};

struct mlx5_ifc_query_dct_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         dctn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_dc_cnak_trace_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         enable[0x1];
	u8         reserved_1[0x1f];

	u8         reserved_2[0x160];

	struct mlx5_ifc_cmd_pas_bits pas;
};

struct mlx5_ifc_query_dc_cnak_trace_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_query_cq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_cqc_bits cq_context;

	u8         reserved_2[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_query_cq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         cqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_cong_status_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];

	u8         enable[0x1];
	u8         tag_enable[0x1];
	u8         reserved_2[0x1e];
};

struct mlx5_ifc_query_cong_status_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x18];
	u8         priority[0x4];
	u8         cong_protocol[0x4];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_cong_statistics_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         cur_flows[0x20];

	u8         sum_flows[0x20];

	u8         cnp_ignored_high[0x20];

	u8         cnp_ignored_low[0x20];

	u8         cnp_handled_high[0x20];

	u8         cnp_handled_low[0x20];

	u8         reserved_2[0x100];

	u8         time_stamp_high[0x20];

	u8         time_stamp_low[0x20];

	u8         accumulators_period[0x20];

	u8         ecn_marked_roce_packets_high[0x20];

	u8         ecn_marked_roce_packets_low[0x20];

	u8         cnps_sent_high[0x20];

	u8         cnps_sent_low[0x20];

	u8         reserved_3[0x560];
};

struct mlx5_ifc_query_cong_statistics_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         clear[0x1];
	u8         reserved_2[0x1f];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_cong_params_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	union mlx5_ifc_cong_control_roce_ecn_auto_bits congestion_parameters;
};

struct mlx5_ifc_query_cong_params_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x1c];
	u8         cong_protocol[0x4];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_query_burst_size_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];

	u8         reserved_2[0x9];
	u8         device_burst_size[0x17];
};

struct mlx5_ifc_query_burst_size_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_query_adapter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	struct mlx5_ifc_query_adapter_param_block_bits query_adapter_struct;
};

struct mlx5_ifc_query_adapter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_qp_2rst_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_qp_2rst_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_qp_2err_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_qp_2err_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_page_fault_resume_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_page_fault_resume_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         error[0x1];
	u8         reserved_2[0x4];
	u8         rdma[0x1];
	u8         read_write[0x1];
	u8         req_res[0x1];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_nop_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_nop_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_modify_vport_state_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_MODIFY_VPORT_STATE_IN_OP_MOD_NIC_VPORT  = 0x0,
	MLX5_MODIFY_VPORT_STATE_IN_OP_MOD_ESW_VPORT  = 0x1,
	MLX5_MODIFY_VPORT_STATE_IN_OP_MOD_UPLINK     = 0x2,
};

enum {
	MLX5_MODIFY_VPORT_STATE_IN_ADMIN_STATE_DOWN    = 0x0,
	MLX5_MODIFY_VPORT_STATE_IN_ADMIN_STATE_UP      = 0x1,
	MLX5_MODIFY_VPORT_STATE_IN_ADMIN_STATE_FOLLOW  = 0x2,
};

struct mlx5_ifc_modify_vport_state_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x18];
	u8         admin_state[0x4];
	u8         reserved_4[0x4];
};

struct mlx5_ifc_modify_tis_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_tis_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         tisn[0x18];

	u8         reserved_3[0x20];

	u8         modify_bitmask[0x40];

	u8         reserved_4[0x40];

	struct mlx5_ifc_tisc_bits ctx;
};

struct mlx5_ifc_modify_tir_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_tir_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         tirn[0x18];

	u8         reserved_3[0x20];

	u8         modify_bitmask[0x40];

	u8         reserved_4[0x40];

	struct mlx5_ifc_tirc_bits tir_context;
};

struct mlx5_ifc_modify_sq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_sq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         sq_state[0x4];
	u8         reserved_2[0x4];
	u8         sqn[0x18];

	u8         reserved_3[0x20];

	u8         modify_bitmask[0x40];

	u8         reserved_4[0x40];

	struct mlx5_ifc_sqc_bits ctx;
};

struct mlx5_ifc_modify_rqt_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_rqt_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rqtn[0x18];

	u8         reserved_3[0x20];

	u8         modify_bitmask[0x40];

	u8         reserved_4[0x40];

	struct mlx5_ifc_rqtc_bits ctx;
};

struct mlx5_ifc_modify_rq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_rq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         rq_state[0x4];
	u8         reserved_2[0x4];
	u8         rqn[0x18];

	u8         reserved_3[0x20];

	u8         modify_bitmask[0x40];

	u8         reserved_4[0x40];

	struct mlx5_ifc_rqc_bits ctx;
};

struct mlx5_ifc_modify_rmp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_rmp_bitmask_bits {
	u8	   reserved[0x20];

	u8         reserved1[0x1f];
	u8         lwm[0x1];
};

struct mlx5_ifc_modify_rmp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         rmp_state[0x4];
	u8         reserved_2[0x4];
	u8         rmpn[0x18];

	u8         reserved_3[0x20];

	struct mlx5_ifc_rmp_bitmask_bits bitmask;

	u8         reserved_4[0x40];

	struct mlx5_ifc_rmpc_bits ctx;
};

struct mlx5_ifc_modify_nic_vport_context_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_nic_vport_field_select_bits {
	u8         reserved_0[0x18];
	u8         min_wqe_inline_mode[0x1];
	u8         mtu[0x1];
	u8         change_event[0x1];
	u8         promisc[0x1];
	u8         permanent_address[0x1];
	u8         addresses_list[0x1];
	u8         roce_en[0x1];
	u8         reserved_1[0x1];
};

struct mlx5_ifc_modify_nic_vport_context_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	struct mlx5_ifc_modify_nic_vport_field_select_bits field_select;

	u8         reserved_3[0x780];

	struct mlx5_ifc_nic_vport_context_bits nic_vport_context;
};

struct mlx5_ifc_modify_hca_vport_context_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_hca_vport_context_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xb];
	u8         port_num[0x4];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	struct mlx5_ifc_hca_vport_context_bits hca_vport_context;
};

struct mlx5_ifc_modify_esw_vport_context_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_esw_vport_context_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         field_select[0x20];

	struct mlx5_ifc_esw_vport_context_bits esw_vport_context;
};

struct mlx5_ifc_modify_cq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_MODIFY_CQ_IN_OP_MOD_MODIFY_CQ  = 0x0,
	MLX5_MODIFY_CQ_IN_OP_MOD_RESIZE_CQ  = 0x1,
};

struct mlx5_ifc_modify_cq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         cqn[0x18];

	union mlx5_ifc_modify_field_select_resize_field_select_auto_bits modify_field_select_resize_field_select;

	struct mlx5_ifc_cqc_bits cq_context;

	u8         reserved_3[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_modify_cong_status_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_cong_status_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x18];
	u8         priority[0x4];
	u8         cong_protocol[0x4];

	u8         enable[0x1];
	u8         tag_enable[0x1];
	u8         reserved_3[0x1e];
};

struct mlx5_ifc_modify_cong_params_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_modify_cong_params_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x1c];
	u8         cong_protocol[0x4];

	union mlx5_ifc_field_select_802_1_r_roce_auto_bits field_select;

	u8         reserved_3[0x80];

	union mlx5_ifc_cong_control_roce_ecn_auto_bits congestion_parameters;
};

struct mlx5_ifc_manage_pages_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         output_num_entries[0x20];

	u8         reserved_1[0x20];

	u8         pas[0][0x40];
};

enum {
	MLX5_PAGES_CANT_GIVE                            = 0x0,
	MLX5_PAGES_GIVE                                 = 0x1,
	MLX5_PAGES_TAKE                                 = 0x2,
};

struct mlx5_ifc_manage_pages_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         function_id[0x10];

	u8         input_num_entries[0x20];

	u8         pas[0][0x40];
};

struct mlx5_ifc_mad_ifc_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         response_mad_packet[256][0x8];
};

struct mlx5_ifc_mad_ifc_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         remote_lid[0x10];
	u8         reserved_2[0x8];
	u8         port[0x8];

	u8         reserved_3[0x20];

	u8         mad[256][0x8];
};

struct mlx5_ifc_init_hca_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_INIT_HCA_IN_OP_MOD_INIT      = 0x0,
	MLX5_INIT_HCA_IN_OP_MOD_PRE_INIT  = 0x1,
};

struct mlx5_ifc_init_hca_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_init2rtr_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_init2rtr_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_init2init_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_init2init_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         opt_param_mask[0x20];

	u8         reserved_4[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_5[0x80];
};

struct mlx5_ifc_get_dropped_packet_log_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         packet_headers_log[128][0x8];

	u8         packet_syndrome[64][0x8];
};

struct mlx5_ifc_get_dropped_packet_log_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_gen_eqe_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x18];
	u8         eq_number[0x8];

	u8         reserved_3[0x20];

	u8         eqe[64][0x8];
};

struct mlx5_ifc_gen_eq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_enable_hca_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];
};

struct mlx5_ifc_enable_hca_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         function_id[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_drain_dct_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_drain_dct_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         dctn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_disable_hca_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x20];
};

struct mlx5_ifc_disable_hca_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         function_id[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_detach_from_mcg_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_detach_from_mcg_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         multicast_gid[16][0x8];
};

struct mlx5_ifc_destroy_xrc_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_xrc_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         xrc_srqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_tis_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_tis_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         tisn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_tir_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_tir_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         tirn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         srqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_sq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_sq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         sqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_rqt_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_rqt_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rqtn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_rq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_rq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_rmp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_rmp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         rmpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_psv_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_psv_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         psvn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_mkey_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_mkey_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         mkey_index[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_flow_table_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_flow_table_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x140];
};

struct mlx5_ifc_destroy_flow_group_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_flow_group_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         group_id[0x20];

	u8         reserved_6[0x120];
};

struct mlx5_ifc_destroy_eq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_eq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x18];
	u8         eq_number[0x8];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_dct_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_dct_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         dctn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_destroy_cq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_destroy_cq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         cqn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_delete_vxlan_udp_dport_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_delete_vxlan_udp_dport_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x20];

	u8         reserved_3[0x10];
	u8         vxlan_udp_port[0x10];
};

struct mlx5_ifc_delete_l2_table_entry_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_delete_l2_table_entry_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x60];

	u8         reserved_3[0x8];
	u8         table_index[0x18];

	u8         reserved_4[0x140];
};

struct mlx5_ifc_delete_fte_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_delete_fte_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x40];

	u8         flow_index[0x20];

	u8         reserved_7[0xe0];
};

struct mlx5_ifc_dealloc_xrcd_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_dealloc_xrcd_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         xrcd[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_dealloc_uar_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_dealloc_uar_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         uar[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_dealloc_transport_domain_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_dealloc_transport_domain_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         transport_domain[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_dealloc_q_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_dealloc_q_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x18];
	u8         counter_set_id[0x8];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_dealloc_pd_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_dealloc_pd_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         pd[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_dealloc_flow_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_dealloc_flow_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         flow_counter_id[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_deactivate_tracer_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_deactivate_tracer_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         mkey[0x20];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_xrc_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         xrc_srqn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_xrc_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	struct mlx5_ifc_xrc_srqc_bits xrc_srq_context_entry;

	u8         reserved_3[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_create_tis_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         tisn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_tis_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0xc0];

	struct mlx5_ifc_tisc_bits ctx;
};

struct mlx5_ifc_create_tir_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         tirn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_tir_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0xc0];

	struct mlx5_ifc_tirc_bits tir_context;
};

struct mlx5_ifc_create_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         srqn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	struct mlx5_ifc_srqc_bits srq_context_entry;

	u8         reserved_3[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_create_sq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         sqn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_sq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0xc0];

	struct mlx5_ifc_sqc_bits ctx;
};

struct mlx5_ifc_create_rqt_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         rqtn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_rqt_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0xc0];

	struct mlx5_ifc_rqtc_bits rqt_context;
};

struct mlx5_ifc_create_rq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         rqn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_rq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0xc0];

	struct mlx5_ifc_rqc_bits ctx;
};

struct mlx5_ifc_create_rmp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         rmpn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_rmp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0xc0];

	struct mlx5_ifc_rmpc_bits ctx;
};

struct mlx5_ifc_create_qp_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         qpn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_qp_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	u8         opt_param_mask[0x20];

	u8         reserved_3[0x20];

	struct mlx5_ifc_qpc_bits qpc;

	u8         reserved_4[0x80];

	u8         pas[0][0x40];
};

struct mlx5_ifc_create_psv_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         reserved_2[0x8];
	u8         psv0_index[0x18];

	u8         reserved_3[0x8];
	u8         psv1_index[0x18];

	u8         reserved_4[0x8];
	u8         psv2_index[0x18];

	u8         reserved_5[0x8];
	u8         psv3_index[0x18];
};

struct mlx5_ifc_create_psv_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         num_psv[0x4];
	u8         reserved_2[0x4];
	u8         pd[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_create_mkey_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         mkey_index[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_mkey_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x20];

	u8         pg_access[0x1];
	u8         reserved_3[0x1f];

	struct mlx5_ifc_mkc_bits memory_key_mkey_entry;

	u8         reserved_4[0x80];

	u8         translations_octword_actual_size[0x20];

	u8         reserved_5[0x560];

	u8         klm_pas_mtt[0][0x20];
};

struct mlx5_ifc_create_flow_table_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         table_id[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_flow_table_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x20];

	u8         reserved_6[0x8];
	u8         level[0x8];
	u8         reserved_7[0x8];
	u8         log_size[0x8];

	u8         reserved_8[0x120];
};

struct mlx5_ifc_create_flow_group_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         group_id[0x18];

	u8         reserved_2[0x20];
};

enum {
	MLX5_CREATE_FLOW_GROUP_IN_MATCH_CRITERIA_ENABLE_OUTER_HEADERS    = 0x0,
	MLX5_CREATE_FLOW_GROUP_IN_MATCH_CRITERIA_ENABLE_MISC_PARAMETERS  = 0x1,
	MLX5_CREATE_FLOW_GROUP_IN_MATCH_CRITERIA_ENABLE_INNER_HEADERS    = 0x2,
};

struct mlx5_ifc_create_flow_group_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         other_vport[0x1];
	u8         reserved_2[0xf];
	u8         vport_number[0x10];

	u8         reserved_3[0x20];

	u8         table_type[0x8];
	u8         reserved_4[0x18];

	u8         reserved_5[0x8];
	u8         table_id[0x18];

	u8         reserved_6[0x20];

	u8         start_flow_index[0x20];

	u8         reserved_7[0x20];

	u8         end_flow_index[0x20];

	u8         reserved_8[0xa0];

	u8         reserved_9[0x18];
	u8         match_criteria_enable[0x8];

	struct mlx5_ifc_fte_match_param_bits match_criteria;

	u8         reserved_10[0xe00];
};

struct mlx5_ifc_create_eq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x18];
	u8         eq_number[0x8];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_eq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	struct mlx5_ifc_eqc_bits eq_context_entry;

	u8         reserved_3[0x40];

	u8         event_bitmask[0x40];

	u8         reserved_4[0x580];

	u8         pas[0][0x40];
};

struct mlx5_ifc_create_dct_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         dctn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_dct_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	struct mlx5_ifc_dctc_bits dct_context_entry;

	u8         reserved_3[0x180];
};

struct mlx5_ifc_create_cq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         cqn[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_create_cq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];

	struct mlx5_ifc_cqc_bits cq_context;

	u8         reserved_3[0x600];

	u8         pas[0][0x40];
};

struct mlx5_ifc_config_int_moderation_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x4];
	u8         min_delay[0xc];
	u8         int_vector[0x10];

	u8         reserved_2[0x20];
};

enum {
	MLX5_CONFIG_INT_MODERATION_IN_OP_MOD_WRITE  = 0x0,
	MLX5_CONFIG_INT_MODERATION_IN_OP_MOD_READ   = 0x1,
};

struct mlx5_ifc_config_int_moderation_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x4];
	u8         min_delay[0xc];
	u8         int_vector[0x10];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_attach_to_mcg_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_attach_to_mcg_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         qpn[0x18];

	u8         reserved_3[0x20];

	u8         multicast_gid[16][0x8];
};

struct mlx5_ifc_arm_xrc_srq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_ARM_XRC_SRQ_IN_OP_MOD_XRC_SRQ  = 0x1,
};

struct mlx5_ifc_arm_xrc_srq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         xrc_srqn[0x18];

	u8         reserved_3[0x10];
	u8         lwm[0x10];
};

struct mlx5_ifc_arm_rq_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

enum {
	MLX5_ARM_RQ_IN_OP_MOD_SRQ  = 0x1,
};

struct mlx5_ifc_arm_rq_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         srq_number[0x18];

	u8         reserved_3[0x10];
	u8         lwm[0x10];
};

struct mlx5_ifc_arm_dct_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_arm_dct_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x8];
	u8         dctn[0x18];

	u8         reserved_3[0x20];
};

struct mlx5_ifc_alloc_xrcd_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         xrcd[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_alloc_xrcd_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_alloc_uar_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         uar[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_alloc_uar_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_alloc_transport_domain_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         transport_domain[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_alloc_transport_domain_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_alloc_q_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x18];
	u8         counter_set_id[0x8];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_alloc_q_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_alloc_pd_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x8];
	u8         pd[0x18];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_alloc_pd_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_alloc_flow_counter_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x10];
	u8         flow_counter_id[0x10];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_alloc_flow_counter_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_add_vxlan_udp_dport_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_add_vxlan_udp_dport_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x20];

	u8         reserved_3[0x10];
	u8         vxlan_udp_port[0x10];
};

struct mlx5_ifc_activate_tracer_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];
};

struct mlx5_ifc_activate_tracer_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         mkey[0x20];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_access_register_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         reserved_1[0x40];

	u8         register_data[0][0x20];
};

enum {
	MLX5_ACCESS_REGISTER_IN_OP_MOD_WRITE  = 0x0,
	MLX5_ACCESS_REGISTER_IN_OP_MOD_READ   = 0x1,
};

struct mlx5_ifc_access_register_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         reserved_2[0x10];
	u8         register_id[0x10];

	u8         argument[0x20];

	u8         register_data[0][0x20];
};

struct mlx5_ifc_sltp_reg_bits {
	u8         status[0x4];
	u8         version[0x4];
	u8         local_port[0x8];
	u8         pnat[0x2];
	u8         reserved_0[0x2];
	u8         lane[0x4];
	u8         reserved_1[0x8];

	u8         reserved_2[0x20];

	u8         reserved_3[0x7];
	u8         polarity[0x1];
	u8         ob_tap0[0x8];
	u8         ob_tap1[0x8];
	u8         ob_tap2[0x8];

	u8         reserved_4[0xc];
	u8         ob_preemp_mode[0x4];
	u8         ob_reg[0x8];
	u8         ob_bias[0x8];

	u8         reserved_5[0x20];
};

struct mlx5_ifc_slrp_reg_bits {
	u8         status[0x4];
	u8         version[0x4];
	u8         local_port[0x8];
	u8         pnat[0x2];
	u8         reserved_0[0x2];
	u8         lane[0x4];
	u8         reserved_1[0x8];

	u8         ib_sel[0x2];
	u8         reserved_2[0x11];
	u8         dp_sel[0x1];
	u8         dp90sel[0x4];
	u8         mix90phase[0x8];

	u8         ffe_tap0[0x8];
	u8         ffe_tap1[0x8];
	u8         ffe_tap2[0x8];
	u8         ffe_tap3[0x8];

	u8         ffe_tap4[0x8];
	u8         ffe_tap5[0x8];
	u8         ffe_tap6[0x8];
	u8         ffe_tap7[0x8];

	u8         ffe_tap8[0x8];
	u8         mixerbias_tap_amp[0x8];
	u8         reserved_3[0x7];
	u8         ffe_tap_en[0x9];

	u8         ffe_tap_offset0[0x8];
	u8         ffe_tap_offset1[0x8];
	u8         slicer_offset0[0x10];

	u8         mixer_offset0[0x10];
	u8         mixer_offset1[0x10];

	u8         mixerbgn_inp[0x8];
	u8         mixerbgn_inn[0x8];
	u8         mixerbgn_refp[0x8];
	u8         mixerbgn_refn[0x8];

	u8         sel_slicer_lctrl_h[0x1];
	u8         sel_slicer_lctrl_l[0x1];
	u8         reserved_4[0x1];
	u8         ref_mixer_vreg[0x5];
	u8         slicer_gctrl[0x8];
	u8         lctrl_input[0x8];
	u8         mixer_offset_cm1[0x8];

	u8         common_mode[0x6];
	u8         reserved_5[0x1];
	u8         mixer_offset_cm0[0x9];
	u8         reserved_6[0x7];
	u8         slicer_offset_cm[0x9];
};

struct mlx5_ifc_slrg_reg_bits {
	u8         status[0x4];
	u8         version[0x4];
	u8         local_port[0x8];
	u8         pnat[0x2];
	u8         reserved_0[0x2];
	u8         lane[0x4];
	u8         reserved_1[0x8];

	u8         time_to_link_up[0x10];
	u8         reserved_2[0xc];
	u8         grade_lane_speed[0x4];

	u8         grade_version[0x8];
	u8         grade[0x18];

	u8         reserved_3[0x4];
	u8         height_grade_type[0x4];
	u8         height_grade[0x18];

	u8         height_dz[0x10];
	u8         height_dv[0x10];

	u8         reserved_4[0x10];
	u8         height_sigma[0x10];

	u8         reserved_5[0x20];

	u8         reserved_6[0x4];
	u8         phase_grade_type[0x4];
	u8         phase_grade[0x18];

	u8         reserved_7[0x8];
	u8         phase_eo_pos[0x8];
	u8         reserved_8[0x8];
	u8         phase_eo_neg[0x8];

	u8         ffe_set_tested[0x10];
	u8         test_errors_per_lane[0x10];
};

struct mlx5_ifc_pvlc_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x1c];
	u8         vl_hw_cap[0x4];

	u8         reserved_3[0x1c];
	u8         vl_admin[0x4];

	u8         reserved_4[0x1c];
	u8         vl_operational[0x4];
};

struct mlx5_ifc_pude_reg_bits {
	u8         swid[0x8];
	u8         local_port[0x8];
	u8         reserved_0[0x4];
	u8         admin_status[0x4];
	u8         reserved_1[0x4];
	u8         oper_status[0x4];

	u8         reserved_2[0x60];
};

enum {
	MLX5_PTYS_REG_PROTO_MASK_INFINIBAND  = 0x1,
	MLX5_PTYS_REG_PROTO_MASK_ETHERNET    = 0x4,
};

struct mlx5_ifc_ptys_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0xd];
	u8         proto_mask[0x3];

	u8         reserved_2[0x40];

	u8         eth_proto_capability[0x20];

	u8         ib_link_width_capability[0x10];
	u8         ib_proto_capability[0x10];

	u8         reserved_3[0x20];

	u8         eth_proto_admin[0x20];

	u8         ib_link_width_admin[0x10];
	u8         ib_proto_admin[0x10];

	u8         reserved_4[0x20];

	u8         eth_proto_oper[0x20];

	u8         ib_link_width_oper[0x10];
	u8         ib_proto_oper[0x10];

	u8         reserved_5[0x20];

	u8         eth_proto_lp_advertise[0x20];

	u8         reserved_6[0x60];
};

struct mlx5_ifc_ptas_reg_bits {
	u8         reserved_0[0x20];

	u8         algorithm_options[0x10];
	u8         reserved_1[0x4];
	u8         repetitions_mode[0x4];
	u8         num_of_repetitions[0x8];

	u8         grade_version[0x8];
	u8         height_grade_type[0x4];
	u8         phase_grade_type[0x4];
	u8         height_grade_weight[0x8];
	u8         phase_grade_weight[0x8];

	u8         gisim_measure_bits[0x10];
	u8         adaptive_tap_measure_bits[0x10];

	u8         ber_bath_high_error_threshold[0x10];
	u8         ber_bath_mid_error_threshold[0x10];

	u8         ber_bath_low_error_threshold[0x10];
	u8         one_ratio_high_threshold[0x10];

	u8         one_ratio_high_mid_threshold[0x10];
	u8         one_ratio_low_mid_threshold[0x10];

	u8         one_ratio_low_threshold[0x10];
	u8         ndeo_error_threshold[0x10];

	u8         mixer_offset_step_size[0x10];
	u8         reserved_2[0x8];
	u8         mix90_phase_for_voltage_bath[0x8];

	u8         mixer_offset_start[0x10];
	u8         mixer_offset_end[0x10];

	u8         reserved_3[0x15];
	u8         ber_test_time[0xb];
};

struct mlx5_ifc_pspa_reg_bits {
	u8         swid[0x8];
	u8         local_port[0x8];
	u8         sub_port[0x8];
	u8         reserved_0[0x8];

	u8         reserved_1[0x20];
};

struct mlx5_ifc_ppsc_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x60];

	u8         reserved_3[0x1c];
	u8         wrps_admin[0x4];

	u8         reserved_4[0x1c];
	u8         wrps_status[0x4];

	u8         up_th_vld[0x1];
	u8         down_th_vld[0x1];
	u8         reserved_5[0x6];
	u8         up_threshold[0x8];
	u8         reserved_6[0x8];
	u8         down_threshold[0x8];

	u8         reserved_7[0x20];

	u8         reserved_8[0x1c];
	u8         srps_admin[0x4];

	u8         reserved_9[0x60];
};

struct mlx5_ifc_pplr_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x8];
	u8         lb_cap[0x8];
	u8         reserved_3[0x8];
	u8         lb_en[0x8];
};

struct mlx5_ifc_pplm_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x20];

	u8         port_profile_mode[0x8];
	u8         static_port_profile[0x8];
	u8         active_port_profile[0x8];
	u8         reserved_3[0x8];

	u8         retransmission_active[0x8];
	u8         fec_mode_active[0x18];

	u8         reserved_4[0x10];
	u8         v_100g_fec_override_cap[0x4];
	u8         v_50g_fec_override_cap[0x4];
	u8         v_25g_fec_override_cap[0x4];
	u8         v_10g_40g_fec_override_cap[0x4];

	u8         reserved_5[0x10];
	u8         v_100g_fec_override_admin[0x4];
	u8         v_50g_fec_override_admin[0x4];
	u8         v_25g_fec_override_admin[0x4];
	u8         v_10g_40g_fec_override_admin[0x4];
};

struct mlx5_ifc_ppll_reg_bits {
	u8         num_pll_groups[0x8];
	u8         pll_group[0x8];
	u8         reserved_0[0x4];
	u8         num_plls[0x4];
	u8         reserved_1[0x8];

	u8         reserved_2[0x1f];
	u8         ae[0x1];

	u8         pll_status[4][0x40];
};

struct mlx5_ifc_ppad_reg_bits {
	u8         reserved_0[0x3];
	u8         single_mac[0x1];
	u8         reserved_1[0x4];
	u8         local_port[0x8];
	u8         mac_47_32[0x10];

	u8         mac_31_0[0x20];

	u8         reserved_2[0x40];
};

struct mlx5_ifc_pmtu_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         max_mtu[0x10];
	u8         reserved_2[0x10];

	u8         admin_mtu[0x10];
	u8         reserved_3[0x10];

	u8         oper_mtu[0x10];
	u8         reserved_4[0x10];
};

struct mlx5_ifc_pmpr_reg_bits {
	u8         reserved_0[0x8];
	u8         module[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x18];
	u8         attenuation_5g[0x8];

	u8         reserved_3[0x18];
	u8         attenuation_7g[0x8];

	u8         reserved_4[0x18];
	u8         attenuation_12g[0x8];
};

struct mlx5_ifc_pmpe_reg_bits {
	u8         reserved_0[0x8];
	u8         module[0x8];
	u8         reserved_1[0xc];
	u8         module_status[0x4];

	u8         reserved_2[0x14];
	u8         error_type[0x4];
	u8         reserved_3[0x8];

	u8         reserved_4[0x40];
};

struct mlx5_ifc_pmpc_reg_bits {
	u8         module_state_updated[32][0x8];
};

struct mlx5_ifc_pmlpn_reg_bits {
	u8         reserved_0[0x4];
	u8         mlpn_status[0x4];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         e[0x1];
	u8         reserved_2[0x1f];
};

struct mlx5_ifc_pmlp_reg_bits {
	u8         rxtx[0x1];
	u8         reserved_0[0x7];
	u8         local_port[0x8];
	u8         reserved_1[0x8];
	u8         width[0x8];

	u8         lane0_module_mapping[0x20];

	u8         lane1_module_mapping[0x20];

	u8         lane2_module_mapping[0x20];

	u8         lane3_module_mapping[0x20];

	u8         reserved_2[0x160];
};

struct mlx5_ifc_pmaos_reg_bits {
	u8         reserved_0[0x8];
	u8         module[0x8];
	u8         reserved_1[0x4];
	u8         admin_status[0x4];
	u8         reserved_2[0x4];
	u8         oper_status[0x4];

	u8         ase[0x1];
	u8         ee[0x1];
	u8         reserved_3[0x12];
	u8         error_type[0x4];
	u8         reserved_4[0x6];
	u8         e[0x2];

	u8         reserved_5[0x40];
};

struct mlx5_ifc_plpc_reg_bits {
	u8         reserved_0[0x4];
	u8         profile_id[0xc];
	u8         reserved_1[0x4];
	u8         proto_mask[0x4];
	u8         reserved_2[0x8];

	u8         reserved_3[0x10];
	u8         lane_speed[0x10];

	u8         reserved_4[0x17];
	u8         lpbf[0x1];
	u8         fec_mode_policy[0x8];

	u8         retransmission_capability[0x8];
	u8         fec_mode_capability[0x18];

	u8         retransmission_support_admin[0x8];
	u8         fec_mode_support_admin[0x18];

	u8         retransmission_request_admin[0x8];
	u8         fec_mode_request_admin[0x18];

	u8         reserved_5[0x80];
};

struct mlx5_ifc_pll_status_data_bits {
	u8         reserved_0[0x1];
	u8         lock_cal[0x1];
	u8         lock_status[0x2];
	u8         reserved_1[0x2];
	u8         algo_f_ctrl[0xa];
	u8         analog_algo_num_var[0x6];
	u8         f_ctrl_measure[0xa];

	u8         reserved_2[0x2];
	u8         analog_var[0x6];
	u8         reserved_3[0x2];
	u8         high_var[0x6];
	u8         reserved_4[0x2];
	u8         low_var[0x6];
	u8         reserved_5[0x2];
	u8         mid_val[0x6];
};

struct mlx5_ifc_plib_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x8];
	u8         ib_port[0x8];

	u8         reserved_2[0x60];
};

struct mlx5_ifc_plbf_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0xd];
	u8         lbf_mode[0x3];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_pipg_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         dic[0x1];
	u8         reserved_2[0x19];
	u8         ipg[0x4];
	u8         reserved_3[0x2];
};

struct mlx5_ifc_pifr_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0xe0];

	u8         port_filter[8][0x20];

	u8         port_filter_update_en[8][0x20];
};

struct mlx5_ifc_phys_layer_cntrs_bits {
	u8         time_since_last_clear_high[0x20];

	u8         time_since_last_clear_low[0x20];

	u8         symbol_errors_high[0x20];

	u8         symbol_errors_low[0x20];

	u8         sync_headers_errors_high[0x20];

	u8         sync_headers_errors_low[0x20];

	u8         edpl_bip_errors_lane0_high[0x20];

	u8         edpl_bip_errors_lane0_low[0x20];

	u8         edpl_bip_errors_lane1_high[0x20];

	u8         edpl_bip_errors_lane1_low[0x20];

	u8         edpl_bip_errors_lane2_high[0x20];

	u8         edpl_bip_errors_lane2_low[0x20];

	u8         edpl_bip_errors_lane3_high[0x20];

	u8         edpl_bip_errors_lane3_low[0x20];

	u8         fc_fec_corrected_blocks_lane0_high[0x20];

	u8         fc_fec_corrected_blocks_lane0_low[0x20];

	u8         fc_fec_corrected_blocks_lane1_high[0x20];

	u8         fc_fec_corrected_blocks_lane1_low[0x20];

	u8         fc_fec_corrected_blocks_lane2_high[0x20];

	u8         fc_fec_corrected_blocks_lane2_low[0x20];

	u8         fc_fec_corrected_blocks_lane3_high[0x20];

	u8         fc_fec_corrected_blocks_lane3_low[0x20];

	u8         fc_fec_uncorrectable_blocks_lane0_high[0x20];

	u8         fc_fec_uncorrectable_blocks_lane0_low[0x20];

	u8         fc_fec_uncorrectable_blocks_lane1_high[0x20];

	u8         fc_fec_uncorrectable_blocks_lane1_low[0x20];

	u8         fc_fec_uncorrectable_blocks_lane2_high[0x20];

	u8         fc_fec_uncorrectable_blocks_lane2_low[0x20];

	u8         fc_fec_uncorrectable_blocks_lane3_high[0x20];

	u8         fc_fec_uncorrectable_blocks_lane3_low[0x20];

	u8         rs_fec_corrected_blocks_high[0x20];

	u8         rs_fec_corrected_blocks_low[0x20];

	u8         rs_fec_uncorrectable_blocks_high[0x20];

	u8         rs_fec_uncorrectable_blocks_low[0x20];

	u8         rs_fec_no_errors_blocks_high[0x20];

	u8         rs_fec_no_errors_blocks_low[0x20];

	u8         rs_fec_single_error_blocks_high[0x20];

	u8         rs_fec_single_error_blocks_low[0x20];

	u8         rs_fec_corrected_symbols_total_high[0x20];

	u8         rs_fec_corrected_symbols_total_low[0x20];

	u8         rs_fec_corrected_symbols_lane0_high[0x20];

	u8         rs_fec_corrected_symbols_lane0_low[0x20];

	u8         rs_fec_corrected_symbols_lane1_high[0x20];

	u8         rs_fec_corrected_symbols_lane1_low[0x20];

	u8         rs_fec_corrected_symbols_lane2_high[0x20];

	u8         rs_fec_corrected_symbols_lane2_low[0x20];

	u8         rs_fec_corrected_symbols_lane3_high[0x20];

	u8         rs_fec_corrected_symbols_lane3_low[0x20];

	u8         link_down_events[0x20];

	u8         successful_recovery_events[0x20];

	u8         reserved_0[0x180];
};

struct mlx5_ifc_phrr_reg_bits {
	u8         clr[0x1];
	u8         reserved_0[0x7];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         hist_group[0x8];
	u8         reserved_2[0x10];
	u8         hist_id[0x8];

	u8         reserved_3[0x40];

	u8         time_since_last_clear_high[0x20];

	u8         time_since_last_clear_low[0x20];

	u8         bin[10][0x20];
};

struct mlx5_ifc_phbr_for_prio_reg_bits {
	u8         reserved_0[0x18];
	u8         prio[0x8];
};

struct mlx5_ifc_phbr_for_port_tclass_reg_bits {
	u8         reserved_0[0x18];
	u8         tclass[0x8];
};

struct mlx5_ifc_phbr_binding_reg_bits {
	u8         opcode[0x4];
	u8         reserved_0[0x4];
	u8         local_port[0x8];
	u8         pnat[0x2];
	u8         reserved_1[0xe];

	u8         hist_group[0x8];
	u8         reserved_2[0x10];
	u8         hist_id[0x8];

	u8         reserved_3[0x10];
	u8         hist_type[0x10];

	u8         hist_parameters[0x20];

	u8         hist_min_value[0x20];

	u8         hist_max_value[0x20];

	u8         sample_time[0x20];
};

enum {
	MLX5_PFCC_REG_PPAN_DISABLED  = 0x0,
	MLX5_PFCC_REG_PPAN_ENABLED   = 0x1,
};

struct mlx5_ifc_pfcc_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         pnat[0x2];
	u8         reserved_1[0xc];
	u8         shl_cap[0x1];
	u8         shl_opr[0x1];

	u8         ppan[0x4];
	u8         reserved_2[0x4];
	u8         prio_mask_tx[0x8];
	u8         reserved_3[0x8];
	u8         prio_mask_rx[0x8];

	u8         pptx[0x1];
	u8         aptx[0x1];
	u8         reserved_4[0x6];
	u8         pfctx[0x8];
	u8         reserved_5[0x10];

	u8         pprx[0x1];
	u8         aprx[0x1];
	u8         reserved_6[0x6];
	u8         pfcrx[0x8];
	u8         reserved_7[0x10];

	u8         reserved_8[0x80];
};

struct mlx5_ifc_pelc_reg_bits {
	u8         op[0x4];
	u8         reserved_0[0x4];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         op_admin[0x8];
	u8         op_capability[0x8];
	u8         op_request[0x8];
	u8         op_active[0x8];

	u8         admin[0x40];

	u8         capability[0x40];

	u8         request[0x40];

	u8         active[0x40];

	u8         reserved_2[0x80];
};

struct mlx5_ifc_peir_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0xc];
	u8         error_count[0x4];
	u8         reserved_3[0x10];

	u8         reserved_4[0xc];
	u8         lane[0x4];
	u8         reserved_5[0x8];
	u8         error_type[0x8];
};

struct mlx5_ifc_pcap_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         port_capability_mask[4][0x20];
};

struct mlx5_ifc_pbmc_reg_bits {
	u8         reserved_0[0x8];
	u8         local_port[0x8];
	u8         reserved_1[0x10];

	u8         xoff_timer_value[0x10];
	u8         xoff_refresh[0x10];

	u8         reserved_2[0x10];
	u8         port_buffer_size[0x10];

	struct mlx5_ifc_bufferx_reg_bits buffer[10];

	u8         reserved_3[0x40];

	u8         port_shared_buffer[0x40];
};

struct mlx5_ifc_paos_reg_bits {
	u8         swid[0x8];
	u8         local_port[0x8];
	u8         reserved_0[0x4];
	u8         admin_status[0x4];
	u8         reserved_1[0x4];
	u8         oper_status[0x4];

	u8         ase[0x1];
	u8         ee[0x1];
	u8         reserved_2[0x1c];
	u8         e[0x2];

	u8         reserved_3[0x40];
};

struct mlx5_ifc_pamp_reg_bits {
	u8         reserved_0[0x8];
	u8         opamp_group[0x8];
	u8         reserved_1[0xc];
	u8         opamp_group_type[0x4];

	u8         start_index[0x10];
	u8         reserved_2[0x4];
	u8         num_of_indices[0xc];

	u8         index_data[18][0x10];
};

struct mlx5_ifc_link_level_retrans_cntr_grp_date_bits {
	u8         llr_rx_cells_high[0x20];

	u8         llr_rx_cells_low[0x20];

	u8         llr_rx_error_high[0x20];

	u8         llr_rx_error_low[0x20];

	u8         llr_rx_crc_error_high[0x20];

	u8         llr_rx_crc_error_low[0x20];

	u8         llr_tx_cells_high[0x20];

	u8         llr_tx_cells_low[0x20];

	u8         llr_tx_ret_cells_high[0x20];

	u8         llr_tx_ret_cells_low[0x20];

	u8         llr_tx_ret_events_high[0x20];

	u8         llr_tx_ret_events_low[0x20];

	u8         reserved_0[0x640];
};

struct mlx5_ifc_lane_2_module_mapping_bits {
	u8         reserved_0[0x6];
	u8         rx_lane[0x2];
	u8         reserved_1[0x6];
	u8         tx_lane[0x2];
	u8         reserved_2[0x8];
	u8         module[0x8];
};

struct mlx5_ifc_eth_per_traffic_class_layout_bits {
	u8         transmit_queue_high[0x20];

	u8         transmit_queue_low[0x20];

	u8         reserved_0[0x780];
};

struct mlx5_ifc_eth_per_traffic_class_cong_layout_bits {
	u8         no_buffer_discard_uc_high[0x20];

	u8         no_buffer_discard_uc_low[0x20];

	u8         wred_discard_high[0x20];

	u8         wred_discard_low[0x20];

	u8         reserved_0[0x740];
};

struct mlx5_ifc_eth_per_prio_grp_data_layout_bits {
	u8         rx_octets_high[0x20];

	u8         rx_octets_low[0x20];

	u8         reserved_0[0xc0];

	u8         rx_frames_high[0x20];

	u8         rx_frames_low[0x20];

	u8         tx_octets_high[0x20];

	u8         tx_octets_low[0x20];

	u8         reserved_1[0xc0];

	u8         tx_frames_high[0x20];

	u8         tx_frames_low[0x20];

	u8         rx_pause_high[0x20];

	u8         rx_pause_low[0x20];

	u8         rx_pause_duration_high[0x20];

	u8         rx_pause_duration_low[0x20];

	u8         tx_pause_high[0x20];

	u8         tx_pause_low[0x20];

	u8         tx_pause_duration_high[0x20];

	u8         tx_pause_duration_low[0x20];

	u8         rx_pause_transition_high[0x20];

	u8         rx_pause_transition_low[0x20];

	u8         reserved_2[0x400];
};

struct mlx5_ifc_eth_extended_cntrs_grp_data_layout_bits {
	u8         port_transmit_wait_high[0x20];

	u8         port_transmit_wait_low[0x20];

	u8         ecn_marked_high[0x20];

	u8         ecn_marked_low[0x20];

	u8         no_buffer_discard_mc_high[0x20];

	u8         no_buffer_discard_mc_low[0x20];

	u8         reserved_0[0x700];
};

struct mlx5_ifc_eth_802_3_cntrs_grp_data_layout_bits {
	u8         a_frames_transmitted_ok_high[0x20];

	u8         a_frames_transmitted_ok_low[0x20];

	u8         a_frames_received_ok_high[0x20];

	u8         a_frames_received_ok_low[0x20];

	u8         a_frame_check_sequence_errors_high[0x20];

	u8         a_frame_check_sequence_errors_low[0x20];

	u8         a_alignment_errors_high[0x20];

	u8         a_alignment_errors_low[0x20];

	u8         a_octets_transmitted_ok_high[0x20];

	u8         a_octets_transmitted_ok_low[0x20];

	u8         a_octets_received_ok_high[0x20];

	u8         a_octets_received_ok_low[0x20];

	u8         a_multicast_frames_xmitted_ok_high[0x20];

	u8         a_multicast_frames_xmitted_ok_low[0x20];

	u8         a_broadcast_frames_xmitted_ok_high[0x20];

	u8         a_broadcast_frames_xmitted_ok_low[0x20];

	u8         a_multicast_frames_received_ok_high[0x20];

	u8         a_multicast_frames_received_ok_low[0x20];

	u8         a_broadcast_frames_recieved_ok_high[0x20];

	u8         a_broadcast_frames_recieved_ok_low[0x20];

	u8         a_in_range_length_errors_high[0x20];

	u8         a_in_range_length_errors_low[0x20];

	u8         a_out_of_range_length_field_high[0x20];

	u8         a_out_of_range_length_field_low[0x20];

	u8         a_frame_too_long_errors_high[0x20];

	u8         a_frame_too_long_errors_low[0x20];

	u8         a_symbol_error_during_carrier_high[0x20];

	u8         a_symbol_error_during_carrier_low[0x20];

	u8         a_mac_control_frames_transmitted_high[0x20];

	u8         a_mac_control_frames_transmitted_low[0x20];

	u8         a_mac_control_frames_received_high[0x20];

	u8         a_mac_control_frames_received_low[0x20];

	u8         a_unsupported_opcodes_received_high[0x20];

	u8         a_unsupported_opcodes_received_low[0x20];

	u8         a_pause_mac_ctrl_frames_received_high[0x20];

	u8         a_pause_mac_ctrl_frames_received_low[0x20];

	u8         a_pause_mac_ctrl_frames_transmitted_high[0x20];

	u8         a_pause_mac_ctrl_frames_transmitted_low[0x20];

	u8         reserved_0[0x300];
};

struct mlx5_ifc_eth_3635_cntrs_grp_data_layout_bits {
	u8         dot3stats_alignment_errors_high[0x20];

	u8         dot3stats_alignment_errors_low[0x20];

	u8         dot3stats_fcs_errors_high[0x20];

	u8         dot3stats_fcs_errors_low[0x20];

	u8         dot3stats_single_collision_frames_high[0x20];

	u8         dot3stats_single_collision_frames_low[0x20];

	u8         dot3stats_multiple_collision_frames_high[0x20];

	u8         dot3stats_multiple_collision_frames_low[0x20];

	u8         dot3stats_sqe_test_errors_high[0x20];

	u8         dot3stats_sqe_test_errors_low[0x20];

	u8         dot3stats_deferred_transmissions_high[0x20];

	u8         dot3stats_deferred_transmissions_low[0x20];

	u8         dot3stats_late_collisions_high[0x20];

	u8         dot3stats_late_collisions_low[0x20];

	u8         dot3stats_excessive_collisions_high[0x20];

	u8         dot3stats_excessive_collisions_low[0x20];

	u8         dot3stats_internal_mac_transmit_errors_high[0x20];

	u8         dot3stats_internal_mac_transmit_errors_low[0x20];

	u8         dot3stats_carrier_sense_errors_high[0x20];

	u8         dot3stats_carrier_sense_errors_low[0x20];

	u8         dot3stats_frame_too_longs_high[0x20];

	u8         dot3stats_frame_too_longs_low[0x20];

	u8         dot3stats_internal_mac_receive_errors_high[0x20];

	u8         dot3stats_internal_mac_receive_errors_low[0x20];

	u8         dot3stats_symbol_errors_high[0x20];

	u8         dot3stats_symbol_errors_low[0x20];

	u8         dot3control_in_unknown_opcodes_high[0x20];

	u8         dot3control_in_unknown_opcodes_low[0x20];

	u8         dot3in_pause_frames_high[0x20];

	u8         dot3in_pause_frames_low[0x20];

	u8         dot3out_pause_frames_high[0x20];

	u8         dot3out_pause_frames_low[0x20];

	u8         reserved_0[0x3c0];
};

struct mlx5_ifc_eth_2863_cntrs_grp_data_layout_bits {
	u8         if_in_octets_high[0x20];

	u8         if_in_octets_low[0x20];

	u8         if_in_ucast_pkts_high[0x20];

	u8         if_in_ucast_pkts_low[0x20];

	u8         if_in_discards_high[0x20];

	u8         if_in_discards_low[0x20];

	u8         if_in_errors_high[0x20];

	u8         if_in_errors_low[0x20];

	u8         if_in_unknown_protos_high[0x20];

	u8         if_in_unknown_protos_low[0x20];

	u8         if_out_octets_high[0x20];

	u8         if_out_octets_low[0x20];

	u8         if_out_ucast_pkts_high[0x20];

	u8         if_out_ucast_pkts_low[0x20];

	u8         if_out_discards_high[0x20];

	u8         if_out_discards_low[0x20];

	u8         if_out_errors_high[0x20];

	u8         if_out_errors_low[0x20];

	u8         if_in_multicast_pkts_high[0x20];

	u8         if_in_multicast_pkts_low[0x20];

	u8         if_in_broadcast_pkts_high[0x20];

	u8         if_in_broadcast_pkts_low[0x20];

	u8         if_out_multicast_pkts_high[0x20];

	u8         if_out_multicast_pkts_low[0x20];

	u8         if_out_broadcast_pkts_high[0x20];

	u8         if_out_broadcast_pkts_low[0x20];

	u8         reserved_0[0x480];
};

struct mlx5_ifc_eth_2819_cntrs_grp_data_layout_bits {
	u8         ether_stats_drop_events_high[0x20];

	u8         ether_stats_drop_events_low[0x20];

	u8         ether_stats_octets_high[0x20];

	u8         ether_stats_octets_low[0x20];

	u8         ether_stats_pkts_high[0x20];

	u8         ether_stats_pkts_low[0x20];

	u8         ether_stats_broadcast_pkts_high[0x20];

	u8         ether_stats_broadcast_pkts_low[0x20];

	u8         ether_stats_multicast_pkts_high[0x20];

	u8         ether_stats_multicast_pkts_low[0x20];

	u8         ether_stats_crc_align_errors_high[0x20];

	u8         ether_stats_crc_align_errors_low[0x20];

	u8         ether_stats_undersize_pkts_high[0x20];

	u8         ether_stats_undersize_pkts_low[0x20];

	u8         ether_stats_oversize_pkts_high[0x20];

	u8         ether_stats_oversize_pkts_low[0x20];

	u8         ether_stats_fragments_high[0x20];

	u8         ether_stats_fragments_low[0x20];

	u8         ether_stats_jabbers_high[0x20];

	u8         ether_stats_jabbers_low[0x20];

	u8         ether_stats_collisions_high[0x20];

	u8         ether_stats_collisions_low[0x20];

	u8         ether_stats_pkts64octets_high[0x20];

	u8         ether_stats_pkts64octets_low[0x20];

	u8         ether_stats_pkts65to127octets_high[0x20];

	u8         ether_stats_pkts65to127octets_low[0x20];

	u8         ether_stats_pkts128to255octets_high[0x20];

	u8         ether_stats_pkts128to255octets_low[0x20];

	u8         ether_stats_pkts256to511octets_high[0x20];

	u8         ether_stats_pkts256to511octets_low[0x20];

	u8         ether_stats_pkts512to1023octets_high[0x20];

	u8         ether_stats_pkts512to1023octets_low[0x20];

	u8         ether_stats_pkts1024to1518octets_high[0x20];

	u8         ether_stats_pkts1024to1518octets_low[0x20];

	u8         ether_stats_pkts1519to2047octets_high[0x20];

	u8         ether_stats_pkts1519to2047octets_low[0x20];

	u8         ether_stats_pkts2048to4095octets_high[0x20];

	u8         ether_stats_pkts2048to4095octets_low[0x20];

	u8         ether_stats_pkts4096to8191octets_high[0x20];

	u8         ether_stats_pkts4096to8191octets_low[0x20];

	u8         ether_stats_pkts8192to10239octets_high[0x20];

	u8         ether_stats_pkts8192to10239octets_low[0x20];

	u8         reserved_0[0x280];
};

struct mlx5_ifc_ib_portcntrs_attribute_grp_data_bits {
	u8         symbol_error_counter[0x10];
	u8         link_error_recovery_counter[0x8];
	u8         link_downed_counter[0x8];

	u8         port_rcv_errors[0x10];
	u8         port_rcv_remote_physical_errors[0x10];

	u8         port_rcv_switch_relay_errors[0x10];
	u8         port_xmit_discards[0x10];

	u8         port_xmit_constraint_errors[0x8];
	u8         port_rcv_constraint_errors[0x8];
	u8         reserved_0[0x8];
	u8         local_link_integrity_errors[0x4];
	u8         excessive_buffer_overrun_errors[0x4];

	u8         reserved_1[0x10];
	u8         vl_15_dropped[0x10];

	u8         port_xmit_data[0x20];

	u8         port_rcv_data[0x20];

	u8         port_xmit_pkts[0x20];

	u8         port_rcv_pkts[0x20];

	u8         port_xmit_wait[0x20];

	u8         reserved_2[0x680];
};

struct mlx5_ifc_trc_tlb_reg_bits {
	u8         reserved_0[0x80];

	u8         tlb_addr[0][0x40];
};

struct mlx5_ifc_trc_read_fifo_reg_bits {
	u8         reserved_0[0x10];
	u8         requested_event_num[0x10];

	u8         reserved_1[0x20];

	u8         reserved_2[0x10];
	u8         acual_event_num[0x10];

	u8         reserved_3[0x20];

	u8         event[0][0x40];
};

struct mlx5_ifc_trc_lock_reg_bits {
	u8         reserved_0[0x1f];
	u8         lock[0x1];

	u8         reserved_1[0x60];
};

struct mlx5_ifc_trc_filter_reg_bits {
	u8         status[0x1];
	u8         reserved_0[0xf];
	u8         filter_index[0x10];

	u8         reserved_1[0x20];

	u8         filter_val[0x20];

	u8         reserved_2[0x1a0];
};

struct mlx5_ifc_trc_event_reg_bits {
	u8         status[0x1];
	u8         reserved_0[0xf];
	u8         event_index[0x10];

	u8         reserved_1[0x20];

	u8         event_id[0x20];

	u8         event_selector_val[0x10];
	u8         event_selector_size[0x10];

	u8         reserved_2[0x180];
};

struct mlx5_ifc_trc_conf_reg_bits {
	u8         limit_en[0x1];
	u8         reserved_0[0x3];
	u8         dump_mode[0x4];
	u8         reserved_1[0x15];
	u8         state[0x3];

	u8         reserved_2[0x20];

	u8         limit_event_index[0x20];

	u8         mkey[0x20];

	u8         fifo_ready_ev_num[0x20];

	u8         reserved_3[0x160];
};

struct mlx5_ifc_trc_cap_reg_bits {
	u8         reserved_0[0x18];
	u8         dump_mode[0x8];

	u8         reserved_1[0x20];

	u8         num_of_events[0x10];
	u8         num_of_filters[0x10];

	u8         fifo_size[0x20];

	u8         tlb_size[0x10];
	u8         event_size[0x10];

	u8         reserved_2[0x160];
};

struct mlx5_ifc_set_node_in_bits {
	u8         node_description[64][0x8];
};

struct mlx5_ifc_register_power_settings_bits {
	u8         reserved_0[0x18];
	u8         power_settings_level[0x8];

	u8         reserved_1[0x60];
};

struct mlx5_ifc_register_host_endianess_bits {
	u8         he[0x1];
	u8         reserved_0[0x1f];

	u8         reserved_1[0x60];
};

struct mlx5_ifc_register_diag_buffer_ctrl_bits {
	u8         physical_address[0x40];
};

struct mlx5_ifc_qtct_reg_bits {
	u8         reserved_0[0x8];
	u8         port_number[0x8];
	u8         reserved_1[0xd];
	u8         prio[0x3];

	u8         reserved_2[0x1d];
	u8         tclass[0x3];
};

struct mlx5_ifc_qpdp_reg_bits {
	u8         reserved_0[0x8];
	u8         port_number[0x8];
	u8         reserved_1[0x10];

	u8         reserved_2[0x1d];
	u8         pprio[0x3];
};

struct mlx5_ifc_port_info_ro_fields_param_bits {
	u8         reserved_0[0x8];
	u8         port[0x8];
	u8         max_gid[0x10];

	u8         reserved_1[0x20];

	u8         port_guid[0x40];
};

struct mlx5_ifc_nvqc_reg_bits {
	u8         type[0x20];

	u8         reserved_0[0x18];
	u8         version[0x4];
	u8         reserved_1[0x2];
	u8         support_wr[0x1];
	u8         support_rd[0x1];
};

struct mlx5_ifc_nvia_reg_bits {
	u8         reserved_0[0x1d];
	u8         target[0x3];

	u8         reserved_1[0x20];
};

struct mlx5_ifc_nvdi_reg_bits {
	struct mlx5_ifc_config_item_bits configuration_item_header;
};

struct mlx5_ifc_nvda_reg_bits {
	struct mlx5_ifc_config_item_bits configuration_item_header;

	u8         configuration_item_data[0x20];
};

struct mlx5_ifc_node_info_ro_fields_param_bits {
	u8         system_image_guid[0x40];

	u8         reserved_0[0x40];

	u8         node_guid[0x40];

	u8         reserved_1[0x10];
	u8         max_pkey[0x10];

	u8         reserved_2[0x20];
};

struct mlx5_ifc_ets_tcn_config_reg_bits {
	u8         g[0x1];
	u8         b[0x1];
	u8         r[0x1];
	u8         reserved_0[0x9];
	u8         group[0x4];
	u8         reserved_1[0x9];
	u8         bw_allocation[0x7];

	u8         reserved_2[0xc];
	u8         max_bw_units[0x4];
	u8         reserved_3[0x8];
	u8         max_bw_value[0x8];
};

struct mlx5_ifc_ets_global_config_reg_bits {
	u8         reserved_0[0x2];
	u8         r[0x1];
	u8         reserved_1[0x1d];

	u8         reserved_2[0xc];
	u8         max_bw_units[0x4];
	u8         reserved_3[0x8];
	u8         max_bw_value[0x8];
};

struct mlx5_ifc_nodnic_mac_filters_bits {
	struct mlx5_ifc_mac_address_layout_bits mac_filter0;

	struct mlx5_ifc_mac_address_layout_bits mac_filter1;

	struct mlx5_ifc_mac_address_layout_bits mac_filter2;

	struct mlx5_ifc_mac_address_layout_bits mac_filter3;

	struct mlx5_ifc_mac_address_layout_bits mac_filter4;

	u8         reserved_0[0xc0];
};

struct mlx5_ifc_nodnic_gid_filters_bits {
	u8         mgid_filter0[16][0x8];

	u8         mgid_filter1[16][0x8];

	u8         mgid_filter2[16][0x8];

	u8         mgid_filter3[16][0x8];
};

enum {
	MLX5_NODNIC_CONFIG_REG_NUM_PORTS_SINGLE_PORT  = 0x0,
	MLX5_NODNIC_CONFIG_REG_NUM_PORTS_DUAL_PORT    = 0x1,
};

enum {
	MLX5_NODNIC_CONFIG_REG_CQE_FORMAT_LEGACY_CQE  = 0x0,
	MLX5_NODNIC_CONFIG_REG_CQE_FORMAT_NEW_CQE     = 0x1,
};

struct mlx5_ifc_nodnic_config_reg_bits {
	u8         no_dram_nic_revision[0x8];
	u8         hardware_format[0x8];
	u8         support_receive_filter[0x1];
	u8         support_promisc_filter[0x1];
	u8         support_promisc_multicast_filter[0x1];
	u8         reserved_0[0x2];
	u8         log_working_buffer_size[0x3];
	u8         log_pkey_table_size[0x4];
	u8         reserved_1[0x3];
	u8         num_ports[0x1];

	u8         reserved_2[0x2];
	u8         log_max_ring_size[0x6];
	u8         reserved_3[0x18];

	u8         lkey[0x20];

	u8         cqe_format[0x4];
	u8         reserved_4[0x1c];

	u8         node_guid[0x40];

	u8         reserved_5[0x740];

	struct mlx5_ifc_nodnic_port_config_reg_bits port1_settings;

	struct mlx5_ifc_nodnic_port_config_reg_bits port2_settings;
};

struct mlx5_ifc_vlan_layout_bits {
	u8         reserved_0[0x14];
	u8         vlan[0xc];

	u8         reserved_1[0x20];
};

struct mlx5_ifc_umr_pointer_desc_argument_bits {
	u8         reserved_0[0x20];

	u8         mkey[0x20];

	u8         addressh_63_32[0x20];

	u8         addressl_31_0[0x20];
};

struct mlx5_ifc_ud_adrs_vector_bits {
	u8         dc_key[0x40];

	u8         ext[0x1];
	u8         reserved_0[0x7];
	u8         destination_qp_dct[0x18];

	u8         static_rate[0x4];
	u8         sl_eth_prio[0x4];
	u8         fl[0x1];
	u8         mlid[0x7];
	u8         rlid_udp_sport[0x10];

	u8         reserved_1[0x20];

	u8         rmac_47_16[0x20];

	u8         rmac_15_0[0x10];
	u8         tclass[0x8];
	u8         hop_limit[0x8];

	u8         reserved_2[0x1];
	u8         grh[0x1];
	u8         reserved_3[0x2];
	u8         src_addr_index[0x8];
	u8         flow_label[0x14];

	u8         rgid_rip[16][0x8];
};

struct mlx5_ifc_port_module_event_bits {
	u8         reserved_0[0x8];
	u8         module[0x8];
	u8         reserved_1[0xc];
	u8         module_status[0x4];

	u8         reserved_2[0x14];
	u8         error_type[0x4];
	u8         reserved_3[0x8];

	u8         reserved_4[0xa0];
};

struct mlx5_ifc_icmd_control_bits {
	u8         opcode[0x10];
	u8         status[0x8];
	u8         reserved_0[0x7];
	u8         busy[0x1];
};

struct mlx5_ifc_eqe_bits {
	u8         reserved_0[0x8];
	u8         event_type[0x8];
	u8         reserved_1[0x8];
	u8         event_sub_type[0x8];

	u8         reserved_2[0xe0];

	union mlx5_ifc_event_auto_bits event_data;

	u8         reserved_3[0x10];
	u8         signature[0x8];
	u8         reserved_4[0x7];
	u8         owner[0x1];
};

enum {
	MLX5_CMD_QUEUE_ENTRY_TYPE_PCIE_CMD_IF_TRANSPORT  = 0x7,
};

struct mlx5_ifc_cmd_queue_entry_bits {
	u8         type[0x8];
	u8         reserved_0[0x18];

	u8         input_length[0x20];

	u8         input_mailbox_pointer_63_32[0x20];

	u8         input_mailbox_pointer_31_9[0x17];
	u8         reserved_1[0x9];

	u8         command_input_inline_data[16][0x8];

	u8         command_output_inline_data[16][0x8];

	u8         output_mailbox_pointer_63_32[0x20];

	u8         output_mailbox_pointer_31_9[0x17];
	u8         reserved_2[0x9];

	u8         output_length[0x20];

	u8         token[0x8];
	u8         signature[0x8];
	u8         reserved_3[0x8];
	u8         status[0x7];
	u8         ownership[0x1];
};

struct mlx5_ifc_cmd_out_bits {
	u8         status[0x8];
	u8         reserved_0[0x18];

	u8         syndrome[0x20];

	u8         command_output[0x20];
};

struct mlx5_ifc_cmd_in_bits {
	u8         opcode[0x10];
	u8         reserved_0[0x10];

	u8         reserved_1[0x10];
	u8         op_mod[0x10];

	u8         command[0][0x20];
};

struct mlx5_ifc_cmd_if_box_bits {
	u8         mailbox_data[512][0x8];

	u8         reserved_0[0x180];

	u8         next_pointer_63_32[0x20];

	u8         next_pointer_31_10[0x16];
	u8         reserved_1[0xa];

	u8         block_number[0x20];

	u8         reserved_2[0x8];
	u8         token[0x8];
	u8         ctrl_signature[0x8];
	u8         signature[0x8];
};

struct mlx5_ifc_mtt_bits {
	u8         ptag_63_32[0x20];

	u8         ptag_31_8[0x18];
	u8         reserved_0[0x6];
	u8         wr_en[0x1];
	u8         rd_en[0x1];
};

struct mlx5_ifc_vendor_specific_cap_bits {
	u8         type[0x8];
	u8         length[0x8];
	u8         next_pointer[0x8];
	u8         capability_id[0x8];

	u8         status[0x3];
	u8         reserved_0[0xd];
	u8         space[0x10];

	u8         counter[0x20];

	u8         semaphore[0x20];

	u8         flag[0x1];
	u8         reserved_1[0x1];
	u8         address[0x1e];

	u8         data[0x20];
};

enum {
	MLX5_INITIAL_SEG_NIC_INTERFACE_FULL_DRIVER  = 0x0,
	MLX5_INITIAL_SEG_NIC_INTERFACE_DISABLED     = 0x1,
	MLX5_INITIAL_SEG_NIC_INTERFACE_NO_DRAM_NIC  = 0x2,
};

enum {
	MLX5_INITIAL_SEG_NIC_INTERFACE_SUPPORTED_FULL_DRIVER  = 0x0,
	MLX5_INITIAL_SEG_NIC_INTERFACE_SUPPORTED_DISABLED     = 0x1,
	MLX5_INITIAL_SEG_NIC_INTERFACE_SUPPORTED_NO_DRAM_NIC  = 0x2,
};

enum {
	MLX5_HEALTH_SYNDR_FW_ERR                                      = 0x1,
	MLX5_HEALTH_SYNDR_IRISC_ERR                                   = 0x7,
	MLX5_HEALTH_SYNDR_HW_UNRECOVERABLE_ERR                        = 0x8,
	MLX5_HEALTH_SYNDR_CRC_ERR                                     = 0x9,
	MLX5_HEALTH_SYNDR_FETCH_PCI_ERR                               = 0xa,
	MLX5_HEALTH_SYNDR_HW_FTL_ERR                                  = 0xb,
	MLX5_HEALTH_SYNDR_ASYNC_EQ_OVERRUN_ERR                        = 0xc,
	MLX5_HEALTH_SYNDR_EQ_ERR                                      = 0xd,
	MLX5_HEALTH_SYNDR_EQ_INV                                      = 0xe,
	MLX5_HEALTH_SYNDR_FFSER_ERR                                   = 0xf,
	MLX5_HEALTH_SYNDR_HIGH_TEMP                                   = 0x10,
};

struct mlx5_ifc_initial_seg_bits {
	u8         fw_rev_minor[0x10];
	u8         fw_rev_major[0x10];

	u8         cmd_interface_rev[0x10];
	u8         fw_rev_subminor[0x10];

	u8         reserved_0[0x40];

	u8         cmdq_phy_addr_63_32[0x20];

	u8         cmdq_phy_addr_31_12[0x14];
	u8         reserved_1[0x2];
	u8         nic_interface[0x2];
	u8         log_cmdq_size[0x4];
	u8         log_cmdq_stride[0x4];

	u8         command_doorbell_vector[0x20];

	u8         reserved_2[0xf00];

	u8         initializing[0x1];
	u8         reserved_3[0x4];
	u8         nic_interface_supported[0x3];
	u8         reserved_4[0x18];

	struct mlx5_ifc_health_buffer_bits health_buffer;

	u8         no_dram_nic_offset[0x20];

	u8         reserved_5[0x6de0];

	u8         internal_timer_h[0x20];

	u8         internal_timer_l[0x20];

	u8         reserved_6[0x20];

	u8         reserved_7[0x1f];
	u8         clear_int[0x1];

	u8         health_syndrome[0x8];
	u8         health_counter[0x18];

	u8         reserved_8[0x17fc0];
};

union mlx5_ifc_icmd_interface_document_bits {
	struct mlx5_ifc_fw_version_bits fw_version;
	struct mlx5_ifc_icmd_access_reg_in_bits icmd_access_reg_in;
	struct mlx5_ifc_icmd_access_reg_out_bits icmd_access_reg_out;
	struct mlx5_ifc_icmd_init_ocsd_in_bits icmd_init_ocsd_in;
	struct mlx5_ifc_icmd_ocbb_init_in_bits icmd_ocbb_init_in;
	struct mlx5_ifc_icmd_ocbb_query_etoc_stats_out_bits icmd_ocbb_query_etoc_stats_out;
	struct mlx5_ifc_icmd_ocbb_query_header_stats_out_bits icmd_ocbb_query_header_stats_out;
	struct mlx5_ifc_icmd_query_cap_general_bits icmd_query_cap_general;
	struct mlx5_ifc_icmd_query_cap_in_bits icmd_query_cap_in;
	struct mlx5_ifc_icmd_query_fw_info_out_bits icmd_query_fw_info_out;
	struct mlx5_ifc_icmd_query_virtual_mac_out_bits icmd_query_virtual_mac_out;
	struct mlx5_ifc_icmd_set_virtual_mac_in_bits icmd_set_virtual_mac_in;
	struct mlx5_ifc_icmd_set_wol_rol_in_bits icmd_set_wol_rol_in;
	struct mlx5_ifc_icmd_set_wol_rol_out_bits icmd_set_wol_rol_out;
	u8         reserved_0[0x42c0];
};

union mlx5_ifc_eth_cntrs_grp_data_layout_auto_bits {
	struct mlx5_ifc_eth_802_3_cntrs_grp_data_layout_bits eth_802_3_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_2863_cntrs_grp_data_layout_bits eth_2863_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_2819_cntrs_grp_data_layout_bits eth_2819_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_3635_cntrs_grp_data_layout_bits eth_3635_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_extended_cntrs_grp_data_layout_bits eth_extended_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_per_prio_grp_data_layout_bits eth_per_prio_grp_data_layout;
	struct mlx5_ifc_phys_layer_cntrs_bits phys_layer_cntrs;
	u8         reserved_0[0x7c0];
};

struct mlx5_ifc_ppcnt_reg_bits {
	u8         swid[0x8];
	u8         local_port[0x8];
	u8         pnat[0x2];
	u8         reserved_0[0x8];
	u8         grp[0x6];

	u8         clr[0x1];
	u8         reserved_1[0x1c];
	u8         prio_tc[0x3];

	union mlx5_ifc_eth_cntrs_grp_data_layout_auto_bits counter_set;
};

union mlx5_ifc_ports_control_registers_document_bits {
	struct mlx5_ifc_ib_portcntrs_attribute_grp_data_bits ib_portcntrs_attribute_grp_data;
	struct mlx5_ifc_bufferx_reg_bits bufferx_reg;
	struct mlx5_ifc_eth_2819_cntrs_grp_data_layout_bits eth_2819_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_2863_cntrs_grp_data_layout_bits eth_2863_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_3635_cntrs_grp_data_layout_bits eth_3635_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_802_3_cntrs_grp_data_layout_bits eth_802_3_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_extended_cntrs_grp_data_layout_bits eth_extended_cntrs_grp_data_layout;
	struct mlx5_ifc_eth_per_prio_grp_data_layout_bits eth_per_prio_grp_data_layout;
	struct mlx5_ifc_eth_per_traffic_class_cong_layout_bits eth_per_traffic_class_cong_layout;
	struct mlx5_ifc_eth_per_traffic_class_layout_bits eth_per_traffic_class_layout;
	struct mlx5_ifc_lane_2_module_mapping_bits lane_2_module_mapping;
	struct mlx5_ifc_link_level_retrans_cntr_grp_date_bits link_level_retrans_cntr_grp_date;
	struct mlx5_ifc_pamp_reg_bits pamp_reg;
	struct mlx5_ifc_paos_reg_bits paos_reg;
	struct mlx5_ifc_pbmc_reg_bits pbmc_reg;
	struct mlx5_ifc_pcap_reg_bits pcap_reg;
	struct mlx5_ifc_peir_reg_bits peir_reg;
	struct mlx5_ifc_pelc_reg_bits pelc_reg;
	struct mlx5_ifc_pfcc_reg_bits pfcc_reg;
	struct mlx5_ifc_phbr_binding_reg_bits phbr_binding_reg;
	struct mlx5_ifc_phbr_for_port_tclass_reg_bits phbr_for_port_tclass_reg;
	struct mlx5_ifc_phbr_for_prio_reg_bits phbr_for_prio_reg;
	struct mlx5_ifc_phrr_reg_bits phrr_reg;
	struct mlx5_ifc_phys_layer_cntrs_bits phys_layer_cntrs;
	struct mlx5_ifc_pifr_reg_bits pifr_reg;
	struct mlx5_ifc_pipg_reg_bits pipg_reg;
	struct mlx5_ifc_plbf_reg_bits plbf_reg;
	struct mlx5_ifc_plib_reg_bits plib_reg;
	struct mlx5_ifc_pll_status_data_bits pll_status_data;
	struct mlx5_ifc_plpc_reg_bits plpc_reg;
	struct mlx5_ifc_pmaos_reg_bits pmaos_reg;
	struct mlx5_ifc_pmlp_reg_bits pmlp_reg;
	struct mlx5_ifc_pmlpn_reg_bits pmlpn_reg;
	struct mlx5_ifc_pmpc_reg_bits pmpc_reg;
	struct mlx5_ifc_pmpe_reg_bits pmpe_reg;
	struct mlx5_ifc_pmpr_reg_bits pmpr_reg;
	struct mlx5_ifc_pmtu_reg_bits pmtu_reg;
	struct mlx5_ifc_ppad_reg_bits ppad_reg;
	struct mlx5_ifc_ppcnt_reg_bits ppcnt_reg;
	struct mlx5_ifc_ppll_reg_bits ppll_reg;
	struct mlx5_ifc_pplm_reg_bits pplm_reg;
	struct mlx5_ifc_pplr_reg_bits pplr_reg;
	struct mlx5_ifc_ppsc_reg_bits ppsc_reg;
	struct mlx5_ifc_pspa_reg_bits pspa_reg;
	struct mlx5_ifc_ptas_reg_bits ptas_reg;
	struct mlx5_ifc_ptys_reg_bits ptys_reg;
	struct mlx5_ifc_pude_reg_bits pude_reg;
	struct mlx5_ifc_pvlc_reg_bits pvlc_reg;
	struct mlx5_ifc_slrg_reg_bits slrg_reg;
	struct mlx5_ifc_slrp_reg_bits slrp_reg;
	struct mlx5_ifc_sltp_reg_bits sltp_reg;
	u8         reserved_0[0x7880];
};

union mlx5_ifc_debug_enhancements_document_bits {
	struct mlx5_ifc_health_buffer_bits health_buffer;
	u8         reserved_0[0x200];
};

union mlx5_ifc_no_dram_nic_document_bits {
	struct mlx5_ifc_nodnic_config_reg_bits nodnic_config_reg;
	struct mlx5_ifc_nodnic_cq_arming_word_bits nodnic_cq_arming_word;
	struct mlx5_ifc_nodnic_event_word_bits nodnic_event_word;
	struct mlx5_ifc_nodnic_gid_filters_bits nodnic_gid_filters;
	struct mlx5_ifc_nodnic_mac_filters_bits nodnic_mac_filters;
	struct mlx5_ifc_nodnic_port_config_reg_bits nodnic_port_config_reg;
	struct mlx5_ifc_nodnic_ring_config_reg_bits nodnic_ring_config_reg;
	struct mlx5_ifc_nodnic_ring_doorbell_bits nodnic_ring_doorbell;
	u8         reserved_0[0x3160];
};

union mlx5_ifc_uplink_pci_interface_document_bits {
	struct mlx5_ifc_initial_seg_bits initial_seg;
	struct mlx5_ifc_vendor_specific_cap_bits vendor_specific_cap;
	u8         reserved_0[0x20120];
};


#endif /* MLX5_IFC_H */
