/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_OLEAUT32_DLL_LOOKUP_H_
#define LIEF_PE_OLEAUT32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> oleaut32_dll_lookup {
    { 0x011e, "BSTR_UserFree"              },
    { 0x011c, "BSTR_UserMarshal"           },
    { 0x011b, "BSTR_UserSize"              },
    { 0x011d, "BSTR_UserUnmarshal"         },
    { 0x019e, "BstrFromVector"             },
    { 0x00ab, "ClearCustData"              },
    { 0x001f, "CreateDispTypeInfo"         },
    { 0x00ca, "CreateErrorInfo"            },
    { 0x0020, "CreateStdDispatch"          },
    { 0x00a0, "CreateTypeLib"              },
    { 0x00b4, "CreateTypeLib2"             },
    { 0x0092, "DispCallFunc"               },
    { 0x001d, "DispGetIDsOfNames"          },
    { 0x001c, "DispGetParam"               },
    { 0x001e, "DispInvoke"                 },
    { 0x0090, "DllCanUnloadNow"            },
    { 0x0091, "DllGetClassObject"          },
    { 0x0097, "DllRegisterServer"          },
    { 0x012c, "DllUnregisterServer"        },
    { 0x000e, "DosDateTimeToVariantTime"   },
    { 0x0023, "GetActiveObject"            },
    { 0x014c, "GetAltMonthNames"           },
    { 0x00c8, "GetErrorInfo"               },
    { 0x0142, "GetRecordInfoFromGuids"     },
    { 0x0143, "GetRecordInfoFromTypeInfo"  },
    { 0x0146, "GetVarConversionLocaleSetting" },
    { 0x00a5, "LHashValOfNameSys"          },
    { 0x00a6, "LHashValOfNameSysA"         },
    { 0x0128, "LPSAFEARRAY_Marshal"        },
    { 0x0127, "LPSAFEARRAY_Size"           },
    { 0x0129, "LPSAFEARRAY_Unmarshal"      },
    { 0x0126, "LPSAFEARRAY_UserFree"       },
    { 0x0124, "LPSAFEARRAY_UserMarshal"    },
    { 0x0123, "LPSAFEARRAY_UserSize"       },
    { 0x0125, "LPSAFEARRAY_UserUnmarshal"  },
    { 0x00a2, "LoadRegTypeLib"             },
    { 0x00a1, "LoadTypeLib"                },
    { 0x00b7, "LoadTypeLibEx"              },
    { 0x012d, "OACreateTypeLib2"           },
    { 0x00aa, "OaBuildVersion"             },
    { 0x01a4, "OleCreateFontIndirect"      },
    { 0x01a3, "OleCreatePictureIndirect"   },
    { 0x01a1, "OleCreatePropertyFrame"     },
    { 0x01a0, "OleCreatePropertyFrameIndirect" },
    { 0x019f, "OleIconToCursor"            },
    { 0x01a2, "OleLoadPicture"             },
    { 0x0191, "OleLoadPictureEx"           },
    { 0x01a6, "OleLoadPictureFile"         },
    { 0x0192, "OleLoadPictureFileEx"       },
    { 0x01a8, "OleLoadPicturePath"         },
    { 0x01a7, "OleSavePictureFile"         },
    { 0x01a5, "OleTranslateColor"          },
    { 0x00a4, "QueryPathOfRegTypeLib"      },
    { 0x0021, "RegisterActiveObject"       },
    { 0x00a3, "RegisterTypeLib"            },
    { 0x01ba, "RegisterTypeLibForUser"     },
    { 0x0022, "RevokeActiveObject"         },
    { 0x0017, "SafeArrayAccessData"        },
    { 0x0025, "SafeArrayAllocData"         },
    { 0x0024, "SafeArrayAllocDescriptor"   },
    { 0x0029, "SafeArrayAllocDescriptorEx" },
    { 0x001b, "SafeArrayCopy"              },
    { 0x019c, "SafeArrayCopyData"          },
    { 0x000f, "SafeArrayCreate"            },
    { 0x002a, "SafeArrayCreateEx"          },
    { 0x019b, "SafeArrayCreateVector"      },
    { 0x002b, "SafeArrayCreateVectorEx"    },
    { 0x0010, "SafeArrayDestroy"           },
    { 0x0027, "SafeArrayDestroyData"       },
    { 0x0026, "SafeArrayDestroyDescriptor" },
    { 0x0011, "SafeArrayGetDim"            },
    { 0x0019, "SafeArrayGetElement"        },
    { 0x0012, "SafeArrayGetElemsize"       },
    { 0x0043, "SafeArrayGetIID"            },
    { 0x0014, "SafeArrayGetLBound"         },
    { 0x002d, "SafeArrayGetRecordInfo"     },
    { 0x0013, "SafeArrayGetUBound"         },
    { 0x004d, "SafeArrayGetVartype"        },
    { 0x0015, "SafeArrayLock"              },
    { 0x0094, "SafeArrayPtrOfIndex"        },
    { 0x001a, "SafeArrayPutElement"        },
    { 0x0028, "SafeArrayRedim"             },
    { 0x0039, "SafeArraySetIID"            },
    { 0x002c, "SafeArraySetRecordInfo"     },
    { 0x0018, "SafeArrayUnaccessData"      },
    { 0x0016, "SafeArrayUnlock"            },
    { 0x00c9, "SetErrorInfo"               },
    { 0x0147, "SetOaNoCache"               },
    { 0x0145, "SetVarConversionLocaleSetting" },
    { 0x0002, "SysAllocString"             },
    { 0x0096, "SysAllocStringByteLen"      },
    { 0x0004, "SysAllocStringLen"          },
    { 0x0006, "SysFreeString"              },
    { 0x0003, "SysReAllocString"           },
    { 0x0005, "SysReAllocStringLen"        },
    { 0x0095, "SysStringByteLen"           },
    { 0x0007, "SysStringLen"               },
    { 0x00b8, "SystemTimeToVariantTime"    },
    { 0x00ba, "UnRegisterTypeLib"          },
    { 0x01bb, "UnRegisterTypeLibForUser"   },
    { 0x0122, "VARIANT_UserFree"           },
    { 0x0120, "VARIANT_UserMarshal"        },
    { 0x011f, "VARIANT_UserSize"           },
    { 0x0121, "VARIANT_UserUnmarshal"      },
    { 0x00a8, "VarAbs"                     },
    { 0x008d, "VarAdd"                     },
    { 0x008e, "VarAnd"                     },
    { 0x007c, "VarBoolFromCy"              },
    { 0x007b, "VarBoolFromDate"            },
    { 0x00ec, "VarBoolFromDec"             },
    { 0x007e, "VarBoolFromDisp"            },
    { 0x00e9, "VarBoolFromI1"              },
    { 0x0077, "VarBoolFromI2"              },
    { 0x0078, "VarBoolFromI4"              },
    { 0x0172, "VarBoolFromI8"              },
    { 0x0079, "VarBoolFromR4"              },
    { 0x007a, "VarBoolFromR8"              },
    { 0x007d, "VarBoolFromStr"             },
    { 0x0076, "VarBoolFromUI1"             },
    { 0x00ea, "VarBoolFromUI2"             },
    { 0x00eb, "VarBoolFromUI4"             },
    { 0x0173, "VarBoolFromUI8"             },
    { 0x0139, "VarBstrCat"                 },
    { 0x013a, "VarBstrCmp"                 },
    { 0x0074, "VarBstrFromBool"            },
    { 0x0071, "VarBstrFromCy"              },
    { 0x0072, "VarBstrFromDate"            },
    { 0x00e8, "VarBstrFromDec"             },
    { 0x0073, "VarBstrFromDisp"            },
    { 0x00e5, "VarBstrFromI1"              },
    { 0x006d, "VarBstrFromI2"              },
    { 0x006e, "VarBstrFromI4"              },
    { 0x0170, "VarBstrFromI8"              },
    { 0x006f, "VarBstrFromR4"              },
    { 0x0070, "VarBstrFromR8"              },
    { 0x006c, "VarBstrFromUI1"             },
    { 0x00e6, "VarBstrFromUI2"             },
    { 0x00e7, "VarBstrFromUI4"             },
    { 0x0171, "VarBstrFromUI8"             },
    { 0x013e, "VarCat"                     },
    { 0x00b0, "VarCmp"                     },
    { 0x0132, "VarCyAbs"                   },
    { 0x012b, "VarCyAdd"                   },
    { 0x0137, "VarCyCmp"                   },
    { 0x0138, "VarCyCmpR8"                 },
    { 0x0133, "VarCyFix"                   },
    { 0x006a, "VarCyFromBool"              },
    { 0x0067, "VarCyFromDate"              },
    { 0x00e4, "VarCyFromDec"               },
    { 0x0069, "VarCyFromDisp"              },
    { 0x00e1, "VarCyFromI1"                },
    { 0x0063, "VarCyFromI2"                },
    { 0x0064, "VarCyFromI4"                },
    { 0x016e, "VarCyFromI8"                },
    { 0x0065, "VarCyFromR4"                },
    { 0x0066, "VarCyFromR8"                },
    { 0x0068, "VarCyFromStr"               },
    { 0x0062, "VarCyFromUI1"               },
    { 0x00e2, "VarCyFromUI2"               },
    { 0x00e3, "VarCyFromUI4"               },
    { 0x016f, "VarCyFromUI8"               },
    { 0x0134, "VarCyInt"                   },
    { 0x012f, "VarCyMul"                   },
    { 0x0130, "VarCyMulI4"                 },
    { 0x0149, "VarCyMulI8"                 },
    { 0x0135, "VarCyNeg"                   },
    { 0x0136, "VarCyRound"                 },
    { 0x0131, "VarCySub"                   },
    { 0x0060, "VarDateFromBool"            },
    { 0x005d, "VarDateFromCy"              },
    { 0x00e0, "VarDateFromDec"             },
    { 0x005f, "VarDateFromDisp"            },
    { 0x00dd, "VarDateFromI1"              },
    { 0x0059, "VarDateFromI2"              },
    { 0x005a, "VarDateFromI4"              },
    { 0x016c, "VarDateFromI8"              },
    { 0x005b, "VarDateFromR4"              },
    { 0x005c, "VarDateFromR8"              },
    { 0x005e, "VarDateFromStr"             },
    { 0x0058, "VarDateFromUI1"             },
    { 0x00de, "VarDateFromUI2"             },
    { 0x00df, "VarDateFromUI4"             },
    { 0x016d, "VarDateFromUI8"             },
    { 0x014a, "VarDateFromUdate"           },
    { 0x013f, "VarDateFromUdateEx"         },
    { 0x00b6, "VarDecAbs"                  },
    { 0x00b1, "VarDecAdd"                  },
    { 0x00cc, "VarDecCmp"                  },
    { 0x012a, "VarDecCmpR8"                },
    { 0x00b2, "VarDecDiv"                  },
    { 0x00bb, "VarDecFix"                  },
    { 0x00c7, "VarDecFromBool"             },
    { 0x00c4, "VarDecFromCy"               },
    { 0x00c3, "VarDecFromDate"             },
    { 0x00c6, "VarDecFromDisp"             },
    { 0x00f1, "VarDecFromI1"               },
    { 0x00bf, "VarDecFromI2"               },
    { 0x00c0, "VarDecFromI4"               },
    { 0x0176, "VarDecFromI8"               },
    { 0x00c1, "VarDecFromR4"               },
    { 0x00c2, "VarDecFromR8"               },
    { 0x00c5, "VarDecFromStr"              },
    { 0x00be, "VarDecFromUI1"              },
    { 0x00f2, "VarDecFromUI2"              },
    { 0x00f3, "VarDecFromUI4"              },
    { 0x0177, "VarDecFromUI8"              },
    { 0x00bc, "VarDecInt"                  },
    { 0x00b3, "VarDecMul"                  },
    { 0x00bd, "VarDecNeg"                  },
    { 0x00cb, "VarDecRound"                },
    { 0x00b5, "VarDecSub"                  },
    { 0x008f, "VarDiv"                     },
    { 0x0098, "VarEqv"                     },
    { 0x00a9, "VarFix"                     },
    { 0x0057, "VarFormat"                  },
    { 0x007f, "VarFormatCurrency"          },
    { 0x0061, "VarFormatDateTime"          },
    { 0x008b, "VarFormatFromTokens"        },
    { 0x006b, "VarFormatNumber"            },
    { 0x0075, "VarFormatPercent"           },
    { 0x00fd, "VarI1FromBool"              },
    { 0x00fa, "VarI1FromCy"                },
    { 0x00f9, "VarI1FromDate"              },
    { 0x0100, "VarI1FromDec"               },
    { 0x00fc, "VarI1FromDisp"              },
    { 0x00f5, "VarI1FromI2"                },
    { 0x00f6, "VarI1FromI4"                },
    { 0x0178, "VarI1FromI8"                },
    { 0x00f7, "VarI1FromR4"                },
    { 0x00f8, "VarI1FromR8"                },
    { 0x00fb, "VarI1FromStr"               },
    { 0x00f4, "VarI1FromUI1"               },
    { 0x00fe, "VarI1FromUI2"               },
    { 0x00ff, "VarI1FromUI4"               },
    { 0x0179, "VarI1FromUI8"               },
    { 0x0038, "VarI2FromBool"              },
    { 0x0034, "VarI2FromCy"                },
    { 0x0035, "VarI2FromDate"              },
    { 0x00d0, "VarI2FromDec"               },
    { 0x0037, "VarI2FromDisp"              },
    { 0x00cd, "VarI2FromI1"                },
    { 0x0031, "VarI2FromI4"                },
    { 0x015a, "VarI2FromI8"                },
    { 0x0032, "VarI2FromR4"                },
    { 0x0033, "VarI2FromR8"                },
    { 0x0036, "VarI2FromStr"               },
    { 0x0030, "VarI2FromUI1"               },
    { 0x00ce, "VarI2FromUI2"               },
    { 0x00cf, "VarI2FromUI4"               },
    { 0x015b, "VarI2FromUI8"               },
    { 0x0042, "VarI4FromBool"              },
    { 0x003e, "VarI4FromCy"                },
    { 0x003f, "VarI4FromDate"              },
    { 0x00d4, "VarI4FromDec"               },
    { 0x0041, "VarI4FromDisp"              },
    { 0x00d1, "VarI4FromI1"                },
    { 0x003b, "VarI4FromI2"                },
    { 0x015c, "VarI4FromI8"                },
    { 0x003c, "VarI4FromR4"                },
    { 0x003d, "VarI4FromR8"                },
    { 0x0040, "VarI4FromStr"               },
    { 0x003a, "VarI4FromUI1"               },
    { 0x00d2, "VarI4FromUI2"               },
    { 0x00d3, "VarI4FromUI4"               },
    { 0x015d, "VarI4FromUI8"               },
    { 0x0155, "VarI8FromBool"              },
    { 0x0151, "VarI8FromCy"                },
    { 0x0152, "VarI8FromDate"              },
    { 0x0159, "VarI8FromDec"               },
    { 0x0154, "VarI8FromDisp"              },
    { 0x0156, "VarI8FromI1"                },
    { 0x014e, "VarI8FromI2"                },
    { 0x014f, "VarI8FromR4"                },
    { 0x0150, "VarI8FromR8"                },
    { 0x0153, "VarI8FromStr"               },
    { 0x014d, "VarI8FromUI1"               },
    { 0x0157, "VarI8FromUI2"               },
    { 0x0158, "VarI8FromUI4"               },
    { 0x01ab, "VarI8FromUI8"               },
    { 0x0099, "VarIdiv"                    },
    { 0x009a, "VarImp"                     },
    { 0x00ac, "VarInt"                     },
    { 0x009b, "VarMod"                     },
    { 0x0081, "VarMonthName"               },
    { 0x009c, "VarMul"                     },
    { 0x00ad, "VarNeg"                     },
    { 0x00ae, "VarNot"                     },
    { 0x002f, "VarNumFromParseNum"         },
    { 0x009d, "VarOr"                      },
    { 0x002e, "VarParseNumFromStr"         },
    { 0x009e, "VarPow"                     },
    { 0x013c, "VarR4CmpR8"                 },
    { 0x004c, "VarR4FromBool"              },
    { 0x0048, "VarR4FromCy"                },
    { 0x0049, "VarR4FromDate"              },
    { 0x00d8, "VarR4FromDec"               },
    { 0x004b, "VarR4FromDisp"              },
    { 0x00d5, "VarR4FromI1"                },
    { 0x0045, "VarR4FromI2"                },
    { 0x0046, "VarR4FromI4"                },
    { 0x0168, "VarR4FromI8"                },
    { 0x0047, "VarR4FromR8"                },
    { 0x004a, "VarR4FromStr"               },
    { 0x0044, "VarR4FromUI1"               },
    { 0x00d6, "VarR4FromUI2"               },
    { 0x00d7, "VarR4FromUI4"               },
    { 0x0169, "VarR4FromUI8"               },
    { 0x0056, "VarR8FromBool"              },
    { 0x0052, "VarR8FromCy"                },
    { 0x0053, "VarR8FromDate"              },
    { 0x00dc, "VarR8FromDec"               },
    { 0x0055, "VarR8FromDisp"              },
    { 0x00d9, "VarR8FromI1"                },
    { 0x004f, "VarR8FromI2"                },
    { 0x0050, "VarR8FromI4"                },
    { 0x016a, "VarR8FromI8"                },
    { 0x0051, "VarR8FromR4"                },
    { 0x0054, "VarR8FromStr"               },
    { 0x004e, "VarR8FromUI1"               },
    { 0x00da, "VarR8FromUI2"               },
    { 0x00db, "VarR8FromUI4"               },
    { 0x016b, "VarR8FromUI8"               },
    { 0x013b, "VarR8Pow"                   },
    { 0x013d, "VarR8Round"                 },
    { 0x00af, "VarRound"                   },
    { 0x009f, "VarSub"                     },
    { 0x008c, "VarTokenizeFormatString"    },
    { 0x008a, "VarUI1FromBool"             },
    { 0x0086, "VarUI1FromCy"               },
    { 0x0087, "VarUI1FromDate"             },
    { 0x00f0, "VarUI1FromDec"              },
    { 0x0089, "VarUI1FromDisp"             },
    { 0x00ed, "VarUI1FromI1"               },
    { 0x0082, "VarUI1FromI2"               },
    { 0x0083, "VarUI1FromI4"               },
    { 0x0174, "VarUI1FromI8"               },
    { 0x0084, "VarUI1FromR4"               },
    { 0x0085, "VarUI1FromR8"               },
    { 0x0088, "VarUI1FromStr"              },
    { 0x00ee, "VarUI1FromUI2"              },
    { 0x00ef, "VarUI1FromUI4"              },
    { 0x0175, "VarUI1FromUI8"              },
    { 0x010a, "VarUI2FromBool"             },
    { 0x0107, "VarUI2FromCy"               },
    { 0x0106, "VarUI2FromDate"             },
    { 0x010d, "VarUI2FromDec"              },
    { 0x0109, "VarUI2FromDisp"             },
    { 0x010b, "VarUI2FromI1"               },
    { 0x0102, "VarUI2FromI2"               },
    { 0x0103, "VarUI2FromI4"               },
    { 0x017a, "VarUI2FromI8"               },
    { 0x0104, "VarUI2FromR4"               },
    { 0x0105, "VarUI2FromR8"               },
    { 0x0108, "VarUI2FromStr"              },
    { 0x0101, "VarUI2FromUI1"              },
    { 0x010c, "VarUI2FromUI4"              },
    { 0x017b, "VarUI2FromUI8"              },
    { 0x0117, "VarUI4FromBool"             },
    { 0x0114, "VarUI4FromCy"               },
    { 0x0113, "VarUI4FromDate"             },
    { 0x011a, "VarUI4FromDec"              },
    { 0x0116, "VarUI4FromDisp"             },
    { 0x0118, "VarUI4FromI1"               },
    { 0x010f, "VarUI4FromI2"               },
    { 0x0110, "VarUI4FromI4"               },
    { 0x01a9, "VarUI4FromI8"               },
    { 0x0111, "VarUI4FromR4"               },
    { 0x0112, "VarUI4FromR8"               },
    { 0x0115, "VarUI4FromStr"              },
    { 0x010e, "VarUI4FromUI1"              },
    { 0x0119, "VarUI4FromUI2"              },
    { 0x01aa, "VarUI4FromUI8"              },
    { 0x01b5, "VarUI8FromBool"             },
    { 0x01b1, "VarUI8FromCy"               },
    { 0x01b2, "VarUI8FromDate"             },
    { 0x01b9, "VarUI8FromDec"              },
    { 0x01b4, "VarUI8FromDisp"             },
    { 0x01b6, "VarUI8FromI1"               },
    { 0x01ae, "VarUI8FromI2"               },
    { 0x01ac, "VarUI8FromI8"               },
    { 0x01af, "VarUI8FromR4"               },
    { 0x01b0, "VarUI8FromR8"               },
    { 0x01b3, "VarUI8FromStr"              },
    { 0x01ad, "VarUI8FromUI1"              },
    { 0x01b7, "VarUI8FromUI2"              },
    { 0x01b8, "VarUI8FromUI4"              },
    { 0x014b, "VarUdateFromDate"           },
    { 0x0080, "VarWeekdayName"             },
    { 0x00a7, "VarXor"                     },
    { 0x000c, "VariantChangeType"          },
    { 0x0093, "VariantChangeTypeEx"        },
    { 0x0009, "VariantClear"               },
    { 0x000a, "VariantCopy"                },
    { 0x000b, "VariantCopyInd"             },
    { 0x0008, "VariantInit"                },
    { 0x000d, "VariantTimeToDosDateTime"   },
    { 0x00b9, "VariantTimeToSystemTime"    },
    { 0x019d, "VectorFromBstr"             },
};


}
}

#endif

