*
* $Id: fxvsof.F,v 1.1.1.3 1996/11/15 17:32:51 cernlib Exp $
*
* $Log: fxvsof.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:51  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:07:18  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:21  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXVSOF(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.6673E-02,0.7137E-02,0.7633E-02,0.8164E-02,0.8732E-02,0.9339E-02,
     +0.9989E-02,0.1068E-01,0.1143E-01,0.1222E-01,0.1307E-01,0.1398E-01,
     +0.1495E-01,0.1599E-01,0.1710E-01,0.1829E-01,0.1956E-01,0.2091E-01,
     +0.2237E-01,0.2392E-01,0.2558E-01,0.2735E-01,0.2925E-01,0.3127E-01,
     +0.3344E-01,0.3576E-01,0.3823E-01,0.4088E-01,0.4370E-01,0.4672E-01,
     +0.4994E-01,0.5339E-01,0.5706E-01,0.6099E-01,0.6518E-01,0.6965E-01,
     +0.7443E-01,0.7952E-01,0.8495E-01,0.9074E-01,0.9691E-01,0.1035E+00,
     +0.1105E+00,0.1179E+00,0.1258E+00,0.1343E+00,0.1432E+00,0.1527E+00,
     +0.1628E+00,0.1734E+00,0.1847E+00,0.1966E+00,0.2092E+00,0.2225E+00,
     +0.2365E+00,0.2511E+00,0.2665E+00,0.2826E+00,0.2993E+00,0.3167E+00,
     +0.3347E+00,0.3533E+00,0.3724E+00,0.3919E+00,0.4116E+00,0.4315E+00,
     +0.4514E+00,0.4710E+00,0.4901E+00,0.5085E+00,0.5258E+00,0.5416E+00,
     +0.5556E+00,0.5673E+00,0.5764E+00,0.5822E+00,0.5844E+00,0.5825E+00,
     +0.5761E+00,0.5649E+00,0.5487E+00,0.5273E+00,0.5008E+00,0.4695E+00,
     +0.4337E+00,0.3942E+00,0.3515E+00,0.3066E+00,0.2603E+00,0.2133E+00,
     +0.1850E+00,0.1587E+00,0.1343E+00,0.1117E+00,0.9112E-01,0.7247E-01,
     +0.5589E-01,0.4143E-01,0.2919E-01,0.1922E-01,0.1149E-01,0.5958E-02,
     +0.2433E-02,0.6116E-03/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.3790E-02,0.4054E-02,0.4335E-02,0.4637E-02,0.4959E-02,0.5304E-02,
     +0.5673E-02,0.6067E-02,0.6489E-02,0.6940E-02,0.7422E-02,0.7938E-02,
     +0.8490E-02,0.9079E-02,0.9710E-02,0.1038E-01,0.1110E-01,0.1188E-01,
     +0.1270E-01,0.1358E-01,0.1452E-01,0.1553E-01,0.1660E-01,0.1775E-01,
     +0.1898E-01,0.2030E-01,0.2170E-01,0.2320E-01,0.2480E-01,0.2651E-01,
     +0.2834E-01,0.3029E-01,0.3237E-01,0.3459E-01,0.3696E-01,0.3949E-01,
     +0.4219E-01,0.4506E-01,0.4813E-01,0.5139E-01,0.5487E-01,0.5857E-01,
     +0.6251E-01,0.6669E-01,0.7114E-01,0.7586E-01,0.8086E-01,0.8617E-01,
     +0.9178E-01,0.9772E-01,0.1040E+00,0.1106E+00,0.1175E+00,0.1249E+00,
     +0.1325E+00,0.1405E+00,0.1489E+00,0.1576E+00,0.1666E+00,0.1759E+00,
     +0.1854E+00,0.1952E+00,0.2051E+00,0.2150E+00,0.2250E+00,0.2349E+00,
     +0.2445E+00,0.2538E+00,0.2625E+00,0.2706E+00,0.2777E+00,0.2837E+00,
     +0.2884E+00,0.2915E+00,0.2927E+00,0.2919E+00,0.2887E+00,0.2831E+00,
     +0.2748E+00,0.2639E+00,0.2503E+00,0.2341E+00,0.2155E+00,0.1950E+00,
     +0.1729E+00,0.1499E+00,0.1265E+00,0.1034E+00,0.8118E-01,0.6057E-01,
     +0.4917E-01,0.3928E-01,0.3078E-01,0.2357E-01,0.1756E-01,0.1264E-01,
     +0.8729E-02,0.5715E-02,0.3494E-02,0.1949E-02,0.9561E-03,0.3867E-03,
     +0.1135E-03,0.1741E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.7804E+01,0.7693E+01,0.7584E+01,0.7477E+01,0.7371E+01,0.7267E+01,
     +0.7165E+01,0.7064E+01,0.6966E+01,0.6869E+01,0.6773E+01,0.6680E+01,
     +0.6588E+01,0.6498E+01,0.6410E+01,0.6323E+01,0.6238E+01,0.6154E+01,
     +0.6073E+01,0.5993E+01,0.5915E+01,0.5838E+01,0.5763E+01,0.5690E+01,
     +0.5618E+01,0.5549E+01,0.5481E+01,0.5414E+01,0.5350E+01,0.5287E+01,
     +0.5226E+01,0.5166E+01,0.5108E+01,0.5052E+01,0.4997E+01,0.4944E+01,
     +0.4893E+01,0.4843E+01,0.4794E+01,0.4747E+01,0.4701E+01,0.4656E+01,
     +0.4612E+01,0.4569E+01,0.4526E+01,0.4484E+01,0.4443E+01,0.4401E+01,
     +0.4360E+01,0.4317E+01,0.4274E+01,0.4230E+01,0.4184E+01,0.4136E+01,
     +0.4085E+01,0.4032E+01,0.3975E+01,0.3914E+01,0.3848E+01,0.3778E+01,
     +0.3702E+01,0.3619E+01,0.3530E+01,0.3434E+01,0.3330E+01,0.3218E+01,
     +0.3098E+01,0.2970E+01,0.2833E+01,0.2688E+01,0.2536E+01,0.2376E+01,
     +0.2210E+01,0.2038E+01,0.1863E+01,0.1685E+01,0.1506E+01,0.1329E+01,
     +0.1155E+01,0.9871E+00,0.8276E+00,0.6786E+00,0.5424E+00,0.4207E+00,
     +0.3151E+00,0.2262E+00,0.1544E+00,0.9896E-01,0.5864E-01,0.3139E-01,
     +0.2024E-01,0.1269E-01,0.7695E-02,0.4490E-02,0.2502E-02,0.1318E-02,
     +0.6487E-03,0.2929E-03,0.1183E-03,0.4116E-04,0.1161E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6995E+00,0.6995E+00,0.6994E+00,0.6994E+00,0.6993E+00,0.6992E+00,
     +0.6991E+00,0.6991E+00,0.6989E+00,0.6989E+00,0.6987E+00,0.6986E+00,
     +0.6985E+00,0.6983E+00,0.6981E+00,0.6979E+00,0.6976E+00,0.6974E+00,
     +0.6971E+00,0.6968E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6911E+00,
     +0.6902E+00,0.6891E+00,0.6879E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6818E+00,0.6799E+00,0.6777E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5133E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3374E-04,0.1183E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2914E+00,
     +0.2913E+00,0.2913E+00,0.2912E+00,0.2912E+00,0.2911E+00,0.2911E+00,
     +0.2910E+00,0.2909E+00,0.2909E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2903E+00,0.2902E+00,0.2900E+00,0.2899E+00,0.2897E+00,
     +0.2895E+00,0.2892E+00,0.2889E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1670E-02,
     +0.1016E-02,0.5892E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1406E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1165E+00,0.1165E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6678E-03,
     +0.4064E-03,0.2357E-03,0.1295E-03,0.6680E-04,0.3207E-04,0.1414E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.7689E-02,0.8219E-02,0.8786E-02,0.9392E-02,0.1004E-01,0.1073E-01,
     +0.1147E-01,0.1226E-01,0.1311E-01,0.1401E-01,0.1497E-01,0.1600E-01,
     +0.1710E-01,0.1827E-01,0.1953E-01,0.2087E-01,0.2230E-01,0.2383E-01,
     +0.2546E-01,0.2720E-01,0.2906E-01,0.3105E-01,0.3316E-01,0.3543E-01,
     +0.3784E-01,0.4041E-01,0.4316E-01,0.4609E-01,0.4921E-01,0.5254E-01,
     +0.5610E-01,0.5988E-01,0.6392E-01,0.6821E-01,0.7279E-01,0.7766E-01,
     +0.8285E-01,0.8837E-01,0.9424E-01,0.1005E+00,0.1071E+00,0.1141E+00,
     +0.1216E+00,0.1296E+00,0.1380E+00,0.1469E+00,0.1563E+00,0.1662E+00,
     +0.1768E+00,0.1879E+00,0.1996E+00,0.2119E+00,0.2248E+00,0.2384E+00,
     +0.2526E+00,0.2675E+00,0.2829E+00,0.2990E+00,0.3156E+00,0.3328E+00,
     +0.3504E+00,0.3685E+00,0.3868E+00,0.4054E+00,0.4241E+00,0.4426E+00,
     +0.4609E+00,0.4787E+00,0.4957E+00,0.5118E+00,0.5264E+00,0.5394E+00,
     +0.5503E+00,0.5588E+00,0.5643E+00,0.5666E+00,0.5652E+00,0.5598E+00,
     +0.5499E+00,0.5355E+00,0.5164E+00,0.4926E+00,0.4643E+00,0.4317E+00,
     +0.3955E+00,0.3561E+00,0.3144E+00,0.2712E+00,0.2272E+00,0.1834E+00,
     +0.1574E+00,0.1335E+00,0.1116E+00,0.9169E-01,0.7373E-01,0.5777E-01,
     +0.4382E-01,0.3190E-01,0.2203E-01,0.1417E-01,0.8254E-02,0.4141E-02,
     +0.1622E-02,0.3835E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.4363E-02,0.4664E-02,0.4985E-02,0.5329E-02,0.5696E-02,0.6088E-02,
     +0.6508E-02,0.6955E-02,0.7434E-02,0.7945E-02,0.8491E-02,0.9074E-02,
     +0.9697E-02,0.1036E-01,0.1107E-01,0.1183E-01,0.1264E-01,0.1351E-01,
     +0.1443E-01,0.1542E-01,0.1647E-01,0.1759E-01,0.1879E-01,0.2007E-01,
     +0.2143E-01,0.2289E-01,0.2444E-01,0.2610E-01,0.2786E-01,0.2974E-01,
     +0.3174E-01,0.3388E-01,0.3615E-01,0.3857E-01,0.4115E-01,0.4389E-01,
     +0.4681E-01,0.4991E-01,0.5321E-01,0.5671E-01,0.6042E-01,0.6436E-01,
     +0.6854E-01,0.7297E-01,0.7766E-01,0.8262E-01,0.8785E-01,0.9338E-01,
     +0.9921E-01,0.1053E+00,0.1118E+00,0.1185E+00,0.1256E+00,0.1330E+00,
     +0.1407E+00,0.1487E+00,0.1570E+00,0.1656E+00,0.1744E+00,0.1835E+00,
     +0.1927E+00,0.2020E+00,0.2113E+00,0.2207E+00,0.2299E+00,0.2388E+00,
     +0.2474E+00,0.2555E+00,0.2630E+00,0.2696E+00,0.2752E+00,0.2795E+00,
     +0.2824E+00,0.2837E+00,0.2831E+00,0.2804E+00,0.2755E+00,0.2682E+00,
     +0.2585E+00,0.2463E+00,0.2318E+00,0.2150E+00,0.1963E+00,0.1760E+00,
     +0.1546E+00,0.1326E+00,0.1107E+00,0.8934E-01,0.6919E-01,0.5079E-01,
     +0.4077E-01,0.3218E-01,0.2491E-01,0.1882E-01,0.1382E-01,0.9799E-02,
     +0.6653E-02,0.4277E-02,0.2562E-02,0.1396E-02,0.6668E-03,0.2611E-03,
     +0.7344E-04,0.1060E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.1965E+02,0.1923E+02,0.1882E+02,0.1842E+02,0.1802E+02,0.1763E+02,
     +0.1725E+02,0.1688E+02,0.1651E+02,0.1615E+02,0.1579E+02,0.1544E+02,
     +0.1510E+02,0.1476E+02,0.1443E+02,0.1410E+02,0.1378E+02,0.1347E+02,
     +0.1316E+02,0.1286E+02,0.1257E+02,0.1228E+02,0.1199E+02,0.1171E+02,
     +0.1144E+02,0.1117E+02,0.1091E+02,0.1065E+02,0.1040E+02,0.1015E+02,
     +0.9905E+01,0.9667E+01,0.9433E+01,0.9205E+01,0.8981E+01,0.8761E+01,
     +0.8546E+01,0.8335E+01,0.8129E+01,0.7926E+01,0.7728E+01,0.7533E+01,
     +0.7342E+01,0.7155E+01,0.6971E+01,0.6790E+01,0.6612E+01,0.6436E+01,
     +0.6263E+01,0.6092E+01,0.5923E+01,0.5756E+01,0.5589E+01,0.5424E+01,
     +0.5259E+01,0.5094E+01,0.4929E+01,0.4763E+01,0.4596E+01,0.4428E+01,
     +0.4258E+01,0.4086E+01,0.3912E+01,0.3735E+01,0.3556E+01,0.3373E+01,
     +0.3188E+01,0.3001E+01,0.2811E+01,0.2619E+01,0.2426E+01,0.2232E+01,
     +0.2039E+01,0.1846E+01,0.1657E+01,0.1471E+01,0.1291E+01,0.1118E+01,
     +0.9536E+00,0.7996E+00,0.6574E+00,0.5286E+00,0.4141E+00,0.3147E+00,
     +0.2309E+00,0.1624E+00,0.1086E+00,0.6833E-01,0.3983E-01,0.2110E-01,
     +0.1358E-01,0.8550E-02,0.5247E-02,0.3129E-02,0.1806E-02,0.1005E-02,
     +0.5350E-03,0.2707E-03,0.1287E-03,0.5645E-04,0.2212E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.1411E+01,0.1397E+01,0.1384E+01,0.1371E+01,0.1358E+01,0.1345E+01,
     +0.1333E+01,0.1320E+01,0.1308E+01,0.1296E+01,0.1285E+01,0.1273E+01,
     +0.1262E+01,0.1251E+01,0.1240E+01,0.1229E+01,0.1218E+01,0.1208E+01,
     +0.1197E+01,0.1187E+01,0.1177E+01,0.1167E+01,0.1157E+01,0.1147E+01,
     +0.1137E+01,0.1128E+01,0.1118E+01,0.1108E+01,0.1099E+01,0.1090E+01,
     +0.1080E+01,0.1071E+01,0.1061E+01,0.1051E+01,0.1042E+01,0.1032E+01,
     +0.1022E+01,0.1012E+01,0.1002E+01,0.9915E+00,0.9809E+00,0.9699E+00,
     +0.9586E+00,0.9470E+00,0.9350E+00,0.9225E+00,0.9095E+00,0.8960E+00,
     +0.8819E+00,0.8671E+00,0.8517E+00,0.8355E+00,0.8185E+00,0.8006E+00,
     +0.7819E+00,0.7622E+00,0.7415E+00,0.7198E+00,0.6971E+00,0.6732E+00,
     +0.6483E+00,0.6224E+00,0.5953E+00,0.5673E+00,0.5384E+00,0.5086E+00,
     +0.4781E+00,0.4471E+00,0.4157E+00,0.3841E+00,0.3526E+00,0.3214E+00,
     +0.2907E+00,0.2610E+00,0.2324E+00,0.2051E+00,0.1794E+00,0.1555E+00,
     +0.1334E+00,0.1131E+00,0.9463E-01,0.7794E-01,0.6291E-01,0.4948E-01,
     +0.3761E-01,0.2732E-01,0.1869E-01,0.1182E-01,0.6731E-02,0.3330E-02,
     +0.1995E-02,0.1140E-02,0.6177E-03,0.3148E-03,0.1495E-03,0.6533E-04,
     +0.2586E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.4519E+00,0.4489E+00,0.4458E+00,0.4429E+00,0.4400E+00,0.4371E+00,
     +0.4343E+00,0.4315E+00,0.4288E+00,0.4261E+00,0.4235E+00,0.4209E+00,
     +0.4183E+00,0.4158E+00,0.4132E+00,0.4108E+00,0.4083E+00,0.4059E+00,
     +0.4035E+00,0.4012E+00,0.3988E+00,0.3965E+00,0.3942E+00,0.3919E+00,
     +0.3895E+00,0.3873E+00,0.3850E+00,0.3826E+00,0.3803E+00,0.3780E+00,
     +0.3757E+00,0.3733E+00,0.3709E+00,0.3684E+00,0.3659E+00,0.3634E+00,
     +0.3607E+00,0.3580E+00,0.3553E+00,0.3524E+00,0.3494E+00,0.3463E+00,
     +0.3430E+00,0.3396E+00,0.3360E+00,0.3323E+00,0.3283E+00,0.3241E+00,
     +0.3197E+00,0.3150E+00,0.3101E+00,0.3048E+00,0.2993E+00,0.2933E+00,
     +0.2871E+00,0.2804E+00,0.2734E+00,0.2659E+00,0.2580E+00,0.2497E+00,
     +0.2409E+00,0.2317E+00,0.2221E+00,0.2121E+00,0.2016E+00,0.1908E+00,
     +0.1797E+00,0.1684E+00,0.1568E+00,0.1452E+00,0.1335E+00,0.1220E+00,
     +0.1106E+00,0.9951E-01,0.8883E-01,0.7863E-01,0.6900E-01,0.6000E-01,
     +0.5167E-01,0.4400E-01,0.3700E-01,0.3062E-01,0.2485E-01,0.1964E-01,
     +0.1500E-01,0.1095E-01,0.7524E-02,0.4774E-02,0.2726E-02,0.1351E-02,
     +0.8096E-03,0.4627E-03,0.2505E-03,0.1275E-03,0.6041E-04,0.2630E-04,
     +0.1035E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.2770E+00,0.2740E+00,0.2710E+00,0.2681E+00,0.2652E+00,0.2624E+00,
     +0.2596E+00,0.2569E+00,0.2542E+00,0.2515E+00,0.2489E+00,0.2464E+00,
     +0.2439E+00,0.2414E+00,0.2389E+00,0.2365E+00,0.2342E+00,0.2318E+00,
     +0.2295E+00,0.2273E+00,0.2250E+00,0.2228E+00,0.2206E+00,0.2185E+00,
     +0.2164E+00,0.2142E+00,0.2121E+00,0.2101E+00,0.2080E+00,0.2059E+00,
     +0.2039E+00,0.2018E+00,0.1998E+00,0.1978E+00,0.1957E+00,0.1936E+00,
     +0.1915E+00,0.1894E+00,0.1873E+00,0.1851E+00,0.1829E+00,0.1806E+00,
     +0.1783E+00,0.1759E+00,0.1735E+00,0.1709E+00,0.1683E+00,0.1656E+00,
     +0.1628E+00,0.1599E+00,0.1569E+00,0.1537E+00,0.1504E+00,0.1469E+00,
     +0.1433E+00,0.1395E+00,0.1356E+00,0.1314E+00,0.1271E+00,0.1226E+00,
     +0.1180E+00,0.1131E+00,0.1081E+00,0.1028E+00,0.9748E-01,0.9198E-01,
     +0.8636E-01,0.8065E-01,0.7489E-01,0.6911E-01,0.6335E-01,0.5766E-01,
     +0.5209E-01,0.4669E-01,0.4149E-01,0.3655E-01,0.3190E-01,0.2757E-01,
     +0.2358E-01,0.1993E-01,0.1662E-01,0.1364E-01,0.1096E-01,0.8587E-02,
     +0.6500E-02,0.4705E-02,0.3209E-02,0.2023E-02,0.1150E-02,0.5678E-03,
     +0.3400E-03,0.1943E-03,0.1053E-03,0.5373E-04,0.2555E-04,0.1120E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.1604E+00,0.1574E+00,0.1545E+00,0.1516E+00,0.1487E+00,0.1459E+00,
     +0.1432E+00,0.1404E+00,0.1378E+00,0.1352E+00,0.1326E+00,0.1301E+00,
     +0.1276E+00,0.1251E+00,0.1227E+00,0.1204E+00,0.1181E+00,0.1158E+00,
     +0.1135E+00,0.1113E+00,0.1092E+00,0.1071E+00,0.1050E+00,0.1029E+00,
     +0.1009E+00,0.9890E-01,0.9694E-01,0.9501E-01,0.9311E-01,0.9124E-01,
     +0.8939E-01,0.8756E-01,0.8576E-01,0.8397E-01,0.8221E-01,0.8046E-01,
     +0.7872E-01,0.7700E-01,0.7529E-01,0.7359E-01,0.7189E-01,0.7020E-01,
     +0.6850E-01,0.6681E-01,0.6511E-01,0.6341E-01,0.6169E-01,0.5997E-01,
     +0.5824E-01,0.5649E-01,0.5472E-01,0.5294E-01,0.5114E-01,0.4931E-01,
     +0.4747E-01,0.4560E-01,0.4372E-01,0.4181E-01,0.3988E-01,0.3794E-01,
     +0.3598E-01,0.3400E-01,0.3202E-01,0.3004E-01,0.2805E-01,0.2607E-01,
     +0.2411E-01,0.2217E-01,0.2026E-01,0.1838E-01,0.1656E-01,0.1479E-01,
     +0.1309E-01,0.1147E-01,0.9936E-02,0.8501E-02,0.7171E-02,0.5955E-02,
     +0.4858E-02,0.3884E-02,0.3035E-02,0.2311E-02,0.1706E-02,0.1216E-02,
     +0.8319E-03,0.5416E-03,0.3323E-03,0.1896E-03,0.9885E-04,0.4592E-04,
     +0.2698E-04,0.1542E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.6955E-01,0.6810E-01,0.6668E-01,0.6527E-01,0.6390E-01,0.6257E-01,
     +0.6123E-01,0.5991E-01,0.5862E-01,0.5737E-01,0.5613E-01,0.5491E-01,
     +0.5371E-01,0.5254E-01,0.5139E-01,0.5026E-01,0.4914E-01,0.4805E-01,
     +0.4698E-01,0.4592E-01,0.4488E-01,0.4387E-01,0.4287E-01,0.4189E-01,
     +0.4092E-01,0.3997E-01,0.3904E-01,0.3812E-01,0.3722E-01,0.3633E-01,
     +0.3546E-01,0.3460E-01,0.3375E-01,0.3292E-01,0.3209E-01,0.3128E-01,
     +0.3048E-01,0.2969E-01,0.2890E-01,0.2813E-01,0.2736E-01,0.2660E-01,
     +0.2584E-01,0.2509E-01,0.2435E-01,0.2360E-01,0.2286E-01,0.2213E-01,
     +0.2139E-01,0.2066E-01,0.1992E-01,0.1919E-01,0.1845E-01,0.1772E-01,
     +0.1698E-01,0.1624E-01,0.1550E-01,0.1477E-01,0.1403E-01,0.1329E-01,
     +0.1255E-01,0.1181E-01,0.1108E-01,0.1035E-01,0.9629E-02,0.8916E-02,
     +0.8213E-02,0.7523E-02,0.6849E-02,0.6192E-02,0.5557E-02,0.4946E-02,
     +0.4362E-02,0.3808E-02,0.3288E-02,0.2803E-02,0.2357E-02,0.1950E-02,
     +0.1586E-02,0.1264E-02,0.9843E-03,0.7469E-03,0.5499E-03,0.3909E-03,
     +0.2667E-03,0.1733E-03,0.1062E-03,0.6063E-04,0.3169E-04,0.1482E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.8739E-02,0.9338E-02,0.9976E-02,0.1066E-01,0.1139E-01,0.1216E-01,
     +0.1299E-01,0.1388E-01,0.1483E-01,0.1584E-01,0.1691E-01,0.1806E-01,
     +0.1929E-01,0.2060E-01,0.2200E-01,0.2349E-01,0.2508E-01,0.2677E-01,
     +0.2858E-01,0.3051E-01,0.3256E-01,0.3475E-01,0.3709E-01,0.3958E-01,
     +0.4223E-01,0.4505E-01,0.4806E-01,0.5126E-01,0.5467E-01,0.5830E-01,
     +0.6216E-01,0.6627E-01,0.7064E-01,0.7528E-01,0.8021E-01,0.8545E-01,
     +0.9102E-01,0.9693E-01,0.1032E+00,0.1098E+00,0.1169E+00,0.1243E+00,
     +0.1322E+00,0.1406E+00,0.1494E+00,0.1587E+00,0.1686E+00,0.1789E+00,
     +0.1898E+00,0.2013E+00,0.2133E+00,0.2259E+00,0.2390E+00,0.2528E+00,
     +0.2671E+00,0.2820E+00,0.2974E+00,0.3134E+00,0.3298E+00,0.3466E+00,
     +0.3637E+00,0.3811E+00,0.3987E+00,0.4163E+00,0.4338E+00,0.4509E+00,
     +0.4676E+00,0.4836E+00,0.4987E+00,0.5124E+00,0.5247E+00,0.5350E+00,
     +0.5431E+00,0.5486E+00,0.5511E+00,0.5502E+00,0.5457E+00,0.5373E+00,
     +0.5247E+00,0.5077E+00,0.4864E+00,0.4608E+00,0.4312E+00,0.3980E+00,
     +0.3617E+00,0.3229E+00,0.2824E+00,0.2410E+00,0.1995E+00,0.1588E+00,
     +0.1349E+00,0.1132E+00,0.9360E-01,0.7597E-01,0.6030E-01,0.4659E-01,
     +0.3480E-01,0.2492E-01,0.1689E-01,0.1064E-01,0.6042E-02,0.2942E-02,
     +0.1108E-02,0.2475E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.4954E-02,0.5293E-02,0.5654E-02,0.6041E-02,0.6453E-02,0.6893E-02,
     +0.7363E-02,0.7864E-02,0.8400E-02,0.8971E-02,0.9580E-02,0.1023E-01,
     +0.1092E-01,0.1166E-01,0.1245E-01,0.1330E-01,0.1419E-01,0.1515E-01,
     +0.1617E-01,0.1726E-01,0.1842E-01,0.1966E-01,0.2097E-01,0.2238E-01,
     +0.2387E-01,0.2546E-01,0.2716E-01,0.2896E-01,0.3088E-01,0.3292E-01,
     +0.3509E-01,0.3739E-01,0.3985E-01,0.4245E-01,0.4522E-01,0.4816E-01,
     +0.5127E-01,0.5458E-01,0.5808E-01,0.6179E-01,0.6571E-01,0.6987E-01,
     +0.7425E-01,0.7889E-01,0.8378E-01,0.8893E-01,0.9436E-01,0.1001E+00,
     +0.1060E+00,0.1123E+00,0.1189E+00,0.1257E+00,0.1329E+00,0.1403E+00,
     +0.1480E+00,0.1560E+00,0.1641E+00,0.1725E+00,0.1811E+00,0.1898E+00,
     +0.1986E+00,0.2075E+00,0.2162E+00,0.2249E+00,0.2333E+00,0.2413E+00,
     +0.2489E+00,0.2559E+00,0.2621E+00,0.2674E+00,0.2716E+00,0.2744E+00,
     +0.2758E+00,0.2755E+00,0.2733E+00,0.2691E+00,0.2627E+00,0.2541E+00,
     +0.2433E+00,0.2302E+00,0.2151E+00,0.1980E+00,0.1794E+00,0.1595E+00,
     +0.1389E+00,0.1180E+00,0.9746E-01,0.7777E-01,0.5945E-01,0.4298E-01,
     +0.3414E-01,0.2665E-01,0.2038E-01,0.1521E-01,0.1102E-01,0.7706E-02,
     +0.5151E-02,0.3256E-02,0.1914E-02,0.1021E-02,0.4755E-03,0.1807E-03,
     +0.4887E-04,0.0000E+00/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.3557E+02,0.3462E+02,0.3369E+02,0.3279E+02,0.3190E+02,0.3103E+02,
     +0.3018E+02,0.2935E+02,0.2854E+02,0.2775E+02,0.2697E+02,0.2621E+02,
     +0.2547E+02,0.2475E+02,0.2404E+02,0.2335E+02,0.2267E+02,0.2201E+02,
     +0.2136E+02,0.2073E+02,0.2012E+02,0.1952E+02,0.1893E+02,0.1836E+02,
     +0.1780E+02,0.1725E+02,0.1672E+02,0.1620E+02,0.1569E+02,0.1519E+02,
     +0.1471E+02,0.1424E+02,0.1378E+02,0.1333E+02,0.1289E+02,0.1247E+02,
     +0.1205E+02,0.1165E+02,0.1125E+02,0.1087E+02,0.1049E+02,0.1012E+02,
     +0.9768E+01,0.9420E+01,0.9081E+01,0.8751E+01,0.8428E+01,0.8113E+01,
     +0.7805E+01,0.7504E+01,0.7210E+01,0.6922E+01,0.6640E+01,0.6364E+01,
     +0.6093E+01,0.5827E+01,0.5566E+01,0.5309E+01,0.5055E+01,0.4805E+01,
     +0.4559E+01,0.4315E+01,0.4075E+01,0.3837E+01,0.3602E+01,0.3369E+01,
     +0.3139E+01,0.2913E+01,0.2689E+01,0.2470E+01,0.2254E+01,0.2044E+01,
     +0.1839E+01,0.1641E+01,0.1450E+01,0.1268E+01,0.1096E+01,0.9341E+00,
     +0.7842E+00,0.6470E+00,0.5234E+00,0.4139E+00,0.3189E+00,0.2384E+00,
     +0.1720E+00,0.1191E+00,0.7847E-01,0.4873E-01,0.2815E-01,0.1487E-01,
     +0.9603E-02,0.6095E-02,0.3793E-02,0.2308E-02,0.1369E-02,0.7876E-03,
     +0.4369E-03,0.2315E-03,0.1154E-03,0.5294E-04,0.2147E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.2835E+01,0.2785E+01,0.2736E+01,0.2688E+01,0.2641E+01,0.2595E+01,
     +0.2550E+01,0.2506E+01,0.2462E+01,0.2420E+01,0.2378E+01,0.2337E+01,
     +0.2297E+01,0.2257E+01,0.2219E+01,0.2181E+01,0.2143E+01,0.2107E+01,
     +0.2071E+01,0.2036E+01,0.2001E+01,0.1968E+01,0.1934E+01,0.1902E+01,
     +0.1869E+01,0.1838E+01,0.1807E+01,0.1776E+01,0.1746E+01,0.1716E+01,
     +0.1687E+01,0.1658E+01,0.1630E+01,0.1601E+01,0.1573E+01,0.1546E+01,
     +0.1518E+01,0.1491E+01,0.1463E+01,0.1436E+01,0.1409E+01,0.1382E+01,
     +0.1354E+01,0.1327E+01,0.1299E+01,0.1271E+01,0.1243E+01,0.1215E+01,
     +0.1186E+01,0.1157E+01,0.1127E+01,0.1096E+01,0.1065E+01,0.1034E+01,
     +0.1001E+01,0.9682E+00,0.9343E+00,0.8996E+00,0.8641E+00,0.8278E+00,
     +0.7907E+00,0.7529E+00,0.7144E+00,0.6752E+00,0.6355E+00,0.5955E+00,
     +0.5552E+00,0.5148E+00,0.4747E+00,0.4349E+00,0.3958E+00,0.3576E+00,
     +0.3207E+00,0.2852E+00,0.2515E+00,0.2197E+00,0.1901E+00,0.1628E+00,
     +0.1379E+00,0.1153E+00,0.9503E-01,0.7699E-01,0.6105E-01,0.4711E-01,
     +0.3510E-01,0.2497E-01,0.1673E-01,0.1035E-01,0.5766E-02,0.2791E-02,
     +0.1650E-02,0.9322E-03,0.4999E-03,0.2526E-03,0.1193E-03,0.5206E-04,
     +0.2073E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.7364E+00,0.7261E+00,0.7160E+00,0.7061E+00,0.6964E+00,0.6868E+00,
     +0.6774E+00,0.6683E+00,0.6592E+00,0.6504E+00,0.6418E+00,0.6333E+00,
     +0.6249E+00,0.6167E+00,0.6086E+00,0.6007E+00,0.5930E+00,0.5853E+00,
     +0.5778E+00,0.5705E+00,0.5632E+00,0.5561E+00,0.5491E+00,0.5422E+00,
     +0.5353E+00,0.5286E+00,0.5220E+00,0.5154E+00,0.5089E+00,0.5025E+00,
     +0.4961E+00,0.4898E+00,0.4835E+00,0.4773E+00,0.4710E+00,0.4648E+00,
     +0.4586E+00,0.4523E+00,0.4460E+00,0.4397E+00,0.4332E+00,0.4268E+00,
     +0.4202E+00,0.4135E+00,0.4067E+00,0.3997E+00,0.3926E+00,0.3853E+00,
     +0.3778E+00,0.3700E+00,0.3620E+00,0.3538E+00,0.3452E+00,0.3364E+00,
     +0.3272E+00,0.3177E+00,0.3079E+00,0.2977E+00,0.2871E+00,0.2761E+00,
     +0.2648E+00,0.2532E+00,0.2411E+00,0.2288E+00,0.2162E+00,0.2033E+00,
     +0.1903E+00,0.1771E+00,0.1640E+00,0.1508E+00,0.1378E+00,0.1250E+00,
     +0.1126E+00,0.1006E+00,0.8913E-01,0.7830E-01,0.6816E-01,0.5876E-01,
     +0.5012E-01,0.4225E-01,0.3512E-01,0.2871E-01,0.2298E-01,0.1790E-01,
     +0.1346E-01,0.9655E-02,0.6515E-02,0.4056E-02,0.2270E-02,0.1101E-02,
     +0.6515E-03,0.3676E-03,0.1967E-03,0.9898E-04,0.4643E-04,0.2006E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.5616E+00,0.5513E+00,0.5412E+00,0.5313E+00,0.5217E+00,0.5122E+00,
     +0.5028E+00,0.4937E+00,0.4847E+00,0.4760E+00,0.4673E+00,0.4589E+00,
     +0.4506E+00,0.4425E+00,0.4345E+00,0.4267E+00,0.4190E+00,0.4115E+00,
     +0.4041E+00,0.3969E+00,0.3898E+00,0.3828E+00,0.3760E+00,0.3693E+00,
     +0.3627E+00,0.3562E+00,0.3498E+00,0.3435E+00,0.3373E+00,0.3312E+00,
     +0.3252E+00,0.3193E+00,0.3134E+00,0.3076E+00,0.3019E+00,0.2963E+00,
     +0.2906E+00,0.2851E+00,0.2795E+00,0.2740E+00,0.2685E+00,0.2630E+00,
     +0.2575E+00,0.2519E+00,0.2464E+00,0.2408E+00,0.2352E+00,0.2295E+00,
     +0.2238E+00,0.2180E+00,0.2121E+00,0.2061E+00,0.2000E+00,0.1938E+00,
     +0.1875E+00,0.1810E+00,0.1745E+00,0.1678E+00,0.1609E+00,0.1540E+00,
     +0.1469E+00,0.1396E+00,0.1323E+00,0.1249E+00,0.1174E+00,0.1098E+00,
     +0.1023E+00,0.9470E-01,0.8718E-01,0.7976E-01,0.7247E-01,0.6537E-01,
     +0.5851E-01,0.5194E-01,0.4570E-01,0.3984E-01,0.3438E-01,0.2935E-01,
     +0.2477E-01,0.2064E-01,0.1694E-01,0.1366E-01,0.1078E-01,0.8280E-02,
     +0.6140E-02,0.4349E-02,0.2901E-02,0.1789E-02,0.9940E-03,0.4803E-03,
     +0.2839E-03,0.1604E-03,0.8611E-04,0.4360E-04,0.2065E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.4450E+00,0.4348E+00,0.4247E+00,0.4149E+00,0.4052E+00,0.3957E+00,
     +0.3864E+00,0.3773E+00,0.3684E+00,0.3597E+00,0.3511E+00,0.3427E+00,
     +0.3344E+00,0.3264E+00,0.3185E+00,0.3107E+00,0.3031E+00,0.2957E+00,
     +0.2884E+00,0.2812E+00,0.2742E+00,0.2673E+00,0.2606E+00,0.2540E+00,
     +0.2475E+00,0.2412E+00,0.2350E+00,0.2289E+00,0.2229E+00,0.2170E+00,
     +0.2112E+00,0.2056E+00,0.2000E+00,0.1946E+00,0.1892E+00,0.1839E+00,
     +0.1787E+00,0.1736E+00,0.1685E+00,0.1636E+00,0.1586E+00,0.1538E+00,
     +0.1490E+00,0.1442E+00,0.1395E+00,0.1349E+00,0.1303E+00,0.1257E+00,
     +0.1211E+00,0.1166E+00,0.1121E+00,0.1076E+00,0.1032E+00,0.9874E-01,
     +0.9432E-01,0.8991E-01,0.8553E-01,0.8116E-01,0.7682E-01,0.7251E-01,
     +0.6822E-01,0.6397E-01,0.5977E-01,0.5562E-01,0.5152E-01,0.4751E-01,
     +0.4357E-01,0.3973E-01,0.3600E-01,0.3240E-01,0.2893E-01,0.2562E-01,
     +0.2247E-01,0.1951E-01,0.1675E-01,0.1419E-01,0.1186E-01,0.9751E-02,
     +0.7875E-02,0.6231E-02,0.4817E-02,0.3626E-02,0.2648E-02,0.1866E-02,
     +0.1261E-02,0.8113E-03,0.4921E-03,0.2778E-03,0.1435E-03,0.6625E-04,
     +0.3890E-04,0.2227E-04,0.1240E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.3557E+00,0.3470E+00,0.3384E+00,0.3300E+00,0.3218E+00,0.3138E+00,
     +0.3059E+00,0.2982E+00,0.2906E+00,0.2832E+00,0.2759E+00,0.2688E+00,
     +0.2618E+00,0.2550E+00,0.2483E+00,0.2418E+00,0.2354E+00,0.2291E+00,
     +0.2229E+00,0.2169E+00,0.2110E+00,0.2052E+00,0.1996E+00,0.1940E+00,
     +0.1886E+00,0.1833E+00,0.1781E+00,0.1730E+00,0.1680E+00,0.1631E+00,
     +0.1583E+00,0.1536E+00,0.1490E+00,0.1445E+00,0.1401E+00,0.1357E+00,
     +0.1315E+00,0.1273E+00,0.1232E+00,0.1191E+00,0.1152E+00,0.1112E+00,
     +0.1074E+00,0.1036E+00,0.9986E-01,0.9618E-01,0.9255E-01,0.8896E-01,
     +0.8542E-01,0.8193E-01,0.7847E-01,0.7505E-01,0.7168E-01,0.6833E-01,
     +0.6503E-01,0.6176E-01,0.5853E-01,0.5533E-01,0.5218E-01,0.4906E-01,
     +0.4599E-01,0.4297E-01,0.4000E-01,0.3708E-01,0.3423E-01,0.3145E-01,
     +0.2874E-01,0.2611E-01,0.2358E-01,0.2114E-01,0.1882E-01,0.1660E-01,
     +0.1452E-01,0.1256E-01,0.1075E-01,0.9076E-02,0.7557E-02,0.6193E-02,
     +0.4985E-02,0.3932E-02,0.3030E-02,0.2274E-02,0.1656E-02,0.1164E-02,
     +0.7849E-03,0.5042E-03,0.3057E-03,0.1727E-03,0.8953E-04,0.4165E-04,
     +0.2464E-04,0.1425E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1060E-01,0.1132E-01,0.1208E-01,0.1290E-01,0.1376E-01,0.1469E-01,
     +0.1567E-01,0.1672E-01,0.1784E-01,0.1904E-01,0.2031E-01,0.2166E-01,
     +0.2311E-01,0.2464E-01,0.2628E-01,0.2802E-01,0.2987E-01,0.3185E-01,
     +0.3395E-01,0.3618E-01,0.3856E-01,0.4109E-01,0.4378E-01,0.4664E-01,
     +0.4967E-01,0.5290E-01,0.5633E-01,0.5997E-01,0.6383E-01,0.6793E-01,
     +0.7228E-01,0.7689E-01,0.8178E-01,0.8696E-01,0.9245E-01,0.9825E-01,
     +0.1044E+00,0.1109E+00,0.1178E+00,0.1250E+00,0.1326E+00,0.1407E+00,
     +0.1492E+00,0.1581E+00,0.1675E+00,0.1774E+00,0.1878E+00,0.1986E+00,
     +0.2100E+00,0.2219E+00,0.2342E+00,0.2471E+00,0.2605E+00,0.2743E+00,
     +0.2886E+00,0.3034E+00,0.3185E+00,0.3340E+00,0.3498E+00,0.3657E+00,
     +0.3819E+00,0.3980E+00,0.4141E+00,0.4299E+00,0.4453E+00,0.4601E+00,
     +0.4742E+00,0.4872E+00,0.4989E+00,0.5092E+00,0.5176E+00,0.5239E+00,
     +0.5277E+00,0.5288E+00,0.5269E+00,0.5216E+00,0.5129E+00,0.5003E+00,
     +0.4840E+00,0.4638E+00,0.4399E+00,0.4123E+00,0.3816E+00,0.3481E+00,
     +0.3124E+00,0.2752E+00,0.2372E+00,0.1991E+00,0.1617E+00,0.1258E+00,
     +0.1052E+00,0.8685E-01,0.7053E-01,0.5617E-01,0.4369E-01,0.3303E-01,
     +0.2409E-01,0.1680E-01,0.1106E-01,0.6738E-02,0.3683E-02,0.1711E-02,
     +0.6062E-03,0.1240E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.6000E-02,0.6404E-02,0.6835E-02,0.7294E-02,0.7784E-02,0.8306E-02,
     +0.8862E-02,0.9455E-02,0.1009E-01,0.1076E-01,0.1148E-01,0.1224E-01,
     +0.1305E-01,0.1392E-01,0.1484E-01,0.1582E-01,0.1686E-01,0.1797E-01,
     +0.1915E-01,0.2041E-01,0.2175E-01,0.2317E-01,0.2468E-01,0.2628E-01,
     +0.2798E-01,0.2979E-01,0.3171E-01,0.3375E-01,0.3591E-01,0.3820E-01,
     +0.4063E-01,0.4321E-01,0.4594E-01,0.4882E-01,0.5188E-01,0.5511E-01,
     +0.5852E-01,0.6213E-01,0.6593E-01,0.6994E-01,0.7417E-01,0.7862E-01,
     +0.8330E-01,0.8821E-01,0.9337E-01,0.9877E-01,0.1044E+00,0.1103E+00,
     +0.1165E+00,0.1229E+00,0.1296E+00,0.1365E+00,0.1436E+00,0.1510E+00,
     +0.1586E+00,0.1663E+00,0.1742E+00,0.1822E+00,0.1903E+00,0.1983E+00,
     +0.2064E+00,0.2143E+00,0.2221E+00,0.2295E+00,0.2366E+00,0.2432E+00,
     +0.2492E+00,0.2544E+00,0.2587E+00,0.2619E+00,0.2639E+00,0.2646E+00,
     +0.2637E+00,0.2611E+00,0.2567E+00,0.2504E+00,0.2422E+00,0.2320E+00,
     +0.2198E+00,0.2058E+00,0.1901E+00,0.1730E+00,0.1548E+00,0.1359E+00,
     +0.1167E+00,0.9770E-01,0.7939E-01,0.6221E-01,0.4659E-01,0.3289E-01,
     +0.2570E-01,0.1972E-01,0.1481E-01,0.1084E-01,0.7692E-02,0.5258E-02,
     +0.3431E-02,0.2112E-02,0.1205E-02,0.6220E-03,0.2786E-03,0.1010E-03,
     +0.2569E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.7099E+02,0.6859E+02,0.6626E+02,0.6400E+02,0.6180E+02,0.5967E+02,
     +0.5759E+02,0.5558E+02,0.5362E+02,0.5172E+02,0.4988E+02,0.4809E+02,
     +0.4636E+02,0.4467E+02,0.4304E+02,0.4145E+02,0.3992E+02,0.3843E+02,
     +0.3698E+02,0.3558E+02,0.3422E+02,0.3290E+02,0.3163E+02,0.3039E+02,
     +0.2920E+02,0.2804E+02,0.2691E+02,0.2583E+02,0.2478E+02,0.2376E+02,
     +0.2277E+02,0.2182E+02,0.2090E+02,0.2001E+02,0.1915E+02,0.1832E+02,
     +0.1751E+02,0.1674E+02,0.1599E+02,0.1526E+02,0.1456E+02,0.1389E+02,
     +0.1324E+02,0.1261E+02,0.1200E+02,0.1141E+02,0.1085E+02,0.1030E+02,
     +0.9776E+01,0.9269E+01,0.8779E+01,0.8307E+01,0.7852E+01,0.7412E+01,
     +0.6988E+01,0.6579E+01,0.6184E+01,0.5803E+01,0.5435E+01,0.5080E+01,
     +0.4738E+01,0.4408E+01,0.4089E+01,0.3782E+01,0.3486E+01,0.3201E+01,
     +0.2927E+01,0.2665E+01,0.2414E+01,0.2174E+01,0.1945E+01,0.1729E+01,
     +0.1524E+01,0.1332E+01,0.1153E+01,0.9872E+00,0.8350E+00,0.6965E+00,
     +0.5721E+00,0.4617E+00,0.3653E+00,0.2826E+00,0.2130E+00,0.1559E+00,
     +0.1102E+00,0.7488E-01,0.4857E-01,0.2981E-01,0.1714E-01,0.9101E-02,
     +0.5937E-02,0.3823E-02,0.2424E-02,0.1509E-02,0.9177E-03,0.5419E-03,
     +0.3080E-03,0.1664E-03,0.8398E-04,0.3853E-04,0.1541E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.6809E+01,0.6630E+01,0.6455E+01,0.6285E+01,0.6118E+01,0.5956E+01,
     +0.5798E+01,0.5644E+01,0.5494E+01,0.5347E+01,0.5204E+01,0.5065E+01,
     +0.4929E+01,0.4796E+01,0.4667E+01,0.4541E+01,0.4419E+01,0.4299E+01,
     +0.4183E+01,0.4069E+01,0.3958E+01,0.3851E+01,0.3745E+01,0.3643E+01,
     +0.3543E+01,0.3445E+01,0.3350E+01,0.3257E+01,0.3167E+01,0.3079E+01,
     +0.2992E+01,0.2908E+01,0.2826E+01,0.2746E+01,0.2667E+01,0.2590E+01,
     +0.2515E+01,0.2441E+01,0.2369E+01,0.2298E+01,0.2229E+01,0.2160E+01,
     +0.2093E+01,0.2027E+01,0.1961E+01,0.1897E+01,0.1833E+01,0.1770E+01,
     +0.1708E+01,0.1646E+01,0.1585E+01,0.1524E+01,0.1464E+01,0.1404E+01,
     +0.1344E+01,0.1284E+01,0.1224E+01,0.1165E+01,0.1106E+01,0.1047E+01,
     +0.9883E+00,0.9298E+00,0.8718E+00,0.8142E+00,0.7572E+00,0.7009E+00,
     +0.6457E+00,0.5915E+00,0.5387E+00,0.4875E+00,0.4381E+00,0.3909E+00,
     +0.3459E+00,0.3036E+00,0.2640E+00,0.2274E+00,0.1938E+00,0.1633E+00,
     +0.1360E+00,0.1116E+00,0.9021E-01,0.7153E-01,0.5543E-01,0.4173E-01,
     +0.3028E-01,0.2096E-01,0.1364E-01,0.8196E-02,0.4430E-02,0.2081E-02,
     +0.1209E-02,0.6723E-03,0.3558E-03,0.1781E-03,0.8373E-04,0.3666E-04,
     +0.1481E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.1531E+01,0.1494E+01,0.1459E+01,0.1425E+01,0.1391E+01,0.1358E+01,
     +0.1326E+01,0.1295E+01,0.1265E+01,0.1235E+01,0.1206E+01,0.1178E+01,
     +0.1151E+01,0.1124E+01,0.1098E+01,0.1072E+01,0.1047E+01,0.1023E+01,
     +0.9993E+00,0.9762E+00,0.9537E+00,0.9317E+00,0.9102E+00,0.8893E+00,
     +0.8688E+00,0.8489E+00,0.8294E+00,0.8103E+00,0.7917E+00,0.7734E+00,
     +0.7556E+00,0.7381E+00,0.7210E+00,0.7042E+00,0.6878E+00,0.6716E+00,
     +0.6557E+00,0.6400E+00,0.6246E+00,0.6093E+00,0.5943E+00,0.5794E+00,
     +0.5647E+00,0.5500E+00,0.5355E+00,0.5210E+00,0.5065E+00,0.4921E+00,
     +0.4777E+00,0.4632E+00,0.4487E+00,0.4341E+00,0.4195E+00,0.4047E+00,
     +0.3898E+00,0.3747E+00,0.3595E+00,0.3442E+00,0.3287E+00,0.3130E+00,
     +0.2972E+00,0.2813E+00,0.2653E+00,0.2492E+00,0.2331E+00,0.2171E+00,
     +0.2011E+00,0.1854E+00,0.1698E+00,0.1546E+00,0.1398E+00,0.1255E+00,
     +0.1118E+00,0.9884E-01,0.8661E-01,0.7521E-01,0.6468E-01,0.5504E-01,
     +0.4631E-01,0.3846E-01,0.3146E-01,0.2527E-01,0.1984E-01,0.1513E-01,
     +0.1112E-01,0.7785E-02,0.5118E-02,0.3099E-02,0.1684E-02,0.7926E-03,
     +0.4600E-03,0.2549E-03,0.1341E-03,0.6646E-04,0.3078E-04,0.1319E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.1356E+01,0.1320E+01,0.1285E+01,0.1250E+01,0.1217E+01,0.1184E+01,
     +0.1152E+01,0.1121E+01,0.1091E+01,0.1061E+01,0.1032E+01,0.1004E+01,
     +0.9767E+00,0.9500E+00,0.9239E+00,0.8986E+00,0.8738E+00,0.8497E+00,
     +0.8262E+00,0.8033E+00,0.7809E+00,0.7592E+00,0.7380E+00,0.7173E+00,
     +0.6971E+00,0.6774E+00,0.6583E+00,0.6396E+00,0.6213E+00,0.6035E+00,
     +0.5862E+00,0.5692E+00,0.5526E+00,0.5364E+00,0.5206E+00,0.5052E+00,
     +0.4900E+00,0.4752E+00,0.4607E+00,0.4465E+00,0.4325E+00,0.4188E+00,
     +0.4053E+00,0.3921E+00,0.3790E+00,0.3662E+00,0.3535E+00,0.3409E+00,
     +0.3285E+00,0.3163E+00,0.3041E+00,0.2921E+00,0.2801E+00,0.2683E+00,
     +0.2565E+00,0.2447E+00,0.2331E+00,0.2215E+00,0.2099E+00,0.1984E+00,
     +0.1870E+00,0.1757E+00,0.1645E+00,0.1534E+00,0.1425E+00,0.1317E+00,
     +0.1211E+00,0.1108E+00,0.1007E+00,0.9100E-01,0.8164E-01,0.7269E-01,
     +0.6421E-01,0.5623E-01,0.4878E-01,0.4190E-01,0.3561E-01,0.2991E-01,
     +0.2480E-01,0.2028E-01,0.1631E-01,0.1287E-01,0.9919E-02,0.7427E-02,
     +0.5362E-02,0.3693E-02,0.2393E-02,0.1432E-02,0.7720E-03,0.3621E-03,
     +0.2105E-03,0.1172E-03,0.6215E-04,0.3122E-04,0.1475E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1239E+01,0.1203E+01,0.1168E+01,0.1134E+01,0.1100E+01,0.1068E+01,
     +0.1036E+01,0.1005E+01,0.9745E+00,0.9450E+00,0.9162E+00,0.8881E+00,
     +0.8608E+00,0.8341E+00,0.8082E+00,0.7829E+00,0.7582E+00,0.7342E+00,
     +0.7108E+00,0.6880E+00,0.6658E+00,0.6442E+00,0.6231E+00,0.6026E+00,
     +0.5826E+00,0.5632E+00,0.5442E+00,0.5257E+00,0.5078E+00,0.4902E+00,
     +0.4732E+00,0.4566E+00,0.4404E+00,0.4246E+00,0.4092E+00,0.3942E+00,
     +0.3796E+00,0.3653E+00,0.3514E+00,0.3379E+00,0.3246E+00,0.3117E+00,
     +0.2991E+00,0.2868E+00,0.2747E+00,0.2629E+00,0.2514E+00,0.2401E+00,
     +0.2291E+00,0.2183E+00,0.2077E+00,0.1974E+00,0.1872E+00,0.1773E+00,
     +0.1676E+00,0.1581E+00,0.1488E+00,0.1397E+00,0.1308E+00,0.1221E+00,
     +0.1136E+00,0.1053E+00,0.9733E-01,0.8955E-01,0.8201E-01,0.7475E-01,
     +0.6776E-01,0.6106E-01,0.5467E-01,0.4860E-01,0.4286E-01,0.3748E-01,
     +0.3246E-01,0.2782E-01,0.2356E-01,0.1970E-01,0.1623E-01,0.1315E-01,
     +0.1047E-01,0.8157E-02,0.6210E-02,0.4602E-02,0.3306E-02,0.2292E-02,
     +0.1524E-02,0.9650E-03,0.5763E-03,0.3208E-03,0.1638E-03,0.7515E-04,
     +0.4410E-04,0.2533E-04,0.1419E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1152E+01,0.1118E+01,0.1084E+01,0.1051E+01,0.1019E+01,0.9879E+00,
     +0.9574E+00,0.9277E+00,0.8987E+00,0.8705E+00,0.8430E+00,0.8162E+00,
     +0.7901E+00,0.7647E+00,0.7399E+00,0.7158E+00,0.6923E+00,0.6694E+00,
     +0.6471E+00,0.6255E+00,0.6043E+00,0.5838E+00,0.5638E+00,0.5443E+00,
     +0.5254E+00,0.5069E+00,0.4890E+00,0.4715E+00,0.4545E+00,0.4380E+00,
     +0.4219E+00,0.4062E+00,0.3910E+00,0.3762E+00,0.3617E+00,0.3477E+00,
     +0.3340E+00,0.3207E+00,0.3077E+00,0.2951E+00,0.2828E+00,0.2708E+00,
     +0.2592E+00,0.2478E+00,0.2367E+00,0.2260E+00,0.2154E+00,0.2052E+00,
     +0.1952E+00,0.1854E+00,0.1759E+00,0.1666E+00,0.1576E+00,0.1488E+00,
     +0.1402E+00,0.1318E+00,0.1236E+00,0.1157E+00,0.1080E+00,0.1005E+00,
     +0.9319E-01,0.8613E-01,0.7932E-01,0.7273E-01,0.6640E-01,0.6032E-01,
     +0.5450E-01,0.4895E-01,0.4368E-01,0.3870E-01,0.3402E-01,0.2965E-01,
     +0.2560E-01,0.2186E-01,0.1846E-01,0.1538E-01,0.1263E-01,0.1021E-01,
     +0.8096E-02,0.6291E-02,0.4775E-02,0.3529E-02,0.2529E-02,0.1749E-02,
     +0.1161E-02,0.7347E-03,0.4389E-03,0.2448E-03,0.1257E-03,0.5816E-04,
     +0.3442E-04,0.1997E-04,0.1133E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1231E-01,0.1313E-01,0.1401E-01,0.1494E-01,0.1593E-01,0.1698E-01,
     +0.1810E-01,0.1930E-01,0.2057E-01,0.2193E-01,0.2337E-01,0.2490E-01,
     +0.2653E-01,0.2826E-01,0.3010E-01,0.3206E-01,0.3414E-01,0.3636E-01,
     +0.3870E-01,0.4120E-01,0.4385E-01,0.4666E-01,0.4964E-01,0.5281E-01,
     +0.5617E-01,0.5973E-01,0.6350E-01,0.6750E-01,0.7173E-01,0.7621E-01,
     +0.8095E-01,0.8596E-01,0.9126E-01,0.9687E-01,0.1028E+00,0.1090E+00,
     +0.1156E+00,0.1225E+00,0.1299E+00,0.1375E+00,0.1456E+00,0.1541E+00,
     +0.1630E+00,0.1724E+00,0.1822E+00,0.1924E+00,0.2031E+00,0.2143E+00,
     +0.2259E+00,0.2379E+00,0.2505E+00,0.2634E+00,0.2768E+00,0.2905E+00,
     +0.3047E+00,0.3191E+00,0.3338E+00,0.3487E+00,0.3638E+00,0.3789E+00,
     +0.3940E+00,0.4089E+00,0.4236E+00,0.4378E+00,0.4514E+00,0.4642E+00,
     +0.4759E+00,0.4865E+00,0.4956E+00,0.5030E+00,0.5084E+00,0.5116E+00,
     +0.5122E+00,0.5101E+00,0.5049E+00,0.4966E+00,0.4848E+00,0.4696E+00,
     +0.4509E+00,0.4288E+00,0.4033E+00,0.3749E+00,0.3439E+00,0.3108E+00,
     +0.2761E+00,0.2406E+00,0.2049E+00,0.1696E+00,0.1356E+00,0.1036E+00,
     +0.8558E-01,0.6969E-01,0.5579E-01,0.4376E-01,0.3349E-01,0.2488E-01,
     +0.1780E-01,0.1216E-01,0.7819E-02,0.4638E-02,0.2458E-02,0.1099E-02,
     +0.3709E-03,0.7066E-04/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.6957E-02,0.7419E-02,0.7911E-02,0.8435E-02,0.8993E-02,0.9586E-02,
     +0.1022E-01,0.1089E-01,0.1161E-01,0.1237E-01,0.1318E-01,0.1404E-01,
     +0.1495E-01,0.1593E-01,0.1696E-01,0.1806E-01,0.1923E-01,0.2047E-01,
     +0.2178E-01,0.2318E-01,0.2467E-01,0.2624E-01,0.2791E-01,0.2968E-01,
     +0.3155E-01,0.3354E-01,0.3564E-01,0.3787E-01,0.4023E-01,0.4272E-01,
     +0.4536E-01,0.4814E-01,0.5108E-01,0.5419E-01,0.5746E-01,0.6091E-01,
     +0.6455E-01,0.6838E-01,0.7240E-01,0.7663E-01,0.8107E-01,0.8573E-01,
     +0.9060E-01,0.9570E-01,0.1010E+00,0.1066E+00,0.1124E+00,0.1184E+00,
     +0.1246E+00,0.1311E+00,0.1377E+00,0.1446E+00,0.1517E+00,0.1589E+00,
     +0.1662E+00,0.1737E+00,0.1812E+00,0.1888E+00,0.1964E+00,0.2039E+00,
     +0.2112E+00,0.2183E+00,0.2252E+00,0.2316E+00,0.2376E+00,0.2429E+00,
     +0.2476E+00,0.2513E+00,0.2541E+00,0.2558E+00,0.2562E+00,0.2552E+00,
     +0.2527E+00,0.2485E+00,0.2426E+00,0.2350E+00,0.2255E+00,0.2143E+00,
     +0.2014E+00,0.1870E+00,0.1712E+00,0.1544E+00,0.1368E+00,0.1188E+00,
     +0.1009E+00,0.8350E-01,0.6697E-01,0.5172E-01,0.3809E-01,0.2637E-01,
     +0.2033E-01,0.1539E-01,0.1139E-01,0.8205E-02,0.5728E-02,0.3846E-02,
     +0.2461E-02,0.1483E-02,0.8267E-03,0.4153E-03,0.1803E-03,0.6292E-04,
     +0.1524E-04,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.1083E+03,0.1041E+03,0.1001E+03,0.9617E+02,0.9238E+02,0.8872E+02,
     +0.8518E+02,0.8176E+02,0.7846E+02,0.7527E+02,0.7219E+02,0.6921E+02,
     +0.6634E+02,0.6357E+02,0.6090E+02,0.5832E+02,0.5583E+02,0.5343E+02,
     +0.5112E+02,0.4888E+02,0.4673E+02,0.4466E+02,0.4267E+02,0.4075E+02,
     +0.3889E+02,0.3711E+02,0.3540E+02,0.3375E+02,0.3216E+02,0.3063E+02,
     +0.2917E+02,0.2776E+02,0.2640E+02,0.2510E+02,0.2385E+02,0.2264E+02,
     +0.2149E+02,0.2039E+02,0.1932E+02,0.1831E+02,0.1733E+02,0.1639E+02,
     +0.1550E+02,0.1464E+02,0.1382E+02,0.1303E+02,0.1228E+02,0.1156E+02,
     +0.1087E+02,0.1021E+02,0.9577E+01,0.8975E+01,0.8400E+01,0.7851E+01,
     +0.7326E+01,0.6825E+01,0.6347E+01,0.5892E+01,0.5457E+01,0.5044E+01,
     +0.4650E+01,0.4275E+01,0.3918E+01,0.3580E+01,0.3259E+01,0.2955E+01,
     +0.2668E+01,0.2397E+01,0.2142E+01,0.1903E+01,0.1679E+01,0.1472E+01,
     +0.1279E+01,0.1102E+01,0.9402E+00,0.7932E+00,0.6609E+00,0.5431E+00,
     +0.4395E+00,0.3494E+00,0.2724E+00,0.2077E+00,0.1544E+00,0.1115E+00,
     +0.7794E-01,0.5245E-01,0.3378E-01,0.2067E-01,0.1190E-01,0.6368E-02,
     +0.4184E-02,0.2717E-02,0.1738E-02,0.1091E-02,0.6678E-03,0.3958E-03,
     +0.2249E-03,0.1209E-03,0.6034E-04,0.2719E-04,0.1059E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1242E+02,0.1203E+02,0.1164E+02,0.1127E+02,0.1090E+02,0.1055E+02,
     +0.1020E+02,0.9871E+01,0.9548E+01,0.9234E+01,0.8930E+01,0.8635E+01,
     +0.8348E+01,0.8070E+01,0.7801E+01,0.7539E+01,0.7286E+01,0.7040E+01,
     +0.6801E+01,0.6570E+01,0.6346E+01,0.6129E+01,0.5919E+01,0.5714E+01,
     +0.5517E+01,0.5325E+01,0.5139E+01,0.4959E+01,0.4784E+01,0.4615E+01,
     +0.4450E+01,0.4291E+01,0.4137E+01,0.3987E+01,0.3842E+01,0.3701E+01,
     +0.3564E+01,0.3431E+01,0.3301E+01,0.3176E+01,0.3054E+01,0.2935E+01,
     +0.2819E+01,0.2707E+01,0.2597E+01,0.2490E+01,0.2386E+01,0.2284E+01,
     +0.2184E+01,0.2086E+01,0.1991E+01,0.1898E+01,0.1806E+01,0.1716E+01,
     +0.1629E+01,0.1542E+01,0.1457E+01,0.1374E+01,0.1293E+01,0.1213E+01,
     +0.1134E+01,0.1057E+01,0.9823E+00,0.9090E+00,0.8376E+00,0.7682E+00,
     +0.7010E+00,0.6362E+00,0.5740E+00,0.5145E+00,0.4579E+00,0.4045E+00,
     +0.3545E+00,0.3079E+00,0.2650E+00,0.2258E+00,0.1903E+00,0.1585E+00,
     +0.1303E+00,0.1056E+00,0.8409E-01,0.6567E-01,0.5006E-01,0.3703E-01,
     +0.2638E-01,0.1790E-01,0.1142E-01,0.6714E-02,0.3552E-02,0.1633E-02,
     +0.9372E-03,0.5158E-03,0.2708E-03,0.1349E-03,0.6336E-04,0.2788E-04,
     +0.1142E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.2553E+01,0.2477E+01,0.2403E+01,0.2331E+01,0.2262E+01,0.2194E+01,
     +0.2129E+01,0.2065E+01,0.2003E+01,0.1943E+01,0.1885E+01,0.1828E+01,
     +0.1773E+01,0.1720E+01,0.1668E+01,0.1618E+01,0.1569E+01,0.1522E+01,
     +0.1476E+01,0.1431E+01,0.1388E+01,0.1346E+01,0.1305E+01,0.1266E+01,
     +0.1228E+01,0.1190E+01,0.1154E+01,0.1119E+01,0.1085E+01,0.1052E+01,
     +0.1020E+01,0.9887E+00,0.9583E+00,0.9288E+00,0.9000E+00,0.8720E+00,
     +0.8447E+00,0.8181E+00,0.7921E+00,0.7668E+00,0.7420E+00,0.7177E+00,
     +0.6940E+00,0.6707E+00,0.6479E+00,0.6254E+00,0.6033E+00,0.5816E+00,
     +0.5601E+00,0.5389E+00,0.5180E+00,0.4973E+00,0.4767E+00,0.4564E+00,
     +0.4361E+00,0.4161E+00,0.3961E+00,0.3762E+00,0.3565E+00,0.3369E+00,
     +0.3174E+00,0.2981E+00,0.2790E+00,0.2600E+00,0.2413E+00,0.2230E+00,
     +0.2050E+00,0.1874E+00,0.1703E+00,0.1538E+00,0.1380E+00,0.1229E+00,
     +0.1086E+00,0.9516E-01,0.8267E-01,0.7115E-01,0.6062E-01,0.5109E-01,
     +0.4254E-01,0.3494E-01,0.2824E-01,0.2239E-01,0.1733E-01,0.1301E-01,
     +0.9403E-02,0.6466E-02,0.4169E-02,0.2473E-02,0.1315E-02,0.6044E-03,
     +0.3458E-03,0.1891E-03,0.9824E-04,0.4818E-04,0.2213E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.2378E+01,0.2302E+01,0.2229E+01,0.2157E+01,0.2087E+01,0.2020E+01,
     +0.1954E+01,0.1891E+01,0.1829E+01,0.1769E+01,0.1711E+01,0.1654E+01,
     +0.1600E+01,0.1546E+01,0.1495E+01,0.1445E+01,0.1396E+01,0.1349E+01,
     +0.1303E+01,0.1259E+01,0.1216E+01,0.1174E+01,0.1134E+01,0.1095E+01,
     +0.1057E+01,0.1020E+01,0.9842E+00,0.9496E+00,0.9160E+00,0.8835E+00,
     +0.8519E+00,0.8212E+00,0.7915E+00,0.7627E+00,0.7347E+00,0.7075E+00,
     +0.6811E+00,0.6555E+00,0.6306E+00,0.6064E+00,0.5828E+00,0.5599E+00,
     +0.5376E+00,0.5159E+00,0.4947E+00,0.4741E+00,0.4540E+00,0.4343E+00,
     +0.4151E+00,0.3963E+00,0.3779E+00,0.3599E+00,0.3423E+00,0.3251E+00,
     +0.3082E+00,0.2916E+00,0.2753E+00,0.2594E+00,0.2438E+00,0.2285E+00,
     +0.2135E+00,0.1988E+00,0.1845E+00,0.1705E+00,0.1570E+00,0.1438E+00,
     +0.1311E+00,0.1188E+00,0.1070E+00,0.9580E-01,0.8515E-01,0.7510E-01,
     +0.6569E-01,0.5696E-01,0.4891E-01,0.4157E-01,0.3494E-01,0.2901E-01,
     +0.2377E-01,0.1918E-01,0.1521E-01,0.1182E-01,0.8969E-02,0.6602E-02,
     +0.4679E-02,0.3161E-02,0.2007E-02,0.1176E-02,0.6208E-03,0.2851E-03,
     +0.1638E-03,0.9026E-04,0.4751E-04,0.2376E-04,0.1122E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.2262E+01,0.2186E+01,0.2112E+01,0.2041E+01,0.1971E+01,0.1904E+01,
     +0.1838E+01,0.1775E+01,0.1713E+01,0.1653E+01,0.1595E+01,0.1539E+01,
     +0.1484E+01,0.1431E+01,0.1379E+01,0.1329E+01,0.1281E+01,0.1234E+01,
     +0.1188E+01,0.1144E+01,0.1101E+01,0.1060E+01,0.1020E+01,0.9807E+00,
     +0.9429E+00,0.9063E+00,0.8709E+00,0.8365E+00,0.8033E+00,0.7710E+00,
     +0.7398E+00,0.7096E+00,0.6803E+00,0.6519E+00,0.6244E+00,0.5978E+00,
     +0.5720E+00,0.5471E+00,0.5229E+00,0.4994E+00,0.4767E+00,0.4547E+00,
     +0.4334E+00,0.4127E+00,0.3926E+00,0.3732E+00,0.3544E+00,0.3361E+00,
     +0.3184E+00,0.3012E+00,0.2846E+00,0.2684E+00,0.2527E+00,0.2376E+00,
     +0.2229E+00,0.2086E+00,0.1948E+00,0.1815E+00,0.1686E+00,0.1562E+00,
     +0.1442E+00,0.1326E+00,0.1215E+00,0.1109E+00,0.1007E+00,0.9101E-01,
     +0.8180E-01,0.7307E-01,0.6484E-01,0.5712E-01,0.4992E-01,0.4325E-01,
     +0.3710E-01,0.3149E-01,0.2641E-01,0.2185E-01,0.1782E-01,0.1429E-01,
     +0.1125E-01,0.8672E-02,0.6528E-02,0.4783E-02,0.3397E-02,0.2328E-02,
     +0.1530E-02,0.9580E-03,0.5661E-03,0.3122E-03,0.1583E-03,0.7226E-04,
     +0.4238E-04,0.2437E-04,0.1369E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.2177E+01,0.2102E+01,0.2030E+01,0.1960E+01,0.1892E+01,0.1826E+01,
     +0.1762E+01,0.1699E+01,0.1639E+01,0.1580E+01,0.1523E+01,0.1468E+01,
     +0.1415E+01,0.1363E+01,0.1312E+01,0.1264E+01,0.1216E+01,0.1170E+01,
     +0.1126E+01,0.1083E+01,0.1041E+01,0.1001E+01,0.9617E+00,0.9237E+00,
     +0.8870E+00,0.8514E+00,0.8170E+00,0.7836E+00,0.7513E+00,0.7201E+00,
     +0.6898E+00,0.6605E+00,0.6322E+00,0.6048E+00,0.5782E+00,0.5526E+00,
     +0.5277E+00,0.5037E+00,0.4805E+00,0.4580E+00,0.4362E+00,0.4152E+00,
     +0.3948E+00,0.3751E+00,0.3561E+00,0.3376E+00,0.3198E+00,0.3026E+00,
     +0.2859E+00,0.2698E+00,0.2542E+00,0.2391E+00,0.2245E+00,0.2105E+00,
     +0.1969E+00,0.1838E+00,0.1711E+00,0.1590E+00,0.1472E+00,0.1360E+00,
     +0.1251E+00,0.1148E+00,0.1049E+00,0.9538E-01,0.8637E-01,0.7781E-01,
     +0.6971E-01,0.6208E-01,0.5492E-01,0.4823E-01,0.4202E-01,0.3628E-01,
     +0.3103E-01,0.2625E-01,0.2195E-01,0.1811E-01,0.1472E-01,0.1177E-01,
     +0.9236E-02,0.7099E-02,0.5329E-02,0.3894E-02,0.2760E-02,0.1888E-02,
     +0.1239E-02,0.7758E-03,0.4590E-03,0.2539E-03,0.1294E-03,0.5969E-04,
     +0.3531E-04,0.2050E-04,0.1165E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.5029E+00,0.4830E+00,0.4638E+00,0.4452E+00,0.4272E+00,0.4099E+00,
     +0.3931E+00,0.3769E+00,0.3612E+00,0.3461E+00,0.3316E+00,0.3175E+00,
     +0.3039E+00,0.2908E+00,0.2782E+00,0.2660E+00,0.2543E+00,0.2430E+00,
     +0.2321E+00,0.2216E+00,0.2115E+00,0.2017E+00,0.1924E+00,0.1833E+00,
     +0.1746E+00,0.1663E+00,0.1582E+00,0.1505E+00,0.1431E+00,0.1359E+00,
     +0.1291E+00,0.1225E+00,0.1162E+00,0.1101E+00,0.1043E+00,0.9870E-01,
     +0.9334E-01,0.8820E-01,0.8328E-01,0.7856E-01,0.7404E-01,0.6972E-01,
     +0.6558E-01,0.6162E-01,0.5784E-01,0.5422E-01,0.5077E-01,0.4747E-01,
     +0.4432E-01,0.4132E-01,0.3846E-01,0.3573E-01,0.3314E-01,0.3067E-01,
     +0.2832E-01,0.2610E-01,0.2399E-01,0.2199E-01,0.2010E-01,0.1832E-01,
     +0.1663E-01,0.1505E-01,0.1356E-01,0.1217E-01,0.1087E-01,0.9661E-02,
     +0.8538E-02,0.7499E-02,0.6544E-02,0.5669E-02,0.4872E-02,0.4150E-02,
     +0.3502E-02,0.2924E-02,0.2412E-02,0.1965E-02,0.1577E-02,0.1246E-02,
     +0.9670E-03,0.7355E-03,0.5469E-03,0.3965E-03,0.2793E-03,0.1904E-03,
     +0.1251E-03,0.7870E-04,0.4711E-04,0.2659E-04,0.1398E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1391E-01,0.1483E-01,0.1580E-01,0.1684E-01,0.1794E-01,0.1912E-01,
     +0.2036E-01,0.2169E-01,0.2310E-01,0.2460E-01,0.2619E-01,0.2788E-01,
     +0.2968E-01,0.3158E-01,0.3361E-01,0.3576E-01,0.3804E-01,0.4046E-01,
     +0.4303E-01,0.4575E-01,0.4864E-01,0.5170E-01,0.5494E-01,0.5837E-01,
     +0.6200E-01,0.6584E-01,0.6991E-01,0.7421E-01,0.7875E-01,0.8355E-01,
     +0.8862E-01,0.9397E-01,0.9961E-01,0.1056E+00,0.1118E+00,0.1184E+00,
     +0.1253E+00,0.1326E+00,0.1403E+00,0.1483E+00,0.1568E+00,0.1656E+00,
     +0.1748E+00,0.1844E+00,0.1945E+00,0.2050E+00,0.2159E+00,0.2272E+00,
     +0.2390E+00,0.2511E+00,0.2636E+00,0.2766E+00,0.2898E+00,0.3034E+00,
     +0.3172E+00,0.3313E+00,0.3455E+00,0.3599E+00,0.3742E+00,0.3885E+00,
     +0.4026E+00,0.4163E+00,0.4297E+00,0.4424E+00,0.4543E+00,0.4653E+00,
     +0.4752E+00,0.4837E+00,0.4905E+00,0.4956E+00,0.4986E+00,0.4992E+00,
     +0.4973E+00,0.4926E+00,0.4850E+00,0.4743E+00,0.4605E+00,0.4433E+00,
     +0.4230E+00,0.3996E+00,0.3734E+00,0.3447E+00,0.3138E+00,0.2813E+00,
     +0.2478E+00,0.2139E+00,0.1803E+00,0.1476E+00,0.1164E+00,0.8756E-01,
     +0.7155E-01,0.5761E-01,0.4556E-01,0.3528E-01,0.2663E-01,0.1949E-01,
     +0.1373E-01,0.9210E-02,0.5807E-02,0.3368E-02,0.1739E-02,0.7533E-03,
     +0.2439E-03,0.4375E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.7850E-02,0.8365E-02,0.8913E-02,0.9496E-02,0.1012E-01,0.1077E-01,
     +0.1147E-01,0.1222E-01,0.1301E-01,0.1385E-01,0.1474E-01,0.1569E-01,
     +0.1670E-01,0.1777E-01,0.1890E-01,0.2010E-01,0.2138E-01,0.2273E-01,
     +0.2417E-01,0.2569E-01,0.2730E-01,0.2900E-01,0.3081E-01,0.3272E-01,
     +0.3474E-01,0.3688E-01,0.3914E-01,0.4153E-01,0.4405E-01,0.4671E-01,
     +0.4951E-01,0.5247E-01,0.5558E-01,0.5886E-01,0.6232E-01,0.6594E-01,
     +0.6975E-01,0.7375E-01,0.7795E-01,0.8234E-01,0.8693E-01,0.9173E-01,
     +0.9675E-01,0.1020E+00,0.1074E+00,0.1130E+00,0.1189E+00,0.1250E+00,
     +0.1312E+00,0.1377E+00,0.1443E+00,0.1510E+00,0.1580E+00,0.1650E+00,
     +0.1721E+00,0.1793E+00,0.1865E+00,0.1936E+00,0.2007E+00,0.2076E+00,
     +0.2143E+00,0.2207E+00,0.2267E+00,0.2323E+00,0.2373E+00,0.2416E+00,
     +0.2451E+00,0.2477E+00,0.2492E+00,0.2496E+00,0.2487E+00,0.2465E+00,
     +0.2427E+00,0.2373E+00,0.2304E+00,0.2218E+00,0.2115E+00,0.1997E+00,
     +0.1864E+00,0.1718E+00,0.1561E+00,0.1397E+00,0.1228E+00,0.1057E+00,
     +0.8896E-01,0.7286E-01,0.5779E-01,0.4408E-01,0.3201E-01,0.2180E-01,
     +0.1662E-01,0.1243E-01,0.9084E-02,0.6461E-02,0.4447E-02,0.2941E-02,
     +0.1852E-02,0.1096E-02,0.5989E-03,0.2941E-03,0.1244E-03,0.4203E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1452E+03,0.1390E+03,0.1330E+03,0.1273E+03,0.1218E+03,0.1165E+03,
     +0.1114E+03,0.1065E+03,0.1017E+03,0.9719E+02,0.9281E+02,0.8860E+02,
     +0.8456E+02,0.8068E+02,0.7694E+02,0.7335E+02,0.6991E+02,0.6660E+02,
     +0.6343E+02,0.6038E+02,0.5745E+02,0.5465E+02,0.5196E+02,0.4938E+02,
     +0.4691E+02,0.4454E+02,0.4227E+02,0.4010E+02,0.3802E+02,0.3603E+02,
     +0.3413E+02,0.3230E+02,0.3056E+02,0.2890E+02,0.2731E+02,0.2579E+02,
     +0.2434E+02,0.2295E+02,0.2163E+02,0.2037E+02,0.1917E+02,0.1803E+02,
     +0.1694E+02,0.1590E+02,0.1491E+02,0.1397E+02,0.1307E+02,0.1222E+02,
     +0.1142E+02,0.1065E+02,0.9919E+01,0.9228E+01,0.8573E+01,0.7951E+01,
     +0.7363E+01,0.6806E+01,0.6279E+01,0.5780E+01,0.5309E+01,0.4865E+01,
     +0.4446E+01,0.4051E+01,0.3680E+01,0.3331E+01,0.3004E+01,0.2697E+01,
     +0.2411E+01,0.2145E+01,0.1898E+01,0.1668E+01,0.1457E+01,0.1264E+01,
     +0.1087E+01,0.9261E+00,0.7814E+00,0.6520E+00,0.5373E+00,0.4368E+00,
     +0.3496E+00,0.2750E+00,0.2122E+00,0.1602E+00,0.1180E+00,0.8454E-01,
     +0.5868E-01,0.3929E-01,0.2524E-01,0.1544E-01,0.8919E-02,0.4797E-02,
     +0.3164E-02,0.2062E-02,0.1323E-02,0.8308E-03,0.5079E-03,0.2999E-03,
     +0.1692E-03,0.9001E-04,0.4427E-04,0.1957E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.1946E+02,0.1875E+02,0.1807E+02,0.1741E+02,0.1678E+02,0.1616E+02,
     +0.1556E+02,0.1499E+02,0.1443E+02,0.1389E+02,0.1337E+02,0.1287E+02,
     +0.1238E+02,0.1191E+02,0.1146E+02,0.1102E+02,0.1059E+02,0.1018E+02,
     +0.9789E+01,0.9408E+01,0.9040E+01,0.8684E+01,0.8341E+01,0.8010E+01,
     +0.7690E+01,0.7382E+01,0.7084E+01,0.6797E+01,0.6520E+01,0.6253E+01,
     +0.5995E+01,0.5747E+01,0.5507E+01,0.5275E+01,0.5052E+01,0.4837E+01,
     +0.4629E+01,0.4428E+01,0.4234E+01,0.4047E+01,0.3866E+01,0.3692E+01,
     +0.3523E+01,0.3360E+01,0.3202E+01,0.3049E+01,0.2902E+01,0.2759E+01,
     +0.2620E+01,0.2486E+01,0.2356E+01,0.2230E+01,0.2107E+01,0.1988E+01,
     +0.1873E+01,0.1761E+01,0.1652E+01,0.1547E+01,0.1444E+01,0.1345E+01,
     +0.1249E+01,0.1156E+01,0.1066E+01,0.9787E+00,0.8951E+00,0.8148E+00,
     +0.7379E+00,0.6645E+00,0.5949E+00,0.5291E+00,0.4673E+00,0.4095E+00,
     +0.3559E+00,0.3067E+00,0.2617E+00,0.2210E+00,0.1846E+00,0.1523E+00,
     +0.1240E+00,0.9937E-01,0.7828E-01,0.6040E-01,0.4545E-01,0.3317E-01,
     +0.2329E-01,0.1556E-01,0.9766E-02,0.5649E-02,0.2938E-02,0.1329E-02,
     +0.7558E-03,0.4128E-03,0.2155E-03,0.1070E-03,0.5030E-04,0.2225E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.3715E+01,0.3588E+01,0.3466E+01,0.3347E+01,0.3232E+01,0.3121E+01,
     +0.3014E+01,0.2909E+01,0.2809E+01,0.2711E+01,0.2617E+01,0.2526E+01,
     +0.2438E+01,0.2353E+01,0.2270E+01,0.2191E+01,0.2114E+01,0.2040E+01,
     +0.1968E+01,0.1898E+01,0.1831E+01,0.1766E+01,0.1703E+01,0.1643E+01,
     +0.1584E+01,0.1528E+01,0.1473E+01,0.1420E+01,0.1369E+01,0.1320E+01,
     +0.1272E+01,0.1226E+01,0.1181E+01,0.1138E+01,0.1096E+01,0.1056E+01,
     +0.1017E+01,0.9790E+00,0.9422E+00,0.9065E+00,0.8719E+00,0.8383E+00,
     +0.8056E+00,0.7739E+00,0.7430E+00,0.7128E+00,0.6834E+00,0.6547E+00,
     +0.6267E+00,0.5993E+00,0.5725E+00,0.5462E+00,0.5204E+00,0.4951E+00,
     +0.4702E+00,0.4458E+00,0.4218E+00,0.3982E+00,0.3749E+00,0.3521E+00,
     +0.3297E+00,0.3077E+00,0.2861E+00,0.2650E+00,0.2444E+00,0.2244E+00,
     +0.2050E+00,0.1862E+00,0.1682E+00,0.1509E+00,0.1345E+00,0.1190E+00,
     +0.1044E+00,0.9090E-01,0.7842E-01,0.6701E-01,0.5667E-01,0.4739E-01,
     +0.3914E-01,0.3186E-01,0.2550E-01,0.2001E-01,0.1531E-01,0.1136E-01,
     +0.8099E-02,0.5489E-02,0.3484E-02,0.2032E-02,0.1061E-02,0.4790E-03,
     +0.2709E-03,0.1465E-03,0.7539E-04,0.3666E-04,0.1673E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.3541E+01,0.3414E+01,0.3292E+01,0.3173E+01,0.3058E+01,0.2947E+01,
     +0.2840E+01,0.2736E+01,0.2635E+01,0.2538E+01,0.2444E+01,0.2353E+01,
     +0.2265E+01,0.2180E+01,0.2098E+01,0.2018E+01,0.1941E+01,0.1867E+01,
     +0.1796E+01,0.1726E+01,0.1660E+01,0.1595E+01,0.1533E+01,0.1472E+01,
     +0.1414E+01,0.1358E+01,0.1304E+01,0.1252E+01,0.1201E+01,0.1152E+01,
     +0.1105E+01,0.1060E+01,0.1016E+01,0.9737E+00,0.9328E+00,0.8933E+00,
     +0.8552E+00,0.8184E+00,0.7828E+00,0.7484E+00,0.7152E+00,0.6830E+00,
     +0.6520E+00,0.6219E+00,0.5928E+00,0.5646E+00,0.5374E+00,0.5109E+00,
     +0.4853E+00,0.4605E+00,0.4364E+00,0.4130E+00,0.3903E+00,0.3682E+00,
     +0.3468E+00,0.3260E+00,0.3059E+00,0.2863E+00,0.2672E+00,0.2488E+00,
     +0.2309E+00,0.2136E+00,0.1969E+00,0.1807E+00,0.1652E+00,0.1503E+00,
     +0.1360E+00,0.1224E+00,0.1095E+00,0.9731E-01,0.8585E-01,0.7516E-01,
     +0.6525E-01,0.5613E-01,0.4782E-01,0.4031E-01,0.3359E-01,0.2765E-01,
     +0.2244E-01,0.1793E-01,0.1407E-01,0.1081E-01,0.8103E-02,0.5887E-02,
     +0.4115E-02,0.2739E-02,0.1712E-02,0.9873E-03,0.5125E-03,0.2316E-03,
     +0.1318E-03,0.7207E-04,0.3771E-04,0.1879E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.3424E+01,0.3298E+01,0.3175E+01,0.3057E+01,0.2942E+01,0.2831E+01,
     +0.2724E+01,0.2620E+01,0.2519E+01,0.2422E+01,0.2328E+01,0.2237E+01,
     +0.2149E+01,0.2064E+01,0.1982E+01,0.1903E+01,0.1827E+01,0.1752E+01,
     +0.1681E+01,0.1612E+01,0.1545E+01,0.1481E+01,0.1419E+01,0.1359E+01,
     +0.1301E+01,0.1245E+01,0.1191E+01,0.1139E+01,0.1089E+01,0.1041E+01,
     +0.9941E+00,0.9492E+00,0.9058E+00,0.8640E+00,0.8237E+00,0.7848E+00,
     +0.7474E+00,0.7113E+00,0.6765E+00,0.6430E+00,0.6107E+00,0.5795E+00,
     +0.5495E+00,0.5206E+00,0.4927E+00,0.4659E+00,0.4400E+00,0.4151E+00,
     +0.3910E+00,0.3679E+00,0.3456E+00,0.3242E+00,0.3035E+00,0.2837E+00,
     +0.2646E+00,0.2462E+00,0.2286E+00,0.2117E+00,0.1954E+00,0.1799E+00,
     +0.1650E+00,0.1509E+00,0.1374E+00,0.1245E+00,0.1124E+00,0.1009E+00,
     +0.9006E-01,0.7990E-01,0.7041E-01,0.6159E-01,0.5344E-01,0.4596E-01,
     +0.3913E-01,0.3296E-01,0.2742E-01,0.2251E-01,0.1821E-01,0.1448E-01,
     +0.1131E-01,0.8640E-02,0.6447E-02,0.4682E-02,0.3295E-02,0.2238E-02,
     +0.1458E-02,0.9054E-03,0.5308E-03,0.2907E-03,0.1465E-03,0.6664E-04,
     +0.3903E-04,0.2242E-04,0.1259E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.3341E+01,0.3216E+01,0.3095E+01,0.2977E+01,0.2864E+01,0.2754E+01,
     +0.2648E+01,0.2546E+01,0.2446E+01,0.2351E+01,0.2258E+01,0.2168E+01,
     +0.2081E+01,0.1998E+01,0.1917E+01,0.1839E+01,0.1763E+01,0.1690E+01,
     +0.1620E+01,0.1552E+01,0.1486E+01,0.1423E+01,0.1362E+01,0.1303E+01,
     +0.1246E+01,0.1191E+01,0.1138E+01,0.1087E+01,0.1038E+01,0.9909E+00,
     +0.9452E+00,0.9012E+00,0.8588E+00,0.8179E+00,0.7786E+00,0.7407E+00,
     +0.7042E+00,0.6691E+00,0.6352E+00,0.6027E+00,0.5713E+00,0.5411E+00,
     +0.5121E+00,0.4842E+00,0.4573E+00,0.4315E+00,0.4066E+00,0.3827E+00,
     +0.3597E+00,0.3377E+00,0.3165E+00,0.2961E+00,0.2766E+00,0.2578E+00,
     +0.2398E+00,0.2226E+00,0.2061E+00,0.1903E+00,0.1753E+00,0.1609E+00,
     +0.1472E+00,0.1342E+00,0.1218E+00,0.1101E+00,0.9906E-01,0.8866E-01,
     +0.7891E-01,0.6980E-01,0.6133E-01,0.5348E-01,0.4626E-01,0.3966E-01,
     +0.3367E-01,0.2827E-01,0.2345E-01,0.1920E-01,0.1548E-01,0.1227E-01,
     +0.9554E-02,0.7282E-02,0.5419E-02,0.3926E-02,0.2758E-02,0.1871E-02,
     +0.1218E-02,0.7563E-03,0.4442E-03,0.2441E-03,0.1238E-03,0.5690E-04,
     +0.3361E-04,0.1950E-04,0.1107E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.1720E+01,0.1648E+01,0.1579E+01,0.1512E+01,0.1447E+01,0.1385E+01,
     +0.1325E+01,0.1267E+01,0.1211E+01,0.1158E+01,0.1106E+01,0.1056E+01,
     +0.1008E+01,0.9624E+00,0.9182E+00,0.8756E+00,0.8347E+00,0.7953E+00,
     +0.7575E+00,0.7212E+00,0.6863E+00,0.6528E+00,0.6206E+00,0.5898E+00,
     +0.5602E+00,0.5317E+00,0.5045E+00,0.4784E+00,0.4534E+00,0.4294E+00,
     +0.4064E+00,0.3844E+00,0.3634E+00,0.3433E+00,0.3240E+00,0.3056E+00,
     +0.2880E+00,0.2712E+00,0.2551E+00,0.2398E+00,0.2252E+00,0.2112E+00,
     +0.1980E+00,0.1853E+00,0.1732E+00,0.1617E+00,0.1508E+00,0.1404E+00,
     +0.1306E+00,0.1212E+00,0.1123E+00,0.1039E+00,0.9590E-01,0.8835E-01,
     +0.8121E-01,0.7447E-01,0.6811E-01,0.6213E-01,0.5649E-01,0.5121E-01,
     +0.4626E-01,0.4163E-01,0.3731E-01,0.3329E-01,0.2956E-01,0.2611E-01,
     +0.2294E-01,0.2002E-01,0.1736E-01,0.1494E-01,0.1276E-01,0.1079E-01,
     +0.9044E-02,0.7497E-02,0.6142E-02,0.4966E-02,0.3957E-02,0.3103E-02,
     +0.2390E-02,0.1804E-02,0.1331E-02,0.9580E-03,0.6700E-03,0.4537E-03,
     +0.2961E-03,0.1853E-03,0.1103E-03,0.6201E-04,0.3250E-04,0.1560E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.1543E-01,0.1643E-01,0.1750E-01,0.1863E-01,0.1984E-01,0.2112E-01,
     +0.2248E-01,0.2392E-01,0.2546E-01,0.2709E-01,0.2882E-01,0.3065E-01,
     +0.3260E-01,0.3467E-01,0.3686E-01,0.3918E-01,0.4164E-01,0.4425E-01,
     +0.4701E-01,0.4994E-01,0.5303E-01,0.5631E-01,0.5977E-01,0.6344E-01,
     +0.6731E-01,0.7140E-01,0.7572E-01,0.8028E-01,0.8509E-01,0.9016E-01,
     +0.9551E-01,0.1011E+00,0.1071E+00,0.1133E+00,0.1198E+00,0.1267E+00,
     +0.1340E+00,0.1415E+00,0.1495E+00,0.1578E+00,0.1665E+00,0.1755E+00,
     +0.1850E+00,0.1948E+00,0.2051E+00,0.2157E+00,0.2268E+00,0.2382E+00,
     +0.2500E+00,0.2621E+00,0.2746E+00,0.2874E+00,0.3005E+00,0.3138E+00,
     +0.3273E+00,0.3410E+00,0.3547E+00,0.3684E+00,0.3821E+00,0.3955E+00,
     +0.4086E+00,0.4213E+00,0.4335E+00,0.4449E+00,0.4554E+00,0.4648E+00,
     +0.4729E+00,0.4796E+00,0.4846E+00,0.4876E+00,0.4886E+00,0.4872E+00,
     +0.4832E+00,0.4765E+00,0.4670E+00,0.4545E+00,0.4390E+00,0.4205E+00,
     +0.3991E+00,0.3749E+00,0.3483E+00,0.3195E+00,0.2890E+00,0.2573E+00,
     +0.2250E+00,0.1926E+00,0.1609E+00,0.1304E+00,0.1017E+00,0.7543E-01,
     +0.6106E-01,0.4867E-01,0.3810E-01,0.2917E-01,0.2176E-01,0.1572E-01,
     +0.1092E-01,0.7214E-02,0.4471E-02,0.2543E-02,0.1283E-02,0.5410E-03,
     +0.1690E-03,0.2877E-04/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.8692E-02,0.9256E-02,0.9855E-02,0.1049E-01,0.1117E-01,0.1189E-01,
     +0.1265E-01,0.1346E-01,0.1432E-01,0.1523E-01,0.1620E-01,0.1722E-01,
     +0.1831E-01,0.1947E-01,0.2069E-01,0.2199E-01,0.2336E-01,0.2481E-01,
     +0.2635E-01,0.2798E-01,0.2970E-01,0.3153E-01,0.3345E-01,0.3549E-01,
     +0.3763E-01,0.3990E-01,0.4229E-01,0.4482E-01,0.4748E-01,0.5028E-01,
     +0.5322E-01,0.5633E-01,0.5959E-01,0.6301E-01,0.6661E-01,0.7038E-01,
     +0.7433E-01,0.7846E-01,0.8279E-01,0.8730E-01,0.9201E-01,0.9692E-01,
     +0.1020E+00,0.1073E+00,0.1128E+00,0.1185E+00,0.1244E+00,0.1305E+00,
     +0.1367E+00,0.1431E+00,0.1496E+00,0.1563E+00,0.1630E+00,0.1699E+00,
     +0.1767E+00,0.1836E+00,0.1904E+00,0.1972E+00,0.2038E+00,0.2101E+00,
     +0.2162E+00,0.2220E+00,0.2273E+00,0.2320E+00,0.2362E+00,0.2396E+00,
     +0.2421E+00,0.2437E+00,0.2443E+00,0.2436E+00,0.2417E+00,0.2384E+00,
     +0.2336E+00,0.2274E+00,0.2196E+00,0.2103E+00,0.1995E+00,0.1873E+00,
     +0.1738E+00,0.1592E+00,0.1438E+00,0.1277E+00,0.1115E+00,0.9528E-01,
     +0.7953E-01,0.6457E-01,0.5072E-01,0.3827E-01,0.2745E-01,0.1843E-01,
     +0.1392E-01,0.1030E-01,0.7447E-02,0.5236E-02,0.3560E-02,0.2324E-02,
     +0.1443E-02,0.8408E-03,0.4515E-03,0.2175E-03,0.8989E-04,0.2954E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1811E+03,0.1728E+03,0.1649E+03,0.1573E+03,0.1500E+03,0.1430E+03,
     +0.1362E+03,0.1298E+03,0.1236E+03,0.1177E+03,0.1120E+03,0.1065E+03,
     +0.1013E+03,0.9631E+02,0.9152E+02,0.8694E+02,0.8256E+02,0.7836E+02,
     +0.7435E+02,0.7051E+02,0.6684E+02,0.6333E+02,0.5999E+02,0.5679E+02,
     +0.5373E+02,0.5082E+02,0.4803E+02,0.4538E+02,0.4285E+02,0.4044E+02,
     +0.3814E+02,0.3595E+02,0.3386E+02,0.3188E+02,0.2999E+02,0.2820E+02,
     +0.2649E+02,0.2487E+02,0.2333E+02,0.2186E+02,0.2048E+02,0.1916E+02,
     +0.1791E+02,0.1673E+02,0.1561E+02,0.1455E+02,0.1354E+02,0.1259E+02,
     +0.1170E+02,0.1085E+02,0.1005E+02,0.9295E+01,0.8584E+01,0.7913E+01,
     +0.7283E+01,0.6689E+01,0.6131E+01,0.5608E+01,0.5117E+01,0.4656E+01,
     +0.4226E+01,0.3823E+01,0.3448E+01,0.3098E+01,0.2773E+01,0.2471E+01,
     +0.2192E+01,0.1934E+01,0.1698E+01,0.1481E+01,0.1283E+01,0.1103E+01,
     +0.9404E+00,0.7947E+00,0.6649E+00,0.5501E+00,0.4496E+00,0.3624E+00,
     +0.2877E+00,0.2246E+00,0.1720E+00,0.1290E+00,0.9441E-01,0.6728E-01,
     +0.4652E-01,0.3106E-01,0.1993E-01,0.1221E-01,0.7064E-02,0.3809E-02,
     +0.2516E-02,0.1640E-02,0.1051E-02,0.6584E-03,0.4007E-03,0.2350E-03,
     +0.1314E-03,0.6909E-04,0.3349E-04,0.1454E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.2698E+02,0.2592E+02,0.2490E+02,0.2391E+02,0.2296E+02,0.2205E+02,
     +0.2116E+02,0.2031E+02,0.1948E+02,0.1869E+02,0.1793E+02,0.1719E+02,
     +0.1648E+02,0.1580E+02,0.1514E+02,0.1451E+02,0.1390E+02,0.1331E+02,
     +0.1275E+02,0.1220E+02,0.1168E+02,0.1117E+02,0.1069E+02,0.1022E+02,
     +0.9776E+01,0.9345E+01,0.8931E+01,0.8533E+01,0.8151E+01,0.7783E+01,
     +0.7429E+01,0.7090E+01,0.6763E+01,0.6450E+01,0.6148E+01,0.5859E+01,
     +0.5581E+01,0.5314E+01,0.5057E+01,0.4810E+01,0.4573E+01,0.4344E+01,
     +0.4125E+01,0.3914E+01,0.3712E+01,0.3517E+01,0.3329E+01,0.3148E+01,
     +0.2974E+01,0.2807E+01,0.2646E+01,0.2490E+01,0.2341E+01,0.2197E+01,
     +0.2058E+01,0.1924E+01,0.1795E+01,0.1671E+01,0.1551E+01,0.1436E+01,
     +0.1326E+01,0.1220E+01,0.1118E+01,0.1021E+01,0.9282E+00,0.8398E+00,
     +0.7560E+00,0.6767E+00,0.6020E+00,0.5321E+00,0.4669E+00,0.4066E+00,
     +0.3511E+00,0.3005E+00,0.2547E+00,0.2136E+00,0.1771E+00,0.1450E+00,
     +0.1171E+00,0.9310E-01,0.7268E-01,0.5555E-01,0.4138E-01,0.2987E-01,
     +0.2073E-01,0.1368E-01,0.8475E-02,0.4836E-02,0.2481E-02,0.1107E-02,
     +0.6250E-03,0.3392E-03,0.1763E-03,0.8733E-04,0.4104E-04,0.1821E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.4961E+01,0.4776E+01,0.4596E+01,0.4423E+01,0.4256E+01,0.4095E+01,
     +0.3939E+01,0.3789E+01,0.3645E+01,0.3505E+01,0.3371E+01,0.3241E+01,
     +0.3116E+01,0.2995E+01,0.2879E+01,0.2767E+01,0.2659E+01,0.2555E+01,
     +0.2455E+01,0.2358E+01,0.2266E+01,0.2176E+01,0.2090E+01,0.2007E+01,
     +0.1927E+01,0.1850E+01,0.1776E+01,0.1705E+01,0.1636E+01,0.1570E+01,
     +0.1507E+01,0.1445E+01,0.1386E+01,0.1329E+01,0.1275E+01,0.1222E+01,
     +0.1171E+01,0.1122E+01,0.1075E+01,0.1029E+01,0.9849E+00,0.9423E+00,
     +0.9012E+00,0.8614E+00,0.8229E+00,0.7856E+00,0.7495E+00,0.7144E+00,
     +0.6804E+00,0.6474E+00,0.6153E+00,0.5841E+00,0.5537E+00,0.5241E+00,
     +0.4953E+00,0.4672E+00,0.4398E+00,0.4130E+00,0.3869E+00,0.3615E+00,
     +0.3368E+00,0.3127E+00,0.2892E+00,0.2665E+00,0.2445E+00,0.2233E+00,
     +0.2029E+00,0.1833E+00,0.1647E+00,0.1470E+00,0.1303E+00,0.1146E+00,
     +0.1001E+00,0.8661E-01,0.7429E-01,0.6310E-01,0.5304E-01,0.4407E-01,
     +0.3614E-01,0.2921E-01,0.2320E-01,0.1804E-01,0.1368E-01,0.1004E-01,
     +0.7082E-02,0.4741E-02,0.2971E-02,0.1709E-02,0.8791E-03,0.3905E-03,
     +0.2188E-03,0.1173E-03,0.5984E-04,0.2889E-04,0.1312E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.4787E+01,0.4601E+01,0.4422E+01,0.4249E+01,0.4082E+01,0.3921E+01,
     +0.3766E+01,0.3616E+01,0.3471E+01,0.3332E+01,0.3197E+01,0.3068E+01,
     +0.2943E+01,0.2822E+01,0.2706E+01,0.2595E+01,0.2487E+01,0.2383E+01,
     +0.2284E+01,0.2187E+01,0.2095E+01,0.2006E+01,0.1920E+01,0.1837E+01,
     +0.1758E+01,0.1682E+01,0.1608E+01,0.1537E+01,0.1469E+01,0.1404E+01,
     +0.1341E+01,0.1280E+01,0.1222E+01,0.1166E+01,0.1113E+01,0.1061E+01,
     +0.1011E+01,0.9632E+00,0.9172E+00,0.8729E+00,0.8303E+00,0.7893E+00,
     +0.7499E+00,0.7120E+00,0.6754E+00,0.6403E+00,0.6064E+00,0.5737E+00,
     +0.5423E+00,0.5120E+00,0.4827E+00,0.4546E+00,0.4274E+00,0.4012E+00,
     +0.3759E+00,0.3515E+00,0.3280E+00,0.3054E+00,0.2836E+00,0.2626E+00,
     +0.2424E+00,0.2230E+00,0.2044E+00,0.1866E+00,0.1696E+00,0.1534E+00,
     +0.1381E+00,0.1236E+00,0.1099E+00,0.9706E-01,0.8512E-01,0.7406E-01,
     +0.6390E-01,0.5463E-01,0.4624E-01,0.3872E-01,0.3204E-01,0.2618E-01,
     +0.2109E-01,0.1671E-01,0.1301E-01,0.9905E-02,0.7350E-02,0.5285E-02,
     +0.3652E-02,0.2402E-02,0.1483E-02,0.8437E-03,0.4320E-03,0.1926E-03,
     +0.1088E-03,0.5913E-04,0.3079E-04,0.1530E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.4671E+01,0.4485E+01,0.4306E+01,0.4133E+01,0.3966E+01,0.3805E+01,
     +0.3650E+01,0.3500E+01,0.3356E+01,0.3216E+01,0.3082E+01,0.2952E+01,
     +0.2828E+01,0.2707E+01,0.2592E+01,0.2480E+01,0.2372E+01,0.2269E+01,
     +0.2169E+01,0.2073E+01,0.1981E+01,0.1892E+01,0.1807E+01,0.1724E+01,
     +0.1645E+01,0.1569E+01,0.1496E+01,0.1426E+01,0.1358E+01,0.1293E+01,
     +0.1231E+01,0.1171E+01,0.1113E+01,0.1058E+01,0.1004E+01,0.9534E+00,
     +0.9044E+00,0.8573E+00,0.8122E+00,0.7689E+00,0.7273E+00,0.6874E+00,
     +0.6491E+00,0.6124E+00,0.5771E+00,0.5434E+00,0.5110E+00,0.4799E+00,
     +0.4502E+00,0.4217E+00,0.3944E+00,0.3682E+00,0.3432E+00,0.3192E+00,
     +0.2963E+00,0.2745E+00,0.2536E+00,0.2337E+00,0.2147E+00,0.1966E+00,
     +0.1795E+00,0.1632E+00,0.1479E+00,0.1333E+00,0.1197E+00,0.1069E+00,
     +0.9486E-01,0.8369E-01,0.7333E-01,0.6378E-01,0.5501E-01,0.4702E-01,
     +0.3979E-01,0.3330E-01,0.2754E-01,0.2246E-01,0.1805E-01,0.1426E-01,
     +0.1105E-01,0.8387E-02,0.6214E-02,0.4480E-02,0.3131E-02,0.2111E-02,
     +0.1366E-02,0.8423E-03,0.4907E-03,0.2672E-03,0.1340E-03,0.6072E-04,
     +0.3550E-04,0.2036E-04,0.1142E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.4589E+01,0.4404E+01,0.4227E+01,0.4055E+01,0.3889E+01,0.3730E+01,
     +0.3576E+01,0.3427E+01,0.3284E+01,0.3146E+01,0.3013E+01,0.2884E+01,
     +0.2761E+01,0.2642E+01,0.2527E+01,0.2417E+01,0.2310E+01,0.2208E+01,
     +0.2109E+01,0.2014E+01,0.1923E+01,0.1835E+01,0.1751E+01,0.1669E+01,
     +0.1591E+01,0.1516E+01,0.1444E+01,0.1375E+01,0.1308E+01,0.1244E+01,
     +0.1183E+01,0.1124E+01,0.1067E+01,0.1012E+01,0.9603E+00,0.9102E+00,
     +0.8622E+00,0.8161E+00,0.7719E+00,0.7295E+00,0.6889E+00,0.6500E+00,
     +0.6127E+00,0.5770E+00,0.5428E+00,0.5100E+00,0.4786E+00,0.4486E+00,
     +0.4199E+00,0.3925E+00,0.3662E+00,0.3412E+00,0.3172E+00,0.2944E+00,
     +0.2726E+00,0.2519E+00,0.2321E+00,0.2133E+00,0.1955E+00,0.1786E+00,
     +0.1626E+00,0.1475E+00,0.1332E+00,0.1198E+00,0.1072E+00,0.9544E-01,
     +0.8448E-01,0.7432E-01,0.6493E-01,0.5630E-01,0.4842E-01,0.4126E-01,
     +0.3481E-01,0.2905E-01,0.2395E-01,0.1948E-01,0.1560E-01,0.1229E-01,
     +0.9503E-02,0.7193E-02,0.5316E-02,0.3825E-02,0.2668E-02,0.1797E-02,
     +0.1162E-02,0.7173E-03,0.4188E-03,0.2290E-03,0.1156E-03,0.5294E-04,
     +0.3121E-04,0.1807E-04,0.1024E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.3013E+01,0.2881E+01,0.2753E+01,0.2631E+01,0.2513E+01,0.2399E+01,
     +0.2290E+01,0.2185E+01,0.2085E+01,0.1988E+01,0.1895E+01,0.1805E+01,
     +0.1720E+01,0.1637E+01,0.1558E+01,0.1483E+01,0.1410E+01,0.1340E+01,
     +0.1273E+01,0.1209E+01,0.1148E+01,0.1089E+01,0.1033E+01,0.9791E+00,
     +0.9275E+00,0.8782E+00,0.8310E+00,0.7859E+00,0.7428E+00,0.7016E+00,
     +0.6623E+00,0.6247E+00,0.5889E+00,0.5547E+00,0.5220E+00,0.4909E+00,
     +0.4613E+00,0.4331E+00,0.4062E+00,0.3806E+00,0.3563E+00,0.3332E+00,
     +0.3112E+00,0.2904E+00,0.2706E+00,0.2518E+00,0.2340E+00,0.2171E+00,
     +0.2011E+00,0.1860E+00,0.1718E+00,0.1583E+00,0.1456E+00,0.1336E+00,
     +0.1223E+00,0.1117E+00,0.1018E+00,0.9242E-01,0.8369E-01,0.7553E-01,
     +0.6792E-01,0.6085E-01,0.5428E-01,0.4820E-01,0.4260E-01,0.3745E-01,
     +0.3273E-01,0.2842E-01,0.2452E-01,0.2099E-01,0.1782E-01,0.1500E-01,
     +0.1249E-01,0.1030E-01,0.8387E-02,0.6741E-02,0.5340E-02,0.4162E-02,
     +0.3186E-02,0.2390E-02,0.1754E-02,0.1255E-02,0.8725E-03,0.5877E-03,
     +0.3816E-03,0.2377E-03,0.1410E-03,0.7893E-04,0.4121E-04,0.1970E-04,
     +0.1197E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.1686E-01,0.1794E-01,0.1910E-01,0.2032E-01,0.2162E-01,0.2301E-01,
     +0.2447E-01,0.2603E-01,0.2768E-01,0.2943E-01,0.3128E-01,0.3325E-01,
     +0.3534E-01,0.3755E-01,0.3989E-01,0.4236E-01,0.4499E-01,0.4776E-01,
     +0.5070E-01,0.5381E-01,0.5709E-01,0.6056E-01,0.6423E-01,0.6810E-01,
     +0.7218E-01,0.7649E-01,0.8103E-01,0.8582E-01,0.9086E-01,0.9617E-01,
     +0.1018E+00,0.1076E+00,0.1138E+00,0.1203E+00,0.1271E+00,0.1342E+00,
     +0.1417E+00,0.1495E+00,0.1576E+00,0.1661E+00,0.1750E+00,0.1843E+00,
     +0.1939E+00,0.2039E+00,0.2143E+00,0.2250E+00,0.2362E+00,0.2476E+00,
     +0.2594E+00,0.2715E+00,0.2839E+00,0.2965E+00,0.3094E+00,0.3224E+00,
     +0.3356E+00,0.3488E+00,0.3621E+00,0.3752E+00,0.3881E+00,0.4008E+00,
     +0.4130E+00,0.4247E+00,0.4357E+00,0.4459E+00,0.4551E+00,0.4631E+00,
     +0.4698E+00,0.4749E+00,0.4782E+00,0.4796E+00,0.4788E+00,0.4756E+00,
     +0.4700E+00,0.4617E+00,0.4506E+00,0.4367E+00,0.4200E+00,0.4004E+00,
     +0.3783E+00,0.3536E+00,0.3268E+00,0.2982E+00,0.2682E+00,0.2373E+00,
     +0.2061E+00,0.1752E+00,0.1452E+00,0.1166E+00,0.9000E-01,0.6596E-01,
     +0.5295E-01,0.4184E-01,0.3245E-01,0.2460E-01,0.1816E-01,0.1297E-01,
     +0.8897E-02,0.5800E-02,0.3541E-02,0.1980E-02,0.9793E-03,0.4028E-03,
     +0.1219E-03,0.1983E-04/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.9488E-02,0.1010E-01,0.1074E-01,0.1143E-01,0.1216E-01,0.1293E-01,
     +0.1375E-01,0.1462E-01,0.1554E-01,0.1652E-01,0.1756E-01,0.1866E-01,
     +0.1982E-01,0.2105E-01,0.2236E-01,0.2374E-01,0.2520E-01,0.2674E-01,
     +0.2837E-01,0.3010E-01,0.3192E-01,0.3385E-01,0.3588E-01,0.3802E-01,
     +0.4028E-01,0.4266E-01,0.4517E-01,0.4781E-01,0.5059E-01,0.5351E-01,
     +0.5658E-01,0.5980E-01,0.6319E-01,0.6673E-01,0.7044E-01,0.7433E-01,
     +0.7839E-01,0.8264E-01,0.8706E-01,0.9168E-01,0.9647E-01,0.1015E+00,
     +0.1066E+00,0.1120E+00,0.1175E+00,0.1232E+00,0.1291E+00,0.1352E+00,
     +0.1413E+00,0.1477E+00,0.1541E+00,0.1606E+00,0.1672E+00,0.1738E+00,
     +0.1804E+00,0.1870E+00,0.1935E+00,0.1998E+00,0.2060E+00,0.2119E+00,
     +0.2174E+00,0.2225E+00,0.2272E+00,0.2313E+00,0.2346E+00,0.2372E+00,
     +0.2390E+00,0.2397E+00,0.2394E+00,0.2379E+00,0.2351E+00,0.2309E+00,
     +0.2254E+00,0.2184E+00,0.2100E+00,0.2002E+00,0.1890E+00,0.1766E+00,
     +0.1630E+00,0.1485E+00,0.1334E+00,0.1178E+00,0.1022E+00,0.8675E-01,
     +0.7189E-01,0.5792E-01,0.4511E-01,0.3371E-01,0.2392E-01,0.1586E-01,
     +0.1187E-01,0.8707E-02,0.6235E-02,0.4340E-02,0.2919E-02,0.1884E-02,
     +0.1155E-02,0.6639E-03,0.3512E-03,0.1662E-03,0.6734E-04,0.2160E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.2156E+03,0.2052E+03,0.1953E+03,0.1857E+03,0.1766E+03,0.1679E+03,
     +0.1595E+03,0.1515E+03,0.1439E+03,0.1366E+03,0.1296E+03,0.1229E+03,
     +0.1166E+03,0.1105E+03,0.1047E+03,0.9913E+02,0.9385E+02,0.8880E+02,
     +0.8399E+02,0.7941E+02,0.7504E+02,0.7087E+02,0.6691E+02,0.6313E+02,
     +0.5954E+02,0.5612E+02,0.5287E+02,0.4978E+02,0.4684E+02,0.4405E+02,
     +0.4140E+02,0.3889E+02,0.3650E+02,0.3423E+02,0.3209E+02,0.3005E+02,
     +0.2813E+02,0.2630E+02,0.2458E+02,0.2295E+02,0.2140E+02,0.1995E+02,
     +0.1857E+02,0.1727E+02,0.1604E+02,0.1489E+02,0.1380E+02,0.1278E+02,
     +0.1181E+02,0.1090E+02,0.1005E+02,0.9253E+01,0.8503E+01,0.7800E+01,
     +0.7142E+01,0.6526E+01,0.5950E+01,0.5412E+01,0.4911E+01,0.4444E+01,
     +0.4010E+01,0.3607E+01,0.3234E+01,0.2888E+01,0.2569E+01,0.2275E+01,
     +0.2005E+01,0.1758E+01,0.1533E+01,0.1328E+01,0.1143E+01,0.9762E+00,
     +0.8269E+00,0.6941E+00,0.5768E+00,0.4740E+00,0.3849E+00,0.3083E+00,
     +0.2432E+00,0.1887E+00,0.1438E+00,0.1072E+00,0.7818E-01,0.5552E-01,
     +0.3829E-01,0.2553E-01,0.1638E-01,0.1003E-01,0.5811E-02,0.3135E-02,
     +0.2069E-02,0.1346E-02,0.8602E-03,0.5366E-03,0.3247E-03,0.1890E-03,
     +0.1047E-03,0.5442E-04,0.2602E-04,0.1111E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.3477E+02,0.3332E+02,0.3192E+02,0.3058E+02,0.2928E+02,0.2804E+02,
     +0.2684E+02,0.2568E+02,0.2457E+02,0.2351E+02,0.2248E+02,0.2150E+02,
     +0.2055E+02,0.1964E+02,0.1877E+02,0.1793E+02,0.1713E+02,0.1635E+02,
     +0.1561E+02,0.1490E+02,0.1421E+02,0.1356E+02,0.1293E+02,0.1232E+02,
     +0.1175E+02,0.1119E+02,0.1066E+02,0.1015E+02,0.9662E+01,0.9194E+01,
     +0.8746E+01,0.8317E+01,0.7905E+01,0.7511E+01,0.7134E+01,0.6773E+01,
     +0.6427E+01,0.6096E+01,0.5779E+01,0.5476E+01,0.5185E+01,0.4907E+01,
     +0.4641E+01,0.4386E+01,0.4142E+01,0.3908E+01,0.3684E+01,0.3469E+01,
     +0.3264E+01,0.3067E+01,0.2878E+01,0.2697E+01,0.2524E+01,0.2358E+01,
     +0.2199E+01,0.2046E+01,0.1901E+01,0.1761E+01,0.1627E+01,0.1500E+01,
     +0.1378E+01,0.1261E+01,0.1151E+01,0.1046E+01,0.9458E+00,0.8515E+00,
     +0.7627E+00,0.6792E+00,0.6012E+00,0.5286E+00,0.4615E+00,0.3997E+00,
     +0.3433E+00,0.2922E+00,0.2462E+00,0.2053E+00,0.1692E+00,0.1377E+00,
     +0.1105E+00,0.8721E-01,0.6759E-01,0.5125E-01,0.3786E-01,0.2708E-01,
     +0.1861E-01,0.1216E-01,0.7448E-02,0.4202E-02,0.2131E-02,0.9401E-03,
     +0.5274E-03,0.2847E-03,0.1474E-03,0.7282E-04,0.3420E-04,0.1520E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.6253E+01,0.6002E+01,0.5760E+01,0.5527E+01,0.5303E+01,0.5087E+01,
     +0.4879E+01,0.4679E+01,0.4487E+01,0.4302E+01,0.4124E+01,0.3953E+01,
     +0.3789E+01,0.3631E+01,0.3479E+01,0.3332E+01,0.3192E+01,0.3057E+01,
     +0.2928E+01,0.2803E+01,0.2684E+01,0.2569E+01,0.2459E+01,0.2353E+01,
     +0.2251E+01,0.2154E+01,0.2060E+01,0.1970E+01,0.1884E+01,0.1801E+01,
     +0.1722E+01,0.1646E+01,0.1572E+01,0.1502E+01,0.1435E+01,0.1370E+01,
     +0.1308E+01,0.1248E+01,0.1191E+01,0.1136E+01,0.1083E+01,0.1032E+01,
     +0.9828E+00,0.9355E+00,0.8901E+00,0.8463E+00,0.8040E+00,0.7633E+00,
     +0.7239E+00,0.6859E+00,0.6492E+00,0.6137E+00,0.5793E+00,0.5460E+00,
     +0.5138E+00,0.4825E+00,0.4523E+00,0.4230E+00,0.3945E+00,0.3670E+00,
     +0.3404E+00,0.3147E+00,0.2898E+00,0.2659E+00,0.2429E+00,0.2208E+00,
     +0.1997E+00,0.1797E+00,0.1606E+00,0.1427E+00,0.1259E+00,0.1103E+00,
     +0.9581E-01,0.8253E-01,0.7044E-01,0.5953E-01,0.4977E-01,0.4113E-01,
     +0.3353E-01,0.2693E-01,0.2124E-01,0.1640E-01,0.1234E-01,0.8979E-02,
     +0.6271E-02,0.4155E-02,0.2574E-02,0.1463E-02,0.7429E-03,0.3256E-03,
     +0.1809E-03,0.9621E-04,0.4875E-04,0.2340E-04,0.1057E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.6079E+01,0.5828E+01,0.5586E+01,0.5353E+01,0.5129E+01,0.4913E+01,
     +0.4706E+01,0.4506E+01,0.4314E+01,0.4129E+01,0.3951E+01,0.3781E+01,
     +0.3616E+01,0.3458E+01,0.3307E+01,0.3161E+01,0.3021E+01,0.2886E+01,
     +0.2757E+01,0.2633E+01,0.2513E+01,0.2399E+01,0.2289E+01,0.2184E+01,
     +0.2083E+01,0.1986E+01,0.1893E+01,0.1804E+01,0.1718E+01,0.1636E+01,
     +0.1557E+01,0.1482E+01,0.1410E+01,0.1341E+01,0.1274E+01,0.1211E+01,
     +0.1150E+01,0.1091E+01,0.1035E+01,0.9816E+00,0.9302E+00,0.8810E+00,
     +0.8338E+00,0.7885E+00,0.7451E+00,0.7035E+00,0.6636E+00,0.6254E+00,
     +0.5887E+00,0.5535E+00,0.5198E+00,0.4874E+00,0.4563E+00,0.4265E+00,
     +0.3979E+00,0.3705E+00,0.3443E+00,0.3191E+00,0.2950E+00,0.2719E+00,
     +0.2499E+00,0.2288E+00,0.2088E+00,0.1897E+00,0.1716E+00,0.1545E+00,
     +0.1384E+00,0.1232E+00,0.1091E+00,0.9586E-01,0.8365E-01,0.7241E-01,
     +0.6215E-01,0.5285E-01,0.4449E-01,0.3705E-01,0.3048E-01,0.2476E-01,
     +0.1982E-01,0.1560E-01,0.1205E-01,0.9111E-02,0.6706E-02,0.4779E-02,
     +0.3272E-02,0.2130E-02,0.1301E-02,0.7321E-03,0.3706E-03,0.1634E-03,
     +0.9168E-04,0.4955E-04,0.2569E-04,0.1273E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.5963E+01,0.5712E+01,0.5470E+01,0.5237E+01,0.5013E+01,0.4798E+01,
     +0.4590E+01,0.4391E+01,0.4199E+01,0.4014E+01,0.3836E+01,0.3665E+01,
     +0.3501E+01,0.3343E+01,0.3192E+01,0.3046E+01,0.2906E+01,0.2772E+01,
     +0.2643E+01,0.2519E+01,0.2400E+01,0.2286E+01,0.2176E+01,0.2071E+01,
     +0.1971E+01,0.1874E+01,0.1781E+01,0.1693E+01,0.1607E+01,0.1526E+01,
     +0.1448E+01,0.1373E+01,0.1301E+01,0.1233E+01,0.1167E+01,0.1104E+01,
     +0.1044E+01,0.9866E+00,0.9315E+00,0.8789E+00,0.8285E+00,0.7804E+00,
     +0.7344E+00,0.6905E+00,0.6485E+00,0.6084E+00,0.5700E+00,0.5335E+00,
     +0.4986E+00,0.4652E+00,0.4335E+00,0.4032E+00,0.3743E+00,0.3469E+00,
     +0.3207E+00,0.2959E+00,0.2723E+00,0.2498E+00,0.2286E+00,0.2085E+00,
     +0.1895E+00,0.1716E+00,0.1548E+00,0.1390E+00,0.1242E+00,0.1104E+00,
     +0.9752E-01,0.8563E-01,0.7467E-01,0.6462E-01,0.5546E-01,0.4717E-01,
     +0.3971E-01,0.3306E-01,0.2719E-01,0.2206E-01,0.1762E-01,0.1384E-01,
     +0.1067E-01,0.8050E-02,0.5929E-02,0.4249E-02,0.2952E-02,0.1979E-02,
     +0.1273E-02,0.7805E-03,0.4523E-03,0.2450E-03,0.1224E-03,0.5523E-04,
     +0.3222E-04,0.1844E-04,0.1032E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.5882E+01,0.5632E+01,0.5392E+01,0.5160E+01,0.4938E+01,0.4723E+01,
     +0.4517E+01,0.4319E+01,0.4128E+01,0.3944E+01,0.3768E+01,0.3598E+01,
     +0.3435E+01,0.3279E+01,0.3128E+01,0.2984E+01,0.2845E+01,0.2712E+01,
     +0.2584E+01,0.2461E+01,0.2343E+01,0.2230E+01,0.2121E+01,0.2017E+01,
     +0.1918E+01,0.1822E+01,0.1730E+01,0.1643E+01,0.1558E+01,0.1478E+01,
     +0.1401E+01,0.1327E+01,0.1256E+01,0.1189E+01,0.1124E+01,0.1062E+01,
     +0.1003E+01,0.9462E+00,0.8921E+00,0.8404E+00,0.7911E+00,0.7439E+00,
     +0.6989E+00,0.6560E+00,0.6150E+00,0.5759E+00,0.5386E+00,0.5031E+00,
     +0.4692E+00,0.4370E+00,0.4063E+00,0.3771E+00,0.3493E+00,0.3230E+00,
     +0.2979E+00,0.2742E+00,0.2517E+00,0.2304E+00,0.2103E+00,0.1913E+00,
     +0.1734E+00,0.1566E+00,0.1409E+00,0.1262E+00,0.1124E+00,0.9963E-01,
     +0.8779E-01,0.7687E-01,0.6684E-01,0.5768E-01,0.4936E-01,0.4185E-01,
     +0.3513E-01,0.2917E-01,0.2392E-01,0.1935E-01,0.1541E-01,0.1207E-01,
     +0.9282E-02,0.6986E-02,0.5134E-02,0.3672E-02,0.2547E-02,0.1706E-02,
     +0.1097E-02,0.6735E-03,0.3913E-03,0.2130E-03,0.1071E-03,0.4886E-04,
     +0.2873E-04,0.1659E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.4345E+01,0.4146E+01,0.3955E+01,0.3772E+01,0.3595E+01,0.3426E+01,
     +0.3264E+01,0.3109E+01,0.2959E+01,0.2816E+01,0.2679E+01,0.2548E+01,
     +0.2422E+01,0.2301E+01,0.2186E+01,0.2075E+01,0.1969E+01,0.1868E+01,
     +0.1771E+01,0.1678E+01,0.1590E+01,0.1505E+01,0.1424E+01,0.1347E+01,
     +0.1273E+01,0.1203E+01,0.1135E+01,0.1071E+01,0.1010E+01,0.9518E+00,
     +0.8963E+00,0.8434E+00,0.7931E+00,0.7452E+00,0.6996E+00,0.6563E+00,
     +0.6151E+00,0.5760E+00,0.5388E+00,0.5036E+00,0.4701E+00,0.4384E+00,
     +0.4084E+00,0.3799E+00,0.3530E+00,0.3276E+00,0.3035E+00,0.2808E+00,
     +0.2593E+00,0.2391E+00,0.2201E+00,0.2022E+00,0.1853E+00,0.1695E+00,
     +0.1547E+00,0.1408E+00,0.1278E+00,0.1157E+00,0.1044E+00,0.9384E-01,
     +0.8407E-01,0.7502E-01,0.6667E-01,0.5897E-01,0.5190E-01,0.4543E-01,
     +0.3954E-01,0.3419E-01,0.2936E-01,0.2502E-01,0.2115E-01,0.1771E-01,
     +0.1469E-01,0.1205E-01,0.9766E-02,0.7811E-02,0.6157E-02,0.4774E-02,
     +0.3637E-02,0.2715E-02,0.1982E-02,0.1411E-02,0.9771E-03,0.6552E-03,
     +0.4237E-03,0.2629E-03,0.1554E-03,0.8668E-04,0.4508E-04,0.2145E-04,
     +0.1298E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.1822E-01,0.1938E-01,0.2062E-01,0.2193E-01,0.2332E-01,0.2479E-01,
     +0.2636E-01,0.2801E-01,0.2977E-01,0.3163E-01,0.3360E-01,0.3569E-01,
     +0.3791E-01,0.4025E-01,0.4272E-01,0.4534E-01,0.4812E-01,0.5105E-01,
     +0.5414E-01,0.5741E-01,0.6086E-01,0.6451E-01,0.6835E-01,0.7241E-01,
     +0.7668E-01,0.8118E-01,0.8593E-01,0.9091E-01,0.9616E-01,0.1017E+00,
     +0.1075E+00,0.1136E+00,0.1199E+00,0.1266E+00,0.1336E+00,0.1409E+00,
     +0.1486E+00,0.1566E+00,0.1649E+00,0.1736E+00,0.1827E+00,0.1921E+00,
     +0.2019E+00,0.2120E+00,0.2224E+00,0.2332E+00,0.2444E+00,0.2558E+00,
     +0.2676E+00,0.2796E+00,0.2918E+00,0.3043E+00,0.3169E+00,0.3297E+00,
     +0.3425E+00,0.3553E+00,0.3680E+00,0.3805E+00,0.3928E+00,0.4047E+00,
     +0.4161E+00,0.4269E+00,0.4369E+00,0.4460E+00,0.4540E+00,0.4607E+00,
     +0.4661E+00,0.4698E+00,0.4717E+00,0.4716E+00,0.4693E+00,0.4647E+00,
     +0.4576E+00,0.4480E+00,0.4357E+00,0.4206E+00,0.4029E+00,0.3826E+00,
     +0.3599E+00,0.3350E+00,0.3082E+00,0.2798E+00,0.2504E+00,0.2204E+00,
     +0.1903E+00,0.1607E+00,0.1322E+00,0.1053E+00,0.8054E-01,0.5839E-01,
     +0.4653E-01,0.3647E-01,0.2805E-01,0.2108E-01,0.1541E-01,0.1090E-01,
     +0.7393E-02,0.4762E-02,0.2868E-02,0.1579E-02,0.7673E-03,0.3088E-03,
     +0.9084E-04,0.1418E-04/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1024E-01,0.1090E-01,0.1159E-01,0.1232E-01,0.1310E-01,0.1392E-01,
     +0.1479E-01,0.1572E-01,0.1670E-01,0.1774E-01,0.1884E-01,0.2000E-01,
     +0.2123E-01,0.2253E-01,0.2391E-01,0.2537E-01,0.2691E-01,0.2853E-01,
     +0.3025E-01,0.3206E-01,0.3398E-01,0.3599E-01,0.3812E-01,0.4036E-01,
     +0.4272E-01,0.4520E-01,0.4781E-01,0.5055E-01,0.5344E-01,0.5646E-01,
     +0.5964E-01,0.6296E-01,0.6645E-01,0.7010E-01,0.7391E-01,0.7789E-01,
     +0.8205E-01,0.8638E-01,0.9089E-01,0.9557E-01,0.1004E+00,0.1055E+00,
     +0.1107E+00,0.1161E+00,0.1216E+00,0.1273E+00,0.1332E+00,0.1392E+00,
     +0.1453E+00,0.1515E+00,0.1579E+00,0.1642E+00,0.1706E+00,0.1770E+00,
     +0.1834E+00,0.1897E+00,0.1958E+00,0.2018E+00,0.2075E+00,0.2130E+00,
     +0.2180E+00,0.2226E+00,0.2267E+00,0.2301E+00,0.2328E+00,0.2347E+00,
     +0.2357E+00,0.2357E+00,0.2346E+00,0.2324E+00,0.2289E+00,0.2241E+00,
     +0.2179E+00,0.2104E+00,0.2015E+00,0.1913E+00,0.1798E+00,0.1672E+00,
     +0.1537E+00,0.1394E+00,0.1245E+00,0.1094E+00,0.9435E-01,0.7964E-01,
     +0.6558E-01,0.5246E-01,0.4055E-01,0.3005E-01,0.2111E-01,0.1384E-01,
     +0.1028E-01,0.7479E-02,0.5310E-02,0.3663E-02,0.2440E-02,0.1559E-02,
     +0.9448E-03,0.5365E-03,0.2799E-03,0.1305E-03,0.5191E-04,0.1629E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2484E+03,0.2358E+03,0.2239E+03,0.2124E+03,0.2015E+03,0.1911E+03,
     +0.1812E+03,0.1717E+03,0.1626E+03,0.1540E+03,0.1457E+03,0.1379E+03,
     +0.1304E+03,0.1233E+03,0.1165E+03,0.1101E+03,0.1039E+03,0.9807E+02,
     +0.9251E+02,0.8722E+02,0.8220E+02,0.7742E+02,0.7289E+02,0.6859E+02,
     +0.6450E+02,0.6062E+02,0.5695E+02,0.5346E+02,0.5016E+02,0.4703E+02,
     +0.4407E+02,0.4126E+02,0.3861E+02,0.3610E+02,0.3373E+02,0.3149E+02,
     +0.2938E+02,0.2738E+02,0.2550E+02,0.2373E+02,0.2206E+02,0.2048E+02,
     +0.1900E+02,0.1761E+02,0.1630E+02,0.1507E+02,0.1392E+02,0.1283E+02,
     +0.1182E+02,0.1087E+02,0.9980E+01,0.9148E+01,0.8372E+01,0.7647E+01,
     +0.6971E+01,0.6342E+01,0.5756E+01,0.5212E+01,0.4708E+01,0.4240E+01,
     +0.3808E+01,0.3408E+01,0.3040E+01,0.2701E+01,0.2390E+01,0.2106E+01,
     +0.1846E+01,0.1610E+01,0.1396E+01,0.1203E+01,0.1030E+01,0.8746E+00,
     +0.7368E+00,0.6150E+00,0.5083E+00,0.4155E+00,0.3356E+00,0.2675E+00,
     +0.2100E+00,0.1622E+00,0.1231E+00,0.9148E-01,0.6648E-01,0.4710E-01,
     +0.3242E-01,0.2160E-01,0.1385E-01,0.8483E-02,0.4912E-02,0.2646E-02,
     +0.1743E-02,0.1131E-02,0.7198E-03,0.4467E-03,0.2686E-03,0.1551E-03,
     +0.8517E-04,0.4380E-04,0.2068E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.4267E+02,0.4080E+02,0.3900E+02,0.3727E+02,0.3561E+02,0.3402E+02,
     +0.3249E+02,0.3102E+02,0.2961E+02,0.2826E+02,0.2697E+02,0.2572E+02,
     +0.2453E+02,0.2339E+02,0.2229E+02,0.2124E+02,0.2024E+02,0.1927E+02,
     +0.1835E+02,0.1747E+02,0.1662E+02,0.1582E+02,0.1504E+02,0.1430E+02,
     +0.1359E+02,0.1291E+02,0.1227E+02,0.1165E+02,0.1106E+02,0.1049E+02,
     +0.9949E+01,0.9433E+01,0.8940E+01,0.8469E+01,0.8019E+01,0.7589E+01,
     +0.7180E+01,0.6788E+01,0.6415E+01,0.6058E+01,0.5718E+01,0.5394E+01,
     +0.5084E+01,0.4788E+01,0.4506E+01,0.4237E+01,0.3980E+01,0.3735E+01,
     +0.3501E+01,0.3278E+01,0.3065E+01,0.2862E+01,0.2668E+01,0.2483E+01,
     +0.2307E+01,0.2139E+01,0.1979E+01,0.1826E+01,0.1681E+01,0.1543E+01,
     +0.1412E+01,0.1288E+01,0.1170E+01,0.1058E+01,0.9535E+00,0.8548E+00,
     +0.7623E+00,0.6760E+00,0.5958E+00,0.5215E+00,0.4532E+00,0.3908E+00,
     +0.3341E+00,0.2830E+00,0.2374E+00,0.1970E+00,0.1615E+00,0.1307E+00,
     +0.1043E+00,0.8184E-01,0.6303E-01,0.4747E-01,0.3481E-01,0.2471E-01,
     +0.1684E-01,0.1090E-01,0.6618E-02,0.3697E-02,0.1856E-02,0.8108E-03,
     +0.4523E-03,0.2431E-03,0.1253E-03,0.6180E-04,0.2900E-04,0.1289E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.7564E+01,0.7242E+01,0.6934E+01,0.6637E+01,0.6353E+01,0.6079E+01,
     +0.5816E+01,0.5564E+01,0.5322E+01,0.5089E+01,0.4866E+01,0.4652E+01,
     +0.4447E+01,0.4250E+01,0.4061E+01,0.3880E+01,0.3707E+01,0.3540E+01,
     +0.3381E+01,0.3228E+01,0.3081E+01,0.2941E+01,0.2807E+01,0.2678E+01,
     +0.2555E+01,0.2437E+01,0.2324E+01,0.2216E+01,0.2113E+01,0.2013E+01,
     +0.1919E+01,0.1828E+01,0.1741E+01,0.1658E+01,0.1579E+01,0.1502E+01,
     +0.1430E+01,0.1360E+01,0.1293E+01,0.1229E+01,0.1168E+01,0.1109E+01,
     +0.1053E+01,0.9986E+00,0.9468E+00,0.8971E+00,0.8493E+00,0.8034E+00,
     +0.7593E+00,0.7169E+00,0.6761E+00,0.6368E+00,0.5989E+00,0.5625E+00,
     +0.5274E+00,0.4935E+00,0.4608E+00,0.4294E+00,0.3990E+00,0.3698E+00,
     +0.3417E+00,0.3147E+00,0.2887E+00,0.2639E+00,0.2401E+00,0.2175E+00,
     +0.1960E+00,0.1756E+00,0.1564E+00,0.1384E+00,0.1216E+00,0.1061E+00,
     +0.9178E-01,0.7873E-01,0.6691E-01,0.5630E-01,0.4686E-01,0.3853E-01,
     +0.3126E-01,0.2497E-01,0.1958E-01,0.1502E-01,0.1122E-01,0.8103E-02,
     +0.5611E-02,0.3684E-02,0.2260E-02,0.1271E-02,0.6382E-03,0.2764E-03,
     +0.1524E-03,0.8052E-04,0.4055E-04,0.1936E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.7390E+01,0.7069E+01,0.6760E+01,0.6464E+01,0.6179E+01,0.5906E+01,
     +0.5643E+01,0.5391E+01,0.5149E+01,0.4917E+01,0.4694E+01,0.4480E+01,
     +0.4275E+01,0.4078E+01,0.3890E+01,0.3709E+01,0.3536E+01,0.3369E+01,
     +0.3210E+01,0.3058E+01,0.2912E+01,0.2772E+01,0.2638E+01,0.2510E+01,
     +0.2387E+01,0.2270E+01,0.2158E+01,0.2050E+01,0.1948E+01,0.1849E+01,
     +0.1755E+01,0.1666E+01,0.1580E+01,0.1498E+01,0.1419E+01,0.1344E+01,
     +0.1273E+01,0.1204E+01,0.1139E+01,0.1077E+01,0.1017E+01,0.9601E+00,
     +0.9057E+00,0.8537E+00,0.8041E+00,0.7567E+00,0.7114E+00,0.6681E+00,
     +0.6268E+00,0.5872E+00,0.5495E+00,0.5135E+00,0.4790E+00,0.4461E+00,
     +0.4147E+00,0.3847E+00,0.3561E+00,0.3289E+00,0.3029E+00,0.2781E+00,
     +0.2546E+00,0.2322E+00,0.2111E+00,0.1910E+00,0.1721E+00,0.1543E+00,
     +0.1377E+00,0.1221E+00,0.1076E+00,0.9416E-01,0.8181E-01,0.7051E-01,
     +0.6025E-01,0.5100E-01,0.4273E-01,0.3541E-01,0.2900E-01,0.2343E-01,
     +0.1865E-01,0.1460E-01,0.1121E-01,0.8419E-02,0.6154E-02,0.4352E-02,
     +0.2956E-02,0.1908E-02,0.1154E-02,0.6433E-03,0.3224E-03,0.1408E-03,
     +0.7854E-04,0.4225E-04,0.2182E-04,0.1078E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.7274E+01,0.6953E+01,0.6644E+01,0.6348E+01,0.6063E+01,0.5790E+01,
     +0.5528E+01,0.5276E+01,0.5034E+01,0.4802E+01,0.4579E+01,0.4365E+01,
     +0.4160E+01,0.3964E+01,0.3775E+01,0.3595E+01,0.3421E+01,0.3256E+01,
     +0.3097E+01,0.2944E+01,0.2799E+01,0.2659E+01,0.2526E+01,0.2398E+01,
     +0.2276E+01,0.2159E+01,0.2047E+01,0.1940E+01,0.1838E+01,0.1740E+01,
     +0.1646E+01,0.1557E+01,0.1472E+01,0.1391E+01,0.1313E+01,0.1239E+01,
     +0.1168E+01,0.1101E+01,0.1036E+01,0.9751E+00,0.9166E+00,0.8609E+00,
     +0.8078E+00,0.7572E+00,0.7090E+00,0.6631E+00,0.6194E+00,0.5779E+00,
     +0.5384E+00,0.5008E+00,0.4651E+00,0.4312E+00,0.3991E+00,0.3685E+00,
     +0.3396E+00,0.3122E+00,0.2863E+00,0.2618E+00,0.2387E+00,0.2170E+00,
     +0.1965E+00,0.1773E+00,0.1593E+00,0.1425E+00,0.1268E+00,0.1123E+00,
     +0.9880E-01,0.8641E-01,0.7504E-01,0.6467E-01,0.5527E-01,0.4680E-01,
     +0.3923E-01,0.3251E-01,0.2661E-01,0.2149E-01,0.1709E-01,0.1336E-01,
     +0.1024E-01,0.7690E-02,0.5635E-02,0.4018E-02,0.2777E-02,0.1852E-02,
     +0.1186E-02,0.7234E-03,0.4173E-03,0.2251E-03,0.1120E-03,0.5034E-04,
     +0.2929E-04,0.1673E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.7193E+01,0.6874E+01,0.6567E+01,0.6272E+01,0.5989E+01,0.5716E+01,
     +0.5455E+01,0.5205E+01,0.4964E+01,0.4733E+01,0.4511E+01,0.4299E+01,
     +0.4095E+01,0.3900E+01,0.3712E+01,0.3533E+01,0.3361E+01,0.3196E+01,
     +0.3038E+01,0.2887E+01,0.2742E+01,0.2604E+01,0.2471E+01,0.2345E+01,
     +0.2223E+01,0.2107E+01,0.1996E+01,0.1891E+01,0.1789E+01,0.1692E+01,
     +0.1600E+01,0.1512E+01,0.1428E+01,0.1347E+01,0.1271E+01,0.1197E+01,
     +0.1128E+01,0.1061E+01,0.9978E+00,0.9374E+00,0.8799E+00,0.8252E+00,
     +0.7731E+00,0.7235E+00,0.6763E+00,0.6314E+00,0.5888E+00,0.5483E+00,
     +0.5099E+00,0.4734E+00,0.4387E+00,0.4059E+00,0.3748E+00,0.3454E+00,
     +0.3176E+00,0.2913E+00,0.2665E+00,0.2432E+00,0.2212E+00,0.2005E+00,
     +0.1811E+00,0.1630E+00,0.1461E+00,0.1303E+00,0.1157E+00,0.1021E+00,
     +0.8963E-01,0.7816E-01,0.6769E-01,0.5817E-01,0.4957E-01,0.4185E-01,
     +0.3498E-01,0.2891E-01,0.2360E-01,0.1900E-01,0.1507E-01,0.1175E-01,
     +0.8987E-02,0.6731E-02,0.4922E-02,0.3503E-02,0.2418E-02,0.1612E-02,
     +0.1032E-02,0.6305E-03,0.3647E-03,0.1977E-03,0.9908E-04,0.4501E-04,
     +0.2640E-04,0.1521E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.5691E+01,0.5421E+01,0.5163E+01,0.4915E+01,0.4677E+01,0.4449E+01,
     +0.4231E+01,0.4022E+01,0.3823E+01,0.3631E+01,0.3448E+01,0.3273E+01,
     +0.3106E+01,0.2946E+01,0.2793E+01,0.2646E+01,0.2507E+01,0.2373E+01,
     +0.2246E+01,0.2124E+01,0.2008E+01,0.1898E+01,0.1792E+01,0.1691E+01,
     +0.1596E+01,0.1504E+01,0.1417E+01,0.1335E+01,0.1256E+01,0.1181E+01,
     +0.1110E+01,0.1042E+01,0.9777E+00,0.9167E+00,0.8587E+00,0.8038E+00,
     +0.7516E+00,0.7022E+00,0.6554E+00,0.6111E+00,0.5692E+00,0.5295E+00,
     +0.4921E+00,0.4567E+00,0.4233E+00,0.3917E+00,0.3620E+00,0.3341E+00,
     +0.3077E+00,0.2830E+00,0.2598E+00,0.2380E+00,0.2175E+00,0.1984E+00,
     +0.1805E+00,0.1638E+00,0.1482E+00,0.1338E+00,0.1203E+00,0.1078E+00,
     +0.9629E-01,0.8564E-01,0.7585E-01,0.6686E-01,0.5864E-01,0.5115E-01,
     +0.4435E-01,0.3821E-01,0.3269E-01,0.2775E-01,0.2336E-01,0.1949E-01,
     +0.1610E-01,0.1315E-01,0.1062E-01,0.8455E-02,0.6636E-02,0.5124E-02,
     +0.3887E-02,0.2890E-02,0.2101E-02,0.1490E-02,0.1028E-02,0.6865E-03,
     +0.4424E-03,0.2735E-03,0.1611E-03,0.8959E-04,0.4641E-04,0.2197E-04,
     +0.1325E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
