"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Vancouver"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Vancouver", { offset: true, expect: "America/Los_Angeles" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Vancouver", { abbr: true, expect: "America/Los_Angeles" }),

	"1918" : helpers.makeTestYear("America/Vancouver", [
		["1918-04-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["1918-04-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1918-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1918-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1942" : helpers.makeTestYear("America/Vancouver", [
		["1942-02-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["1942-02-09T10:00:00+00:00", "03:00:00", "PWT", 420]
	]),

	"1945" : helpers.makeTestYear("America/Vancouver", [
		["1945-08-14T22:59:59+00:00", "15:59:59", "PWT", 420],
		["1945-08-14T23:00:00+00:00", "16:00:00", "PPT", 420],
		["1945-09-30T08:59:59+00:00", "01:59:59", "PPT", 420],
		["1945-09-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1946" : helpers.makeTestYear("America/Vancouver", [
		["1946-04-28T09:59:59+00:00", "01:59:59", "PST", 480],
		["1946-04-28T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1946-10-13T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1946-10-13T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1947" : helpers.makeTestYear("America/Vancouver", [
		["1947-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1947-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1947-09-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1947-09-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1948" : helpers.makeTestYear("America/Vancouver", [
		["1948-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1948-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1948-09-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1948-09-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1949" : helpers.makeTestYear("America/Vancouver", [
		["1949-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1949-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1949-09-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1949-09-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1950" : helpers.makeTestYear("America/Vancouver", [
		["1950-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1950-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1950-09-24T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1950-09-24T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1951" : helpers.makeTestYear("America/Vancouver", [
		["1951-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1951-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1951-09-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1951-09-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1952" : helpers.makeTestYear("America/Vancouver", [
		["1952-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1952-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1952-09-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1952-09-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1953" : helpers.makeTestYear("America/Vancouver", [
		["1953-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1953-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1953-09-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1953-09-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1954" : helpers.makeTestYear("America/Vancouver", [
		["1954-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1954-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1954-09-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1954-09-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1955" : helpers.makeTestYear("America/Vancouver", [
		["1955-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1955-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1955-09-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1955-09-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1956" : helpers.makeTestYear("America/Vancouver", [
		["1956-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1956-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1956-09-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1956-09-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1957" : helpers.makeTestYear("America/Vancouver", [
		["1957-04-28T09:59:59+00:00", "01:59:59", "PST", 480],
		["1957-04-28T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1957-09-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1957-09-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1958" : helpers.makeTestYear("America/Vancouver", [
		["1958-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1958-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1958-09-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1958-09-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1959" : helpers.makeTestYear("America/Vancouver", [
		["1959-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1959-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1959-09-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1959-09-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1960" : helpers.makeTestYear("America/Vancouver", [
		["1960-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1960-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1960-09-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1960-09-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1961" : helpers.makeTestYear("America/Vancouver", [
		["1961-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1961-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1961-09-24T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1961-09-24T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1962" : helpers.makeTestYear("America/Vancouver", [
		["1962-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1962-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1962-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1962-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1963" : helpers.makeTestYear("America/Vancouver", [
		["1963-04-28T09:59:59+00:00", "01:59:59", "PST", 480],
		["1963-04-28T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1963-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1963-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1964" : helpers.makeTestYear("America/Vancouver", [
		["1964-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1964-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1964-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1964-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1965" : helpers.makeTestYear("America/Vancouver", [
		["1965-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1965-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1965-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1965-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1966" : helpers.makeTestYear("America/Vancouver", [
		["1966-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1966-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1966-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1966-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1967" : helpers.makeTestYear("America/Vancouver", [
		["1967-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1967-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1967-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1967-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1968" : helpers.makeTestYear("America/Vancouver", [
		["1968-04-28T09:59:59+00:00", "01:59:59", "PST", 480],
		["1968-04-28T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1968-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1968-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1969" : helpers.makeTestYear("America/Vancouver", [
		["1969-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1969-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1969-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1969-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1970" : helpers.makeTestYear("America/Vancouver", [
		["1970-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1970-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1970-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1970-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1971" : helpers.makeTestYear("America/Vancouver", [
		["1971-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1971-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1971-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1971-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1972" : helpers.makeTestYear("America/Vancouver", [
		["1972-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1972-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1972-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1972-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1973" : helpers.makeTestYear("America/Vancouver", [
		["1973-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1973-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1973-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1973-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1974" : helpers.makeTestYear("America/Vancouver", [
		["1974-04-28T09:59:59+00:00", "01:59:59", "PST", 480],
		["1974-04-28T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1974-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1974-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1975" : helpers.makeTestYear("America/Vancouver", [
		["1975-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1975-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1975-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1975-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1976" : helpers.makeTestYear("America/Vancouver", [
		["1976-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1976-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1976-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1976-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1977" : helpers.makeTestYear("America/Vancouver", [
		["1977-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1977-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1977-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1977-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1978" : helpers.makeTestYear("America/Vancouver", [
		["1978-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1978-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1978-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1978-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1979" : helpers.makeTestYear("America/Vancouver", [
		["1979-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1979-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1979-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1979-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1980" : helpers.makeTestYear("America/Vancouver", [
		["1980-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1980-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1980-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1980-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1981" : helpers.makeTestYear("America/Vancouver", [
		["1981-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1981-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1981-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1981-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1982" : helpers.makeTestYear("America/Vancouver", [
		["1982-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1982-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1982-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1982-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1983" : helpers.makeTestYear("America/Vancouver", [
		["1983-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1983-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1983-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1983-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1984" : helpers.makeTestYear("America/Vancouver", [
		["1984-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1984-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1984-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1984-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1985" : helpers.makeTestYear("America/Vancouver", [
		["1985-04-28T09:59:59+00:00", "01:59:59", "PST", 480],
		["1985-04-28T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1985-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1985-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1986" : helpers.makeTestYear("America/Vancouver", [
		["1986-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1986-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1986-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1986-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1987" : helpers.makeTestYear("America/Vancouver", [
		["1987-04-05T09:59:59+00:00", "01:59:59", "PST", 480],
		["1987-04-05T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1987-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1987-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1988" : helpers.makeTestYear("America/Vancouver", [
		["1988-04-03T09:59:59+00:00", "01:59:59", "PST", 480],
		["1988-04-03T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1988-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1988-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1989" : helpers.makeTestYear("America/Vancouver", [
		["1989-04-02T09:59:59+00:00", "01:59:59", "PST", 480],
		["1989-04-02T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1989-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1989-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1990" : helpers.makeTestYear("America/Vancouver", [
		["1990-04-01T09:59:59+00:00", "01:59:59", "PST", 480],
		["1990-04-01T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1990-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1990-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1991" : helpers.makeTestYear("America/Vancouver", [
		["1991-04-07T09:59:59+00:00", "01:59:59", "PST", 480],
		["1991-04-07T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1991-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1991-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1992" : helpers.makeTestYear("America/Vancouver", [
		["1992-04-05T09:59:59+00:00", "01:59:59", "PST", 480],
		["1992-04-05T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1992-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1992-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1993" : helpers.makeTestYear("America/Vancouver", [
		["1993-04-04T09:59:59+00:00", "01:59:59", "PST", 480],
		["1993-04-04T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1993-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1993-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1994" : helpers.makeTestYear("America/Vancouver", [
		["1994-04-03T09:59:59+00:00", "01:59:59", "PST", 480],
		["1994-04-03T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1994-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1994-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1995" : helpers.makeTestYear("America/Vancouver", [
		["1995-04-02T09:59:59+00:00", "01:59:59", "PST", 480],
		["1995-04-02T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1995-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1995-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1996" : helpers.makeTestYear("America/Vancouver", [
		["1996-04-07T09:59:59+00:00", "01:59:59", "PST", 480],
		["1996-04-07T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1996-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1996-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1997" : helpers.makeTestYear("America/Vancouver", [
		["1997-04-06T09:59:59+00:00", "01:59:59", "PST", 480],
		["1997-04-06T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1997-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1997-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1998" : helpers.makeTestYear("America/Vancouver", [
		["1998-04-05T09:59:59+00:00", "01:59:59", "PST", 480],
		["1998-04-05T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1998-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1998-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1999" : helpers.makeTestYear("America/Vancouver", [
		["1999-04-04T09:59:59+00:00", "01:59:59", "PST", 480],
		["1999-04-04T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1999-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1999-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2000" : helpers.makeTestYear("America/Vancouver", [
		["2000-04-02T09:59:59+00:00", "01:59:59", "PST", 480],
		["2000-04-02T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2000-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2000-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2001" : helpers.makeTestYear("America/Vancouver", [
		["2001-04-01T09:59:59+00:00", "01:59:59", "PST", 480],
		["2001-04-01T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2001-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2001-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2002" : helpers.makeTestYear("America/Vancouver", [
		["2002-04-07T09:59:59+00:00", "01:59:59", "PST", 480],
		["2002-04-07T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2002-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2002-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2003" : helpers.makeTestYear("America/Vancouver", [
		["2003-04-06T09:59:59+00:00", "01:59:59", "PST", 480],
		["2003-04-06T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2003-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2003-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2004" : helpers.makeTestYear("America/Vancouver", [
		["2004-04-04T09:59:59+00:00", "01:59:59", "PST", 480],
		["2004-04-04T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2004-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2004-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2005" : helpers.makeTestYear("America/Vancouver", [
		["2005-04-03T09:59:59+00:00", "01:59:59", "PST", 480],
		["2005-04-03T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2005-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2005-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2006" : helpers.makeTestYear("America/Vancouver", [
		["2006-04-02T09:59:59+00:00", "01:59:59", "PST", 480],
		["2006-04-02T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2006-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2006-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2007" : helpers.makeTestYear("America/Vancouver", [
		["2007-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2007-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2007-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2007-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2008" : helpers.makeTestYear("America/Vancouver", [
		["2008-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2008-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2008-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2008-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2009" : helpers.makeTestYear("America/Vancouver", [
		["2009-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2009-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2009-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2009-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2010" : helpers.makeTestYear("America/Vancouver", [
		["2010-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2010-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2010-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2010-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2011" : helpers.makeTestYear("America/Vancouver", [
		["2011-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2011-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2011-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2011-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2012" : helpers.makeTestYear("America/Vancouver", [
		["2012-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2012-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2012-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2012-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2013" : helpers.makeTestYear("America/Vancouver", [
		["2013-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2013-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2013-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2013-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2014" : helpers.makeTestYear("America/Vancouver", [
		["2014-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2014-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2014-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2014-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2015" : helpers.makeTestYear("America/Vancouver", [
		["2015-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2015-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2015-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2015-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2016" : helpers.makeTestYear("America/Vancouver", [
		["2016-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2016-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2016-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2016-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2017" : helpers.makeTestYear("America/Vancouver", [
		["2017-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2017-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2017-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2017-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2018" : helpers.makeTestYear("America/Vancouver", [
		["2018-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2018-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2018-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2018-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2019" : helpers.makeTestYear("America/Vancouver", [
		["2019-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2019-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2019-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2019-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2020" : helpers.makeTestYear("America/Vancouver", [
		["2020-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2020-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2020-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2020-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2021" : helpers.makeTestYear("America/Vancouver", [
		["2021-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2021-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2021-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2021-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2022" : helpers.makeTestYear("America/Vancouver", [
		["2022-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2022-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2022-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2022-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2023" : helpers.makeTestYear("America/Vancouver", [
		["2023-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2023-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2023-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2023-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2024" : helpers.makeTestYear("America/Vancouver", [
		["2024-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2024-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2024-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2024-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2025" : helpers.makeTestYear("America/Vancouver", [
		["2025-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2025-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2025-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2025-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2026" : helpers.makeTestYear("America/Vancouver", [
		["2026-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2026-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2026-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2026-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2027" : helpers.makeTestYear("America/Vancouver", [
		["2027-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2027-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2027-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2027-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2028" : helpers.makeTestYear("America/Vancouver", [
		["2028-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2028-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2028-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2028-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2029" : helpers.makeTestYear("America/Vancouver", [
		["2029-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2029-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2029-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2029-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2030" : helpers.makeTestYear("America/Vancouver", [
		["2030-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2030-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2030-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2030-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2031" : helpers.makeTestYear("America/Vancouver", [
		["2031-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2031-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2031-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2031-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2032" : helpers.makeTestYear("America/Vancouver", [
		["2032-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2032-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2032-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2032-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2033" : helpers.makeTestYear("America/Vancouver", [
		["2033-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2033-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2033-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2033-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2034" : helpers.makeTestYear("America/Vancouver", [
		["2034-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2034-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2034-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2034-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2035" : helpers.makeTestYear("America/Vancouver", [
		["2035-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2035-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2035-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2035-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2036" : helpers.makeTestYear("America/Vancouver", [
		["2036-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2036-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2036-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2036-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2037" : helpers.makeTestYear("America/Vancouver", [
		["2037-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2037-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2037-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2037-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2038" : helpers.makeTestYear("America/Vancouver", [
		["2038-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2038-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2038-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2038-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2039" : helpers.makeTestYear("America/Vancouver", [
		["2039-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2039-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2039-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2039-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2040" : helpers.makeTestYear("America/Vancouver", [
		["2040-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2040-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2040-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2040-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2041" : helpers.makeTestYear("America/Vancouver", [
		["2041-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2041-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2041-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2041-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2042" : helpers.makeTestYear("America/Vancouver", [
		["2042-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2042-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2042-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2042-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2043" : helpers.makeTestYear("America/Vancouver", [
		["2043-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2043-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2043-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2043-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2044" : helpers.makeTestYear("America/Vancouver", [
		["2044-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2044-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2044-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2044-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2045" : helpers.makeTestYear("America/Vancouver", [
		["2045-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2045-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2045-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2045-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2046" : helpers.makeTestYear("America/Vancouver", [
		["2046-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2046-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2046-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2046-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2047" : helpers.makeTestYear("America/Vancouver", [
		["2047-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2047-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2047-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2047-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2048" : helpers.makeTestYear("America/Vancouver", [
		["2048-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2048-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2048-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2048-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2049" : helpers.makeTestYear("America/Vancouver", [
		["2049-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2049-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2049-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2049-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2050" : helpers.makeTestYear("America/Vancouver", [
		["2050-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2050-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2050-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2050-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2051" : helpers.makeTestYear("America/Vancouver", [
		["2051-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2051-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2051-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2051-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2052" : helpers.makeTestYear("America/Vancouver", [
		["2052-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2052-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2052-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2052-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2053" : helpers.makeTestYear("America/Vancouver", [
		["2053-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2053-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2053-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2053-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2054" : helpers.makeTestYear("America/Vancouver", [
		["2054-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2054-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2054-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2054-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2055" : helpers.makeTestYear("America/Vancouver", [
		["2055-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2055-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2055-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2055-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2056" : helpers.makeTestYear("America/Vancouver", [
		["2056-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2056-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2056-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2056-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2057" : helpers.makeTestYear("America/Vancouver", [
		["2057-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2057-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2057-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2057-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2058" : helpers.makeTestYear("America/Vancouver", [
		["2058-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2058-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2058-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2058-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2059" : helpers.makeTestYear("America/Vancouver", [
		["2059-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2059-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2059-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2059-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2060" : helpers.makeTestYear("America/Vancouver", [
		["2060-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2060-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2060-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2060-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2061" : helpers.makeTestYear("America/Vancouver", [
		["2061-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2061-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2061-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2061-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2062" : helpers.makeTestYear("America/Vancouver", [
		["2062-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2062-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2062-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2062-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2063" : helpers.makeTestYear("America/Vancouver", [
		["2063-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2063-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2063-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2063-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2064" : helpers.makeTestYear("America/Vancouver", [
		["2064-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2064-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2064-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2064-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2065" : helpers.makeTestYear("America/Vancouver", [
		["2065-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2065-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2065-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2065-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2066" : helpers.makeTestYear("America/Vancouver", [
		["2066-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2066-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2066-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2066-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2067" : helpers.makeTestYear("America/Vancouver", [
		["2067-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2067-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2067-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2067-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2068" : helpers.makeTestYear("America/Vancouver", [
		["2068-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2068-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2068-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2068-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2069" : helpers.makeTestYear("America/Vancouver", [
		["2069-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2069-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2069-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2069-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2070" : helpers.makeTestYear("America/Vancouver", [
		["2070-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2070-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2070-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2070-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2071" : helpers.makeTestYear("America/Vancouver", [
		["2071-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2071-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2071-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2071-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2072" : helpers.makeTestYear("America/Vancouver", [
		["2072-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2072-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2072-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2072-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2073" : helpers.makeTestYear("America/Vancouver", [
		["2073-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2073-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2073-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2073-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2074" : helpers.makeTestYear("America/Vancouver", [
		["2074-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2074-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2074-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2074-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2075" : helpers.makeTestYear("America/Vancouver", [
		["2075-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2075-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2075-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2075-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2076" : helpers.makeTestYear("America/Vancouver", [
		["2076-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2076-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2076-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2076-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2077" : helpers.makeTestYear("America/Vancouver", [
		["2077-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2077-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2077-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2077-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2078" : helpers.makeTestYear("America/Vancouver", [
		["2078-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2078-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2078-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2078-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2079" : helpers.makeTestYear("America/Vancouver", [
		["2079-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2079-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2079-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2079-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2080" : helpers.makeTestYear("America/Vancouver", [
		["2080-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2080-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2080-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2080-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2081" : helpers.makeTestYear("America/Vancouver", [
		["2081-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2081-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2081-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2081-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2082" : helpers.makeTestYear("America/Vancouver", [
		["2082-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2082-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2082-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2082-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2083" : helpers.makeTestYear("America/Vancouver", [
		["2083-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2083-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2083-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2083-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2084" : helpers.makeTestYear("America/Vancouver", [
		["2084-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2084-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2084-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2084-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2085" : helpers.makeTestYear("America/Vancouver", [
		["2085-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2085-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2085-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2085-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2086" : helpers.makeTestYear("America/Vancouver", [
		["2086-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2086-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2086-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2086-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2087" : helpers.makeTestYear("America/Vancouver", [
		["2087-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2087-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2087-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2087-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2088" : helpers.makeTestYear("America/Vancouver", [
		["2088-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2088-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2088-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2088-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2089" : helpers.makeTestYear("America/Vancouver", [
		["2089-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2089-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2089-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2089-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2090" : helpers.makeTestYear("America/Vancouver", [
		["2090-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2090-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2090-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2090-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2091" : helpers.makeTestYear("America/Vancouver", [
		["2091-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2091-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2091-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2091-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2092" : helpers.makeTestYear("America/Vancouver", [
		["2092-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2092-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2092-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2092-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2093" : helpers.makeTestYear("America/Vancouver", [
		["2093-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2093-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2093-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2093-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2094" : helpers.makeTestYear("America/Vancouver", [
		["2094-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2094-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2094-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2094-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2095" : helpers.makeTestYear("America/Vancouver", [
		["2095-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2095-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2095-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2095-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2096" : helpers.makeTestYear("America/Vancouver", [
		["2096-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2096-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2096-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2096-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2097" : helpers.makeTestYear("America/Vancouver", [
		["2097-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2097-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2097-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2097-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2098" : helpers.makeTestYear("America/Vancouver", [
		["2098-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2098-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2098-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2098-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2099" : helpers.makeTestYear("America/Vancouver", [
		["2099-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2099-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2099-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2099-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2100" : helpers.makeTestYear("America/Vancouver", [
		["2100-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2100-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2100-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2100-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2101" : helpers.makeTestYear("America/Vancouver", [
		["2101-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2101-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2101-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2101-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2102" : helpers.makeTestYear("America/Vancouver", [
		["2102-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2102-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2102-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2102-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2103" : helpers.makeTestYear("America/Vancouver", [
		["2103-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2103-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2103-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2103-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2104" : helpers.makeTestYear("America/Vancouver", [
		["2104-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2104-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2104-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2104-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2105" : helpers.makeTestYear("America/Vancouver", [
		["2105-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2105-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2105-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2105-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2106" : helpers.makeTestYear("America/Vancouver", [
		["2106-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2106-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2106-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2106-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2107" : helpers.makeTestYear("America/Vancouver", [
		["2107-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2107-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2107-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2107-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2108" : helpers.makeTestYear("America/Vancouver", [
		["2108-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2108-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2108-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2108-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2109" : helpers.makeTestYear("America/Vancouver", [
		["2109-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2109-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2109-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2109-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2110" : helpers.makeTestYear("America/Vancouver", [
		["2110-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2110-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2110-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2110-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2111" : helpers.makeTestYear("America/Vancouver", [
		["2111-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2111-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2111-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2111-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2112" : helpers.makeTestYear("America/Vancouver", [
		["2112-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2112-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2112-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2112-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2113" : helpers.makeTestYear("America/Vancouver", [
		["2113-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2113-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2113-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2113-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2114" : helpers.makeTestYear("America/Vancouver", [
		["2114-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2114-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2114-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2114-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2115" : helpers.makeTestYear("America/Vancouver", [
		["2115-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2115-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2115-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2115-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2116" : helpers.makeTestYear("America/Vancouver", [
		["2116-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2116-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2116-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2116-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2117" : helpers.makeTestYear("America/Vancouver", [
		["2117-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2117-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2117-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2117-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2118" : helpers.makeTestYear("America/Vancouver", [
		["2118-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2118-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2118-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2118-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2119" : helpers.makeTestYear("America/Vancouver", [
		["2119-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2119-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2119-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2119-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2120" : helpers.makeTestYear("America/Vancouver", [
		["2120-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2120-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2120-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2120-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2121" : helpers.makeTestYear("America/Vancouver", [
		["2121-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2121-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2121-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2121-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2122" : helpers.makeTestYear("America/Vancouver", [
		["2122-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2122-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2122-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2122-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2123" : helpers.makeTestYear("America/Vancouver", [
		["2123-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2123-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2123-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2123-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2124" : helpers.makeTestYear("America/Vancouver", [
		["2124-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2124-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2124-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2124-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2125" : helpers.makeTestYear("America/Vancouver", [
		["2125-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2125-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2125-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2125-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2126" : helpers.makeTestYear("America/Vancouver", [
		["2126-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2126-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2126-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2126-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2127" : helpers.makeTestYear("America/Vancouver", [
		["2127-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2127-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2127-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2127-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2128" : helpers.makeTestYear("America/Vancouver", [
		["2128-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2128-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2128-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2128-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2129" : helpers.makeTestYear("America/Vancouver", [
		["2129-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2129-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2129-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2129-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2130" : helpers.makeTestYear("America/Vancouver", [
		["2130-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2130-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2130-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2130-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2131" : helpers.makeTestYear("America/Vancouver", [
		["2131-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2131-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2131-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2131-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2132" : helpers.makeTestYear("America/Vancouver", [
		["2132-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2132-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2132-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2132-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2133" : helpers.makeTestYear("America/Vancouver", [
		["2133-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2133-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2133-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2133-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2134" : helpers.makeTestYear("America/Vancouver", [
		["2134-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2134-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2134-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2134-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2135" : helpers.makeTestYear("America/Vancouver", [
		["2135-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2135-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2135-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2135-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2136" : helpers.makeTestYear("America/Vancouver", [
		["2136-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2136-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2136-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2136-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2137" : helpers.makeTestYear("America/Vancouver", [
		["2137-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2137-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2137-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2137-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2138" : helpers.makeTestYear("America/Vancouver", [
		["2138-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2138-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2138-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2138-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2139" : helpers.makeTestYear("America/Vancouver", [
		["2139-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2139-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2139-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2139-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2140" : helpers.makeTestYear("America/Vancouver", [
		["2140-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2140-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2140-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2140-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2141" : helpers.makeTestYear("America/Vancouver", [
		["2141-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2141-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2141-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2141-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2142" : helpers.makeTestYear("America/Vancouver", [
		["2142-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2142-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2142-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2142-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2143" : helpers.makeTestYear("America/Vancouver", [
		["2143-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2143-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2143-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2143-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2144" : helpers.makeTestYear("America/Vancouver", [
		["2144-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2144-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2144-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2144-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2145" : helpers.makeTestYear("America/Vancouver", [
		["2145-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2145-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2145-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2145-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2146" : helpers.makeTestYear("America/Vancouver", [
		["2146-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2146-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2146-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2146-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2147" : helpers.makeTestYear("America/Vancouver", [
		["2147-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2147-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2147-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2147-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2148" : helpers.makeTestYear("America/Vancouver", [
		["2148-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2148-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2148-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2148-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2149" : helpers.makeTestYear("America/Vancouver", [
		["2149-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2149-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2149-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2149-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2150" : helpers.makeTestYear("America/Vancouver", [
		["2150-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2150-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2150-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2150-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2151" : helpers.makeTestYear("America/Vancouver", [
		["2151-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2151-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2151-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2151-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2152" : helpers.makeTestYear("America/Vancouver", [
		["2152-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2152-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2152-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2152-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2153" : helpers.makeTestYear("America/Vancouver", [
		["2153-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2153-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2153-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2153-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2154" : helpers.makeTestYear("America/Vancouver", [
		["2154-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2154-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2154-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2154-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2155" : helpers.makeTestYear("America/Vancouver", [
		["2155-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2155-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2155-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2155-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2156" : helpers.makeTestYear("America/Vancouver", [
		["2156-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2156-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2156-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2156-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2157" : helpers.makeTestYear("America/Vancouver", [
		["2157-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2157-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2157-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2157-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2158" : helpers.makeTestYear("America/Vancouver", [
		["2158-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2158-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2158-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2158-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2159" : helpers.makeTestYear("America/Vancouver", [
		["2159-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2159-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2159-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2159-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2160" : helpers.makeTestYear("America/Vancouver", [
		["2160-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2160-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2160-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2160-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2161" : helpers.makeTestYear("America/Vancouver", [
		["2161-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2161-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2161-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2161-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2162" : helpers.makeTestYear("America/Vancouver", [
		["2162-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2162-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2162-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2162-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2163" : helpers.makeTestYear("America/Vancouver", [
		["2163-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2163-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2163-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2163-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2164" : helpers.makeTestYear("America/Vancouver", [
		["2164-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2164-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2164-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2164-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2165" : helpers.makeTestYear("America/Vancouver", [
		["2165-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2165-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2165-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2165-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2166" : helpers.makeTestYear("America/Vancouver", [
		["2166-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2166-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2166-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2166-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2167" : helpers.makeTestYear("America/Vancouver", [
		["2167-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2167-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2167-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2167-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2168" : helpers.makeTestYear("America/Vancouver", [
		["2168-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2168-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2168-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2168-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2169" : helpers.makeTestYear("America/Vancouver", [
		["2169-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2169-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2169-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2169-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2170" : helpers.makeTestYear("America/Vancouver", [
		["2170-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2170-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2170-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2170-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2171" : helpers.makeTestYear("America/Vancouver", [
		["2171-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2171-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2171-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2171-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2172" : helpers.makeTestYear("America/Vancouver", [
		["2172-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2172-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2172-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2172-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2173" : helpers.makeTestYear("America/Vancouver", [
		["2173-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2173-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2173-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2173-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2174" : helpers.makeTestYear("America/Vancouver", [
		["2174-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2174-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2174-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2174-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2175" : helpers.makeTestYear("America/Vancouver", [
		["2175-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2175-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2175-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2175-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2176" : helpers.makeTestYear("America/Vancouver", [
		["2176-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2176-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2176-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2176-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2177" : helpers.makeTestYear("America/Vancouver", [
		["2177-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2177-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2177-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2177-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2178" : helpers.makeTestYear("America/Vancouver", [
		["2178-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2178-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2178-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2178-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2179" : helpers.makeTestYear("America/Vancouver", [
		["2179-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2179-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2179-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2179-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2180" : helpers.makeTestYear("America/Vancouver", [
		["2180-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2180-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2180-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2180-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2181" : helpers.makeTestYear("America/Vancouver", [
		["2181-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2181-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2181-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2181-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2182" : helpers.makeTestYear("America/Vancouver", [
		["2182-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2182-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2182-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2182-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2183" : helpers.makeTestYear("America/Vancouver", [
		["2183-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2183-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2183-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2183-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2184" : helpers.makeTestYear("America/Vancouver", [
		["2184-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2184-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2184-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2184-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2185" : helpers.makeTestYear("America/Vancouver", [
		["2185-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2185-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2185-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2185-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2186" : helpers.makeTestYear("America/Vancouver", [
		["2186-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2186-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2186-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2186-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2187" : helpers.makeTestYear("America/Vancouver", [
		["2187-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2187-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2187-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2187-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2188" : helpers.makeTestYear("America/Vancouver", [
		["2188-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2188-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2188-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2188-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2189" : helpers.makeTestYear("America/Vancouver", [
		["2189-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2189-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2189-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2189-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2190" : helpers.makeTestYear("America/Vancouver", [
		["2190-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2190-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2190-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2190-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2191" : helpers.makeTestYear("America/Vancouver", [
		["2191-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2191-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2191-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2191-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2192" : helpers.makeTestYear("America/Vancouver", [
		["2192-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2192-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2192-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2192-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2193" : helpers.makeTestYear("America/Vancouver", [
		["2193-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2193-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2193-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2193-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2194" : helpers.makeTestYear("America/Vancouver", [
		["2194-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2194-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2194-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2194-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2195" : helpers.makeTestYear("America/Vancouver", [
		["2195-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2195-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2195-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2195-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2196" : helpers.makeTestYear("America/Vancouver", [
		["2196-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2196-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2196-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2196-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2197" : helpers.makeTestYear("America/Vancouver", [
		["2197-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2197-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2197-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2197-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2198" : helpers.makeTestYear("America/Vancouver", [
		["2198-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2198-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2198-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2198-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2199" : helpers.makeTestYear("America/Vancouver", [
		["2199-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2199-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2199-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2199-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2200" : helpers.makeTestYear("America/Vancouver", [
		["2200-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2200-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2200-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2200-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2201" : helpers.makeTestYear("America/Vancouver", [
		["2201-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2201-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2201-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2201-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2202" : helpers.makeTestYear("America/Vancouver", [
		["2202-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2202-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2202-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2202-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2203" : helpers.makeTestYear("America/Vancouver", [
		["2203-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2203-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2203-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2203-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2204" : helpers.makeTestYear("America/Vancouver", [
		["2204-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2204-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2204-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2204-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2205" : helpers.makeTestYear("America/Vancouver", [
		["2205-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2205-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2205-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2205-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2206" : helpers.makeTestYear("America/Vancouver", [
		["2206-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2206-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2206-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2206-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2207" : helpers.makeTestYear("America/Vancouver", [
		["2207-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2207-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2207-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2207-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2208" : helpers.makeTestYear("America/Vancouver", [
		["2208-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2208-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2208-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2208-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2209" : helpers.makeTestYear("America/Vancouver", [
		["2209-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2209-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2209-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2209-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2210" : helpers.makeTestYear("America/Vancouver", [
		["2210-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2210-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2210-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2210-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2211" : helpers.makeTestYear("America/Vancouver", [
		["2211-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2211-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2211-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2211-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2212" : helpers.makeTestYear("America/Vancouver", [
		["2212-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2212-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2212-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2212-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2213" : helpers.makeTestYear("America/Vancouver", [
		["2213-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2213-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2213-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2213-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2214" : helpers.makeTestYear("America/Vancouver", [
		["2214-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2214-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2214-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2214-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2215" : helpers.makeTestYear("America/Vancouver", [
		["2215-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2215-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2215-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2215-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2216" : helpers.makeTestYear("America/Vancouver", [
		["2216-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2216-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2216-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2216-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2217" : helpers.makeTestYear("America/Vancouver", [
		["2217-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2217-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2217-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2217-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2218" : helpers.makeTestYear("America/Vancouver", [
		["2218-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2218-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2218-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2218-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2219" : helpers.makeTestYear("America/Vancouver", [
		["2219-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2219-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2219-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2219-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2220" : helpers.makeTestYear("America/Vancouver", [
		["2220-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2220-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2220-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2220-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2221" : helpers.makeTestYear("America/Vancouver", [
		["2221-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2221-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2221-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2221-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2222" : helpers.makeTestYear("America/Vancouver", [
		["2222-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2222-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2222-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2222-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2223" : helpers.makeTestYear("America/Vancouver", [
		["2223-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2223-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2223-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2223-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2224" : helpers.makeTestYear("America/Vancouver", [
		["2224-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2224-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2224-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2224-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2225" : helpers.makeTestYear("America/Vancouver", [
		["2225-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2225-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2225-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2225-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2226" : helpers.makeTestYear("America/Vancouver", [
		["2226-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2226-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2226-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2226-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2227" : helpers.makeTestYear("America/Vancouver", [
		["2227-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2227-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2227-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2227-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2228" : helpers.makeTestYear("America/Vancouver", [
		["2228-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2228-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2228-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2228-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2229" : helpers.makeTestYear("America/Vancouver", [
		["2229-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2229-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2229-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2229-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2230" : helpers.makeTestYear("America/Vancouver", [
		["2230-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2230-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2230-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2230-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2231" : helpers.makeTestYear("America/Vancouver", [
		["2231-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2231-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2231-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2231-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2232" : helpers.makeTestYear("America/Vancouver", [
		["2232-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2232-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2232-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2232-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2233" : helpers.makeTestYear("America/Vancouver", [
		["2233-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2233-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2233-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2233-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2234" : helpers.makeTestYear("America/Vancouver", [
		["2234-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2234-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2234-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2234-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2235" : helpers.makeTestYear("America/Vancouver", [
		["2235-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2235-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2235-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2235-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2236" : helpers.makeTestYear("America/Vancouver", [
		["2236-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2236-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2236-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2236-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2237" : helpers.makeTestYear("America/Vancouver", [
		["2237-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2237-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2237-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2237-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2238" : helpers.makeTestYear("America/Vancouver", [
		["2238-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2238-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2238-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2238-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2239" : helpers.makeTestYear("America/Vancouver", [
		["2239-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2239-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2239-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2239-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2240" : helpers.makeTestYear("America/Vancouver", [
		["2240-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2240-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2240-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2240-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2241" : helpers.makeTestYear("America/Vancouver", [
		["2241-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2241-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2241-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2241-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2242" : helpers.makeTestYear("America/Vancouver", [
		["2242-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2242-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2242-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2242-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2243" : helpers.makeTestYear("America/Vancouver", [
		["2243-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2243-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2243-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2243-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2244" : helpers.makeTestYear("America/Vancouver", [
		["2244-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2244-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2244-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2244-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2245" : helpers.makeTestYear("America/Vancouver", [
		["2245-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2245-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2245-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2245-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2246" : helpers.makeTestYear("America/Vancouver", [
		["2246-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2246-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2246-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2246-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2247" : helpers.makeTestYear("America/Vancouver", [
		["2247-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2247-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2247-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2247-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2248" : helpers.makeTestYear("America/Vancouver", [
		["2248-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2248-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2248-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2248-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2249" : helpers.makeTestYear("America/Vancouver", [
		["2249-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2249-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2249-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2249-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2250" : helpers.makeTestYear("America/Vancouver", [
		["2250-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2250-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2250-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2250-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2251" : helpers.makeTestYear("America/Vancouver", [
		["2251-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2251-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2251-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2251-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2252" : helpers.makeTestYear("America/Vancouver", [
		["2252-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2252-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2252-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2252-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2253" : helpers.makeTestYear("America/Vancouver", [
		["2253-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2253-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2253-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2253-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2254" : helpers.makeTestYear("America/Vancouver", [
		["2254-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2254-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2254-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2254-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2255" : helpers.makeTestYear("America/Vancouver", [
		["2255-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2255-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2255-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2255-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2256" : helpers.makeTestYear("America/Vancouver", [
		["2256-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2256-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2256-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2256-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2257" : helpers.makeTestYear("America/Vancouver", [
		["2257-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2257-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2257-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2257-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2258" : helpers.makeTestYear("America/Vancouver", [
		["2258-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2258-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2258-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2258-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2259" : helpers.makeTestYear("America/Vancouver", [
		["2259-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2259-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2259-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2259-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2260" : helpers.makeTestYear("America/Vancouver", [
		["2260-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2260-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2260-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2260-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2261" : helpers.makeTestYear("America/Vancouver", [
		["2261-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2261-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2261-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2261-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2262" : helpers.makeTestYear("America/Vancouver", [
		["2262-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2262-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2262-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2262-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2263" : helpers.makeTestYear("America/Vancouver", [
		["2263-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2263-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2263-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2263-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2264" : helpers.makeTestYear("America/Vancouver", [
		["2264-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2264-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2264-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2264-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2265" : helpers.makeTestYear("America/Vancouver", [
		["2265-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2265-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2265-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2265-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2266" : helpers.makeTestYear("America/Vancouver", [
		["2266-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2266-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2266-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2266-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2267" : helpers.makeTestYear("America/Vancouver", [
		["2267-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2267-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2267-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2267-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2268" : helpers.makeTestYear("America/Vancouver", [
		["2268-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2268-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2268-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2268-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2269" : helpers.makeTestYear("America/Vancouver", [
		["2269-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2269-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2269-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2269-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2270" : helpers.makeTestYear("America/Vancouver", [
		["2270-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2270-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2270-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2270-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2271" : helpers.makeTestYear("America/Vancouver", [
		["2271-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2271-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2271-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2271-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2272" : helpers.makeTestYear("America/Vancouver", [
		["2272-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2272-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2272-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2272-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2273" : helpers.makeTestYear("America/Vancouver", [
		["2273-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2273-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2273-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2273-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2274" : helpers.makeTestYear("America/Vancouver", [
		["2274-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2274-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2274-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2274-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2275" : helpers.makeTestYear("America/Vancouver", [
		["2275-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2275-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2275-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2275-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2276" : helpers.makeTestYear("America/Vancouver", [
		["2276-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2276-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2276-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2276-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2277" : helpers.makeTestYear("America/Vancouver", [
		["2277-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2277-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2277-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2277-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2278" : helpers.makeTestYear("America/Vancouver", [
		["2278-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2278-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2278-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2278-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2279" : helpers.makeTestYear("America/Vancouver", [
		["2279-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2279-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2279-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2279-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2280" : helpers.makeTestYear("America/Vancouver", [
		["2280-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2280-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2280-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2280-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2281" : helpers.makeTestYear("America/Vancouver", [
		["2281-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2281-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2281-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2281-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2282" : helpers.makeTestYear("America/Vancouver", [
		["2282-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2282-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2282-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2282-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2283" : helpers.makeTestYear("America/Vancouver", [
		["2283-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2283-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2283-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2283-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2284" : helpers.makeTestYear("America/Vancouver", [
		["2284-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2284-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2284-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2284-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2285" : helpers.makeTestYear("America/Vancouver", [
		["2285-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2285-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2285-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2285-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2286" : helpers.makeTestYear("America/Vancouver", [
		["2286-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2286-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2286-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2286-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2287" : helpers.makeTestYear("America/Vancouver", [
		["2287-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2287-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2287-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2287-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2288" : helpers.makeTestYear("America/Vancouver", [
		["2288-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2288-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2288-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2288-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2289" : helpers.makeTestYear("America/Vancouver", [
		["2289-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2289-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2289-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2289-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2290" : helpers.makeTestYear("America/Vancouver", [
		["2290-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2290-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2290-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2290-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2291" : helpers.makeTestYear("America/Vancouver", [
		["2291-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2291-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2291-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2291-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2292" : helpers.makeTestYear("America/Vancouver", [
		["2292-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2292-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2292-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2292-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2293" : helpers.makeTestYear("America/Vancouver", [
		["2293-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2293-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2293-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2293-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2294" : helpers.makeTestYear("America/Vancouver", [
		["2294-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2294-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2294-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2294-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2295" : helpers.makeTestYear("America/Vancouver", [
		["2295-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2295-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2295-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2295-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2296" : helpers.makeTestYear("America/Vancouver", [
		["2296-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2296-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2296-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2296-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2297" : helpers.makeTestYear("America/Vancouver", [
		["2297-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2297-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2297-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2297-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2298" : helpers.makeTestYear("America/Vancouver", [
		["2298-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2298-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2298-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2298-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2299" : helpers.makeTestYear("America/Vancouver", [
		["2299-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2299-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2299-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2299-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2300" : helpers.makeTestYear("America/Vancouver", [
		["2300-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2300-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2300-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2300-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2301" : helpers.makeTestYear("America/Vancouver", [
		["2301-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2301-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2301-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2301-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2302" : helpers.makeTestYear("America/Vancouver", [
		["2302-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2302-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2302-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2302-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2303" : helpers.makeTestYear("America/Vancouver", [
		["2303-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2303-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2303-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2303-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2304" : helpers.makeTestYear("America/Vancouver", [
		["2304-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2304-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2304-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2304-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2305" : helpers.makeTestYear("America/Vancouver", [
		["2305-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2305-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2305-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2305-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2306" : helpers.makeTestYear("America/Vancouver", [
		["2306-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2306-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2306-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2306-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2307" : helpers.makeTestYear("America/Vancouver", [
		["2307-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2307-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2307-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2307-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2308" : helpers.makeTestYear("America/Vancouver", [
		["2308-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2308-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2308-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2308-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2309" : helpers.makeTestYear("America/Vancouver", [
		["2309-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2309-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2309-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2309-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2310" : helpers.makeTestYear("America/Vancouver", [
		["2310-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2310-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2310-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2310-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2311" : helpers.makeTestYear("America/Vancouver", [
		["2311-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2311-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2311-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2311-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2312" : helpers.makeTestYear("America/Vancouver", [
		["2312-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2312-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2312-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2312-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2313" : helpers.makeTestYear("America/Vancouver", [
		["2313-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2313-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2313-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2313-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2314" : helpers.makeTestYear("America/Vancouver", [
		["2314-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2314-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2314-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2314-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2315" : helpers.makeTestYear("America/Vancouver", [
		["2315-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2315-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2315-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2315-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2316" : helpers.makeTestYear("America/Vancouver", [
		["2316-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2316-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2316-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2316-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2317" : helpers.makeTestYear("America/Vancouver", [
		["2317-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2317-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2317-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2317-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2318" : helpers.makeTestYear("America/Vancouver", [
		["2318-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2318-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2318-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2318-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2319" : helpers.makeTestYear("America/Vancouver", [
		["2319-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2319-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2319-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2319-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2320" : helpers.makeTestYear("America/Vancouver", [
		["2320-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2320-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2320-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2320-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2321" : helpers.makeTestYear("America/Vancouver", [
		["2321-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2321-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2321-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2321-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2322" : helpers.makeTestYear("America/Vancouver", [
		["2322-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2322-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2322-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2322-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2323" : helpers.makeTestYear("America/Vancouver", [
		["2323-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2323-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2323-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2323-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2324" : helpers.makeTestYear("America/Vancouver", [
		["2324-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2324-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2324-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2324-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2325" : helpers.makeTestYear("America/Vancouver", [
		["2325-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2325-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2325-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2325-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2326" : helpers.makeTestYear("America/Vancouver", [
		["2326-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2326-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2326-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2326-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2327" : helpers.makeTestYear("America/Vancouver", [
		["2327-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2327-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2327-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2327-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2328" : helpers.makeTestYear("America/Vancouver", [
		["2328-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2328-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2328-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2328-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2329" : helpers.makeTestYear("America/Vancouver", [
		["2329-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2329-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2329-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2329-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2330" : helpers.makeTestYear("America/Vancouver", [
		["2330-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2330-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2330-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2330-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2331" : helpers.makeTestYear("America/Vancouver", [
		["2331-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2331-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2331-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2331-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2332" : helpers.makeTestYear("America/Vancouver", [
		["2332-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2332-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2332-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2332-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2333" : helpers.makeTestYear("America/Vancouver", [
		["2333-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2333-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2333-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2333-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2334" : helpers.makeTestYear("America/Vancouver", [
		["2334-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2334-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2334-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2334-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2335" : helpers.makeTestYear("America/Vancouver", [
		["2335-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2335-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2335-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2335-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2336" : helpers.makeTestYear("America/Vancouver", [
		["2336-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2336-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2336-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2336-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2337" : helpers.makeTestYear("America/Vancouver", [
		["2337-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2337-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2337-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2337-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2338" : helpers.makeTestYear("America/Vancouver", [
		["2338-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2338-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2338-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2338-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2339" : helpers.makeTestYear("America/Vancouver", [
		["2339-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2339-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2339-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2339-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2340" : helpers.makeTestYear("America/Vancouver", [
		["2340-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2340-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2340-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2340-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2341" : helpers.makeTestYear("America/Vancouver", [
		["2341-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2341-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2341-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2341-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2342" : helpers.makeTestYear("America/Vancouver", [
		["2342-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2342-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2342-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2342-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2343" : helpers.makeTestYear("America/Vancouver", [
		["2343-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2343-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2343-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2343-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2344" : helpers.makeTestYear("America/Vancouver", [
		["2344-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2344-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2344-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2344-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2345" : helpers.makeTestYear("America/Vancouver", [
		["2345-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2345-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2345-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2345-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2346" : helpers.makeTestYear("America/Vancouver", [
		["2346-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2346-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2346-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2346-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2347" : helpers.makeTestYear("America/Vancouver", [
		["2347-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2347-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2347-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2347-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2348" : helpers.makeTestYear("America/Vancouver", [
		["2348-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2348-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2348-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2348-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2349" : helpers.makeTestYear("America/Vancouver", [
		["2349-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2349-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2349-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2349-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2350" : helpers.makeTestYear("America/Vancouver", [
		["2350-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2350-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2350-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2350-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2351" : helpers.makeTestYear("America/Vancouver", [
		["2351-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2351-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2351-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2351-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2352" : helpers.makeTestYear("America/Vancouver", [
		["2352-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2352-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2352-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2352-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2353" : helpers.makeTestYear("America/Vancouver", [
		["2353-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2353-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2353-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2353-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2354" : helpers.makeTestYear("America/Vancouver", [
		["2354-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2354-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2354-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2354-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2355" : helpers.makeTestYear("America/Vancouver", [
		["2355-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2355-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2355-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2355-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2356" : helpers.makeTestYear("America/Vancouver", [
		["2356-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2356-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2356-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2356-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2357" : helpers.makeTestYear("America/Vancouver", [
		["2357-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2357-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2357-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2357-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2358" : helpers.makeTestYear("America/Vancouver", [
		["2358-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2358-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2358-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2358-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2359" : helpers.makeTestYear("America/Vancouver", [
		["2359-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2359-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2359-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2359-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2360" : helpers.makeTestYear("America/Vancouver", [
		["2360-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2360-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2360-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2360-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2361" : helpers.makeTestYear("America/Vancouver", [
		["2361-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2361-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2361-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2361-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2362" : helpers.makeTestYear("America/Vancouver", [
		["2362-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2362-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2362-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2362-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2363" : helpers.makeTestYear("America/Vancouver", [
		["2363-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2363-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2363-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2363-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2364" : helpers.makeTestYear("America/Vancouver", [
		["2364-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2364-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2364-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2364-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2365" : helpers.makeTestYear("America/Vancouver", [
		["2365-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2365-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2365-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2365-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2366" : helpers.makeTestYear("America/Vancouver", [
		["2366-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2366-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2366-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2366-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2367" : helpers.makeTestYear("America/Vancouver", [
		["2367-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2367-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2367-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2367-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2368" : helpers.makeTestYear("America/Vancouver", [
		["2368-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2368-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2368-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2368-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2369" : helpers.makeTestYear("America/Vancouver", [
		["2369-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2369-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2369-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2369-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2370" : helpers.makeTestYear("America/Vancouver", [
		["2370-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2370-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2370-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2370-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2371" : helpers.makeTestYear("America/Vancouver", [
		["2371-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2371-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2371-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2371-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2372" : helpers.makeTestYear("America/Vancouver", [
		["2372-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2372-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2372-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2372-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2373" : helpers.makeTestYear("America/Vancouver", [
		["2373-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2373-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2373-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2373-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2374" : helpers.makeTestYear("America/Vancouver", [
		["2374-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2374-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2374-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2374-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2375" : helpers.makeTestYear("America/Vancouver", [
		["2375-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2375-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2375-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2375-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2376" : helpers.makeTestYear("America/Vancouver", [
		["2376-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2376-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2376-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2376-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2377" : helpers.makeTestYear("America/Vancouver", [
		["2377-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2377-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2377-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2377-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2378" : helpers.makeTestYear("America/Vancouver", [
		["2378-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2378-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2378-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2378-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2379" : helpers.makeTestYear("America/Vancouver", [
		["2379-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2379-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2379-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2379-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2380" : helpers.makeTestYear("America/Vancouver", [
		["2380-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2380-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2380-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2380-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2381" : helpers.makeTestYear("America/Vancouver", [
		["2381-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2381-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2381-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2381-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2382" : helpers.makeTestYear("America/Vancouver", [
		["2382-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2382-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2382-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2382-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2383" : helpers.makeTestYear("America/Vancouver", [
		["2383-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2383-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2383-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2383-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2384" : helpers.makeTestYear("America/Vancouver", [
		["2384-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2384-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2384-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2384-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2385" : helpers.makeTestYear("America/Vancouver", [
		["2385-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2385-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2385-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2385-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2386" : helpers.makeTestYear("America/Vancouver", [
		["2386-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2386-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2386-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2386-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2387" : helpers.makeTestYear("America/Vancouver", [
		["2387-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2387-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2387-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2387-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2388" : helpers.makeTestYear("America/Vancouver", [
		["2388-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2388-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2388-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2388-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2389" : helpers.makeTestYear("America/Vancouver", [
		["2389-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2389-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2389-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2389-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2390" : helpers.makeTestYear("America/Vancouver", [
		["2390-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2390-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2390-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2390-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2391" : helpers.makeTestYear("America/Vancouver", [
		["2391-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2391-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2391-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2391-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2392" : helpers.makeTestYear("America/Vancouver", [
		["2392-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2392-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2392-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2392-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2393" : helpers.makeTestYear("America/Vancouver", [
		["2393-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2393-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2393-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2393-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2394" : helpers.makeTestYear("America/Vancouver", [
		["2394-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2394-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2394-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2394-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2395" : helpers.makeTestYear("America/Vancouver", [
		["2395-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2395-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2395-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2395-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2396" : helpers.makeTestYear("America/Vancouver", [
		["2396-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2396-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2396-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2396-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2397" : helpers.makeTestYear("America/Vancouver", [
		["2397-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2397-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2397-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2397-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2398" : helpers.makeTestYear("America/Vancouver", [
		["2398-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2398-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2398-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2398-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2399" : helpers.makeTestYear("America/Vancouver", [
		["2399-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2399-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2399-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2399-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2400" : helpers.makeTestYear("America/Vancouver", [
		["2400-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2400-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2400-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2400-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2401" : helpers.makeTestYear("America/Vancouver", [
		["2401-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2401-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2401-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2401-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2402" : helpers.makeTestYear("America/Vancouver", [
		["2402-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2402-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2402-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2402-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2403" : helpers.makeTestYear("America/Vancouver", [
		["2403-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2403-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2403-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2403-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2404" : helpers.makeTestYear("America/Vancouver", [
		["2404-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2404-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2404-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2404-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2405" : helpers.makeTestYear("America/Vancouver", [
		["2405-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2405-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2405-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2405-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2406" : helpers.makeTestYear("America/Vancouver", [
		["2406-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2406-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2406-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2406-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2407" : helpers.makeTestYear("America/Vancouver", [
		["2407-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2407-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2407-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2407-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2408" : helpers.makeTestYear("America/Vancouver", [
		["2408-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2408-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2408-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2408-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2409" : helpers.makeTestYear("America/Vancouver", [
		["2409-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2409-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2409-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2409-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2410" : helpers.makeTestYear("America/Vancouver", [
		["2410-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2410-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2410-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2410-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2411" : helpers.makeTestYear("America/Vancouver", [
		["2411-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2411-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2411-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2411-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2412" : helpers.makeTestYear("America/Vancouver", [
		["2412-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2412-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2412-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2412-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2413" : helpers.makeTestYear("America/Vancouver", [
		["2413-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2413-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2413-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2413-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2414" : helpers.makeTestYear("America/Vancouver", [
		["2414-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2414-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2414-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2414-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2415" : helpers.makeTestYear("America/Vancouver", [
		["2415-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2415-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2415-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2415-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2416" : helpers.makeTestYear("America/Vancouver", [
		["2416-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2416-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2416-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2416-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2417" : helpers.makeTestYear("America/Vancouver", [
		["2417-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2417-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2417-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2417-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2418" : helpers.makeTestYear("America/Vancouver", [
		["2418-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2418-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2418-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2418-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2419" : helpers.makeTestYear("America/Vancouver", [
		["2419-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2419-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2419-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2419-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2420" : helpers.makeTestYear("America/Vancouver", [
		["2420-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2420-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2420-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2420-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2421" : helpers.makeTestYear("America/Vancouver", [
		["2421-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2421-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2421-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2421-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2422" : helpers.makeTestYear("America/Vancouver", [
		["2422-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2422-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2422-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2422-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2423" : helpers.makeTestYear("America/Vancouver", [
		["2423-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2423-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2423-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2423-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2424" : helpers.makeTestYear("America/Vancouver", [
		["2424-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2424-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2424-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2424-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2425" : helpers.makeTestYear("America/Vancouver", [
		["2425-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2425-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2425-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2425-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2426" : helpers.makeTestYear("America/Vancouver", [
		["2426-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2426-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2426-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2426-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2427" : helpers.makeTestYear("America/Vancouver", [
		["2427-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2427-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2427-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2427-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2428" : helpers.makeTestYear("America/Vancouver", [
		["2428-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2428-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2428-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2428-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2429" : helpers.makeTestYear("America/Vancouver", [
		["2429-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2429-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2429-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2429-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2430" : helpers.makeTestYear("America/Vancouver", [
		["2430-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2430-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2430-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2430-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2431" : helpers.makeTestYear("America/Vancouver", [
		["2431-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2431-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2431-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2431-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2432" : helpers.makeTestYear("America/Vancouver", [
		["2432-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2432-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2432-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2432-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2433" : helpers.makeTestYear("America/Vancouver", [
		["2433-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2433-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2433-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2433-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2434" : helpers.makeTestYear("America/Vancouver", [
		["2434-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2434-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2434-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2434-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2435" : helpers.makeTestYear("America/Vancouver", [
		["2435-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2435-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2435-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2435-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2436" : helpers.makeTestYear("America/Vancouver", [
		["2436-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2436-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2436-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2436-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2437" : helpers.makeTestYear("America/Vancouver", [
		["2437-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2437-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2437-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2437-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2438" : helpers.makeTestYear("America/Vancouver", [
		["2438-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2438-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2438-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2438-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2439" : helpers.makeTestYear("America/Vancouver", [
		["2439-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2439-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2439-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2439-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2440" : helpers.makeTestYear("America/Vancouver", [
		["2440-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2440-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2440-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2440-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2441" : helpers.makeTestYear("America/Vancouver", [
		["2441-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2441-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2441-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2441-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2442" : helpers.makeTestYear("America/Vancouver", [
		["2442-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2442-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2442-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2442-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2443" : helpers.makeTestYear("America/Vancouver", [
		["2443-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2443-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2443-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2443-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2444" : helpers.makeTestYear("America/Vancouver", [
		["2444-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2444-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2444-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2444-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2445" : helpers.makeTestYear("America/Vancouver", [
		["2445-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2445-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2445-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2445-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2446" : helpers.makeTestYear("America/Vancouver", [
		["2446-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2446-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2446-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2446-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2447" : helpers.makeTestYear("America/Vancouver", [
		["2447-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2447-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2447-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2447-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2448" : helpers.makeTestYear("America/Vancouver", [
		["2448-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2448-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2448-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2448-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2449" : helpers.makeTestYear("America/Vancouver", [
		["2449-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2449-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2449-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2449-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2450" : helpers.makeTestYear("America/Vancouver", [
		["2450-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2450-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2450-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2450-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2451" : helpers.makeTestYear("America/Vancouver", [
		["2451-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2451-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2451-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2451-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2452" : helpers.makeTestYear("America/Vancouver", [
		["2452-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2452-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2452-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2452-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2453" : helpers.makeTestYear("America/Vancouver", [
		["2453-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2453-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2453-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2453-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2454" : helpers.makeTestYear("America/Vancouver", [
		["2454-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2454-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2454-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2454-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2455" : helpers.makeTestYear("America/Vancouver", [
		["2455-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2455-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2455-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2455-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2456" : helpers.makeTestYear("America/Vancouver", [
		["2456-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2456-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2456-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2456-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2457" : helpers.makeTestYear("America/Vancouver", [
		["2457-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2457-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2457-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2457-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2458" : helpers.makeTestYear("America/Vancouver", [
		["2458-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2458-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2458-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2458-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2459" : helpers.makeTestYear("America/Vancouver", [
		["2459-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2459-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2459-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2459-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2460" : helpers.makeTestYear("America/Vancouver", [
		["2460-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2460-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2460-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2460-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2461" : helpers.makeTestYear("America/Vancouver", [
		["2461-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2461-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2461-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2461-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2462" : helpers.makeTestYear("America/Vancouver", [
		["2462-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2462-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2462-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2462-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2463" : helpers.makeTestYear("America/Vancouver", [
		["2463-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2463-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2463-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2463-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2464" : helpers.makeTestYear("America/Vancouver", [
		["2464-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2464-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2464-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2464-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2465" : helpers.makeTestYear("America/Vancouver", [
		["2465-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2465-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2465-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2465-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2466" : helpers.makeTestYear("America/Vancouver", [
		["2466-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2466-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2466-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2466-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2467" : helpers.makeTestYear("America/Vancouver", [
		["2467-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2467-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2467-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2467-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2468" : helpers.makeTestYear("America/Vancouver", [
		["2468-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2468-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2468-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2468-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2469" : helpers.makeTestYear("America/Vancouver", [
		["2469-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2469-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2469-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2469-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2470" : helpers.makeTestYear("America/Vancouver", [
		["2470-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2470-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2470-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2470-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2471" : helpers.makeTestYear("America/Vancouver", [
		["2471-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2471-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2471-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2471-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2472" : helpers.makeTestYear("America/Vancouver", [
		["2472-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2472-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2472-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2472-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2473" : helpers.makeTestYear("America/Vancouver", [
		["2473-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2473-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2473-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2473-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2474" : helpers.makeTestYear("America/Vancouver", [
		["2474-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2474-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2474-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2474-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2475" : helpers.makeTestYear("America/Vancouver", [
		["2475-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2475-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2475-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2475-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2476" : helpers.makeTestYear("America/Vancouver", [
		["2476-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2476-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2476-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2476-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2477" : helpers.makeTestYear("America/Vancouver", [
		["2477-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2477-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2477-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2477-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2478" : helpers.makeTestYear("America/Vancouver", [
		["2478-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2478-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2478-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2478-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2479" : helpers.makeTestYear("America/Vancouver", [
		["2479-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2479-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2479-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2479-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2480" : helpers.makeTestYear("America/Vancouver", [
		["2480-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2480-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2480-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2480-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2481" : helpers.makeTestYear("America/Vancouver", [
		["2481-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2481-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2481-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2481-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2482" : helpers.makeTestYear("America/Vancouver", [
		["2482-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2482-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2482-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2482-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2483" : helpers.makeTestYear("America/Vancouver", [
		["2483-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2483-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2483-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2483-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2484" : helpers.makeTestYear("America/Vancouver", [
		["2484-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2484-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2484-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2484-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2485" : helpers.makeTestYear("America/Vancouver", [
		["2485-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2485-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2485-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2485-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2486" : helpers.makeTestYear("America/Vancouver", [
		["2486-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2486-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2486-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2486-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2487" : helpers.makeTestYear("America/Vancouver", [
		["2487-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2487-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2487-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2487-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2488" : helpers.makeTestYear("America/Vancouver", [
		["2488-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2488-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2488-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2488-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2489" : helpers.makeTestYear("America/Vancouver", [
		["2489-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2489-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2489-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2489-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2490" : helpers.makeTestYear("America/Vancouver", [
		["2490-03-12T09:59:59+00:00", "01:59:59", "PST", 480],
		["2490-03-12T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2490-11-05T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2490-11-05T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2491" : helpers.makeTestYear("America/Vancouver", [
		["2491-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2491-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2491-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2491-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2492" : helpers.makeTestYear("America/Vancouver", [
		["2492-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2492-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2492-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2492-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2493" : helpers.makeTestYear("America/Vancouver", [
		["2493-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2493-03-08T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2493-11-01T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2493-11-01T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2494" : helpers.makeTestYear("America/Vancouver", [
		["2494-03-14T09:59:59+00:00", "01:59:59", "PST", 480],
		["2494-03-14T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2494-11-07T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2494-11-07T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2495" : helpers.makeTestYear("America/Vancouver", [
		["2495-03-13T09:59:59+00:00", "01:59:59", "PST", 480],
		["2495-03-13T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2495-11-06T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2495-11-06T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2496" : helpers.makeTestYear("America/Vancouver", [
		["2496-03-11T09:59:59+00:00", "01:59:59", "PST", 480],
		["2496-03-11T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2496-11-04T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2496-11-04T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2497" : helpers.makeTestYear("America/Vancouver", [
		["2497-03-10T09:59:59+00:00", "01:59:59", "PST", 480],
		["2497-03-10T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2497-11-03T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2497-11-03T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2498" : helpers.makeTestYear("America/Vancouver", [
		["2498-03-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["2498-03-09T10:00:00+00:00", "03:00:00", "PDT", 420],
		["2498-11-02T08:59:59+00:00", "01:59:59", "PDT", 420],
		["2498-11-02T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2499" : helpers.makeTestYear("America/Vancouver", [
		["2499-03-08T09:59:59+00:00", "01:59:59", "PST", 480],
		["2499-03-08T10:00:00+00:00", "03:00:00", "PDT", 420]
	])
};