// Copyright (c) 2012 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.every
es5id: 15.4.4.16-1-8
description: Array.prototype.every applied to String object
---*/

function callbackfn(val, idx, obj) {
  return !(obj instanceof String);
}

var obj = new String("hello\nworld\\!");

assert.sameValue(Array.prototype.every.call(obj, callbackfn), false, 'Array.prototype.every.call(obj, callbackfn)');

reportCompare(0, 0);
