/*
 * Auto-expanding trees and smart hierarchy interface
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/SmartHierarchy.h>

#include <tagcoll/TextFormat.h>
#include <tagcoll/input/string.h>
#include <tagcoll/coll/fast.h>

namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::tests;

struct tagcoll_smarthierarchy_shar {
};
TESTGRP(tagcoll_smarthierarchy);

template<> template<>
void to::test<1>()
{
	std::string input_coll(
			"a: b, c\n"
			"b:\n"
			"c: \n"
			"d:  c::D, e::F,    f::g\n"
			);
	coll::Fast<string, string> coll;
	parseCollection(input_coll, inserter(coll));

	HierarchyNode< coll::Fast<string, string> >* root = smartHierarchyNode("_top", coll, 2);
	delete root;

	root = cleanSmartHierarchyNode("_top", coll, 2);
	delete root;

	//ensure(false);
}

std::set<int> ints(int i1, int i2, int i3)
{
	std::set<int> res;
	res.insert(i1); res.insert(i2); res.insert(i3);
	return res;
}

// Try out with a collection where the item is a different type than the tag
template<> template<>
void to::test<2>()
{
	coll::Fast<string, int> coll;
	coll.insert(wibble::singleton(std::string("even")), ints(0, 2, 4));
	coll.insert(wibble::singleton(std::string("odd")), ints(0, 1, 3));

	HierarchyNode< coll::Fast<string, int> >* root = smartHierarchyNode(0, coll, 2);
	delete root;

	root = cleanSmartHierarchyNode(0, coll, 2);
	delete root;
}

}

#include <tagcoll/coll/fast.tcc>
#include <tagcoll/TextFormat.tcc>
#include <tagcoll/SmartHierarchy.tcc>

// vim:set ts=4 sw=4:
