/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import net.tinyos.mviz.DDocument;
import net.tinyos.mviz.DLayer;
import net.tinyos.mviz.DMoteModel;

public class DNavigate
extends JPanel
implements ActionListener {
    private DDocument parent;
    protected ArrayList layers = new ArrayList();
    private int _tmp_i = 0;
    protected int totalLayers = 0;
    private int default_width = 600;
    private int default_height = 600;
    private long currentSecond = -1L;
    private long PERIOD = 500L;

    public DNavigate(Vector vector, Vector vector2, DDocument dDocument) {
        this.parent = dDocument;
        BoxLayout boxLayout = new BoxLayout(this, 3);
        this.setLayout(boxLayout);
        this.totalLayers = 2 * vector.size() + vector2.size();
        this._tmp_i = 0;
        this.addLayer(vector, 0, dDocument.motes);
        this.addLayer(vector2, 1, dDocument.links);
        this.addLayer(vector, 2, dDocument.motes);
        this.updateLayerIndex(false);
        for (DLayer dLayer : this.layers) {
        }
    }

    protected void addMote(DMoteModel dMoteModel) {
        for (DLayer dLayer : this.layers) {
            dLayer.addMote(dMoteModel, true);
        }
    }

    private void addLayer(Vector vector, int n, ArrayList arrayList) {
        int n2 = 0;
        while (n2 < vector.size()) {
            DLayer dLayer = new DLayer(this._tmp_i, n2, (String)vector.elementAt(n2), n, this.parent, arrayList, this);
            this.add(dLayer);
            this.layers.add(dLayer);
            ++n2;
            ++this._tmp_i;
        }
    }

    private void updateLayerIndex(boolean bl) {
        int n = this.layers.size();
        Iterator iterator = this.layers.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            DLayer dLayer = (DLayer)iterator.next();
            dLayer.updateIndex(n2, bl);
            ++n2;
        }
    }

    public void redrawNavigator() {
        Iterator iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            this.remove((DLayer)iterator.next());
        }
        iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            this.add((DLayer)iterator.next());
        }
        this.revalidate();
        this.redrawAllLayers();
    }

    public void moveLayerUp(int n) {
        if (n == 0) {
            return;
        }
        DLayer dLayer = (DLayer)this.layers.remove(n);
        this.layers.add(n - 1, dLayer);
        this.updateLayerIndex(true);
        this.redrawNavigator();
        this.redrawAllLayers();
    }

    public void moveLayerDown(int n) {
        if (n == this.layers.size() - 1) {
            return;
        }
        DLayer dLayer = (DLayer)this.layers.remove(n);
        this.layers.add(n + 1, dLayer);
        this.updateLayerIndex(true);
        this.redrawNavigator();
        this.redrawAllLayers();
    }

    public void init() {
        for (DLayer dLayer : this.layers) {
            dLayer.init();
        }
    }

    public void paint() {
        this.redrawNavigator();
        Iterator iterator = this.layers.iterator();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected void redrawAllLayers() {
        Object object;
        Date date = new Date();
        if (date.getTime() - this.currentSecond < this.PERIOD) {
            return;
        }
        this.currentSecond = date.getTime();
        int n = this.totalLayers - 1;
        for (int i = 0; i < this.totalLayers; ++i) {
            object = (DLayer)this.layers.get(i);
            if (!((DLayer)object).isFieldSelected()) continue;
            n = ((DLayer)object).zIndex;
            break;
        }
        DLayer dLayer = (DLayer)this.layers.get(n);
        object = new BufferedImage(this.parent.canvas.getWidth(), this.parent.canvas.getHeight(), 2);
        Graphics graphics = ((Image)object).getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clearRect(0, 0, this.parent.canvas.getWidth(), this.parent.canvas.getHeight());
        graphics2D.fillRect(0, 0, this.parent.canvas.getWidth(), this.parent.canvas.getHeight());
        for (int i = n; i >= 0; --i) {
            DLayer dLayer2 = (DLayer)this.layers.get(i);
            dLayer2.repaintLayer(graphics);
        }
        this.parent.canvas.getGraphics().drawImage((Image)object, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

