/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.tinyos.packet.PacketListenerIF;
import net.tinyos.packet.PacketSource;
import net.tinyos.packet.PhoenixError;
import net.tinyos.util.Messenger;

public class PhoenixSource
extends Thread
implements PhoenixError {
    private PacketSource source;
    private Messenger messages;
    private Vector listeners;
    private boolean phoenixLike = true;
    private boolean started;
    private PhoenixError errorHandler = this;

    protected void message(String string) {
        if (this.messages != null) {
            this.messages.message(string);
        }
    }

    public synchronized void awaitStartup() throws IOException {
        while (!this.started) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted");
            }
        }
    }

    private synchronized void started() {
        this.started = true;
        this.notify();
    }

    private synchronized void stopped() {
        this.started = false;
    }

    PhoenixSource(PacketSource packetSource, Messenger messenger) {
        this.source = packetSource;
        this.messages = messenger;
        this.listeners = new Vector();
    }

    public synchronized void shutdown() {
        this.phoenixLike = false;
        try {
            this.source.close();
            this.interrupt();
        }
        catch (IOException iOException) {
            this.message("close error " + iOException);
        }
    }

    public PacketSource getPacketSource() {
        return this.source;
    }

    public boolean writePacket(byte[] byArray) throws IOException {
        this.awaitStartup();
        return this.source.writePacket(byArray);
    }

    public void registerPacketListener(PacketListenerIF packetListenerIF) {
        this.listeners.addElement(packetListenerIF);
    }

    public void deregisterPacketListener(PacketListenerIF packetListenerIF) {
        this.listeners.remove(packetListenerIF);
    }

    private void packetDipatchLoop() throws IOException {
        while (true) {
            this.dispatch(this.source.readPacket());
        }
    }

    private void dispatch(byte[] byArray) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            PacketListenerIF packetListenerIF = (PacketListenerIF)enumeration.nextElement();
            packetListenerIF.packetReceived(byArray);
        }
    }

    public void run() {
        while (this.phoenixLike) {
            try {
                this.source.open(this.messages);
                this.started();
                this.packetDipatchLoop();
            }
            catch (IOException iOException) {
                this.stopped();
                if (!this.phoenixLike) continue;
                this.errorHandler.error(iOException);
            }
        }
    }

    public synchronized void setPacketErrorHandler(PhoenixError phoenixError) {
        this.errorHandler = phoenixError;
    }

    public void setResurrection() {
        this.setPacketErrorHandler(new PhoenixError(){

            public void error(IOException iOException) {
                PhoenixSource.this.message(PhoenixSource.this.source.getName() + " died - restarting");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public void error(IOException iOException) {
        String string = this.source.getName() + " died - exiting (" + iOException + ")";
        if (this.messages != null) {
            this.message(string);
        } else {
            System.err.println(string);
        }
        System.exit(2);
    }
}

