/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TABLEVIEW_H
#define TABLEVIEW_H

#include "headerview.h"
#include "tableviewmodel.h"
#include "itemdelegate.h"

#include <DTableView>
#include <QTableView>
#include <QAbstractTableModel>
#include <QTableWidget>
#include <QScrollBar>

DWIDGET_USE_NAMESPACE


class TableView:public QTableView
{
    Q_OBJECT
public:
    TableView(int Flag);
    TableViewModel *get_tableViewModel();
    void reset(bool switched=false);
   // RecycleTableViewModel* get_recycletableViewModel();


private:
    void initUI();
    void initConnections();
    void initTableView();
    TableViewModel *table_mode;
    int Table_Flag;
    ItemDelegate *itemdegegate;
signals:
    void get_datachanged();
    void header_stateChanged(bool checked);
    void clear_header_check();
    void get_tableview_allchecked(bool checked);
    void signal_hoverChanged(const QModelIndex &index);
protected:
    void mousePressEvent(QMouseEvent *event);
    void leaveEvent(QEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void keyPressEvent(QKeyEvent *event);

};

#endif // TABLEVIEW_H
