/*
* Copyright (C) 2019 ~ 2019 Deepin Technology Co., Ltd.
*
* Author: zhanglei <zhanglei_hlj@nfschina.com>
*
* Maintainer: zhanglei <zhanglei_hlj@nfschina.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TABLEVIEWMODEL_H
#define TABLEVIEWMODEL_H


#include "global.h"
#include <QAbstractTableModel>
#include <QDateTime>

using namespace Global;


class TableViewModel:public QAbstractTableModel
{
    Q_OBJECT
public:
    enum Mode {
       Downloading=0, Finished
    };
    TableViewModel(int Flag,QObject *parent = nullptr);

        enum DataRole {
            Ischecked=0, Speed, Size, FileName, Time, Status, GID, Percent, TotalLength,SavePath
        };



        ~TableViewModel();
       bool setData(const QModelIndex &ndex, const QVariant &value, int role);

        void append(DataItem *data);
        void removeItem(DataItem *data);
        void removeItem(DelDataItem *data);
        void removeItems();
        void removeItems(bool isrecycle);

        void switchDownloadingMode();
        void switchFinishedMode();
        DataItem *find(const QString &gid);

        const QList<DataItem *> dataList();
        const QList<DataItem *> renderList();
        int get_tablemodel_mode();

        void append(DelDataItem *data);
        DelDataItem *find(const QString &gid,int flag);
        const QList<DelDataItem *> recyleList();
        QMap<QString, DataItem *> get_table_model_map();



    public:
        int rowCount(const QModelIndex &parent) const;
        int columnCount(const QModelIndex &parent) const;
        QVariant data(const QModelIndex &index, int role) const;
        QVariant headerData(int section, Qt::Orientation orientation, int role) const;

    private:
        QList<DataItem *> m_dataList;
        QList<DataItem *> m_renderList;
        QMap<QString, DataItem *> m_map;
        Mode m_mode;
        int TableViewTab_Flag;

        QMap<QString, DelDataItem *> m_Deletemap;
        QList<DelDataItem *> m_recyleList;
signals:
        void check_dataChange(int flag);
        void tableView_allChecked_or_allUnchecked(bool checked);
        void signal_check_change(bool checked, int flag);
private slots:
        void get_check_dataChange(int flag);



};

#endif // TABLEVIEWMODEL_H
