/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSACCOUNT_H__
#define __UOSACCOUNT_H__

#include "libsylph/account.h"
#include "uosprefs.h"
#include "uosprefs_account.h"
#include "uosfolder.h"
#include "uosprocmsg.h"

typedef AccountFunc UosAccountFunc;

void          uos_account_read_config_all   (void);
void          uos_account_write_config_all  (void);

UosPrefsAccount *uos_account_find_from_smtp_server (const gchar    *address,
                                                    const gchar    *smtp_server);
UosPrefsAccount *uos_account_find_from_address     (const gchar    *address);
UosPrefsAccount *uos_account_find_from_id      (gint        id);
UosPrefsAccount *uos_account_find_from_item        (UosFolderItem *item);
UosPrefsAccount *uos_account_find_from_item_property   (UosFolderItem *item);
UosPrefsAccount *uos_account_find_from_message_file    (const gchar    *file);
UosPrefsAccount *uos_account_find_from_msginfo     (UosMsgInfo    *msginfo);

gboolean      uos_account_address_exist (const gchar    *address);

void          uos_account_foreach       (UosAccountFunc     func,
                                         gpointer    user_data);
GList        *uos_account_get_list      (void);
void          uos_account_list_free     (void);
void          uos_account_append        (UosPrefsAccount   *ac_prefs);

void          uos_account_set_as_default    (UosPrefsAccount   *ac_prefs);
UosPrefsAccount *uos_account_get_default   (void);

UosFolderItem   *uos_account_get_special_folder(UosPrefsAccount       *ac_prefs,
                                                UosSpecialFolderItemType   type);

void          uos_account_destroy       (UosPrefsAccount   *ac_prefs);

void          uos_account_update_lock   (void);
void          uos_account_update_unlock (void);
void          uos_account_updated       (void);

#endif /* __UOSACCOUNT_H__ */
