/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef __UOSPOP_H__
#define __UOSPOP_H__

#include "libsylph/pop.h"

#include "uossession.h"
#include "uosprefs_account.h"
#include "uosutils.h"

typedef Pop3MsgInfo UosPop3MsgInfo;
typedef Pop3Session UosPop3Session;

#define UOSPOP3_SESSION(obj) POP3_SESSION(obj)

typedef Pop3State UosPop3State;
#define UosPOP3_READY POP3_READY
#define UosPOP3_GREETING POP3_GREETING
#define UosPOP3_STLS POP3_STLS
#define UosPOP3_GETAUTH_USER POP3_GETAUTH_USER
#define UosPOP3_GETAUTH_PASS POP3_GETAUTH_PASS
#define UosPOP3_GETAUTH_APOP POP3_GETAUTH_APOP
#define UosPOP3_GETRANGE_STAT POP3_GETRANGE_STAT
#define UosPOP3_GETRANGE_LAST POP3_GETRANGE_LAST
#define UosPOP3_GETRANGE_UIDL POP3_GETRANGE_UIDL
#define UosPOP3_GETRANGE_UIDL_RECV POP3_GETRANGE_UIDL_RECV
#define UosPOP3_GETSIZE_LIST POP3_GETSIZE_LIST
#define UosPOP3_GETSIZE_LIST_RECV POP3_GETSIZE_LIST_RECV
#define UosPOP3_RETR POP3_RETR
#define UosPOP3_RETR_RECV POP3_RETR_RECV
#define UosPOP3_DELETE POP3_DELETE
#define UosPOP3_LOGOUT POP3_LOGOUT
#define UosPOP3_DONE POP3_DONE
#define UosPOP3_ERROR POP3_ERROR
#define UosN_POP3_STATE N_POP3_STATE

typedef Pop3ErrorValue UosPop3ErrorValue;
#define UosPS_SUCCESS PS_SUCCESS
#define UosPS_NOMAIL PS_NOMAIL
#define UosPS_SOCKET PS_SOCKET
#define UosPS_AUTHFAIL PS_AUTHFAIL
#define UosPS_PROTOCOL PS_PROTOCOL
#define UosPS_SYNTAX PS_SYNTAX
#define UosPS_IOERR PS_IOERR
#define UosPS_ERROR PS_ERROR
#define UosPS_EXCLUDE PS_EXCLUDE
#define UosPS_LOCKBUSY PS_LOCKBUSY
#define UosPS_SMTP PS_SMTP
#define UosPS_DNS PS_DNS
#define UosPS_BSMTP PS_BSMTP
#define UosPS_MAXFETCH PS_MAXFETCH
#define UosPS_NOTSUPPORTED PS_NOTSUPPORTED
#define UosPS_CONTINUE PS_CONTINUE

typedef RecvTime UosRecvTime;
#define UosRECV_TIME_NONE RECV_TIME_NONE
#define UosRECV_TIME_RECEIVED RECV_TIME_RECEIVED
#define UosRECV_TIME_KEEP RECV_TIME_KEEP
#define UosRECV_TIME_DELETE RECV_TIME_DELETE

typedef Pop3DropValue UosPop3DropValue;
#define UosDROP_OK DROP_OK
#define UosDROP_DONT_RECEIVE DROP_DONT_RECEIVE
#define UosDROP_DELETE DROP_DELETE
#define UosDROP_ERROR DROP_ERROR

#define UOSPOPBUFSIZE  POPBUFSIZE
#define UOSIDLEN       IDLEN

UosSession *uos_pop3_session_new   (UosPrefsAccount   *account);

GHashTable *uos_pop3_get_uidl_table (UosPrefsAccount   *account);
gint uos_pop3_write_uidl_list   (UosPop3Session    *session);

#endif /* __UOSPOP_H__ */
