/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosprefs.h"

GHashTable *uos_prefs_param_table_get	(UosPrefParam	*param){
     return prefs_param_table_get	(param);
}

void uos_prefs_param_table_destroy		(GHashTable	*param_table){
    prefs_param_table_destroy		(param_table);
}


void uos_prefs_read_config		(UosPrefParam	*param,
                 const gchar	*label,
                 const gchar	*rcfile,
                 const gchar	*encoding){
    prefs_read_config		(param,label,rcfile,encoding);
}

void uos_prefs_write_config		(UosPrefParam	*param,
                 const gchar	*label,
                 const gchar	*rcfile){
    prefs_write_config		(param,label,rcfile);
}


UosPrefFile *uos_prefs_file_open		(const gchar	*path){
    return prefs_file_open		(path);
}

gint uos_prefs_file_write_param		(UosPrefFile	*pfile,
                     UosPrefParam	*param){
    return prefs_file_write_param		(pfile,param);
}

void uos_prefs_file_set_backup_generation	(UosPrefFile	*pfile,
                     gint		 generation){
    prefs_file_set_backup_generation	(pfile,generation);
}

gint uos_prefs_file_get_backup_generation	(UosPrefFile	*pfile){
    return prefs_file_get_backup_generation		(pfile);
}

gint uos_prefs_file_close			(UosPrefFile	*pfile){
    return prefs_file_close		(pfile);
}

gint uos_prefs_file_close_revert		(UosPrefFile	*pfile){
    return prefs_file_close_revert		(pfile);
}


void uos_prefs_set_default		(UosPrefParam	*param){
    prefs_set_default		(param);
}

void uos_prefs_free			(UosPrefParam	*param){
    prefs_free		(param);
}

