/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSRECV_H__
#define __UOSRECV_H__

#include "libsylph/recv.h"

#include "uossocket.h"

typedef RecvUIFunc UosRecvUIFunc;

gchar *uos_recv_bytes		(UosSockInfo	*sock,
				 glong		 size);

gint uos_recv_write_to_file		(UosSockInfo	*sock,
				 const gchar	*filename);
gint uos_recv_bytes_write_to_file	(UosSockInfo	*sock,
				 glong		 size,
				 const gchar	*filename);
gint uos_recv_write			(UosSockInfo	*sock,
				 FILE		*fp);
gint uos_recv_bytes_write		(UosSockInfo	*sock,
				 glong		 size,
				 FILE		*fp);

void uos_recv_set_ui_func		(UosRecvUIFunc	 func,
				 gpointer	 data);

gboolean uos_if_recv_needexit();

void uos_set_recv_needexit(gboolean gb);

#endif /* __UOSRECV_H__ */
