/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uossocks.h"

UosSocksInfo *uos_socks_info_new(UosSocksType type, const gchar *proxy_host,
              gushort proxy_port, const gchar *proxy_name,
                                 const gchar *proxy_pass){
     return socks_info_new(type, proxy_host,proxy_port, proxy_name,proxy_pass);
}

void uos_socks_info_free(UosSocksInfo *socks_info){
    socks_info_free(socks_info);
}

gint uos_socks_connect(UosSockInfo *sock, const gchar *hostname, gushort port,
           UosSocksInfo *socks_info, gchar **errorchar){
    return socks_connect(sock, hostname, port,socks_info, errorchar);
}

gint uos_socks4_connect(UosSockInfo *sock, const gchar *hostname, gushort port, gchar **errorchar){
    return socks4_connect(sock, hostname, port, errorchar);
}

gint uos_socks5_connect(UosSockInfo *sock, const gchar *hostname, gushort port,
            const gchar *proxy_name, const gchar *proxy_pass, gchar **errorchar){
    return socks5_connect(sock, hostname, port,proxy_name, proxy_pass, errorchar);
}

