////////////////////////////////////////////////////////////////////
//
//! @file vt_deprecated.h
//! @ingroup PublicAPI
//! @brief Deprecated symbol handling.
//
//  Copyright 2004 - 2018, Ron <ron@debian.org>
//  Created: 6-Feb-2004
//
//  Symbols renamed for use in the Voicetronix vpb library 2006.
////////////////////////////////////////////////////////////////////

#ifndef _VT_DEPRECATED_H
#define _VT_DEPRECATED_H

//! Compiler version test.
//
//! This macro will return false if the version of gcc in use
//! is earlier than the specified major, minor limit, or if gcc
//! is not being used.  Otherwise it will evaluate to be true.
#if defined(__GNUC__) && defined(__GNUC_MINOR__)
 #define VT_COMPILER_GCC( major, minor )   ( ( __GNUC__ > (major) )     \
            || ( __GNUC__ == (major) && __GNUC_MINOR__ >= (minor) ) )
#else
 #define VT_COMPILER_GCC( major, minor )  0
#endif


//! @name Code deprecating macros
//! Use these macros to mark deprecated code if you wish to
//! generate compile time warnings about its continued use.
//! @ingroup Debug
//@{

    //! Macro wrapper for deprecated symbols.
    //
    /*! You can use this macro to generate compile time warnings for
        deprecated functions and methods, variables, and types, by
        simply wrapping an existing declaration with it or creating
        one that matches the existing definition.  You cannot wrap
        definitions or implicitly inline methods with it, a separate
        declaration must exist.

        @param x The symbol declaration to deprecate.

        For example:
        @code
        VT_DEPRECATED( typedef int DeprecatedType );
        VT_DEPRECATED( void DeprecatedFunctionDecl( int arg ) );
        VT_DEPRECATED( bool DeprecatedFlagVariable );
        @endcode
        @hideinitializer
    */
    #if VT_COMPILER_GCC(3,1)
        #define VT_DEPRECATED( x )      x __attribute__((deprecated))
    #else
        #define VT_DEPRECATED( x )      x
    #endif


    //! Helper for deprecated macros.
    //
    /*! Include this macro somewhere harmless (eg. hidden in a comma operator
        or empty statement) in a macro definition to get compile time warnings
        about its continued use.

        For example:
        @code
        #define OLD_MACRO( arg )  ( VT_DEPRECATED_MACRO, OldMacroFunction( arg ) )
        @endcode
        @hideinitializer
    */
    #define VT_DEPRECATED_MACRO     (void)(Deprecated::Macro)0

//@}


namespace Deprecated
{
  //! @name Macro-deprecating helper
  //@{

    //! Parasitic type used to generate @c VT_DEPRECATED_MACRO warnings.
    VT_DEPRECATED( typedef int Macro );

  //@}
}


#endif  // _VT_DEPRECATED_H

// vi:sts=4:sw=4:et:foldmethod=marker
