#!/bin/sh
FIFO=$1
PATTERN=$2

echo do_til_pipe: $*

mknod "$FIFO" p

if ! [ -p "$FIFO" ]; then
	echo pipe $FIFO not found;
	exit 1;
fi

echo found pipe: "'$FIFO'"
echo waiting for string: "'$PATTERN'"

HEARTBEAT_PID=$$

( while true; do
	IN=`cat $FIFO || echo quit`;		\
	if [ "$IN" == "quit" ];	then		\
		echo error reading pipe;	\
		break;				\
	fi;					\
	echo $IN;				\
	echo $IN | grep -q "$PATTERN" && break; \
	echo Unhandled;				\
  done;						\
  echo killing "Connected loop....";		\
  kill -HUP $HEARTBEAT_PID ) &

trap 'exit 0' HUP

i=0;
while true; do 
	echo Connected $i; 
	sleep 15; 
	((i++)); 
done
