/*
  BNEP protocol definition for Linux Bluetooth stack (BlueZ).
  Copyright (C) 2002 Maxim Krasnyansky <maxk@qualcomm.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef _BNEP_H
#define _BNEP_H

#include <linux/types.h>
#include <linux/crc32.h>
#include <net/bluetooth/bluetooth.h>

/* Limits */
#define BNEP_MAX_PROTO_FILTERS		5
#define BNEP_MAX_MULTICAST_FILTERS	20

/* UUIDs */
#define BNEP_BASE_UUID	0x0000000000001000800000805F9B34FB
#define BNEP_UUID16	0x02
#define BNEP_UUID32	0x04
#define BNEP_UUID128	0x16

#define BNEP_SVC_PANU	0x1115
#define BNEP_SVC_NAP	0x1116
#define BNEP_SVC_GN	0x1117

/* Packet types */
#define BNEP_GENERAL			0x00
#define BNEP_CONTROL			0x01
#define BNEP_COMPRESSED			0x02
#define BNEP_COMPRESSED_SRC_ONLY	0x03
#define BNEP_COMPRESSED_DST_ONLY	0x04

/* Control types */
#define BNEP_CMD_NOT_UNDERSTOOD		0x00
#define BNEP_SETUP_CONN_REQ		0x01
#define BNEP_SETUP_CONN_RSP		0x02
#define BNEP_FILTER_NET_TYPE_SET	0x03
#define BNEP_FILTER_NET_TYPE_RSP	0x04
#define BNEP_FILTER_MULTI_ADDR_SET	0x05
#define BNEP_FILTER_MULTI_ADDR_RSP	0x06

/* Extension types */
#define BNEP_EXT_CONTROL 0x00

/* Response messages */
#define BNEP_SUCCESS 0x00

#define BNEP_CONN_INVALID_DST 0x01
#define BNEP_CONN_INVALID_SRC 0x02
#define BNEP_CONN_INVALID_SVC 0x03
#define BNEP_CONN_NOT_ALLOWED 0x04

#define BNEP_FILTER_UNSUPPORTED_REQ	0x01
#define BNEP_FILTER_INVALID_RANGE	0x02
#define BNEP_FILTER_INVALID_MCADDR	0x02
#define BNEP_Fhnˌ k"Xj8ZZAe:7ky\稫ʖHy`^f1pFl݊>$eX8SChI>,X=j=_\&_TOpcģdh:
#1aK'ިO7g*3^MI	$o ܧK.9S:3
ύ	;SvmyԶ-l8M_dS,ӉOc^(d.uweL<wvL+xxaQ^ޏ`L.߉,h/ۃMp-*Y^;9]rΧjq-Fb>g Uߙ#9mhp.AyΞ.&k9FLF}@t#VK+sr=8
Jo4סS=gBk'L)4/Lic-;DzAXBU{(o6mC,|Ŋ̭i "
C`Q%PH<j2^pFQ;4WJ͖OiC-AU(-Pj-30:ŉ
99dDeU7z.eغG e[:tT
 
n7/#'ː{[6l)ܦ!nbV' }<	<F!%N8dWVMAT^)C] @&k8Ұ,$ Kp)(VZ Z˫O;rǧGF$'$ӇxqWf_mq"Jhu~bZ)⅖D%ܚeTpe1VoQT)Cە.I.PZ}/ojW-w5bntWP0:>T{k^{d,^4̙eV:KRu)5|@dPT\vΉT]P/}e,ڡ;;Ǐ4	V0r\'=`c[찂I DRxRoQev^LfzP7Q`Zo jAk0|r*BnI"TАgVUh ?d #7p$J,@N5G(^Ո;`) *E̠!
EA[$<܀O	jIaPɺH}]`,)^DvGS KƎryNZ57EЗ1KAuM1U=W	{<2:v``蝝زExMtlO
yqzP00lg),:+VFڷ|gwvs\vsjX?lL?SBSxŦ˟6}%*Ikthmx6OnEbZ2->=^dm5FEkY[s+GA(?*<?`q>(`(7;@Rb33 x* ;C
*/
struct bnep_session {
	struct list_head list;

	unsigned int  role;
	unsigned long state;
	unsigned long flags;
	atomic_t      terminate;
	struct task_struct *task;

	struct ethhdr eh;
	struct msghdr msg;

	struct bnep_proto_filter proto_filter[BNEP_MAX_PROTO_FILTERS];
	unsigned long long mc_filter;

	struct socket    *sock;
	struct net_device *dev;
};

void bnep_net_setup(struct net_device *dev);
int bnep_sock_init(void);
void bnep_sock_cleanup(void);

static inline int bnep_mc_hash(__u8 *addr)
{
	return crc32_be(~0, addr, ETH_ALEN) >> 26;
}

#endif
