/* png.h - header file for PNG reference library
 *
 * libpng version 1.2.8 - December 3, 2004
 * Copyright (c) 1998-2004 Glenn Randers-Pehrson
 * (Version 0.96 Copyright (c) 1996, 1997 Andreas Dilger)
 * (Version 0.88 Copyright (c) 1995, 1996 Guy Eric Schalnat, Group 42, Inc.)
 *
 * Authors and maintainers:
 *  libpng versions 0.71, May 1995, through 0.88, January 1996: Guy Schalnat
 *  libpng versions 0.89c, June 1996, through 0.96, May 1997: Andreas Dilger
 *  libpng versions 0.97, January 1998, through 1.2.8 - December 3, 2004: Glenn
 *  See also "Contributing Authors", below.
 *
 * Note about libpng version numbers:
 *
 *    Due to various miscommunications, unforeseen code incompatibilities
 *    and occasional factors outside the authors' control, version numbering
 *    on the library has not always been consistent and straightforward.
 *    The following table summarizes matters since version 0.89c, which was
 *    the first widely used release:
 *
 *    source                 png.h  png.h  shared-lib
 *    version                string   int  version
 *    -------                ------ -----  ----------
 *    0.89c "1.0 beta 3"     0.89      89  1.0.89
 *    0.90  "1.0 beta 4"     0.90      90  0.90  [should have been 2.0.90]
 *    0.95  "1.0 beta 5"     0.95      95  0.95  [should have been 2.0.95]
 *    0.96  "1.0 beta 6"     0.96      96  0.96  [should have been 2.0.96]
 *    0.97b "1.00.97 beta 7" 1.00.97   97  1.0.1 [should have been 2.0.97]
 *    0.97c                  0.97      97  2.0.97
 *    0.98                   0.98      98  2.0.98
 *    0.99                   0.99      98  2.0.99
 *    0.99a-m                0.99      99  2.0.99
 *    1.00                   1.00     100  2.1.0 [100 should be 10000]
 *    1.0.0      (from here on, the   100  2.1.0 [100 should be 10000]
 *    1.0.1       png.h string is   10001  2.1.0
 *    1.0.1a-e    identical to the  10002  from here on, the shared library
 *    1.0.2       source version)   10002  is 2.V where V is the source code
 *    1.0.2a-b                      10003  version, except as noted.
 *    1.0.3                         10003
 *    1.0.3a-d                      10004
 *    1.0.4                         10004
 *    1.0.4a-f                      10005
 *    1.0.5 (+ 2 patches)           10005
 *    1.0.5a-d                      10006
 *    1.0.5e-r                      10100 (not source compatible)
 *    1.0.5s-v                      10006 (not binary compatible)
 *    1.0.6 (+ 3 patches)           10006 (still binary incompatible)
 *    1.0.6d-f                      10007 (still binary incompatible)
 *    1.0.6g                        10007
 *    1.0.6h                        10007  10.6h (testing xy.z so-numbering)
 *    1.0.6i                        10007  10.6i
 *    1.0.6j                        10007  2.1.0.6j (incompatible with 1.0.0)
 *    1.0.7beta11-14        DLLNUM  10007  2.1.0.7beta11-14 (binary compatible)
 *    1.0.7beta15-18           1    10007  2.1.0.7beta15-18 (binary compatible)
 *    1.0.7rc1-2               1    10007  2.1.0.7rc1-2 (binary compatible)
 *    1.0.7                    1    10007  (still compatible)
 *    1.0.8beta1-4             1    10008  2.1.0.8beta1-4
 *    1.0.8rc1                 1    10008  2.1.0.8rc1
 *    1.0.8                    1    10008  2.1.0.8
 *    1.0.9beta1-6             1    10009  2.1.0.9beta1-6
 *    1.0.9rc1                 1    10009  2.1.0.9rc1
 *    1.0.9beta7-10            1    10009  2.1.0.9beta7-10
 *    1.0.9rc2                 1    10009  2.1.0.9rc2
 *    1.0.9                    1    10009  2.1.0.9
 *    1.0.10beta1              1    10010  2.1.0.10beta1
 *    1.0.10rc1                1    10010  2.1.0.10rc1
 *    1.0.10                   1    10010  2.1.0.10
 *    1.0.11beta1-3            1    10011  2.1.0.11beta1-3
 *    1.0.11rc1                1    10011  2.1.0.11rc1
 *    1.0.11                   1    10011  2.1.0.11
 *    1.0.12beta1-2            2    10012  2.1.0.12beta1-2
 *    1.0.12rc1                2    10012  2.1.0.12rc1
 *    1.0.12                   2    10012  2.1.0.12
 *    1.1.0a-f                 -    10100  2.1.1.0a-f (branch abandoned)
 *    1.2.0beta1-2             2    10200  2.1.2.0beta1-2
 *    1.2.0beta3-5             3    10200  3.1.2.0beta3-5
 *    1.2.0rc1                 3    10200  3.1.2.0rc1
 *    1.2.0                    3    10200  3.1.2.0
 *    1.2.1beta1-4             3    10201  3.1.2.1beta1-4
 *    1.2.1rc1-2               3    10201  3.1.2.1rc1-2
 *    1.2.1                    3    10201  3.1.2.1
 *    1.2.2beta1-6            12    10202  12.so.0.1.2.2beta1-6
 *    1.0.13beta1             10    10013  10.so.0.1.0.13beta1
 *    1.0.13rc1               10    10013  10.so.0.1.0.13rc1
 *    1.2.2rc1                12    10202  12.so.0.1.2.2rc1
 *    1.0.13                  10    10013  10.so.0.1.0.13
 *    1.2.2                   12    10202  12.so.0.1.2.2
 *    1.2.3rc1-6              12    10203  12.so.0.1.2.3rc1-6
 *    1.2.3                   12    10203  12.so.0.1.2.3
 *    1.2.4beta1-3            13    10204  12.so.0.1.2.4beta1-3
 *    1.0.14rc1               13    10014  10.so.0.1.0.14rc1
 *    1.2.4rc1                13    10204  12.so.0.1.2.4rc1
 *    1.0.14                  10    10014  10.so.0.1.0.14
 *    1.2.4                   13    10204  12.so.0.1.2.4
 *    1.2.5beta1-2            13    10205  12.so.0.1.2.5beta1-2
 *    1.0.15rc1-3             10    10015  10.so.0.1.0.15rc1-3
 *    1.2.5rc1-3              13    10205  12.so.0.1.2.5rc1-3
 *    1.0.15                  10    10015  10.so.0.1.0.15
 *    1.2.5                   13    10205  12.so.0.1.2.5
 *    1.2.6beta1-4            13    10206  12.so.0.1.2.6beta1-4
 *    1.0.16                  10    10016  10.so.0.1.0.16
 *    1.2.6                   13    10206  12.so.0.1.2.6
 *    1.2.7beta1-2            13    10207  12.so.0.1.2.7beta1-2
 *    1.0.17rc1               10    10017  12.so.0.1.0.17rc1
 *    1.2.7rc1                13    10207  12.so.0.1.2.7rc1
 *    1.0.17                  10    10017  12.so.0.1.0.17
 *    1.2.7                   13    10207  12.so.0.1.2.7
 *    1.2.8beta1-5            13    10208  12.so.0.1.2.8beta1-5
 *    1.0.18rc1-5             10    10018  12.so.0.1.0.18rc1-5
 *    1.2.8rc1-5              13    10208  12.so.0.1.2.8rc1-5
 *    1.0.18                  10    10018  12.so.0.1.0.18
 *    1.2.8                   13    10208  12.so.0.1.2.8
 *
 *    Henceforth the source version will match the shared-library major
 *    and minor numbers; the shared-library major version number will be
 *    used for changes in backward compatibility, as it is intended.  The
 *    PNG_LIBPNG_VER macro, which is not used within libpng but is available
 *    for applications, is an unsigned integer of the form xyyzz corresponding
 *    to the source version x.y.z (leading zeros in y and z).  Beta versions
 *    were given the previous public release number plus a letter, until
 *    version 1.0.6j; from then on they were given the upcoming public
 *    release number plus "betaNN" or "rcN".
 *
 *    Binary incompatibility exists only when applications make direct access
 *    to the info_ptr or png_ptr members through png.h, and the compiled
 *    application is loaded with a different version of the library.
 *
 *    DLLNUM will change each time there are forward or backward changes
 *    in binary compatibility (e.g., when a new feature is added).
 *
 * See libpng.txt or libpng.3 for more information.  The PNG specification
 * is available as a W3C Recommendation and as an ISO Specification,
 * <http://www.w3.org/TR/2003/REC-PNG-20031110/
 */

/*
 * COPYRIGHT NOTICE, DISCLAIMER, and LICENSE:
 *
 * If you modify libpng you may insert additional notices immediately following
 * this sentence.
 *
 * libpng versions 1.2.6, August 15, 2004, through 1.2.8, December 3, 2004, are
 * Copyright (c) 2004 Glenn Randers-Pehrson, and are
 * distributed according to the same disclaimer and license as libpng-1.2.5
 * with the following individual added to the list of Contributing Authors:
 *
 *    Cosmin Truta
 *
 * libpng versions 1.0.7, July 1, 2000, through 1.2.5, October 3, 2002, are
 * Copyright (c) 2000-2002 Glenn Randers-Pehrson, and are
 * distributed according to the same disclaimer and license as libpng-1.0.6
 * with the following individuals added to the list of Contributing Authors:
 *
 *    Simon-Pierre Cadieux
 *    Eric S. Raymond
 *    Gilles Vollant
 *
 * and with the following additions to the disclaimer:
 *
 *    There is no warranty against interference with your enjoyment of the
 *    library or against infringement.  There is no warranty that our
 *    efforts or the library will fulfill any of your particular purposes
 *    or needs.  This library is provided with all faults, and the entire
 *    risk of satisfactory quality, performance, accuracy, and effort is with
 *    the user.
 *
 * libpng versions 0.97, January 1998, through 1.0.6, March 20, 2000, are
 * Copyright (c) 1998, 1999, 2000 Glenn Randers-Pehrson, and are
 * distributed according to the same disclaimer and license as libpng-0.96,
 * with the following individuals added to the list of Contributing Authors:
 *
 *    Tom Lane
 *    Glenn Randers-Pehrson
 *    Willem van Schaik
 *
 * libpng versions 0.89, June 1996, through 0.96, May 1997, are
 * Copyright (c) 1996, 1997 Andreas Dilger
 * Distributed according to the same disclaimer and license as libpng-0.88,
 * with the following individuals added to the list of Contributing Authors:
 *
 *    John Bowler
 *    Kevin Bracey
 *    Sam Bushell
 *    Magnus Holmgren
 *    Greg Roelofs
 *    Tom Tanner
 *
 * libpng versions 0.5, May 1995, through 0.88, January 1996, are
 * Copyright (c) 1995, 1996 Guy Eric Schalnat, Group 42, Inc.
 *
 * For the purposes of this copyright and license, "Contributing Authors"
 * is defined as the following set of individuals:
 *
 *    Andreas Dilger
 *    Dave Martindale
 *    Guy Eric Schalnat
 *    Paul Schmidt
 *    Tim Wegner
 *
 * The PNG Reference Library is supplied "AS IS".  The Contributing Authors
 * and Group 42, Inc. disclaim all warranties, expressed or implied,
 * including, without limitation, the warranties of merchantability and of
 * fitness for any purpose.  The Contributing Authors and Group 42, Inc.
 * assume no liability for direct, indirect, incidental, special, exemplary,
 * or consequential damages, which may result from the use of the PNG
 * Reference Library, even if advised of the possibility of such damage.
 *
 * Permission is hereby granted to use, copy, modify, and distribute this
 * source code, or portions hereof, for any purpose, without fee, subject
 * to the following restrictions:
 *
 * 1. The origin of this source code must not be misrepresented.
 *
 * 2. Altered versions must be plainly marked as such and
 * must not be misrepresented as being the original source.
 *
 * 3. This Copyright notice may not be removed or altered from
 *    any source or altered source distribution.
 *
 * The Contributing Authors and Group 42, Inc. specifically permit, without
 * fee, and encourage the use of this source code as a component to
 * supporting the PNG file format in commercial products.  If you use this
 * source code in a product, acknowledgment is not required but would be
 * appreciated.
 */

/*
 * A "png_get_copyright" function is available, for convenient use in "about"
 * boxes and the like:
 *
 * printf("%s",png_get_copyright(NULL));
 *
 * Also, the PNG logo (in PNG format, of course) is supplied in the
 * files "pngbar.png" and "pngbar.jpg (88x31) and "pngnow.png" (98x31).
 */

/*
 * Libpng is OSI Certified Open Source Software.  OSI Certified is a
 * certification mark of the Open Source Initiative.
 */

/*
 * The contributing authors would like to thank all those who helped
 * with testing, bug fixes, and patience.  This wouldn't have been
 * possible without all of you.
 *
 * Thanks to Frank J. T. Wojcik for helping with the documentation.
 */

/*
 * Y2K compliance in libpng:
 * =========================
 *
 *    December 3, 2004
 *
 *    Since the PNG Development group is an ad-hoc body, we can't make
 *    an official declaration.
 *
 *    This is your unofficial assurance that libpng from version 0.71 and
 *    upward through 1.2.8 are Y2K compliant.  It is my belief that earlier
 *    versions were also Y2K compliant.
 *
 *    Libpng only has three year fields.  One is a 2-byte unsigned integer
 *    that will hold years up to 65535.  The other two hold the date in text
 *    format, and will hold years up to 9999.
 *
 *    The integer is
 *        "png_uint_16 year" in png_time_struct.
 *
 *    The strings are
 *        "png_charp time_buffer" in png_struct and
 *        "near_time_buffer", which is a local character string in png.c.
 *
 *    There are seven time-related functions:
 *        png.c: png_convert_to_rfc_1123() in png.c
 *          (formerly png_convert_to_rfc_1152() in error)
 *        png_convert_from_struct_tm() in pngwrite.c, called in pngwrite.c
 *        png_convert_from_time_t() in pngwrite.c
 *        png_get_tIME() in pngget.c
 *        png_handle_tIME() in pngrutil.c, called in pngread.c
 *        png_set_tIME() in pngset.c
 *        png_write_tIME() in pngwutil.c, called in pngwrite.c
 *
 *    All handle dates properly in a Y2K environment.  The
 *    png_convert_from_time_t() function calls gmtime() to convert from system
 *    clock time, which returns (year - 1900), which we properly convert to
 *    the full 4-digit year.  There is a possibility that applications using
 *    libpng are not passing 4-digit years into the png_convert_to_rfc_1123()
 *    function, or that they are incorrectly passing only a 2-digit year
 *    instead of "year - 1900" into the png_convert_from_struct_tm() function,
 *    but this is not under our control.  The libpng documentation has always
 *    stated that it works with 4-digit years, and the APIs have been
 *    documented as such.
 *
 *    The tIME chunk itself is also Y2K compliant.  It uses a 2-byte unsigned
 *    integer to hold the year, and can hold years as large as 65535.
 *
 *    zlib, upon which libpng depends, is also Y2K compliant.  It contains
 *    no date-related code.
 *
 *       Glenn Randers-Pehrson
 *       libpng maintainer
 *       PNG Development Group
 */

#ifndef PNG_H
#define PNG_H

/* This is not the place to learn how to use libpng.  The file libpng.txt
 * describes how to use libpng, and the file example.c summarizes it
 * with some code on which to build.  This file is useful for looking
 * at the actual function definitions and structure components.
 */

/* Version information for png.h - this should match the version in png.c */
#define PNG_LIBPNG_VER_STRING "1.2.8"
#define PNG_HEADER_VERSION_STRING \
   " libpng version 1.2.8 - December 3, 2004 (header)\n"

#define PNG_LIBPNG_VER_SONUM   0
#define PNG_LIBPNG_VER_DLLNUM  13

/* These should match the first 3 components of PNG_LIBPNG_VER_STRING: */
#define PNG_LIBPNG_VER_MAJOR   1
#define PNG_LIBPNG_VER_MINOR   2
#define PNG_LIBPNG_VER_RELEASE 8
/* This should match the numeric part of the final component of
 * PNG_LIBPNG_VER_STRING, omitting any leading zero: */

#define PNG_LIBPNG_VER_BUILD  0

/* Release Status */
#define PNG_LIBPNG_BUILD_ALPHA    1
#define PNG_LIBPNG_BUILD_BETA     2
#define PNG_LIBPNG_BUILD_RC       3
#define PNG_LIBPNG_BUILD_STABLE   4
#define PNG_LIBPNG_BUILD_RELEASE_STATUS_MASK 7
  
/* Release-Specific Flags */
#define PNG_LIBPNG_BUILD_PATCH    8 /* Can be OR'ed with
                                       PNG_LIBPNG_BUILD_STABLE only */
#define PNG_LIBPNG_BUILD_PRIVATE 16 /* Cannot be OR'ed with
                                       PNG_LIBPNG_BUILD_SPECIAL */
#define PNG_LIBPNG_BUILD_SPECIAL 32 /* Cannot be OR'ed with
                                       PNG_LIBPNG_BUILD_PRIVATE */

#define PNG_LIBPNG_BUILD_BASE_TYPE PNG_LIBPNG_BUILD_STABLE

/* Careful here.  At one time, Guy wanted to use 082, but that would be octal.
 * We must not include leading zeros.
 * Versions 0.7 through 1.0.0 were in the range 0 to 100 here (only
 * version 1.0.0 was mis-numbered 100 instead of 10000).  From
 * version 1.0.1 it's    xxyyzz, where x=major, y=minor, z=release */
#define PNG_LIBPNG_VER 10208 /* 1.2.8 */

#ifndef PNG_VERSION_INFO_ONLY
/* include the compression library's header */
#include "zlib.h"
#endif

/* include all user configurable info, including optional assembler routines */
#include "pngconf.h"

/*
 * Added at libpng-1.2.8 */
/* Ref MSDN: Private as priority over Special
 * VS_FF_PRIVATEBUILD File *was not* built using standard release
 * procedures. If this value is given, the StringFileInfo block must
 * contain a PrivateBuild string. 
 *
 * VS_FF_SPECIALBUILD File *was* built by the original company using
 * standard release procedures but is a variation of the standard
 * file of the same version number. If this value is given, the
 * StringFileInfo block must contain a SpecialBuild string. 
 */

#if defined(PNG_USER_PRIVATEBUILD)
#  define PNG_LIBPNG_BUILD_TYPE PNG_LIBPNG_BUILD_BASE_TYPE | \
          PNG_LIBPNG_BUILD_PRIVATE
#else
#  if defined(PNG_LIBPNG_SPECIALBUILD)
#    define PNG_LIBPNG_BUILD_TYPE PNG_LIBPNG_BUILD_BASE_TYPE | \
            PNG_LIBPNG_BUILD_SPECIAL
#  else
#    define PNG_LIBPNG_BUILD_TYPE PNG_LIBPNG_BUILD_BASE_TYPE
#  endif
#endif

#ifndef PNG_VERSION_INFO_ONLY

/* Inhibit C++ name-mangling for libpng functions but not for system calls. */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* This file is arranged in several sections.  The first section contains
 * structure and type definitions.  The second section contains the external
 * library functions, while the third has the internal library functions,
 * which applications aren't expected to use directly.
 */

#ifndef PNG_NO_TYPECAST_NULL
#define int_p_NULL                (int *)NULL
#define png_bytep_NULL            (png_bytep)NULL
#define png_bytepp_NULL           (png_bytepp)NULL
#define png_doublep_NULL          (png_doublep)NULL
#define png_error_ptr_NULL        (png_error_ptr)NULL
#define png_flush_ptr_NULL        (png_flush_ptr)NULL
#define png_free_ptr_NULL         (png_free_ptr)NULL
#define png_infopp_NULL           (png_infopp)NULL
#define png_malloc_ptr_NULL       (png_malloc_ptr)NULL
#define png_read_status_ptr_NULL  (png_read_status_ptr)NULL
#define png_rw_ptr_NULL           (png_rw_ptr)NULL
#define png_structp_NULL          (png_structp)NULL
#define png_uint_16p_NULL         (png_uint_16p)NULL
#define png_voidp_NULL            (png_voidp)NULL
#define png_write_status_ptr_NULL (png_write_status_ptr)NULL
#else
#define int_p_NULL                NULL
#define png_bytep_NULL            NULL
#define png_bytepp_NULL           NULL
#define png_doublep_NULL          NULL
#define png_error_ptr_NULL        NULL
#define png_flush_ptr_NULL        NULL
#define png_free_ptr_NULL         NULL
#define png_infopp_NULL           NULL
#define png_malloc_ptr_NULL       NULL
#define png_read_status_ptr_NULL  NULL
#define png_rw_ptr_NULL           NULL
#define png_structp_NULL          NULL
#define png_uint_16p_NULL         NULL
#define png_voidp_NULL            NULL
#define png_write_status_ptr_NULL NULL
#endif

/* variables declared in png.c - only it needs to define PNG_NO_EXTERN */
#if !defined(PNG_NO_EXTERN) || defined(PNG_ALWAYS_EXTERN)
/* Version information for C files, stored in png.c.  This had better match
 * the version above.
 */
#ifdef PNG_USE_GLOBAL_ARRAYS
PNG_EXPORT_VAR (const char) png_libpng_ver[18];
  /* need room for 99.99.99beta99z */
#else
#define png_libpng_ver png_get_header_ver(NULL)
#endif

#ifdef PNG_USE_GLOBAL_ARRAYS
/* This was removed in version 1.0.5c */
/* Structures to facilitate easy interlacing.  See png.c for more details */
PNG_EXPORT_VAR (const int FARDATA) png_pass_start[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_inc[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_ystart[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_yinc[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_mask[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_dsp_mask[7];
#ifdef PNG_HAVE_ASSEMBLER_COMBINE_ROW
PNG_EXPORT_VAR (const int FARDATA) png_pass_width[7];
#endif
/* This isn't currently used.  If you need it, see png.c for more details.
PNG_EXPORT_VAR (const int FARDATA) png_pass_height[7];
*/
#endif

#endif /* PNG_NO_EXTERN */

/* Three color definitions.  The order of the red, green, and blue, (and the
 * exact size) is not important, although the size of the fields need to
 * be png_byte or png_uint_16 (as defined below).
 */
typedef struct png_color_struct
{
   png_byte red;
   png_byte green;
   png_byte blue;
} png_color;
typedef png_color FAR * png_colorp;
typedef png_color FAR * FAR * png_colorpp;

typedef struct png_color_16_struct
{
   png_byte index;    /* used for palette files */
   png_uint_16 red;   /* for use in red green blue files */
   png_uint_16 green;
   png_uint_16 blue;
   png_uint_16 gray;  /* for use in grayscale files */
} png_color_16;
typedef png_color_16 FAR * png_color_16p;
typedef png_color_16 FAR * FAR * png_color_16pp;

typedef struct png_color_8_struct
{
   png_byte red;   /* for use in red green blue files */
   png_byte green;
   png_byte blue;
   png_byte gray;  /* for use in grayscale files */
   png_byte alpha; /* for alpha channel files */
} png_color_8;
typedef png_color_8 FAR * png_color_8p;
typedef png_color_8 FAR * FAR * png_color_8pp;

/*
 * The following two structures are used for the in-core representation
 * of sPLT chunks.
 */
typedef struct png_sPLT_entry_struct
{
   png_uint_16 red;
   png_uint_16 green;
   png_uint_16 blue;
   png_uint_16 alpha;
   png_uint_16 frequency;
} png_sPLT_entry;
typedef png_sPLT_entry FAR * png_sPLT_entryp;
typedef png_sPLT_entry FAR * FAR * png_sPLT_entrypp;

/*  When the depth of the sPLT palette is 8 bits, the color and alpha samples
 *  occupy the LSB of their respective members, and the MSB of each member
 *  is zero-filled.  The frequency member always occupies the full 16 bits.
 */

typedef struct png_sPLT_struct
{
   png_charp name;           /* palette name */
   png_byte depth;           /* depth of palette samples */
   png_sPLT_entryp entries;  /* palette entries */
   png_int_32 nentries;      /* number of palette entries */
} png_sPLT_t;
typedef png_sPLT_t FAR * png_sPLT_tp;
typedef png_sPLT_t FAR * FAR * png_sPLT_tpp;

#ifdef PNG_TEXT_SUPPORTED
/* png_text holds the contents of a text/ztxt/itxt chunk in a PNG file,
 * and whether that contents is compressed or not.  The "key" field
 * points to a regular zero-terminated C string.  The "text", "lang", and
 * "lang_key" fields can be regular C strings, empty strings, or NULL pointers.
 * However, the * structure returned by png_get_text() will always contain
 * regular zero-terminated C strings (possibly empty), never NULL pointers,
 * so they can be safely used in printf() and other string-handling functions.
 */
typedef struct png_text_struct
{
   int  compression;       /* compression value:
                             -1: tEXt, none
                              0: zTXt, deflate
                              1: iTXt, none
                              2: iTXt, deflate  */
   png_charp key;          /* keyword, 1-79 character description of "text" */
   png_charp text;         /* comment, may be an empty string (ie "")
                              or a NULL pointer */
   png_size_t text_length; /* length of the text string */
#ifdef PNG_iTXt_SUPPORTED
   png_size_t itxt_length; /* length of the itxt string */
   png_charp lang;         /* language code, 0-79 characters
                              or a NULL pointer */
   png_charp lang_key;     /* keyword translated UTF-8 string, 0 or more
                              chars or a NULL pointer */
#endif
} png_text;
typedef png_text FAR * png_textp;
typedef png_text FAR * FAR * png_textpp;
#endif

/* Supported compression types for text in PNG files (tEXt, and zTXt).
 * The values of the PNG_TEXT_COMPRESSION_ defines should NOT be changed. */
#define PNG_TEXT_COMPRESSION_NONE_WR -3
#define PNG_TEXT_COMPRESSION_zTXt_WR -2
#define PNG_TEXT_COMPRESSION_NONE    -1
#define PNG_TEXT_COMPRESSION_zTXt     0
#define PNG_ITXT_COMPRESSION_NONE     1
#define PNG_ITXT_COMPRESSION_zTXt     2
#define PNG_TEXT_COMPRESSION_LAST     3  /* Not a valid value */

/* png_time is a way to hold the time in an machine independent way.
 * Two conversions are provided, both from time_t and struct tm.  There
 * is no portable way to convert to either of these structures, as far
 * as I know.  If you know of a portable way, send it to me.  As a side
 * note - PNG has always been Year 2000 compliant!
 */
typedef struct png_time_struct
{
   png_uint_16 year; /* full year, as in, 1995 */
   png_byte month;   /* month of year, 1 - 12 */
   png_byte day;     /* day of month, 1 - 31 */
   png_byte hour;    /* hour of day, 0 - 23 */
   png_byte minute;  /* minute of hour, 0 - 59 */
   png_byte second;  /* second of minute, 0 - 60 (for leap seconds) */
} png_time;
typedef png_time FAR * png_timep;
typedef png_time FAR * FAR * png_timepp;

#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
/* png_unknown_chunk is a structure to hold queued chunks for which there is
 * no specific support.  The idea is that we can use this to queue
 * up private chunks for output even though the library doesn't actually
 * know about their semantics.
 */
typedef struct png_unknown_chunk_t
{
    png_byte name[5];
    png_byte *data;
    png_size_t size;

    /* libpng-using applications should NOT directly modify this byte. */
    png_byte location; /* mode of operation at read time */
}
png_unknown_chunk;
typedef png_unknown_chunk FAR * png_unknown_chunkp;
typedef png_unknown_chunk FAR * FAR * png_unknown_chunkpp;
#endif

/* png_info is a structure that holds the information in a PNG file so
 * that the application can find out the characteristics of the image.
 * If you are reading the file, this structure will tell you what is
 * in the PNG file.  If you are writing the file, fill in the information
 * you want to put into the PNG file, then call png_write_info().
 * The names chosen should be very close to the PNG specification, so
 * consult that document for information about the meaning of each field.
 *
 * With libpng < 0.95, it was only possible to directly set and read the
 * the values in the png_info_struct, which meant that the contents and
 * order of the values had to remain fixed.  With libpng 0.95 and later,
 * however, there are now functions that abstract the contents of
 * png_info_struct from the application, so this makes it easier to use
 * libpng with dynamic libraries, and even makes it possible to use
 * libraries that don't have all of the libpng ancillary chunk-handing
 * functionality.
 *
 * In any case, the order of the parameters in png_info_struct should NOT
 * be changed for as long as possible to keep compatibility with applications
 * that use the old direct-access method with png_info_struct.
 *
 * The following members may have allocated storage attached that should be
 * cleaned up before the structure is discarded: palette, trans, text,
 * pcal_purpose, pcal_units, pcal_params, hist, iccp_name, iccp_profile,
 * splt_palettes, scal_unit, row_pointers, and unknowns.   By default, these
 * are automatically freed when the info structure is deallocated, if they were
 * allocated internally by libpng.  This behavior can be changed by means
 * of the png_data_freer() function.
 *
 * More allocation details: all the chunk-reading functions that
 * change these members go through the corresponding png_set_*
 * functions.  A function to clear these members is available: see
 * png_free_data().  The png_set_* functions do not depend on being
 * able to point info structure members to any of the storage they are
 * passed (they make their own copies), EXCEPT that the png_set_text
 * functions use the same storage passed to them in the text_ptr or
 * itxt_ptr structure argument, and the png_set_rows and png_set_unknowns
 * functions do not make their own copies.
 */
typedef struct png_info_struct
{
   /* the following are necessary for every PNG file */
   png_uint_32 width;       /* width of image in pixels (from IHDR) */
   png_uint_32 height;      /* height of image in pixels (from IHDR) */
   png_uint_32 valid;       /* valid chunk data (see PNG_INFO_ below) */
   png_uint_32 rowbytes;    /* bytes needed to hold an untransformed row */
   png_colorp palette;      /* array of color values (valid & PNG_INFO_PLTE) */
   png_uint_16 num_palette; /* number of color entries in "palette" (PLTE) */
   png_uint_16 num_trans;   /* number of transparent palette color (tRNS) */
   png_byte bit_depth;      /* 1, 2, 4, 8, or 16 bits/channel (from IHDR) */
   png_byte color_type;     /* see PNG_COLOR_TYPE_ below (from IHDR) */
   /* The following three should have been named *_method not *_type */
   png_byte compression_type; /* must be PNG_COMPRESSION_TYPE_BASE (IHDR) */
   png_byte filter_type;    /* must be PNG_FILTER_TYPE_BASE (from IHDR) */
   png_byte interlace_type; /* One of PNG_INTERLACE_NONE, PNG_INTERLACE_ADAM7 */

   /* The following is informational only on read, and not used on writes. */
   png_byte channels;       /* number of data channels per pixel (1, 2, 3, 4) */
   png_byte pixel_depth;    /* number of bits per pixel */
   png_byte spare_byte;     /* to align the data, and for future use */
   png_byte signature[8];   /* magic bytes read by libpng from start of file */

   /* The rest of the data is optional.  If you are reading, check the
    * valid field to see if the information in these are valid.  If you
    * are writing, set the valid field to those chunks you want written,
    * and initialize the appropriate fields below.
    */

#if defined(PNG_gAMA_SUPPORTED) && defined(PNG_FLOATING_POINT_SUPPORTED)
   /* The gAMA chunk describes the gamma characteristics of the system
    * on which the image was created, normally in the range [1.0, 2.5].
    * Data is valid if (valid & PNG_INFO_gAMA) is non-zero.
    */
   float gamma; /* gamma value of image, if (valid & PNG_INFO_gAMA) */
#endif

#if defined(PNG_sRGB_SUPPORTED)
    /* GR-P, 0.96a */
    /* Data valid if (valid & PNG_INFO_sRGB) non-zero. */
   png_byte srgb_intent; /* sRGB rendering intent [0, 1, 2, or 3] */
#endif

#if defined(PNG_TEXT_SUPPORTED)
   /* The tEXt, and zTXt chunks contain human-readable textual data in
    * uncompressed, compressed, and optionally compressed forms, respectively.
    * The data in "text" is an array of pointers to uncompressed,
    * null-terminated C strings. Each chunk has a keyword that describes the
    * textual data contained in that chunk.  Keywords are not required to be
    * unique, and the text string may be empty.  Any number of text chunks may
    * be in an image.
    */
   int num_text; /* number of comments read/to write */
   int max_text; /* current size of text array */
   png_textp text; /* array of comments read/to write */
#endif /* PNG_TEXT_SUPPORTED */

#if defined(PNG_tIME_SUPPORTED)
   /* The tIME chunk holds the last time the displayed image data was
    * modified.  See the png_time struct for the contents of this struct.
    */
   png_time mod_time;
#endif

#if defined(PNG_sBIT_SUPPORTED)
   /* The sBIT chunk specifies the number of significant high-order bits
    * in the pixel data.  Values are in the range [1, bit_depth], and are
    * only specified for the channels in the pixel data.  The contents of
    * the low-order bits is not specified.  Data is valid if
    * (valid & PNG_INFO_sBIT) is non-zero.
    */
   png_color_8 sig_bit; /* significant bits in color channels */
#endif

#if defined(PNG_tRNS_SUPPORTED) || defined(PNG_READ_EXPAND_SUPPORTED) || \
defined(PNG_READ_BACKGROUND_SUPPORTED)
   /* The tRNS chunk supplies transparency data for paletted images and
    * other image types that don't need a full alpha channel.  There are
    * "num_trans" transparency values for a paletted image, stored in the
    * same order as the palette colors, starting from index 0.  Values
    * for the data are in the range [0, 255], ranging from fully transparent
    * to fully opaque, respectively.  For non-paletted images, there is a
    * single color specified that should be treated as fully transparent.
    * Data is valid if (valid & PNG_INFO_tRNS) is non-zero.
    */
   png_bytep trans; /* transparent values for paletted image */
   png_color_16 trans_values; /* transparent color for non-palette image */
#endif

#if defined(PNG_bKGD_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   /* The bKGD chunk gives the suggested image background color if the
    * display program does not have its own background color and the image
    * is needs to composited onto a background before display.  The colors
    * in "background" are normally in the same color space/depth as the
    * pixel data.  Data is valid if (valid & PNG_INFO_bKGD) is non-zero.
    */
   png_color_16 background;
#endif

#if defined(PNG_oFFs_SUPPORTED)
   /* The oFFs chunk gives the offset in "offset_unit_type" units rightwards
    * and downwards from the top-left corner of the display, page, or other
    * application-specific co-ordinate space.  See the PNG_OFFSET_ defines
    * below for the unit types.  Valid if (valid & PNG_INFO_oFFs) non-zero.
    */
   png_int_32 x_offset; /* x offset on page */
   png_int_32 y_offset; /* y offset on page */
   png_byte offset_unit_type; /* offset units type */
#endif

#if defined(PNG_pHYs_SUPPORTED)
   /* The pHYs chunk gives the physical pixel density of the image for
    * display or printing in "phys_unit_type" units (see PNG_RESOLUTION_
    * defines below).  Data is valid if (valid & PNG_INFO_pHYs) is non-zero.
    */
   png_uint_32 x_pixels_per_unit; /* horizontal pixel density */
   png_uint_32 y_pixels_per_unit; /* vertical pixel density */
   png_byte phys_unit_type; /* resolution type (see PNG_RESOLUTION_ below) */
#endif

#if defined(PNG_hIST_SUPPORTED)
   /* The hIST chunk contains the relative frequency or importance of the
    * various palette entries, so that a viewer can intelligently select a
    * reduced-color palette, if required.  Data is an array of "num_palette"
    * values in the range [0,65535]. Data valid if (valid & PNG_INFO_hIST)
    * is non-zero.
    */
   png_uint_16p hist;
#endif

#ifdef PNG_cHRM_SUPPORTED
   /* The cHRM chunk describes the CIE color characteristics of the monitor
    * on which the PNG was created.  This data allows the viewer to do gamut
    * mapping of the input image to ensure that the viewer sees the same
    * colors in the image as the creator.  Values are in the range
    * [0.0, 0.8].  Data valid if (valid & PNG_INFO_cHRM) non-zero.
    */
#ifdef PNG_FLOATING_POINT_SUPPORTED
   float x_white;
   float y_white;
   float x_red;
   float y_red;
   float x_green;
   float y_green;
   float x_blue;
   float y_blue;
#endif
#endif

#if defined(PNG_pCAL_SUPPORTED)
   /* The pCAL chunk describes a transformation between the stored pixel
    * values and original physical data values used to create the image.
    * The integer range [0, 2^bit_depth - 1] maps to the floating-point
    * range given by [pcal_X0, pcal_X1], and are further transformed by a
    * (possibly non-linear) transformation function given by "pcal_type"
    * and "pcal_params" into "pcal_units".  Please see the PNG_EQUATION_
    * defines below, and the PNG-Group's PNG extensions document for a
    * complete description of the transformations and how they should be
    * implemented, and for a description of the ASCII parameter strings.
    * Data values are valid if (valid & PNG_INFO_pCAL) non-zero.
    */
   png_charp pcal_purpose;  /* pCAL chunk description string */
   png_int_32 pcal_X0;      /* minimum value */
   png_int_32 pcal_X1;      /* maximum value */
   png_charp pcal_units;    /* Latin-1 string giving physical units */
   png_charpp pcal_params;  /* ASCII strings containing parameter values */
   png_byte pcal_type;      /* equation type (see PNG_EQUATION_ below) */
   png_byte pcal_nparams;   /* number of parameters given in pcal_params */
#endif

/* New members added in libpng-1.0.6 */
#ifdef PNG_FREE_ME_SUPPORTED
   png_uint_32 free_me;     /* flags items libpng is responsible for freeing */
#endif

#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
   /* storage for unknown chunks that the library doesn't recognize. */
   png_unknown_chunkp unknown_chunks;
   png_size_t unknown_chunks_num;
#endif

#if defined(PNG_iCCP_SUPPORTED)
   /* iCCP chunk data. */
   png_charp iccp_name;     /* profile name */
   png_charp iccp_profile;  /* International Color Consortium profile data */
                            /* Note to maintainer: should be png_bytep */
   png_uint_32 iccp_proflen;  /* ICC profile data length */
   png_byte iccp_compression; /* Always zero */
#endif

#if defined(PNG_sPLT_SUPPORTED)
   /* data on sPLT chunks (there may be more than one). */
   png_sPLT_tp splt_palettes;
   png_uint_32 splt_palettes_num;
#endif

#if defined(PNG_sCAL_SUPPORTED)
   /* The sCAL chunk describes the actual physical dimensions of the
    * subject matter of the graphic.  The chunk contains a unit specification
    * a byte value, and two ASCII strings representing floating-point
    * values.  The values are width and height corresponsing to one pixel
    * in the image.  This external representation is converted to double
    * here.  Data values are valid if (valid & PNG_INFO_sCAL) is non-zero.
    */
   png_byte scal_unit;         /* unit of physical scale */
#ifdef PNG_FLOATING_POINT_SUPPORTED
   double scal_pixel_width;    /* width of one pixel */
   double scal_pixel_height;   /* height of one pixel */
#endif
#ifdef PNG_FIXED_POINT_SUPPORTED
   png_charp scal_s_width;     /* string containing height */
   png_charp scal_s_height;    /* string containing width */
#endif
#endif

#if defined(PNG_INFO_IMAGE_SUPPORTED)
   /* Memory has been allocated if (valid & PNG_ALLOCATED_INFO_ROWS) non-zero */
   /* Data valid if (valid & PNG_INFO_IDAT) non-zero */
   png_bytepp row_pointers;        /* the image bits */
#endif

#if defined(PNG_FIXED_POINT_SUPPORTED) && defined(PNG_gAMA_SUPPORTED)
   png_fixed_point int_gamma; /* gamma of image, if (valid & PNG_INFO_gAMA) */
#endif

#if defined(PNG_cHRM_SUPPORTED) && defined(PNG_FIXED_POINT_SUPPORTED)
   png_fixed_point int_x_white;
   png_fixed_point int_y_white;
   png_fixed_point int_x_red;
   png_fixed_point int_y_red;
   png_fixed_point int_x_green;
   png_fixed_point int_y_green;
   png_fixed_point int_x_blue;
   png_fixed_point int_y_blue;
#endif

} png_info;

typedef png_info FAR * png_infop;
typedef png_info FAR * FAR * png_infopp;

/* Maximum positive integer used in PNG is (2^31)-1 */
#define PNG_UINT_31_MAX ((png_uint_32)0x7fffffffL)
#define PNG_UINT_32_MAX ((png_uint_32)(-1))
#define PNG_SIZE_MAX ((png_size_t)(-1))
/* PNG_MAX_UINT is deprecated; use PNG_UINT_31_MAX instead. */
#define PNG_MAX_UINT PNG_UINT_31_MAX

/* These describe the color_type field in png_info. */
/* color type masks */
#define PNG_COLOR_MASK_PALETTE    1
#define PNG_COLOR_MASK_COLOR      2
#define PNG_COLOR_MASK_ALPHA      4

/* color types.  Note that not all combinations are legal */
#define PNG_COLOR_TYPE_GRAY 0
#define PNG_COLOR_TYPE_PALETTE  (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_PALETTE)
#define PNG_COLOR_TYPE_RGB        (PNG_COLOR_MASK_COLOR)
#define PNG_COLOR_TYPE_RGB_ALPHA  (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_ALPHA)
#define PNG_COLOR_TYPE_GRAY_ALPHA (PNG_COLOR_MASK_ALPHA)
/* aliases */
#define PNG_COLOR_TYPE_RGBA  PNG_COLOR_TYPE_RGB_ALPHA
#define PNG_COLOR_TYPE_GA  PNG_COLOR_TYPE_GRAY_ALPHA

/* This is for compression type. PNG 1.0-1.2 only define the single type. */
#define PNG_COMPRESSION_TYPE_BASE 0 /* Deflate method 8, 32K window */
#define PNG_COMPRESSION_TYPE_DEFAULT PNG_COMPRESSION_TYPE_BASE

/* This is for filter type. PNG 1.0-1.2 only define the single type. */
#define PNG_FILTER_TYPE_BASE      0 /* Single row per-byte filtering */
#define PNG_INTRAPIXEL_DIFFERENCING 64 /* Used only in MNG datastreams */
#define PNG_FILTER_TYPE_DEFAULT   PNG_FILTER_TYPE_BASE

/* These are for the interlacing type.  These values should NOT be changed. */
#define PNG_INTERLACE_NONE        0 /* Non-interlaced image */
#define PNG_INTERLACE_ADAM7       1 /* Adam7 interlacing */
#define PNG_INTERLACE_LAST        2 /* Not a valid value */

/* These are for the oFFs chunk.  These values should NOT be changed. */
#define PNG_OFFSET_PIXEL          0 /* Offset in pixels */
#define PNG_OFFSET_MICROMETER     1 /* Offset in micrometers (1/10^6 meter) */
#define PNG_OFFSET_LAST           2 /* Not a valid value */

/* These are for the pCAL chunk.  These values should NOT be changed. */
#define PNG_EQUATION_LINEAR       0 /* Linear transformation */
#define PNG_EQUATION_BASE_E       1 /* Exponential base e transform */
#define PNG_EQUATION_ARBITRARY    2 /* Arbitrary base exponential transform */
#define PNG_EQUATION_HYPERBOLIC   3 /* Hyperbolic sine transformation */
#define PNG_EQUATION_LAST         4 /* Not a valid value */

/* These are for the sCAL chunk.  These values should NOT be changed. */
#define PNG_SCALE_UNKNOWN         0 /* unknown unit (image scale) */
#define PNG_SCALE_METER           1 /* meters per pixel */
#define PNG_SCALE_RADIAN          2 /* radians per pixel */
#define PNG_SCALE_LAST            3 /* Not a valid value */

/* These are for the pHYs chunk.  These values should NOT be changed. */
#define PNG_RESOLUTION_UNKNOWN    0 /* pixels/unknown unit (aspect ratio) */
#define PNG_RESOLUTION_METER      1 /* pixels/meter */
#define PNG_RESOLUTION_LAST       2 /* Not a valid value */

/* These are for the sRGB chunk.  These values should NOT be changed. */
#define PNG_sRGB_INTENT_PERCEPTUAL 0
#define PNG_sRGB_INTENT_RELATIVE   1
#define PNG_sRGB_INTENT_SATURATION 2
#define PNG_sRGB_INTENT_ABSOLUTE   3
#define PNG_sRGB_INTENT_LAST       4 /* Not a valid value */

/* This is for text chunks */
#define PNG_KEYWORD_MAX_LENGTH     79

/* Maximum number of entries in PLTE/sPLT/tRNS arrays */
#define PNG_MAX_PALETTE_LENGTH    256

/* These determine if an ancillary chunk's data has been successfully read
 * from the PNG header, or if the application has filled in the corresponding
 * data in the info_struct to be written into the output file.  The values
 * of the PNG_INFO_<chunk> defines should NOT be changed.
 */
#define PNG_INFO_gAMA 0x0001
#define PNG_INFO_sBIT 0x0002
#define PNG_INFO_cHRM 0x0004
#define PNG_INFO_PLTE 0x0008
#define PNG_INFO_tRNS 0x0010
#define PNG_INFO_bKGD 0x0020
#define PNG_INFO_hIST 0x0040
#define PNG_INFO_pHYs 0x0080
#define PNG_INFO_oFFs 0x0100
#define PNG_INFO_tIME 0x0200
#define PNG_INFO_pCAL 0x0400
#define PNG_INFO_sRGB 0x0800   /* GR-P, 0.96a */
#define PNG_INFO_iCCP 0x1000   /* ESR, 1.0.6 */
#define PNG_INFO_sPLT 0x2000   /* ESR, 1.0.6 */
#define PNG_INFO_sCAL 0x4000   /* ESR, 1.0.6 */
#define PNG_INFO_IDAT 0x8000L  /* ESR, 1.0.6 */

/* This is used for the transformation routines, as some of them
 * change these values for the row.  It also should enable using
 * the routines for other purposes.
 */
typedef struct png_row_info_struct
{
   png_uint_32 width; /* width of row */
   png_uint_32 rowbytes; /* number of bytes in row */
   png_byte color_type; /* color type of row */
   png_byte bit_depth; /* bit depth of row */
   png_byte channels; /* number of channels (1, 2, 3, or 4) */
   png_byte pixel_depth; /* bits per pixel (depth * channels) */
} png_row_info;

typedef png_row_info FAR * png_row_infop;
typedef png_row_info FAR * FAR * png_row_infopp;

/* These are the function types for the I/O functions and for the functions
 * that allow the user to override the default I/O functions with his or her
 * own.  The png_error_ptr type should match that of user-supplied warning
 * and error functions, while the png_rw_ptr type should match that of the
 * user read/write data functions.
 */
typedef struct png_struct_def png_struct;
typedef png_struct FAR * png_structp;

typedef void (PNGAPI *png_error_ptr) PNGARG((png_structp, png_const_charp));
typedef void (PNGAPI *png_rw_ptr) PNGARG((png_structp, png_bytep, png_size_t));
typedef void (PNGAPI *png_flush_ptr) PNGARG((png_structp));
typedef void (PNGAPI *png_read_status_ptr) PNGARG((png_structp, png_uint_32,
   int));
typedef void (PNGAPI *png_write_status_ptr) PNGARG((png_structp, png_uint_32,
   int));

#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
typedef void (PNGAPI *png_progressive_info_ptr) PNGARG((png_structp, png_infop));
typedef void (PNGAPI *png_progressive_end_ptr) PNGARG((png_structp, png_infop));
typedef void (PNGAPI *png_progressive_row_ptr) PNGARG((png_structp, png_bytep,
   png_uint_32, int));
#endif

#if defined(PNG_READ_USER_TRANSFORM_SUPPORTED) || \
    defined(PNG_WRITE_USER_TRANSFORM_SUPPORTED) || \
    defined(PNG_LEGACY_SUPPORTED)
typedef void (PNGAPI *png_user_transform_ptr) PNGARG((png_structp,
    png_row_infop, png_bytep));
#endif

#if defined(PNG_USER_CHUNKS_SUPPORTED)
typedef int (PNGAPI *png_user_chunk_ptr) PNGARG((png_structp, png_unknown_chunkp));
#endif
#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
typedef void (PNGAPI *png_unknown_chunk_ptr) PNGARG((png_structp));
#endif

/* Transform masks for the high-level interface */
#define PNG_TRANSFORM_IDENTITY       0x0000    /* read and write */
#define PNG_TRANSFORM_STRIP_16       0x0001    /* read only */
#define PNG_TRANSFORM_STRIP_ALPHA    0x0002    /* read only */
#define PNG_TRANSFORM_PACKING        0x0004    /* read and write */
#define PNG_TRANSFORM_PACKSWAP       0x0008    /* read and write */
#define PNG_TRANSFORM_EXPAND         0x0010    /* read only */
#define PNG_TRANSFORM_INVERT_MONO    0x0020    /* read and write */
#define PNG_TRANSFORM_SHIFT          0x0040    /* read and write */
#define PNG_TRANSFORM_BGR            0x0080    /* read and write */
#define PNG_TRANSFORM_SWAP_ALPHA     0x0100    /* read and write */
#define PNG_TRANSFORM_SWAP_ENDIAN    0x0200    /* read and write */
#define PNG_TRANSFORM_INVERT_ALPHA   0x0400    /* read and write */
#define PNG_TRANSFORM_STRIP_FILLER   0x0800    /* WRITE only */

/* Flags for MNG supported features */
#define PNG_FLAG_MNG_EMPTY_PLTE     0x01
#define PNG_FLAG_MNG_FILTER_64      0x04
#define PNG_ALL_MNG_FEATURES        0x05

typedef png_voidp (*png_malloc_ptr) PNGARG((png_structp, png_size_t));
typedef void (*png_free_ptr) PNGARG((png_structp, png_voidp));

/* The structure that holds the information to read and write PNG files.
 * The only people who need to care about what is inside of this are the
 * people who will be modifying the library for their own special needs.
 * It should NOT be accessed directly by an application, except to store
 * the jmp_buf.
 */

struct png_struct_def
{
#ifdef PNG_SETJMP_SUPPORTED
   jmp_buf jmpbuf;            /* used in png_error */
#endif
   png_error_ptr error_fn;    /* function for printing errors and aborting */
   png_error_ptr warning_fn;  /* function for printing warnings */
   png_voidp error_ptr;       /* user supplied struct for error functions */
   png_rw_ptr write_data_fn;  /* function for writing output data */
   png_rw_ptr read_data_fn;   /* function for reading input data */
   png_voidp io_ptr;          /* ptr to application struct for I/O functions */

#if defined(PNG_READ_USER_TRANSFORM_SUPPORTED)
   png_user_transform_ptr read_user_transform_fn; /* user read transform */
#endif

#if defined(PNG_WRITE_USER_TRANSFORM_SUPPORTED)
   png_user_transform_ptr write_user_transform_fn; /* user write transform */
#endif

/* These were added in libpng-1.0.2 */
#if defined(PNG_USER_TRANSFORM_PTR_SUPPORTED)
#if defined(PNG_READ_USER_TRANSFORM_SUPPORTED) || \
    defined(PNG_WRITE_USER_TRANSFORM_SUPPORTED)
   png_voidp user_transform_ptr; /* user supplied struct for user transform */
   png_byte user_transform_depth;    /* bit depth of user transformed pixels */
   png_byte user_transform_channels; /* channels in user transformed pixels */
#endif
#endif

   png_uint_32 mode;          /* tells us where we are in the PNG file */
   png_uint_32 flags;         /* flags indicating various things to libpng */
   png_uint_32 transformations; /* which transformations to perform */

   z_stream zstream;          /* pointer to decompression structure (below) */
   png_bytep zbuf;            /* buffer for zlib */
   png_size_t zbuf_size;      /* size of zbuf */
   int zlib_level;            /* holds zlib compression level */
   int zlib_method;           /* holds zlib compression method */
   int zlib_window_bits;      /* holds zlib compression window bits */
   int zlib_mem_level;        /* holds zlib compression memory level */
   int zlib_strategy;         /* holds zlib compression strategy */

   png_uint_32 width;         /* width of image in pixels */
   png_uint_32 height;        /* height of image in pixels */
   png_uint_32 num_rows;      /* number of rows in current pass */
   png_uint_32 usr_width;     /* width of row at start of write */
   png_uint_32 rowbytes;      /* size of row in bytes */
   png_uint_32 irowbytes;     /* size of current interlaced row in bytes */
   png_uint_32 iwidth;        /* width of current interlaced row in pixels */
   png_uint_32 row_number;    /* current row in interlace pass */
   png_bytep prev_row;        /* buffer to save previous (unfiltered) row */
   png_bytep row_buf;         /* buffer to save current (unfiltered) row */
   png_bytep sub_row;         /* buffer to save "sub" row when filtering */
   png_bytep up_row;          /* buffer to save "up" row when filtering */
   png_bytep avg_row;         /* buffer to save "avg" row when filtering */
   png_bytep paeth_row;       /* buffer to save "Paeth" row when filtering */
   png_row_info row_info;     /* used for transformation routines */

   png_uint_32 idat_size;     /* current IDAT size for read */
   png_uint_32 crc;           /* current chunk CRC value */
   png_colorp palette;        /* palette from the input file */
   png_uint_16 num_palette;   /* number of color entries in palette */
   png_uint_16 num_trans;     /* number of transparency values */
   png_byte chunk_name[5];    /* null-terminated name of current chunk */
   png_byte compression;      /* file compression type (always 0) */
   png_byte filter;           /* file filter type (always 0) */
   png_byte interlaced;       /* PNG_INTERLACE_NONE, PNG_INTERLACE_ADAM7 */
   png_byte pass;             /* current interlace pass (0 - 6) */
   png_byte do_filter;        /* row filter flags (see PNG_FILTER_ below ) */
   png_byte color_type;       /* color type of file */
   png_byte bit_depth;        /* bit depth of file */
   png_byte usr_bit_depth;    /* bit depth of users row */
   png_byte pixel_depth;      /* number of bits per pixel */
   png_byte channels;         /* number of channels in file */
   png_byte usr_channels;     /* channels at start of write */
   png_byte sig_bytes;        /* magic bytes read/written from start of file */

#if defined(PNG_READ_FILLER_SUPPORTED) || defined(PNG_WRITE_FILLER_SUPPORTED)
#ifdef PNG_LEGACY_SUPPORTED
   png_byte filler;           /* filler byte for pixel expansion */
#else
   png_uint_16 filler;           /* filler bytes for pixel expansion */
#endif
#endif

#if defined(PNG_bKGD_SUPPORTED)
   png_byte background_gamma_type;
#  ifdef PNG_FLOATING_POINT_SUPPORTED
   float background_gamma;
#  endif
   png_color_16 background;   /* background color in screen gamma space */
#if defined(PNG_READ_GAMMA_SUPPORTED)
   png_color_16 background_1; /* background normalized to gamma 1.0 */
#endif
#endif /* PNG_bKGD_SUPPORTED */

#if defined(PNG_WRITE_FLUSH_SUPPORTED)
   png_flush_ptr output_flush_fn;/* Function for flushing output */
   png_uint_32 flush_dist;    /* how many rows apart to flush, 0 - no flush */
   png_uint_32 flush_rows;    /* number of rows written since last flush */
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   int gamma_shift;      /* number of "insignificant" bits 16-bit gamma */
#ifdef PNG_FLOATING_POINT_SUPPORTED
   float gamma;          /* file gamma value */
   float screen_gamma;   /* screen gamma value (display_exponent) */
#endif
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_bytep gamma_table;     /* gamma table for 8-bit depth files */
   png_bytep gamma_from_1;    /* converts from 1.0 to screen */
   png_bytep gamma_to_1;      /* converts from file to 1.0 */
   png_uint_16pp gamma_16_table; /* gamma table for 16-bit depth files */
   png_uint_16pp gamma_16_from_1; /* converts from 1.0 to screen */
   png_uint_16pp gamma_16_to_1; /* converts from file to 1.0 */
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_sBIT_SUPPORTED)
   png_color_8 sig_bit;       /* significant bits in each available channel */
#endif

#if defined(PNG_READ_SHIFT_SUPPORTED) || defined(PNG_WRITE_SHIFT_SUPPORTED)
   png_color_8 shift;         /* shift for significant bit tranformation */
#endif

#if defined(PNG_tRNS_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED) \
 || defined(PNG_READ_EXPAND_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_bytep trans;           /* transparency values for paletted files */
   png_color_16 trans_values; /* transparency values for non-paletted files */
#endif

   png_read_status_ptr read_row_fn;   /* called after each row is decoded */
   png_write_status_ptr write_row_fn; /* called after each row is encoded */
#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
   png_progressive_info_ptr info_fn; /* called after header data fully read */
   png_progressive_row_ptr row_fn;   /* called after each prog. row is decoded */
   png_progressive_end_ptr end_fn;   /* called after image is complete */
   png_bytep save_buffer_ptr;        /* current location in save_buffer */
   png_bytep save_buffer;            /* buffer for previously read data */
   png_bytep current_buffer_ptr;     /* current location in current_buffer */
   png_bytep current_buffer;         /* buffer for recently used data */
   png_uint_32 push_length;          /* size of current input chunk */
   png_uint_32 skip_length;          /* bytes to skip in input data */
   png_size_t save_buffer_size;      /* amount of data now in save_buffer */
   png_size_t save_buffer_max;       /* total size of save_buffer */
   png_size_t buffer_size;           /* total amount of available input data */
   png_size_t current_buffer_size;   /* amount of data now in current_buffer */
   int process_mode;                 /* what push library is currently doing */
   int cur_palette;                  /* current push library palette index */

#  if defined(PNG_TEXT_SUPPORTED)
     png_size_t current_text_size;   /* current size of text input data */
     png_size_t current_text_left;   /* how much text left to read in input */
     png_charp current_text;         /* current text chunk buffer */
     png_charp current_text_ptr;     /* current location in current_text */
#  endif /* PNG_PROGRESSIVE_READ_SUPPORTED && PNG_TEXT_SUPPORTED */

#endif /* PNG_PROGRESSIVE_READ_SUPPORTED */

#if defined(__TURBOC__) && !defined(_Windows) && !defined(__FLAT__)
/* for the Borland special 64K segment handler */
   png_bytepp offset_table_ptr;
   png_bytep offset_table;
   png_uint_16 offset_table_number;
   png_uint_16 offset_table_count;
   png_uint_16 offset_table_count_free;
#endif

#if defined(PNG_READ_DITHER_SUPPORTED)
   png_bytep palette_lookup;         /* lookup table for dithering */
   png_bytep dither_index;           /* index translation for palette files */
#endif

#if defined(PNG_READ_DITHER_SUPPORTED) || defined(PNG_hIST_SUPPORTED)
   png_uint_16p hist;                /* histogram */
#endif

#if defined(PNG_WRITE_WEIGHTED_FILTER_SUPPORTED)
   png_byte heuristic_method;        /* heuristic for row filter selection */
   png_byte num_prev_filters;        /* number of weights for previous rows */
   png_bytep prev_filters;           /* filter type(s) of previous row(s) */
   png_uint_16p filter_weights;      /* weight(s) for previous line(s) */
   png_uint_16p inv_filter_weights;  /* 1/weight(s) for previous line(s) */
   png_uint_16p filter_costs;        /* relative filter calculation cost */
   png_uint_16p inv_filter_costs;    /* 1/relative filter calculation cost */
#endif

#if defined(PNG_TIME_RFC1123_SUPPORTED)
   png_charp time_buffer;            /* String to hold RFC 1123 time text */
#endif

/* New members added in libpng-1.0.6 */

#ifdef PNG_FREE_ME_SUPPORTED
   png_uint_32 free_me;       /* flags items libpng is responsible for freeing */
#endif

#if defined(PNG_USER_CHUNKS_SUPPORTED)
   png_voidp user_chunk_ptr;
   png_user_chunk_ptr read_user_chunk_fn; /* user read chunk handler */
#endif

#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
   int num_chunk_list;
   png_bytep chunk_list;
#endif

/* New members added in libpng-1.0.3 */
#if defined(PNG_READ_RGB_TO_GRAY_SUPPORTED)
   png_byte rgb_to_gray_status;
   /* These were changed from png_byte in libpng-1.0.6 */
   png_uint_16 rgb_to_gray_red_coeff;
   png_uint_16 rgb_to_gray_green_coeff;
   png_uint_16 rgb_to_gray_blue_coeff;
#endif

/* New member added in libpng-1.0.4 (renamed in 1.0.9) */
#if defined(PNG_MNG_FEATURES_SUPPORTED) || \
    defined(PNG_READ_EMPTY_PLTE_SUPPORTED) || \
    defined(PNG_WRITE_EMPTY_PLTE_SUPPORTED)
/* changed from png_byte to png_uint_32 at version 1.2.0 */
#ifdef PNG_1_0_X
   png_byte mng_features_permitted;
#else
   png_uint_32 mng_features_permitted;
#endif /* PNG_1_0_X */
#endif

/* New member added in libpng-1.0.7 */
#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_fixed_point int_gamma;
#endif

/* New member added in libpng-1.0.9, ifdef'ed out in 1.0.12, enabled in 1.2.0 */
#if defined(PNG_MNG_FEATURES_SUPPORTED)
   png_byte filter_type;
#endif

#if defined(PNG_1_0_X) || (defined(PNG_DEBUG) && defined(PNG_USE_PNGGCCRD))
/* New member added in libpng-1.0.10, ifdef'ed out in 1.2.0 */
   png_uint_32 row_buf_size;
#endif

/* New members added in libpng-1.2.0 */
#if !defined(PNG_1_0_X) && defined(PNG_ASSEMBLER_CODE_SUPPORTED)
   png_byte     mmx_bitdepth_threshold;
   png_uint_32  mmx_rowbytes_threshold;
   png_uint_32  asm_flags;
#endif

/* New members added in libpng-1.0.2 but first enabled by default in 1.2.0 */
#ifdef PNG_USER_MEM_SUPPORTED
   png_voidp mem_ptr;                /* user supplied struct for mem functions */
   png_malloc_ptr malloc_fn;         /* function for allocating memory */
   png_free_ptr free_fn;             /* function for freeing memory */
#endif

/* New member added in libpng-1.0.13 and 1.2.0 */
   png_bytep big_row_buf;         /* buffer to save current (unfiltered) row */

#if defined(PNG_READ_DITHER_SUPPORTED)
/* The following three members were added at version 1.0.14 and 1.2.4 */
   png_bytep dither_sort;            /* working sort array */
   png_bytep index_to_palette;       /* where the original index currently is */
                                     /* in the palette */
   png_bytep palette_to_index;       /* which original index points to this */
                                     /* palette color */
#endif

/* New members added in libpng-1.0.16 and 1.2.6 */
   png_byte compression_type;

#ifdef PNG_SET_USER_LIMITS_SUPPORTED
   png_uint_32 user_width_max;
   png_uint_32 user_height_max;
#endif

};


/* This triggers a compiler error in png.c, if png.c and png.h
 * do not agree upon the version number.
 */
typedef png_structp version_1_2_8;

typedef png_struct FAR * FAR * png_structpp;

/* Here are the function definitions most commonly used.  This is not
 * the place to find out how to use libpng.  See libpng.txt for the
 * full explanation, see example.c for the summary.  This just provides
 * a simple one line description of the use of each function.
 */

/* Returns the version number of the library */
extern PNG_EXPORT(png_uint_32,png_access_version_number) PNGARG((void));

/* Tell lib we have already handled the first <num_bytes> magic bytes.
 * Handling more than 8 bytes from the beginning of the file is an error.
 */
extern PNG_EXPORT(void,png_set_sig_bytes) PNGARG((png_structp png_ptr,
   int num_bytes));

/* Check sig[start] through sig[start + num_to_check - 1] to see if it's a
 * PNG file.  Returns zero if the supplied bytes match the 8-byte PNG
 * signature, and non-zero otherwise.  Having num_to_check == 0 or
 * start > 7 will always fail (ie return non-zero).
 */
extern PNG_EXPORT(int,png_sig_cmp) PNGARG((png_bytep sig, png_size_t start,
   png_size_t num_to_check));

/* Simple signature checking function.  This is the same as calling
 * png_check_sig(sig, n) := !png_sig_cmp(sig, 0, n).
 */
extern PNG_EXPORT(int,png_check_sig) PNGARG((png_bytep sig, int num));

/* Allocate and initialize png_ptr struct for reading, and any other memory. */
extern PNG_EXPORT(png_structp,png_create_read_struct)
   PNGARG((png_const_charp user_png_ver, png_voidp error_ptr,
   png_error_ptr error_fn, png_error_ptr warn_fn));

/* Allocate and initialize png_ptr struct for writing, and any other memory */
extern PNG_EXPORT(png_structp,png_create_write_struct)
   PNGARG((png_const_charp user_png_ver, png_voidp error_ptr,
   png_error_ptr error_fn, png_error_ptr warn_fn));

#ifdef PNG_WRITE_SUPPORTED
extern PNG_EXPORT(png_uint_32,png_get_compression_buffer_size)
   PNGARG((png_structp png_ptr));
#endif

#ifdef PNG_WRITE_SUPPORTED
extern PNG_EXPORT(void,png_set_compression_buffer_size)
   PNGARG((png_structp png_ptr, png_uint_32 size));
#endif

/* Reset the compression stream */
extern PNG_EXPORT(int,png_reset_zstream) PNGARG((png_structp png_ptr));

/* New functions added in libpng-1.0.2 (not enabled by default until 1.2.0) */
#ifdef PNG_USER_MEM_SUPPORTED
extern PNG_EXPORT(png_structp,png_create_read_struct_2)
   PNGARG((png_const_charp user_png_ver, png_voidp error_ptr,
   png_error_ptr error_fn, png_error_ptr warn_fn, png_voidp mem_ptr,
   png_malloc_ptr malloc_fn, png_free_ptr free_fn));
extern PNG_EXPORT(png_structp,png_create_write_struct_2)
   PNGARG((png_const_charp user_png_ver, png_voidp error_ptr,
   png_error_ptr error_fn, png_error_ptr warn_fn, png_voidp mem_ptr,
   png_malloc_ptr malloc_fn, png_free_ptr free_fn));
#endif

/* Write a PNG chunk - size, type, (optional) data, CRC. */
extern PNG_EXPORT(void,png_write_chunk) PNGARG((png_structp png_ptr,
   png_bytep chunk_name, png_bytep data, png_size_t length));

/* Write the start of a PNG chunk - length and chunk name. */
extern PNG_EXPORT(void,png_write_chunk_start) PNGARG((png_structp png_ptr,
   png_bytep chunk_name, png_uint_32 length));

/* Write the data of a PNG chunk started with png_write_chunk_start(). */
extern PNG_EXPORT(void,png_write_chunk_data) PNGARG((png_structp png_ptr,
   png_bytep data, png_size_t length));

/* Finish a chunk started with png_write_chunk_start() (includes CRC). */
extern PNG_EXPORT(void,png_write_chunk_end) PNGARG((png_structp png_ptr));

/* Allocate and initialize the info structure */
extern PNG_EXPORT(png_infop,png_create_info_struct)
   PNGARG((png_structp png_ptr));

/* Initialize the info structure (old interface - DEPRECATED) */
extern PNG_EXPORT(void,png_info_init) PNGARG((png_infop info_ptr));
#undef png_info_init
#define png_info_init(info_ptr) png_info_init_3(&info_ptr,\
    png_sizeof(png_info));
extern PNG_EXPORT(void,png_info_init_3) PNGARG((png_infopp info_ptr,
    png_size_t png_info_struct_size));

/* Writes all the PNG information before the image. */
extern PNG_EXPORT(void,png_write_info_before_PLTE) PNGARG((png_structp png_ptr,
   png_infop info_ptr));
extern PNG_EXPORT(void,png_write_info) PNGARG((png_structp png_ptr,
   png_infop info_ptr));

#ifndef PNG_NO_SEQUENTIAL_READ_SUPPORTED
/* read the information before the actual image data. */
extern PNG_EXPORT(void,png_read_info) PNGARG((png_structp png_ptr,
   png_infop info_ptr));
#endif

#if defined(PNG_TIME_RFC1123_SUPPORTED)
extern PNG_EXPORT(png_charp,png_convert_to_rfc1123)
   PNGARG((png_structp png_ptr, png_timep ptime));
#endif

#if !defined(_WIN32_WCE)
/* "time.h" functions are not supported on WindowsCE */
#if defined(PNG_WRITE_tIME_SUPPORTED)
/* convert from a struct tm to png_time */
extern PNG_EXPORT(void,png_convert_from_struct_tm) PNGARG((png_timep ptime,
   struct tm FAR * ttime));

/* convert from time_t to png_time.  Uses gmtime() */
extern PNG_EXPORT(void,png_convert_from_time_t) PNGARG((png_timep ptime,
   time_t ttime));
#endif /* PNG_WRITE_tIME_SUPPORTED */
#endif /* _WIN32_WCE */

#if defined(PNG_READ_EXPAND_SUPPORTED)
/* Expand data to 24-bit RGB, or 8-bit grayscale, with alpha if available. */
extern PNG_EXPORT(void,png_set_expand) PNGARG((png_structp png_ptr));
extern PNG_EXPORT(void,png_set_gray_1_2_4_to_8) PNGARG((png_structp png_ptr));
extern PNG_EXPORT(void,png_set_palette_to_rgb) PNGARG((png_structp png_ptr));
extern PNG_EXPORT(void,png_set_tRNS_to_alpha) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_BGR_SUPPORTED) || defined(PNG_WRITE_BGR_SUPPORTED)
/* Use blue, green, red order for pixels. */
extern PNG_EXPORT(void,png_set_bgr) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_GRAY_TO_RGB_SUPPORTED)
/* Expand the grayscale to 24-bit RGB if necessary. */
extern PNG_EXPORT(void,png_set_gray_to_rgb) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_RGB_TO_GRAY_SUPPORTED)
/* Reduce RGB to grayscale. */
#ifdef PNG_FLOATING_POINT_SUPPORTED
extern PNG_EXPORT(void,png_set_rgb_to_gray) PNGARG((png_structp png_ptr,
   int error_action, double red, double green ));
#endif
extern PNG_EXPORT(void,png_set_rgb_to_gray_fixed) PNGARG((png_structp png_ptr,
   int error_action, png_fixed_point red, png_fixed_point green ));
extern PNG_EXPORT(png_byte,png_get_rgb_to_gray_status) PNGARG((png_structp
   png_ptr));
#endif

extern PNG_EXPORT(void,png_build_grayscale_palette) PNGARG((int bit_depth,
   png_colorp palette));

#if defined(PNG_READ_STRIP_ALPHA_SUPPORTED)
extern PNG_EXPORT(void,png_set_strip_alpha) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_SWAP_ALPHA_SUPPORTED) || \
    defined(PNG_WRITE_SWAP_ALPHA_SUPPORTED)
extern PNG_EXPORT(void,png_set_swap_alpha) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_INVERT_ALPHA_SUPPORTED) || \
    defined(PNG_WRITE_INVERT_ALPHA_SUPPORTED)
extern PNG_EXPORT(void,png_set_invert_alpha) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_FILLER_SUPPORTED) || defined(PNG_WRITE_FILLER_SUPPORTED)
/* Add a filler byte to 8-bit Gray or 24-bit RGB images. */
extern PNG_EXPORT(void,png_set_filler) PNGARG((png_structp png_ptr,
   png_uint_32 filler, int flags));
/* The values of the PNG_FILLER_ defines should NOT be changed */
#define PNG_FILLER_BEFORE 0
#define PNG_FILLER_AFTER 1
/* Add an alpha byte to 8-bit Gray or 24-bit RGB images. */
#if !defined(PNG_1_0_X)
extern PNG_EXPORT(void,png_set_add_alpha) PNGARG((png_structp png_ptr,
   png_uint_32 filler, int flags));
#endif
#endif /* PNG_READ_FILLER_SUPPORTED || PNG_WRITE_FILLER_SUPPORTED */

#if defined(PNG_READ_SWAP_SUPPORTED) || defined(PNG_WRITE_SWAP_SUPPORTED)
/* Swap bytes in 16-bit depth files. */
extern PNG_EXPORT(void,png_set_swap) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_PACK_SUPPORTED) || defined(PNG_WRITE_PACK_SUPPORTED)
/* Use 1 byte per pixel in 1, 2, or 4-bit depth files. */
extern PNG_EXPORT(void,png_set_packing) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_PACKSWAP_SUPPORTED) || defined(PNG_WRITE_PACKSWAP_SUPPORTED)
/* Swap packing order of pixels in bytes. */
extern PNG_EXPORT(void,png_set_packswap) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_SHIFT_SUPPORTED) || defined(PNG_WRITE_SHIFT_SUPPORTED)
/* Converts files to legal bit depths. */
extern PNG_EXPORT(void,png_set_shift) PNGARG((png_structp png_ptr,
   png_color_8p true_bits));
#endif

#if defined(PNG_READ_INTERLACING_SUPPORTED) || \
    defined(PNG_WRITE_INTERLACING_SUPPORTED)
/* Have the code handle the interlacing.  Returns the number of passes. */
extern PNG_EXPORT(int,png_set_interlace_handling) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_INVERT_SUPPORTED) || defined(PNG_WRITE_INVERT_SUPPORTED)
/* Invert monochrome files */
extern PNG_EXPORT(void,png_set_invert_mono) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_BACKGROUND_SUPPORTED)
/* Handle alpha and tRNS by replacing with a background color. */
#ifdef PNG_FLOATING_POINT_SUPPORTED
extern PNG_EXPORT(void,png_set_background) PNGARG((png_structp png_ptr,
   png_color_16p background_color, int background_gamma_code,
   int need_expand, double background_gamma));
#endif
#define PNG_BACKGROUND_GAMMA_UNKNOWN 0
#define PNG_BACKGROUND_GAMMA_SCREEN  1
#define PNG_BACKGROUND_GAMMA_FILE    2
#define PNG_BACKGROUND_GAMMA_UNIQUE  3
#endif

#if defined(PNG_READ_16_TO_8_SUPPORTED)
/* strip the second byte of information from a 16-bit depth file. */
extern PNG_EXPORT(void,png_set_strip_16) PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_DITHER_SUPPORTED)
/* Turn on dithering, and reduce the palette to the number of colors available. */
extern PNG_EXPORT(void,png_set_dither) PNGARG((png_structp png_ptr,
   png_colorp palette, int num_palette, int maximum_colors,
   png_uint_16p histogram, int full_dither));
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED)
/* Handle gamma correction. Screen_gamma=(display_exponent) */
#ifdef PNG_FLOATING_POINT_SUPPORTED
extern PNG_EXPORT(void,png_set_gamma) PNGARG((png_structp png_ptr,
   double screen_gamma, double default_file_gamma));
#endif
#endif

#if defined(PNG_READ_EMPTY_PLTE_SUPPORTED) || \
    defined(PNG_WRITE_EMPTY_PLTE_SUPPORTED)
/* Permit or disallow empty PLTE (0: not permitted, 1: permitted) */
/* Deprecated and will be removed.  Use png_permit_mng_features() instead. */
extern PNG_EXPORT(void,png_permit_empty_plte) PNGARG((png_structp png_ptr,
   int empty_plte_permitted));
#endif

#if defined(PNG_WRITE_FLUSH_SUPPORTED)
/* Set how many lines between output flushes - 0 for no flushing */
extern PNG_EXPORT(void,png_set_flush) PNGARG((png_structp png_ptr, int nrows));
/* Flush the current PNG output buffer */
extern PNG_EXPORT(void,png_write_flush) PNGARG((png_structp png_ptr));
#endif

/* optional update palette with requested transformations */
extern PNG_EXPORT(void,png_start_read_image) PNGARG((png_structp png_ptr));

/* optional call to update the users info structure */
extern PNG_EXPORT(void,png_read_update_info) PNGARG((png_structp png_ptr,
   png_infop info_ptr));

#ifndef PNG_NO_SEQUENTIAL_READ_SUPPORTED
/* read one or more rows of image data. */
extern PNG_EXPORT(void,png_read_rows) PNGARG((png_structp png_ptr,
   png_bytepp row, png_bytepp display_row, png_uint_32 num_rows));
#endif

#ifndef PNG_NO_SEQUENTIAL_READ_SUPPORTED
/* read a row of data. */
extern PNG_EXPORT(void,png_read_row) PNGARG((png_structp png_ptr,
   png_bytep row,
   png_bytep display_row));
#endif

#ifndef PNG_NO_SEQUENTIAL_READ_SUPPORTED
/* read the whole image into memory at once. */
extern PNG_EXPORT(void,png_read_image) PNGARG((png_structp png_ptr,
   png_bytepp image));
#endif

/* write a row of image data */
extern PNG_EXPORT(void,png_write_row) PNGARG((png_structp png_ptr,
   png_bytep row));

/* write a few rows of image data */
extern PNG_EXPORT(void,png_write_rows) PNGARG((png_structp png_ptr,
   png_bytepp row, png_uint_32 num_rows));

/* write the image data */
extern PNG_EXPORT(void,png_write_image) PNGARG((png_structp png_ptr,
   png_bytepp image));

/* writes the end of the PNG file. */
extern PNG_EXPORT(void,png_write_end) PNGARG((png_structp png_ptr,
   png_infop info_ptr));

#ifndef PNG_NO_SEQUENTIAL_READ_SUPPORTED
/* read the end of the PNG file. */
extern PNG_EXPORT(void,png_read_end) PNGARG((png_structp png_ptr,
   png_infop info_ptr));
#endif

/* free any memory associated with the png_info_struct */
extern PNG_EXPORT(void,png_destroy_info_struct) PNGARG((png_structp png_ptr,
   png_infopp info_ptr_ptr));

/* free any memory associated with the png_struct and the png_info_structs */
extern PNG_EXPORT(void,png_destroy_read_struct) PNGARG((png_structpp
   png_ptr_ptr, png_infopp info_ptr_ptr, png_infopp end_info_ptr_ptr));

/* free all memory used by the read (old method - NOT DLL EXPORTED) */
extern void png_read_destroy PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_infop end_info_ptr));

/* free any memory associated with the png_struct and the png_info_structs */
extern PNG_EXPORT(void,png_destroy_write_struct)
   PNGARG((png_structpp png_ptr_ptr, png_infopp info_ptr_ptr));

/* free any memory used in png_ptr struct (old method - NOT DLL EXPORTED) */
extern void png_write_destroy PNGARG((png_structp png_ptr));

/* set the libpng method of handling chunk CRC errors */
extern PNG_EXPORT(void,png_set_crc_action) PNGARG((png_structp png_ptr,
   int crit_action, int ancil_action));

/* Values for png_set_crc_action() to say how to handle CRC errors in
 * ancillary and critical chunks, and whether to use the data contained
 * therein.  Note that it is impossible to "discard" data in a critical
 * chunk.  For versions prior to 0.90, the action was always error/quit,
 * whereas in version 0.90 and later, the action for CRC errors in ancillary
 * chunks is warn/discard.  These values should NOT be changed.
 *
 *      value                       action:critical     action:ancillary
 */
#define PNG_CRC_DEFAULT       0  /* error/quit          warn/discard data */
#define PNG_CRC_ERROR_QUIT    1  /* error/quit          error/quit        */
#define PNG_CRC_WARN_DISCARD  2  /* (INVALID)           warn/discard data */
#define PNG_CRC_WARN_USE      3  /* warn/use data       warn/use data     */
#define PNG_CRC_QUIET_USE     4  /* quiet/use data      quiet/use data    */
#define PNG_CRC_NO_CHANGE     5  /* use current value   use current value */

/* These functions give the user control over the scan-line filtering in
 * libpng and the compression methods used by zlib.  These functions are
 * mainAllocaedefine PNG_TRANSFfiltering in
 * libpng and the compression , th XTED
/* uiint_32 user_height_max;
#endif

};


/* This triDinto pHYs R_SUPPORfilhis errorSd the pTED)
/*PORfilhis _height_max;
#endif

};


/can-liallocfEAD_GRAY_TO_RGB_SUPPORTED)
/_S]efine int_32 user_height_max;b:bdif

#if defineC png_ptr,
   pnRC_Noe (C

#ifiXPOR(neC pngfiXPOR(neC e to the ned(P(sC errorsp ba   pnRC_Noe (C

#ifcal chunks, and whethORTED)
/_S]efine int_32 user_height_max;b:bdif

ntrol_3) PNGARG(tructppf

#if de_CRC_WARN_USE      3  /* warn/use data   c,alues should NOT be changed.
row));tpNG_Ation) d whethORTED)g_ptr,
   png_bytepp image));

/* rD)
/_SIbp ;tpNG_Aendif

   png_rion nM IESSIVta oolength))e datachunk.  #if d0
#define PNG_Isfa*aion) d wpNG_Aendif

   png_rion g_ver1 d whethOoite_destsfa*aion) d wpion) efplay_exponent) */
#endif
#endif

#if defined(PNG/* set tese val to 8-bit Gray cc#endint) */
#e_png_ver, png_void/* read and write */
#define PNG_TRANSFORM_EXPANtted;
#.y_plte_pen PNGhts for pcng_destrolte_1fineC png_ptr,
   pnRC_Noe (,Cd;
#.y_plteg_stionE,
  R 2ror_fn, d(PNG/* set tese val to 8-bit Gray cc#en_set_crc__er));

/* set the libpng te_pen PNGht32_WCEny otherrmations to as alwad;
#.y_PPORTED) || defined(PNG_WRITE_FILLER_SUPPORTED)
/ny oth_D,ter, the action for CRy other_(f PNGput */efined(AE_ptr,p chunk_name_CRC_WARN_USand whe/d(AEm_d files *gon g_vED)
/nf curren */efinede_end) PNGARG((png_strucG/* set troy PNGARG((png_structp png_ptr));

/* se,t pngG/* set tese vSchunk_name_CRC_WARe vSchunk_n */
   png_byte rom file to 1vCet tese val to a_rp user_png_ver
extern _ARN_ine d anhts f and critical ceom file tDiticalpng_ptr));
8Iveom se,t pngG/ww members added in libpng-1.2.AED)
/* Use 1 Fg in
 *o_ptr_ptmCng_ptr));ng_charp camma value (display_expon_ptr) PNG_set_));ng_charp cammon_ptrrG_EXPORed(PNG_WRITE_FILLER

exterGr));
8I8S2.A(nt_text;  t

exterGr));
8I8S2.A(7  PNG o4r));
8plane_chunk_start) lay_eu t

exteGARG((;
8plaed o/use data      ;
8I8S2.APNG_1
#if defineC pt troy eeAzrn P PNGARG((png_stry associated with the png_inf7bytep duC pt troy eeAzrn P PNGARG((png_N#if defineC pt troy eeAzrn((png_s useSUPPORTED
extern Phe action for CRy other_(f PNGput) PNGARG((png_structp png_ptr,
  ociRITE_SWAP_  ocin,
   ;
8I8,NG o4r))

exteeng te_pen PNGht32_WCEnMe 1 Fg in
 *o_ptr_eEnMe 1 Fg in
 mahts f and no flutrn PNG_EXPORT(void,png_refoid,png_set_crc_action) PNGARG((pnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmpnmether to e_de,32 transformations; /*"ey eeA pe (aoED) || defined(Ppng_ptheck sig[start]() to say how to handle CRC errorsObng and thhy used in Idef tion) PNGARG((png_cong|| defined(PpnL
8plane_chunk_start) pC e to_2     ree an_WRITE_tIME_SUPPORTEDo a_rp oan_WRITE_ hREAD_BACK oth_D,ter, the actionepth amma;
#endif

/* New member oan_WALPHA     0x0100    /* rpng_create_info_struct)
   PNGARG((png_structp* moI_WRITE_-1.0.6 uct)
   PNGARG((png_stru_length;          /* size of current input chunk */
 ,_BACKGtette_to_index;s)png.c_infop,png_c)C e7thanlSWAP_  oc;sbyte usr_channels;     /* channels at staransformpng-1.0.13 and 1.2.0 */
   urrent input chunk */
 ,_BACKGtette_to_indermpnmpnmpnmpna8te_pen PNGht32_WCEnMe 1 FgRT(void,png_% chunk _uloFdestspnmpnmpnmpnmpnmete PNG file. */
extern PNG_EXPORT(void,png_read_enne PNG_FTrefoid,pn,tte_to_inde_% chunk _uloFdestspnmpnmpne_to_rgb) PNGARG((png and th_rgb) P offset(ed,png_% chunk _uloFdestspnmp and th_rgb) P offset(* WRITE only */

/* Flags for PORT* WRIT)png_structSUPPORTED)
extern Ppnmpnmete,pn,tte_aPORTED)
extern PNG_EXPORT(void,pnuG((png_strucng_crITE os[_o_rgb)TED)png_infPANtted;_cMk_ptr;
   png_user_chunk_ptr ffilter_tG_TIME_RFC1123_SUPPORTED)
   png_chasa5d bfPANttlstruct)
   PNGARG((png_structp* moIpngxtern PNG_EXPORT(void,png_write_pANSFORM_STRIP_FILLER   0x0800    /* WRIructSRM_STRIP_FILLER  PNG_EXPO;hunk - ver1 d whethOoit123 * read P.    /zm Ipngxtern PNG_EXPORT(void,png_write_pANSFORM_STRIP_FILLER _timep ptime,
   struANSF)cMALER n_WRIT channels at staransformp  pngpng_st  written sininput chunk */
 ,_BACKfPNG_FREE_ME_SUpnmpnmete,pn,tte_aPORM_tGapng


/canG((=input chunk */
 ,_BACKfPNG_dr));

/* sBACKfPNG_dr))ed(PNG_READ_GAMMA_SU_flumi written s TMtumi written s TM_REtructp png_ptr,
   png_infop info_ptsa5d bfPFSU_flumi written s T- PNG_CRC_nRC_Noe (,ructpRpo e_de,32 tran_8revious rfPFSU_flumi writtel_readcCAnsgg(ther_Sam functions */
   png_malloc_ptr malloc_fn;         /* funcSu writtetran_8revioE           /* buffer for zl_ptrEpng_set_int chunk */
 ,_BACKfPNG_FRE_structp pnptr erructp png_ptr,
   png_infop info_ptr));
#ev,
      png_inix.>thORTEDother_mpnmpnmi(PNG_1tr));
#eER _timep ptime,
   struANSF)cMALER nMALER nMALER nMALER nMALER n1; /pcng_destrolte_1fineC png_ptr,
   pnRC_Noe (,Cd;
#.y_plteg_stionE,
  R 2ror_fn, RORTEnfop define PNG_BACKGROUND_GAMpnRC_Nog_struc   pn,e_pen PNGht32_WCEnMe 1 Fg in
 *oEGCC_bytep 2(,Cd;
Cmfne PNG_FTrefop,pngpher_mpnmpnmi(Ptr)   pn_ptr));
   struANSF)cMALER n_WRIT de PNG
 * signature, and non-zRT(png_structp,png_create_write_struct_2)k _ulthe version number T de PN
 * signre, d*/
    ditheringy other tp pngIDAT svel;     2 tratp pnptr erructp png_p-gE_ptr));
8gnreuld om file to 1.TE only *_ T de Pb)TED)pnge       _row_buf;      to useIFs; /*"ey eeA pe (aoED) || defined(Pr erructp png_pxtern PNG_EXPORTx_CRC_WARe _ptr));
ee memMstruc   pn,e_pegrayscaD)pngeions */
  TED)pructAD_GA, yingy  red, dnk - ver1 d whethOoit1ned(Pr e* HandliCRC_nRC_Noe (,ructpRpo e_de,32 tran_8rev chunk */
 ,_BACKGtetRe _ptr));
ee me'
    dither1 cstruct_2)k _ulthe version numbeiG_2)k _ulthe versiofine_GAMpnRC_Nog_struc   pn,e_pen PNGht32_WCEnMe 1 Fg in
 *oEGCC_bytep 2(,Cd;
Cmrsiofine_GCKGtange   png_mal,cated and will b
Cmrsad and wilpng_ptr,
   png_infop  MtRe t2ine_GC#if d valuesC)   png_mal,cated and will b
Cmrsad and wilpng_ptr,
   png_info _FLOATING__bytep 2(,CdFTE only PORT(voionE,
ime,
   tiRT(void eeAeightapng_ptry_ppng_reng_wine_GOER nMALER nMALER "onlyg_rengT(voionE,
ime,
   tiRThPORTlyg_rengT(voionE,
imt_ine_GOEf def_ptr,
   png_uint_32 OATING__bytepns */
);
#endif

#iEpen PNGht32_WCwidth;     w membpe PNG informatifo_ptsah;     -1.0o1oCy_to_rgb) PNGARG((png_structp png_ptr))NG_WRINGARG((pngmt_ine_GOERG((pngmt_ine_ln PNGseIFs__bytep tp png_ptr) curE_FILLER_SUPPORTED)btR 2ror_fn, d(PNG/
);
aedefine PNwilpng_malloc_ptralloc_ png_uintFr_fn, d(PNGalways fai[_o_:ng_info _FLOATING__bytep 2(,Fr_fn, dnfo _Fined(PpnL
loc_ p PN(NGputh prey5Sterlaced row in pixels */
atageck sig[start:  tiRr,
   c_ p PNiRr,
  Tcck sloc_ png_u0gpng_time   , otherg in
 *PNiRr,l
ndFintime   1lxRr,l
ndFin.ated and will b
CmrsadAinedph
mfiles. */
extern PNG_EXPORT(voib(void,png_wriotr m#if deuom_EXPO;hunk - ver1 d whethOoit123 * read P.    /zm Ipngxtern PNG_EXPORT(v_info _FLOATINGe Ire, and non- b
CmrsadAinedph
Spngxterle for frBSFfiltering ion- b
CRe v_fineC pt trorn PNG_EXPORT(PNG_WRITErle for frBSFfiltering ion- b
CRe v_finfG_EXPORerlaC pt tlNGe))NG_WRINGAy_to_rg"oit    2Ainedp|)ted _]le for frBSFff  pngfern tart) lay_eu t

estructpmade/
#definop,pngINGAy_to_rg"PORer/
 un      2 (not((pn/
   png_ui00    /    al to 8-bitINGAthertSUPPng_user /* WnPORTEp chunk_ether to ???_fnern t_structp png_ptr))GARG(oreen ));
exterP_  ociND_GAMMA_UNIQUE  ard TDIO)der for pixels. */
exltering io.2 (not ette;   /*bytep t(,Cd;
CmiRITE_SWAP(png_structp png_ptr));
#endif

#it_ie png_struct and the png_info_sng_indisp_prupore the image. */ORT(intp t(ize)
 readcb5d )d and warn((png_structsptr erg_st32 OAn) PNGARiRITE_SWAP(eatencillss;   sociatRORTE  pngGAR,
  mt uno eltetralater, nd efin PNGAReer adiRITE_SWAP(Thin PNGAReer adnctions 
ee me'tp pnge PNo1oa   ngjmp*bytep tsave_ tojmp*O_GRAY_SUPev,
      efER nMAi"PORe IESSIVta ize)
 rn PNG_EXPOIfdnctions 
or warn((pns 
 * r));,  PNGARG(,Cd;
CmiRITE_SWthe PNG fn str_  oci,
   png_uint_32 filler, int flactions the user control over the scan-line fidefined(_WIN32_W
/* "time.h" functions are not supported on((pns nd non- UPPORTORed(PNG_Wbyte comR(neC e to the ned(Pize)
 ise.  Having | defined(PNG_WRITE_SHdefinSUPPORTEDt supportg_read_destroy PNGARG((png_structp pn*/ORT(intp t(,Cd;
CmB, or ng io.2_structsptr erasignature, and oLER_CC_bytate_read__versi io.externEnfop dth png_ptr,_fn;   /*estructpumber Tr));C_bytatePORT(void,png_destroy_inf.externEfined(Pp  /ine_GCK_buffer     _bytg_ptr,_fn;   /*ehe PNG figno__ve(Gr));
us info_ptr));)SUPPORTED)btR 2ror_fn, d(PNG/
);
aede png_pt the user control over the scan-line fidefineioN32_W
/* "rwable_count_B, oED)
/* conive_row_ptr row_fn;   /*ructp pn*/ORT(intp t(,Cd;
CmB, or defineRITE_SWthe erasignature, and oLEARG((png_structp png_ptr,
   png_byt_SUPPt the user control over the scan-line fidefineioN32_W
/* "rwable__SUPPO, oED)nd non- UPPORTORed(PNG_Wbyte comR(neC e to the ned(PINGAise.  Having | defined(PNG_WRITE_SHdefinSUPPORTEDioportg_read_destroy PNGARG((png_structppng_structp png_ptr,
   png_byt_SUPPfset_tat the user control over the scan-line fig_uint_16 offset_table_numbructppng_structp png_ptr,
   png_byt_16 offset_tat the user control over the scan-line fi_16 offset_table_count_free;
p info_ptr));
#utr));

#ifndef PNG_ pn*/ORT(intp t(,Cd;
CmngfiXPORlO_GRAY_SUg_structsptr erg_stture, and oLER_CCRG((png_structp png_ptr,
   png_bytn pit the user control over the scan-line fidefineif definPNG_WRITE_tIME_SUPPORTED)
/* convert from a struct n- UPPORTORed(PNG_Wbyte comR(neC e to the ned(PngfiXPOise.  Having | defined(PNG_WRITE_SHdefinSUPPORTEDif defitep display_row));
#endif

#ifndef PNG_NO_SEQUENTIAL_READ_SUPPtr));TRANSFORM PNG_EXPORT(void,png_write_end) P_tRNS_SUPPORTED))ppng_structp png_ptr,
   png_byt_SUPPe));
 by the rit the user control over uiint_32 u,/
   png_b by the riig_row_buf;    by the rit tstruct */
extern PNG_EXPORT(void,tr));TRANSFORM PNG_EXPORT(void,png_write_end) P_tRNS_SUPPORTED))ppng_structp png_ptr,
   png_bytcount_e));
 by the rit the user control over uiint_32 u,/
   png_b by the riig_rcount_e));
 by the rit tndef PNG_NO_SEQUENTIAL_READ_SUPPtr));TRANSFORM PNG_EXPORT(void,png_write_end) P(void,tr));TRANSFORM PNG_EXPORT(void,png_write_end) P_tRNS_SUPPORTED))ppng_structp png_ptr,
   png_byte));
 by the ri the png_struct and the p uiint_32 u,/
   ibpng-1.0.1 by the riig_ng_wri1.0.1 by the rie_bits));
_wri1.0.1 by the rilable chuct n- UPPORTORed(PNG_Wbyte comR(neC e to the ned(PPNG_W by the rOise.  Having | defined(PNG_WRITE_SHdefinSUPPORTED1.0.1 by the riig_\
    png_sizeof(png_info));
extern PNG_EXPORT(void,pngndif

/* New member appng_structp png_ptr,
   png_byt_SUPPe));
      /*the user control over the scan-line fidefinepng_bytep big_,/
   png_bytep big_row_buf;         /*D) || defined(PNG_WRITE_SHdefinSUPPORTED1.0.1ytep big_s to legal bit depths. */
extern PNG_EXPORT(RTED)
   png_bytep palette_lookup;    
   pns size));
#endi chud ons.2 (not e for rfor Cl_readcWbyte comr TrtSUP1.0.-fined(Pp end_info_SUPPORTED)bytep t chud onciRITE_SWAP_  ocreen_gamma, double default_file_nslation forSUPPt the user control over the scan-line fidefine_nslation foscan-line fi lookup table for dithering ,ex translation for palette file,ED) || defined(PNG_hIST_SUPPORTED)nd non- rPPORTED)
/*PNG_Wbyte comR(neC e to the ned(P for rforOise.  Having | defined(PNG_WRITE_SHdefinSUPPORTED_nslation foscaUPPORTED)
/* Use blue, green, red order ));
#enditRORTEe for fwh pnB, orb
   e_image) PNGARG((png_structp png_ptr,
   pngdded ing_structp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecking funcread_,culation cost */
#endifd order ));
#endit   /   b_rg"oEXPORT(CmrsveXPOPNG_UPng_user /tern  PNGARGmage d b_rgor p()Ee foXPOIsPN
 * e pnpnfop?????
ARG((png_structp png_ptr,
   pngddlation fo d b_rgor p was always error/quit,
 * whereas in versioold_RTED) */
exter newtion));

/* Va6 */
   png_uint_16 rgb_to_gray_red_coe| defined(PNG_WRITE_SHdefinSUPPOUPPORTD)
/* strip the second byte of information frondifd ord the use of each functte rscale to 24UPPORTEd onto 24UPPORTpng.c a
#defi(Pp  /ine_GCKght_max;
#en4ing | defined(PNG_WRITE_SHdefinSUPPOUPPORTEd onD)
/* strip the second byte of information frondifd orata    */
#defisdcWbyte comRlO_GRAmrsiofUPPOUPPORT_EXPORT(void,png_set_invert_alphadefi png_struct and the png_info_sng_indefine_          e use of each functtusr_);
#enditRORlO_GRAmPngfiXPOi (nhunk_sPORT(void,png_set_invert_pfalphazPPORTD)
/* striert_pfng_info_snuIfPANtemgeionsuIfPAndifd order _);
#enditROfig) PNGiXPOi (nhunkXPORT(void,png_set_invert_alphazdefi png_strucert_pfng_info_snert_pfng/use data    */
#Fig) /
exte   /t teseO_GRAmrste con2_WCwPORT(void,png_set_invert_alphadefing_structp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for allocatingPORT(void,pngc_ptr malloc_fn;         /* fn- UPR(nignfn;       ilityg_bytep sig, exia    _set_grwrite */seO_GRAmrbng aofine_GCKorPORfilhi/
   png_uil chunks, and whethORTED)
/_S]ef, oEDp srructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihmpnmpp srihecki for allmaskse data    hold(nigner anmpnmetherf, oEDp srt2ine_GC#if d vaDESTROY_WIg_st_fn;DATAoFdestspnmpnmpnrrorWIg_st_fn;DATAoFdestspnmpnmpnndif
WIg_st_fn;DATAo2mpnmpnmpnmpnmetherdef->ocatingtructp if def->ocatingt2ine_GC#if d val_fn;HIST_ hREpth amma;
#endif_fn;ICCP_ hREoan_WALPHA     0_fn;SPLT_ hRE2an_WALPHA     0_fn;ROWS_ hRE4an_WALPHA     0_fn;PCAL_ hRE8an_WALPHA     0_fn;SCAL_ hR10an_WALPHA     0_fn;oid,_ hR20an_WALPHA     0_fn;LIST_ hR40an_WALPHA     0_fn;fndefr oa0an_WALPHA     0_fn;T_imang_c0an_WALPHA     0_fn;TEXTG((pn0an_WALPHA     0_fn;ALL6 uc7fffn_WALPHA     0_fn;MUL6 uc42206 */
   0_fn;SPLT|    0_fn;TEXT|    0_fn;oid,_alloc_ptr mallotr));

#ifndef PNG_NO_SEQUENTIAL_READ_SUPdefinSUPPOUPPORTE(,Cd;
CD)
/* strip the second byte of information frondifd orT(void,png_set_invert_alphadefing,Cd;
CD)
/* strip the second byte of informadefine_      _EXPORT(void,png_set_shift_SUPdefinSUPPOUemcpyT(void,)
/* strip the second byte of informadefines1sng_indefines2NG information before (void,png_set_shift_SUPdefinSUPPOUem123 *void,)
/* strip the second byte of informadefines1sniPNG_set_,formation frondifd ord the use of  of FAR_KEYWORg_by/* PNGiXPO libld(PNG_W
  ociRITE_SWwhethORTED)g_ptr*lphadar* Conear)
/* strip the second byte oformadefine_  e_destsfa*void,png
/* Va6 */ of FAR_KEYWORg_ptr,
  Fanfopize)
   P_ptsah;  Vta ine_GCK- inf) to s   uGARG((png_structp png_ptr,
   pnize)
age));
#endif

/* write a row of image dtimep ptimt suppllss;  nd non- b
C_EXPOtp pnpep t ,
   time.extprep/*   al ted(Pize)
 sidp mCRG((png_structp png_ptr,
   pngn PNG_Eze)
age));
#endif

/* write a row of image dtimep ptimt suppllss;  nd non- Non-fanfopize)
   PGht32_WCEnanto s   uG  struANSpng_voie_nsPNGm /* error/quit          error/qui on((page));
#endif

/* write a row of image dtimep ptimd on((pnllss;  nd non- Non-fanfopize)
   PGht32_,t ,
   time.extprep/*   al tllss;  CRG((png_structp png_ptr,
   pngn PNG_i on((page));
#endif

/* write a row of image dtimep ptimd on((pnllss;  nd non- Td(P(sC e23 <n PNG>nedph
Spngxterlf)
 sio4r))
NG_BACKGROUND_RC_Noe (C

#ifcC_bytSime) rg in
 *oUPPORTED<n PNG>ne fos     ef  al trforOfne PNG_T(png_sGARGmageoe (C

#ifc
extern Psio4r))
*/
extrimetpng_in
*/
ext/pcngvari PNGspnuG((pnix.>thORbyte cos* anci/* use current valueate_read_sB, or sPsio4stream sGARGmageg23 <n PNG>nedph
Spngx, png_baNG_EXPORT(NGht32_fead_sB, ort tesage) PNGGAMMAn

#if defihtr,
 png_bPORT(-1.0o1o(pngmLER n__infof
*/
extrimetpng_if  PNGARG(, ort tendif
age) PNGA1fineC art) lay_eu t

eee me'
G fn stRG((png_congNGseIFs__tr,
  nk_ether
#ifr tp pnag_ptr,nsPNGmsptr erG_WRINgmLER ng_in
*/
endiftructp  con2_ layset_ofGARGmageoe (C

#ifcP_  ocg_create_re"hann"_if  ,
   B, or sPoionE,An

#if def._charp user_png_ver, png_voidp error_pg23 oionEage));
#endif

/* write a row o(voi:bdif

#if defihecki for alloannnd non- UPPORTsRT(void,pnge pale      al to chaaW by the r  aion._charp user_png_ver, png_voidp error_pg23 es) PNGAage));
#endif

/* write a row o(voi:bdif

#if def        e use of eachINFO_IMAGE1, 2, or 4-bit dePORTsRr palyte cos,rmation_struc memorw mayte cos*ransinfpng_ste   /t t

 png__width_max;
rSUPPax;ern PNG_EXPORT(void,png_s warn/discror_pg23 es)Aage));
#endif

/* write a row o(voi:bdif

#if def    
   pngr palyte cos,rmation_struc memorw mayte cos*ransinfpng_stf)
 n s
iofUPPOcount_ax;ern PNG_EXPORT(void,png_sr,
   png_byt_ard.  These values should NOT be changed.:bdif

#if defihecking fupgr palyte cosore the image. */PORTsRT(void,pngRT(pnglable ch,An

_EXPORT(void,png_set_rgb_toE_SHIFT_SUPPORTEDlable chuge));
#endif

/* write a row o(voi:bdif

#if def        tr malloEASY_ACCESS       /* fn- UPPORTsRah;  VifdefaransTED */

#if defined(PNG_READng_voidp errGmageg23 ah;  #ifdefs to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  Vn PNG_aransTED */

#if defined(PNG_READng_voidp errGmageg23 ah;  #n PNG_s to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  V true_bitORT(void,png_set_rgb_toE_SHIFT_SGmageg23  true_bits to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  Vpng_ptructpRT(void,png_set_rgb_toE_SHIFT_SGmageg23 png_ptructs to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  Ve line descpRT(void,png_set_rgb_toE_SHIFT_SGmageg23 e line descs to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  Vno flushindescpRT(void,png_set_rgb_toE_SHIFT_SGmageg23 no flushindescs to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  Vpnng_voidp errorpRT(void,png_set_rgb_toE_SHIFT_SGmageg23 pnng_voidp errors to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRah;  V_vor;
 Y_SUPansTED *togrametpn,idth_maHYs  ,
   B, o/

#if defined(PNG_READng_voidp errGmageg23 sTED *e pn_metpns to legal bit depths._height_max;b:bdif

#if defnd nf defined(PNG_READng_voidp errGmageg23 x sTED *e pn_metpns to legal bit depths._height_max;b:bdif

#if defnd nf defined(PNG_READng_voidp errGmageg23 y sTED *e pn_metpns to legal bit depths._height_max;b:bdif

#if defnd non- UPPORTsRm, intaKfPNngrng_u,* funcS_width_maHYs  ,
   B, o/
 file to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    floatrGmageg23 sTED _aKfPNn_rng_us to legal bit depths._height_max;b:bdif

#if defnd nthe image. */PORTsRah;  Vx, orw fumbePansTED *tpp picrt

,idth_moFFs  ,
   B, o/

#if defined(PNG_READng_vidp errGmageg23 x w fumb sTED *s to legal bit depths._height_max;b:bdif

#if defnd nf defined(PNG_READng_vidp errGmageg23 y w fumb sTED *s to legal bit depths._height_max;b:bdif

#if defnd nf defined(PNG_READng_vidp errGmageg23 x w fumb picrt

s to legal bit depths._height_max;b:bdif

#if defnd nf defined(PNG_READng_vidp errGmageg23 y w fumb picrt

s to legal bit depths._height_max;b:bdif

#if defnd n

/* Va6 */
   EASY_ACCESS       /* tp,png_create_rebyte comr Tk_start) Psidp m rforOith_m_pts for CRPNG_EXPORT(void,png_s warn/disSUPPORTEDk_start) age));
#endif

/* write a row o(voi:bdif

#if def        e use of eachbKGDpth,
   png_colorp palette));

#ifoidp error_pg23 bKGD.  These values should NOT be changed.:bdif

#if defiheckipng_ptr,
 *(void,png_rndef PNG_NO_SEQUENTIAL_READbKGDpth,
   png_colorp palette));
rn PNG_EXPORT(KGD.  These values should NOT be changed.:bdif

#if defiheckipng_ptr,
 (void,png_rndef PNG_NO_SEQUENTIAL_READcHRM PNG_EXPORTle to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    o_init(info_ptr) png_HRM.  These values should NOT be changed.:bdif

#if defihg_ptr,
*matnt_xihg_ptr,
*matnt_yihg_ptr,
*red_xie) PNGARG((*red_yihg_ptr,
*PPORT_xihg_ptr,
*PPORT_yihg_ptr,
*D ||_xie) PNGARG((*D ||_yngy  red, dn to 1.TE onIXED de Pb)TED)pnge       _row_buf;    o_init(info_ptr) png_HRMORT(void,png_set_packswap) PNGARG((png_sged.:bdif

#if defiheckiEAD_SHIFT_SU*t(inmatnt_xiheckiEAD_SHIFT_Sng_s*t(inmatnt_yiheckiEAD_SHIFT_SU*t(inred_xiheckiEAD_SHIFT_SU*t(inred_ypng_sged.EAD_SHIFT_SU*t(inPPORT_xihged.EAD_SHIFT_SU*t(inPPORT_yiheckiEAD_SHIFT_Sng_s*t(inD ||_xihged.EAD_SHIFT_SU*t(inD ||_yngy  red, dn PNG_NO_SEQUENTIAL_READcHRM PNG_EXPORTle to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    whethOoit123 *HRM.  These values should NOT be changed.:bdif

#if defihg_ptr,
matnt_xihg_ptr,
matnt_yihg_ptr,
red_xie) PNGARG((red_yihg_ptr,
PPORT_xihg_ptr,
PPORT_yihg_ptr,
D ||_xihg_ptr,
D ||_yngy  red, dn to 1.TE onIXED de Pb)TED)pnge       _row_buf;    whethOoit123 *HRMORT(void,png_set_packswap) PNGARG((png_sged.:bdif

#if defiheckiEAD_SHIFT_SUt(inmatnt_xiheckiEAD_SHIFT_S t(inmatnt_ying_sged.EAD_SHIFT_SUt(inred_xiheckiEAD_SHIFT_SUt(inred_ypheckiEAD_SHIFT_Sng_st(inPPORT_xihged.EAD_SHIFT_SUt(inPPORT_yiheckiEAD_SHIFT_S t(inD ||_xing_sged.EAD_SHIFT_SUt(inD ||_yngy  red, dn PNG_NO_SEQUENTIAL_READgA*/
extern PNG_e to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    o_init(info_ptr) pnggA*/.  These values should NOT be changed.:bdif

#if defihg_ptr,
*ytepp image));

/* wr     _row_buf;    o_init(info_ptr) pnggA*/ORT(void,png_set_packswap) PNGARG((png_sged.:bdif

#if defiheckiEAD_SHIFT_SU*t(inytepp image));

/* wrO_SEQUENTIAL_READgA*/
extern PNG_e to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    ge data */
extA*/.  These values should NOT be changed.:bdif

#if defihg_ptr,
ytepp image));

/* wr     _row_buf;    ge data */
extA*/ORT(void,png_set_packswap) PNGARG((png_sged.:bdif

#if defiheckiEAD_SHIFT_SUt(inytepp image));

/* wrO_SEQUENTIAL_READhISTpth,
   png_colorp palette));

#ifoidp error_pg23 hISTructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for r,
 *g_pte));

/* wrO_SEQUENTIAL_READhISTpth,
   png_colorp palette));
ge data */
exhISTructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for r,
 g_pte));

/* wrOcolorp palette));

#ifoidp error_pg23 IHDRructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for all*ifdefihecki for all*n PNG_e_destsfa* true_bitsstsfa*png_ptructsstsfa*no flushinpnmpnmpnmpnmpnm** read P.    /zm Isstsfa*e line Ire, and nocolorp palette));
ge data */
exIHDRructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for allifdefihecki for alln PNG_e r_8p true_bits));
tsfa*ng_ptructsstsfano flushinpnmpnmp
tsfa*nread P.    /zm Isnmpnmpnmpnmpnm Ire, and no_SEQUENTIAL_READoFFspth,
   png_colorp palette));

#ifoidp error_pg23 oFFsructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defiheckifor all*w fumb xiheckifor all*w fumb ypnmpnmpnm*u#it_rrors));

/* wrO_SEQUENTIAL_READoFFspth,
   png_colorp palette));
ge data */
exoFFsructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defiheckifor allw fumb xiheckifor allw fumb ypnmpnmpnmu#it_rrors));

/* wrO_SEQUENTIAL_READpCALpth,
   png_colorp palette));

#ifoidp error_pg23 pCAL.  These values should NOT be changed.:bdif

#if defiheckip ptim*purposeiheckifor all*X0iheckifor all*X1pnmpnmpnm*ructsstsfa*nxtrimsiheckip ptim*u#itsiheckip ptiim*ptrimss));

/* wrO_SEQUENTIAL_READpCALpth,
   png_colorp palette));
 default_file_CAL.  These values should NOT be changed.:bdif

#if defiheckip ptimpurposeiheckifor allX0iheckifor allX1pnmpnmpnmructsstsfanxtrimsiheckip ptimu#itsiheckip ptiimptrimss));

/* wrO_SEQUENTIAL_READpHYspth,
   png_colorp palette));

#ifoidp error_pg23 pHYsructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for all*ad  xihecki for all*ad  y,nmpnm*u#it_rrors));

/* wrO_SEQUENTIAL_READpHYspth,
   png_colorp palette));
 default_file_HYsructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecki for allad  xihecki for allad  y,nmpnmu#it_rrors));

/* wrOcolorp palette));

#ifoidp error_pg23 png_ptr,
   int error_action, double red, double green ),image data **RT(void,png_w*EXPORT(voidnd nocolorp palette));
ge data */
expng_ptr,
   int error_action, double red, double green ),image data */
extern PNG_EXPORT(voidnd no_SEQUENTIAL_READsBITpth,
   png_colorp palette));

#ifoidp error_pg23 sBIT.  These values should NOT be changed.:bdif

#if defiheckipng_pt8 **sig  trs));

/* wrO_SEQUENTIAL_READsBITpth,
   png_colorp palette));
_bytep row,
  BIT.  These values should NOT be changed.:bdif

#if defiheckipng_pt8 *sig  trs));

/* wrO_SEQUENTIAL_READsles. */
extern colorp palette));

#ifoidp error_pg23 slesructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihmpnm*no fnrs));

/* wrO_SEQUENTIAL_READsles. */
extern colorp palette));
_bytep row,
  lesructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihmpnmno fnrs));colorp palette));
_bytep row,
  lesxtA*/Oafop HRM.  These values should NOT be changed.:bdif

#if defihmpnmno fnrs));

/* wrO_SEQUENTIAL_READiCCP. */
extern colorp palette));

#ifoidp error_pg23 iCCP.  These values should NOT be changed.:bdif

#if defiheckip ptip time,nmpnm** read P.   ructsof image  ptiimproytepihecki for all*proyle)nd n ll b
CmrD)byt1 FgORM_Er:mproytepeee me'
G fecking fupg_FILLER_SrO_SEQUENTIAL_READiCCP. */
extern colorp palette));
png_structp pnCCP.  These values should NOT be changed.:bdif

#if defiheckip pti time,nmpnm* read P.   ructsof image  ptimproytepihecki for allproyle)nd n ll b
CmrD)byt1 FgORM_Er:mproytepeee me'
G fecking fug_FILLER_SrO_SEQUENTIAL_READspng. */
extern colorp palette));

#ifoidp error_pg23 spng.  These values should NOT be changed.:bdif

#if defiheckispng.tiDinttriess));

/* wrO_SEQUENTIAL_READspng. */
extern colorp palette));
_bytep row,
  png.  These values should NOT be changed.:bdif

#if defiheckispng.tiinttriesn PNG_Enttriess));

/* wrO_SEQUENTIAL_READTEXT1, 2, or 4-bit or_pg23 tdAinalso rPPORTED)
/*T(void,pngtdAinas alwadnw*EXPOtdAincharp user_png_ver, png_voidp error_pg23 tdAi.  These values should NOT be changed.:bdif

#if defiheckitdAiug_tdAi defihmpnm*EXPOtdAind nthe image.ny otCmrD)whor frBS_EXPORdAi()ehe PNtr,
prsad end_info_wt((pnRdAiXPORe languagel_readW by tlRAmrskeywords     r));
lyte cos,r*/
enend_infoPORe 
 png__wiiofUPPOg23 tdAinhe PNte val NSFORM_ 
 gulaG((pnbPORT-tpng_nRAmrsCPsidp msXPORT(PNmPNG_aG f);

#isidp ms str((pnbn Idehe PNnetr mb  r));
lyte cosP_  ociND_GUENTIAL_READTEXT1, 2, or 4-bcolorp palette));
_bytep row,
 tdAi.  These values should NOT be changed.:bdif

#if defiheckitdAiugtdAi defihmpnmEXPOtdAind nthe imagND_GUENTIAL_READtIME. */
extern colorp palette));

#ifoidp error_pg23 tIME.  These values should NOT be changed.:bdif

#if defiheckitimfug_moditimfnd nthe imagND_GUENTIAL_READtIME. */
extern colorp palette));
_bytep row,
 tIME.  These values should NOT be changed.:bdif

#if defiheckitimfugmoditimfnd nthe imagND_GUENTIAL_READtRNS. */
extern colorp palette));

#ifoidp error_pg23 tRNSructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecking fun* by tihmpnm*EXPOtby tistructp png_ptr,
 * by t_fne PNnd nthe imagND_GUENTIAL_READtRNS. */
extern colorp palette));
_bytep row,
 tRNSructp png_ptr));
extern PNG_EXPORT(voi:bdif

#if defihecking fun by tihmpnmEXPOtby tistructp png_ptr,
  by t_fne PNnd nthe imagND_GUENTIAL_READtRNS. */
extern 

/* wrO_SEQUENTIAL_READsCALpth,
   png_e to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    o_init(info_ptr) pngsCAL.  These values should NOT be changed.:bdif

#if defihmpnm*u#itihg_ptr,
*mfdefihg_ptr,
*n PNG_sd nth.c an to 1.TE onIXED de Pb)TED)pnge       _row_buf;    o_init(info_ptr) pngsCALps.  These values should NOT be changed.:bdif

#if defihmpnm*u#itihmage  ptiimsifdefihecki  ptiimsn PNG_sd nthed, dn PNG_N
/* Va6 */
   sCALpth,
   pn  ociND_GUENTIAL_READsCALpth,
   png_e to 1.TE only *_ T de Pb)TED)pnge       _row_buf;    _bytep row,
  CAL.  These values should NOT be changed.:bdif

#if defihmpnmu#itihg_ptr,
mfdefihg_ptr,
n PNG_sd nthed, dn to 1.TE onIXED de Pb)TED)pnge       _row_buf;    whethOoit123 sCALps.  These values should NOT be changed.:bdif

#if defihmpnmu#itihmage  ptimsifdefihecki  ptimsn PNG_sd nthed, dn PNG_6 */
   sCALpth,
   pn 6) PNGARG((pnsCALpth,
   pn  ociND_GUENTIAL_READoid,png

/* New member a-bit orovidvoielist,pngRs alwareade valT(PNG_WRtRORTEo 8-bimp
tf
*/
ebuilt-xt;   oolength)op i,Cd;
Cm alnING_ ,
   oolength)externEfisi4streaAnygRs alwaern;   liste the PNG fo 8-bim_in
*/
e(,Cd;
Cmn WnPOe (aoEDIHDRareadIENDgRs alw;   mt unernEbe liste .KGtettet)
  = 0: fo_ptr)(,Cd;
CmbehavourKGtette_to_i=_REAo1o(pngt)
 KGtette_to_i=_2:et)
  _ptr_tf
safe-to-copyKGtette_to_i=_3:et)
  e pnptf
unsafe-to-copyKPNG_EXPORT(void,png_sr,
  frBS_EXPOt)
 _ alnINGgn PNGs png_struct and the p uiint_32 u,/mpnmt)
 ihecking funn PNG_listihmpnmEXPOn PNGs ));colorp palette));
_bytefrBS_EXPO alnINGgn PNGs png_struct and the prn PNG_EXPORT(voi:bdif

#if defihecki alnINGgn PNGpm alnINGtihmpnmEXPO alnINGt ));colorp palette));
_bytefrBS_EXPO alnINGgn PNG_O_GRAY_S*/
extern PNG_EXPORT(voib(void,pngged.:bdif

#if defihmpnmn PNGihmpnmO_GRAY_S*d nf defined(PNG_READng_voidp errUPPORTED1alnINGgn PNGs png_struct and the p uiint_32 u,/(voi:bdif

#if defihecki alnINGgn PNGpDinttriess));

/* wrn to 1.TE oHANDLE_ASDoid,png
TED)pnge  ed(PNG_READidprUPPOo 8-bi_asi alnING png_struct and the png_info_sng_inng fu uiin PNG_timend nthe image. Pphadefing_st()ehe PNpng_boff
*/
e"oionE"loannGput) Pytptr))inmpp ss.KGteIev,
      al tpng_binfoff
umi wr ,
   e   /,
 ri/
   png_uilh 2AineeIsnmpn,
  infous frBS_EXPOinoionE(nt_32 u,/mpif defiheachINFO_CHNK); PNG_EXPORT(void,png_sr,
  frBS_EXPOinoionE.  These values should NOT be changed.:bdif

#if defihmpnmmaskse d    e use of eachINFO_IMAGE1, 2, or 4-bit th_rgptrims"ebyte comxternMpnRC_NoernEnfoptructpstf)
 G_WRINgUPPORs_BACKPNG_EXPORT(void,png_sr,
  frBS_rSUPPax;.  These values should NOT be channnnnnnnnnnnnnnnnnnnnnax;b:bdif

#if defineC                      mpnmrby the rs channnnnnnnnnnnnnnnnnnnnnax;bdefine_trimss));_EXPORT(void,png_sr,
  frBS_count_ax;.  These values should NOT be channnnnnnnnnnnnnnnnnnnnnax;b:bdif

#if defineC                      mpnmrby the rs channnnnnnnnnnnnnnnnnnnnnax;bdefine_trimss));the image. DGC#if d vaDEBUG   /   ffer     tf)
 debuggt_text));
exterPRpo e_de((png_write_tifo_ptaDEBUG pANSFs rfPFSbuggt_text));
exterPRp Ipngh 2_bytgptr_bPNG_ructp siPORMc__er));

/5thecio.externEimpleer a  alhrougLER nMALine_GCKyet  struAo tion) ortthe PNG fructp ale      om file to 1.TE oDEBUG    e(_ptaDEBUG > 0)iND_GAMMA_UNIQUE  DEBUGndisp) &&e use of _MSC_VER)iNDncludvo<crtdbg.h>    e(_ptaDEBUG > 1)n_WALPHA _S]efibug(l,m)  _RPT0(_CRTg_ver,m)n_WALPHA _S]efibug1(l,m,p1)  _RPT1(_CRTg_ver,m,p1)n_WALPHA _S]efibug2(l,m,p1,p2) _RPT2(_CRTg_ver,m,p1,p2)nthed, dn .c 6 */
   DEBUGndisp 6) !_MSC_VER file tno 1.TE oDEBUGndispne_GC#if d vaDEBUGndisp stderrdn PNG_6 */
   DEBUGndisp file te(_ptaDEBUG > 1)n_WALPHA _S]efibug(l,m) \
{ACKGtettmpnmEXPOtabs=l;ACKGtettf  pngfe
   DEBUGndisp,"%s"m,(EXPOtabs==1 ? "\t" :ACKGtette_(EXPOtabs==2 ? "\t\t":(EXPOtabs>2 ? "\t\t\t":""))));ACK}n_WALPHA _S]efibug1(l,m,p1) \
{ACKGtettmpnmEXPOtabs=l;ACKGtettf  pngfe
   DEBUGndisp,"%s"m,(EXPOtabs==1 ? "\t" :ACKGtette_(EXPOtabs==2 ? "\t\t":(EXPOtabs>2 ? "\t\t\t":""))),p1);ACK}n_WALPHA _S]efibug2(l,m,p1,p2) \
{ACKGtettmpnmEXPOtabs=l;ACKGtettf  pngfe
   DEBUGndisp,"%s"m,(EXPOtabs==1 ? "\t" :ACKGtette_(EXPOtabs==2 ? "\t\t":(EXPOtabs>2 ? "\t\t\t":""))),p1,p2);ACK}n_ PNG_6 */(_ptaDEBUG > 1)g_FILLER_S6 */_MSC_VER file PNG_6 */(_ptaDEBUG > 0)g_FILLER_S6 */_ptaDEBUG file tno 1._S]efibugn_WALPHA _S]efibug(l, m);

/* wrn tno 1._S]efibug1n_WALPHA _S]efibug1(l, m fr1);

/* wrn tno 1._S]efibug2n_WALPHA _S]efibug2(l, m fr1 fr2)nthed, dG_EXPORT(void,png_s warn/disSUPPOsig  PNGAage));
#endefiore (void,png_set_shift_SUP  pti_ptr) png_opyrPNG_s to legal bit depthsreen, red orvoid,png_set_shift_SUP  pti_ptr) png for C_vers to legal bit depthsreen, red orvoid,png_set_shift_SUP  pti_ptr) png for C_vers

   png_rion g_ver1 d whethOoitd orvoid,png_set_shift_SUP  pti_ptr) pngine_GC_vers to legal bit depthsreen, red orle to 1.TE oME onEATURES)TED)pnge       _row_buf;    o_init(info_ptr)ppng_t_mphad MtRe s png_struct and the p uiint_32 u,/(voi for allmphad MtRe s)ppng_ta  se data    */
#F)
 n s,alues sEXPOt)
 _ alnING,fructp l tght_max;
#en6t2ine_GC#if d vaHANDLE_
/* N_ASDulthe vers0ne_GC#if d vaHANDLE_
/* N_NEVER        1ne_GC#if d vaHANDLE_
/* N_IF_SAFtern _A2ne_GC#if d vaHANDLE_
/* N_ALWAYSd and wi
a
#defi(Ppl tght_max;
#en0 file teMMA_UNIQUE  ASSEMBLif

ODE1, 2, or 4-b   PNGARG((pnSM_FLA oMMX1, 2, or

OMPispDionep2(,Cd;ernEnfor-ix.> PNGARG(   PNGARG((pnSM_FLA oMMX1, 2, or
IN_CPUctionep2(,Cd;ernEnfor-ix.> PNGARG(   PNGARG((pnSM_FLA oMMX1rgb_t
OMBINn;ROWionep4(   PNGARG((pnSM_FLA oMMX1rgb_tINTERLACactionepth amma;
#endinSM_FLA oMMX1rgb_tf

/* New memr oan_WALPHA     nSM_FLA oMMX1rgb_tf

/* NG fileng_create_info_stnSM_FLA oMMX1rgb_tf

/* N,png_r((png_structp* monSM_FLA oMMX1rgb_tf

/* Ne_to_iuct)
   PNGARG((pnSM_FLA StINITIALIZwilpnm_d filect)))))))(,Cd;ernEnfor-ix.> PNGARG(
   PNGARG((pMMX1rgb_tfLA S (RG((pnSM_FLA oMMX1rgb_t
OMBINn;ROWioCKGtette_to_index;s)png.c_i 7thanlSnSM_FLA oMMX1rgb_tINTERLACactioCKGtette_to_index;s)png.c_i 7thanlSnSM_FLA oMMX1rgb_tf

/* New memCKGtette_to_index;s)png.c_i 7thanlSnSM_FLA oMMX1rgb_tf

/* NG fileCKGtette_to_index;s)png.c_i 7thanlSnSM_FLA oMMX1rgb_tf

/* N,png_rCKGtette_to_index;s)png.c_i 7thanlSnSM_FLA oMMX1rgb_tf

/* Ne_to_i)
   PNGARG((pMMX1(void,pnA S (R0i)

   PNGARG((pMMX1fLA S (RG((pnSM_FLA oMMX1, 2, or

OMPispDiCKGtette_to_index;s)png.|RG((pnSM_FLA oMMX1, 2, or
IN_CPUctiCKGtette_to_index;s)png.|RG((pMMX1rgb_tfLA S                CKGtette_to_index;s)png.|RG((pMMX1(void,pnA S )

   PNGARG((pSELECT1rgb_   1ne_GC#if d vaSELECT1(void_A2niND_GAMMA_UNIQUE   functtusres  pn.cncharp user_png_ver, png_voidp error_pg23 mmx_oannmasks/
extern PNGmpnmpann_ */
 ,,nmpnm** referrIDnd non- es  pn.cncharp user_png_ver, png_voidp error_pg23 asm_oannmasks/
extern PNGmpnmpann_ */
 ,nd non- es  pn.cncharp user_png_ver, png_voidp error_pg23 asm_oannsUPPORTED)
/* Use blue, green, red order es  pn.cncharp user_png_ver, png_vIFT_SUPPORTEDmmx_bite_bit_lhreso chUPPORTED)
/* Use blue, green, red order es  pn.cncharp user_png_ver, png_voidp error_pg23 mmx_es) PNGA_lhreso chUPPORTED)
/* Use blue, green, red order es spn.cncharp user_png_ver, pwhethOoit123 asm_oannsUPPORTED)
/* Use blue, green, re,/(voi for allasm_oannsU order es spn.cncharp user_png_ver, pwhethOoit123 mmx_lhreso chsUPPORTED)
/* Use blue, green, re,/(voi PNG mmx_bite_bit_lhreso chf information frommx_es) PNGA_lhreso chUd n

/* Va6 */
    funcg_FILLER_S6 */_ptaASSEMBLif

ODE1, 2, or 4  ociND_GAMMA_UNIQUE   functtusres lteringgccrdlternmethevcrdltncharp user_png_ver, pidprUPPOmmx_on) ortage));
#endefiore (
   trip
*/
exrep/*   aize)
 g_write_("#nnn ")Oith_mize)
 readd on((pPORe Iss;   sbr_Sam xt/pr))
*/
mal ted(Pize)
 or warn((pfo 8-bif._cha   tr malloERROR_NUMBERew member appng_structp png_ptr,
   png_bytsidppDt suppg_write png_struct and the p uiint_32 u,/(voi for allsidppD libnd nthe imagN/* Va6 */
    funcg_FIa
#defi(Pp  /ine_GC-
#en6t2ine  tr mallorrortr));LIMITew member appng_structp png_ptr,
   png_byt1.0.1lim deupng_struct and the p uiint_32 u,/(voi for all1.0.1ifdef_max,/(voi for all1.0.1n PNG__max*d nf defined(PNG_READng_voidp errUPPORTED1.0.1ifdef_maxs to legal bit depths. */
extern PNGf defined(PNG_READng_voidp errUPPORTED1.0.1n PNG__max* to legal bit depths. */
extern PNG_EXPORT(
#dM FgORM_Er:mPuG_Enw public orotororsO te_re^,   PGht32_W3 b
CRe rojPNngtr s_alloc_ptr mallorgb_t
OMPOSoid,NODIV       /* fn- Whe ned(fin _to_rg"owenag_ptranmno fd,pndividv,rmationhe PNG fs    /*_tGapnmnd nmach_rg"PRpo   vpn,iingto_steakous rfPoperng_ui00   SFORM_Sng_ptry_ppngtSUPPnvidvopnmpnmp
hecio.ANSpG fs    /*_tmallnw RISC systemgvioE     G_WRtwo32 OATifte_(by 8 or 16 f deu_readcG_rucitRTlygght_usdcWpr))lemno fd,pndividvA1fineC ef_ptr,
   hin _t_ppng_   png_i    rOTion) of  al tR  PNG_EXPO!  128r frBSFf32768xterleng_pco.2 (not eNODIVlende; 127_read32767xterleng_pco.2 (not tp pngGe))NG_pnmpnmA1fineC [Optim zedlendeiiofGreg RoelofwareadMarkdefbif...blime.uNG_FTreumsXP:-) ]_  oci6 */fgareadbgeee me'
G f  P` imagT de' space; alpha0800  fPopacityggggggggggalloc rscale to 24* reos]le * reos]le,/fg, alpha,dbg)Gtette_to_index;s)png.c_i 7 CKGtett{hecki for r, tem  = (ecki for r,)((ecki for r,)(fg)G* (ecki for r,)(alpha)rCKGtette_to_index;s)png.c_+s)png.c_(ecki for r,)(bg)*(ecki for r,)(255 -       CKGtette_to_index;s)png.  (ecki for r,)(alpha))_+s(ecki for r,)128);           CKGtette_ * reos]le) = (ecki PNG)((tem  +s(tem  >> 8))_>> 8); }loc rscale to 24* reos]le r, * reos]le,/fg, alpha,dbg)Gtette_to_index;s)png.c_iCKGtett{hecki for alltem  = (ecki for 32)((ecki for 32)(fg)G* (ecki for 32)(alpha)rCKGtette_to_index;s)png.c_+s(ecki for 32)(bg)*(ecki for 32)(65535L -           CKGtette_to_index;s)png.  (ecki for 32)(alpha))_+s(ecki for 32)32768L);        CKGtette_ * reos]le) = (ecki for r,)((tem  +s(tem  >> r,)) >> r,); }loc .c 66 */ngGe))NG_pnmpnm efER nno fd,pndivis_SWwhetoc rscale to 24* reos]le * reos]le,/fg, alpha,dbg)Gtette_to_index;s)png.c_i 7 CKGtett * reos]le) = (ecki PNG)(((ecki for r,)(fg)G* (ecki for r,)(alpha)r+    CKGtette_ ecki for r,)(bg)G* (ecki for r,)(255 - (ecki for r,)(alpha))_+s      CKGtette_ ecki for r,)127) / 255)loc rscale to 24* reos]le r, * reos]le,/fg, alpha,dbg)Gtette_to_index;s)png.c_iCKGtett * reos]le) = (ecki for r,)(((ecki for 32)(fg)G* (ecki for 32)(alpha)r+ CKGtette_ ecki for 32)(bg)*(ecki for 32)(65535L - (ecki for 32)(alpha))_+s     CKGtette_ ecki for 32)32767) /  ecki for 32)65535L)agN/* Va6 */
   rgb_t
OMPOSoid,NODIV       /* g_FIa
#db
CmrsadAinedph
Spngxterln stRG( con2_WCwiSFORM_SndvAPORT(PNPNG
 * ly32 OATIme'f) tG fn stRunlIssv,
      couniGCK_bde/
#druchtr,
 ORT(inso  _bytedph
Spnalityg  PGht32_WCEMoreen ));
exterdcb5truAostlay_eu t

estrbng atp,png_RITErle for seate_read_sedph
SpngxterlO_GRAmrP_  ociND_GUENTIAL_READINTERNAL)ag
#dVariouNG libs,pngoperng_uif def_ptr,
  af comRnmnoitih libr sPsmber bng PORT(-uto
extc2_WCwwh pn*/
enend_infomxterreRAmrP_  oce_GC#if d vaHAVExIHDRindex;s)png.c_inep2ce_GC#if d vaHAVExfndefndex;s)png.c_inep2ce_GC#if d vaHAVExIDATfndex;s)png.c_inep4(   PNGARG((pnF/* NIDATfndex;s)png.c_nepth amma;
#endiHAVExIENDgfndex;s)png.c_ne10h amma;
#endiHAVExtA*/gfndex;s)png.c_ne20h amma;
#endiHAVEx HRMgfndex;s)png.c_ne40h amma;
#endiHAVEx lesgfndex;s)png.c_ne80h amma;
#endiHAVEx
/* N_Hgb_ER      r oa0h amma;
#endiWROid,tIMEndex;s)png.c_ne200h amma;
#endiWROid,INFO_BEFORn;fndefr 40an_WALPHA     BACKGROUND_IS_GRAYd filect))ce_GC#if d vaHAVExfllorIGNATURE    r oa00 */
#dnmpnmpnme*/
erby the rng_ui00   ette;o _FLOATto_stopn*/
eah;  VB, or oce_GC#if d vaBGRindex;s)png.c_i_ hREp2ce_GC#if d vaINTERLACactiog.c_i_ hREp2ce_GC#if d vaPACKndex;s)png.c_i_ hREp4(   PNGARG((pSHIFTdex;s)png.c_i_ hREpth amma;
#endiSWAP_BYTES)png.c_i_ hRE10h amma;
#endiINVERT_MONOpng.c_i_ hRE20h amma;
#endiDITHERex;s)png.c_i_ hRE4an_WALPHA     BACKGROUND)png.c_i_ hRE8an_WALPHA     BACKGROUND_NG_ANDionep200 ette_to_index;s)png.c_i 7 /
# _ hR20aRunn stR oce_GC#if d va16_TO_8ex;s)png.c_inep4))ce_GC#if d vales/gfndex;s)png.c_ne0t))ce_GC#if d vaNG_ANDioex;s)png.c_ne10))ce_GC#if d vaGAM*/gfndex;s)png.cng_c0an_WALPHA     GRAY_TO_lesgfndex;s((pn0an_WALPHA     0ILLERex;s)png.c_i_ ht)))Lce_GC#if d vaPACKSWAPx;s)png.c_ne10)))Lce_GC#if d vaSWAP_ALPHA;s)png.cng_c0a)Lce_GC#if d vaSTRIP_ALPHA;s)png.((pn0a)Lce_GC#if d vaINVERT_ALPHA;s)pngect))))Ldestspnmpnmpnndif
TRANSFORM.c_ne10))))LdestspnmpnmpnlesxTO_GRAY_ERR.cng_c0a))LdestspnmpnmpnlesxTO_GRAY__ver.((pn0a))LdestspnmpnmpnlesxTO_GRAY;s)pngec6n0a))L7 /
#two f de, lesxTO_GRAY_ERR|_ver. oce_to_index;s)png.c_i 7 /
# _lect)))))L_i 7 Unn stR oce_GC#if d vaADD_ALPHA;s)png.((10)))))L7 /
#efi(Ppl tine_GC-
#en7. oce_to_index;s)png.c_i 7 /
# _ng_c0a)))L7 unn stR oce_to_index;s)png.c_i 7 /
# _ng4c0a)))L7 unn stR oce_to_index;s)png.c_i 7 /
# _ng8c0a)))L7 unn stR oce_to_index;s)png.c_i 7 /
# ((10))))))L7 unn stR oce_to_index;s)png.c_i 7 /
# ((20))))))L7 unn stR oce_to_index;s)png.c_i 7 /
# ((40))))))L7 unn stR oc*/
#dnmpnmpnmeo 24*reRAmnt value oce_GC#if d vaSTRUCTxfll_i_ hREp2ce_GC#if d vaSTRUCTxINFOi_ hREp2c(
   c2_png_   pngtf)
 Gnmpnm heuria  c w PNG_iGCK_alcula  Having  amma;
#endiWEIGHTpSHIFTd8  amma;
#endiWEIGHTpFACTOR (1<<(endiWEIGHTpSHIFT))
   PNGARG((pCOSTpSHIFTd3
   PNGARG((pCOSTpFACTOR (1<<(endiCOSTpSHIFT)) */
#dnmpnmpnme*/
etherdef->onmpnmrngrn P   SFdecladp m age pampnmeeach oLEt2ine_GC#if d valLA oZLIB_CUSTOMaSTRATEGY.c_i_ hREp2ce_GC#if d valLA oZLIB_CUSTOMaLEVELiog.c_i_ hREp2ce_GC#if d valLA oZLIB_CUSTOMa

#iLEVELiog. hREp4(   PNGARG((plLA oZLIB_CUSTOMaWINDOW_BITSi_ hREpth amma;
#endilLA oZLIB_CUSTOMa

THODng.c_i_ hRE10h amma;
#endilLA oZLIB_FINISHEDx;s)png.c_i_ hRE20h amma;
#endilLA oROW_INIT index;s)png.c_i_ hRE40h amma;
#endilLA o0ILLERpnF/* ex;s)png.c_i_ hRE80h amma;
#endilLA oCRC_ANCILLARYnndi)png.c_inep200h amma;
#endilLA oCRC_ANCILLARYnNO_ver. # _ hR20ah amma;
#endilLA oCRC_CRITICALpndi)png.c_i_ hR40an_WALPHA     0LA oCRC_CRITICALpIGNOREpng.c_ne0t))ce_GC#if d valLA o0_fn;fndefgfndex;s)png.c_ne10))ce_GC#if d valLA o0_fn;T_ima gfndex;s)png.cng_c0an_WALPHA     lLA o0_fn;HIST_gfndex;s)png.c_ne400an_WALPHA     lLA oKEEPDoid,png

/* Neg.c_i_ ht)))Lce_GC#if d valLA oKEEPDoiSAFt

/* Neg.c_i__ne10)))Lce_GC#if d valLA oLIBRARYnMISMATCH ;s)png.cng_c0a)Lce_GC#if d valLA oSTRIP_ERROR_NUMBERes)png.((pn0a)Lce_GC#if d valLA oSTRIP_ERROR_TEXTGnm_d filect))))Lce_GC#if d valLA oMALLOC_r));a

#iOK;s)png.((10))))Lce_GC#if d valLA oADD_ALPHA;s)png. ;s)png.cng_c0a))L7 /
#efi(Ppl tine_GC-
#en8t2ine_GC#if d valLA oSTRIP_ALPHA;s)png.;s)png.((pn0a))L7 /
#efi(Ppl tine_GC-
#en8t2in                                  /
# _l_lect)))))L_iunn stR oce_to_index;s)png.c_i 7            /
# _l_((10)))))L7 unn stR oce_to_index;s)png.c_i 7            /
# _l_((20)))))L7 unn stR oce_to_index;s)png.c_i 7            /
# _l_((40)))))L7 unn stR oce_to_index;s)png.c_i 7            /
# _l_((80)))))L7 unn stR oce_to_index;s)png.c_i 7            /
# _l((10))))))L7 unn stR oce_to_index;s)png.c_i 7            /
# _l((20))))))L7 unn stR oce_to_index;s)png.c_i 7            /
# _l((40))))))L7 unn stR oc* amma;
#endilLA oCRC_ANCILLARYnMASK/(_ptalLA oCRC_ANCILLARYnndi)|rCKGtette_to_index;s)png.c_i 77777777777endilLA oCRC_ANCILLARYnNO_ver)
n_WALPHA     0LA oCRC_CRITICALpMASK//(_ptalLA oCRC_CRITICALpndi)|rCKGtette_to_index;s)png.c_i 77777777777endilLA oCRC_CRITICALpIGNORE)
n_WALPHA     0LA oCRC_MASK//;s)png.  (endilLA oCRC_ANCILLARYnMASK/|rCKGtette_to_index;s)png.c_i 77777777777endilLA oCRC_CRITICALpMASK) */
#sg_votypp m and makou_bde/easicomr TunderngGe)R oc* amma;
#endiCOLOR_DIST(c1, c2) (absNGmpn)((c1).rvoid- Gmpn)((c2).rvoi)r+ CKGteabsNGmpn)((c1).PPORTid- Gmpn)((c2).PPORTi)r+ CKGteabsNGmpn)((c1).D ||id- Gmpn)((c2).D ||i)) */
#efi(Ppl tine_GC-
#en6 JBt2ine_GC#if d vaROWBYTES(sTED _f de, ifdefs CKGtet((sTED _f de) >= 8 ? CKGtet((ifdefs * (((ecki for 32)(sTED _f de)) >> 3)) : CKGtet((t((ifdefs * ((ecki for 32)(sTED _f de)))r+ 7) >> 3) ) */
#d vaOUT_OF_RANGE rPPORTED)rt32_feNGht32_s outsidvo hin ER nnmpnmdeal-delta..mdeal+delta.  Each arguer a  * e GhtRAmrstwice.KGte"mdeal" and "delta"eee me'
G f dtimande, ne rn_WCwsimplenmpnmpnfd,pe, "NGht3" agvari PNG.#efi(Ppl tine_GC-
#en6 JBt2ine_GC#if d vaOUT_OF_RANGE(_set_,fmdeal, delta)rCKGtette_t(t(_set_) < Gmdeal)-(delta)r||t(_set_) > Gmdeal)+(delta)r) */
#vari PNGsFdecladim_in
es ltd- _ptr_tte    s*ran_GC#if d vaNO_EXTEer. ocND_GAMMA_UNIQUE  NO_EXTEer)r||tMMA_UNIQUE  ALWAYS_EXTEer)tusreRT(inl to cha*/
endstart) Psidp m umi wrfll_for ._cha   tr mallo of GLOBALpARRAYSPPORTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatiog[8] nth.c anscale to 24iog UPPOsig  PNGA(r));)nthed, dn PNG_6 */
   NO_EXTEer. octusrCdtimandisidp ms umi lnING_ ,
   rorsO.teIev,
      al truchwr ,
  XPORescale t)
/*Time.te_rl_readcdtranmnov_GRAY_Sfof
*/
emacro_in
es ltd frBSFfate_rtr mit'le      om file_GC#if d vaIHDRi* tim/(voi PNG (voiIHDR[5] = { 73,  72,  68,  82, '\0'}le_GC#if d vaIDATf* tim/(voi PNG (voiIDAT[5] = { 73,  68,  65,  84, '\0'}le_GC#if d vaIENDgR tim/(voi PNG (voiIEND[5] = { 73,  69,  78,  68, '\0'}le_GC#if d vafndefR tim/(voi PNG (voifnde[5] = { 80,  76,  84,  69, '\0'}le_GC#if d va(KGDfR tim/(voi PNG (voi(KGD[5] = { 98,  75,  71,  68, '\0'}le_GC#if d va HRMgR tim/(voi PNG (voi HRM[5] = { 99,  72,  82,  77, '\0'}le_GC#if d vatA*/gR tim/(voi PNG (voitA*/[5] = {103,  65,  77,  65, '\0'}le_GC#if d vahISTgR tim/(voi PNG (voihIST[5] = {104,  73,  83,  84, '\0'}le_GC#if d vanCCPgR tim/(voi PNG (voinCCP[5] = {105,  67,  67,  80, '\0'}le_GC#if d vanTXtgR tim/(voi PNG (voinTXt[5] = {105,  84,  88, 116, '\0'}le_GC#if d vaoFFs   tim/(voi PNG (voioFFs[5] = {111,  70,  70, 115, '\0'}le_GC#if d va_CAL   tim/(voi PNG (voi_CAL[5] = {112,  67,  65,  76, '\0'}le_GC#if d vasCAL   tim/(voi PNG (voisCAL[5] = {115,  67,  65,  76, '\0'}le_GC#if d vaaHYs   tim/(voi PNG (voi_HYs[5] = {112,  72,  89, 115, '\0'}le_GC#if d va BIT   tim/(voi PNG (voisBIT[5] = {115,  66,  73,  84, '\0'}le_GC#if d vaspng   tim/(voi PNG (voispng[5] = {115,  80,  76,  84, '\0'}le_GC#if d vaslesg  tim/(voi PNG (voisles[5] = {115,  82,  71,  66, '\0'}le_GC#if d vatEXtgR tim/(voi PNG (voitEXt[5] = {116,  69,  88, 116, '\0'}le_GC#if d vatIMEnR tim/(voi PNG (voitIME[5] = {116,  73,  77,  69, '\0'}le_GC#if d vatRNSnR tim/(voi PNG (voitRNS[5] = {116,  82,  78,  83, '\0'}le_GC#if d vazTXtgR tim/(voi PNG (voizTXt[5] = {122,  84,  88, 116, '\0'}la   tr mallo of GLOBALpARRAYSPTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatIHDR[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatIDAT[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatIEND[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatfnde[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culat(KGD[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culat HRM[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culattA*/[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culathIST[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatnCCP[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatnTXt[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatoFFs[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culat_CAL[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatsCAL[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culat_HYs[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatsBIT[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatspng[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatsles[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culattEXt[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culattIME[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culattRNS[5];PTEDPNG_REA_VARt * tim/(voi PNG FARDATA)culatzTXt[5];Pn PNG_6 */
    of GLOBALpARRAYS. octtusrIfpng_emacros*ran_ogNGseIF rfors,pnge pale_T(png_s_input buffPOe (aoEs _bytrequire e   /,
 xterln p m anxtecatnt_infome   /usalefll_ PNG orderpngtSUP(MSB_forstu_readon) orts unalig__wiB, orsio4EXPOR I tptr  e   /P   /PCGAMMAn
big- PNGNSFs dftruct680x0 G_WRt fPoptr_og_ste   /te PNon) ortttptsP_   th_r                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  