/* Copyright (C) 2004 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define _GNU_SOURCE

#include <stdio.h>
#include <syslog.h>
#include <stdarg.h>
#include <stdlib.h>
#include "logging.h"

static char *msg_table[] = {
  "NULL",
  "path specification denied - by=%u",
  "permission denied - name=%s, id=%u, by=%u",
  "password aging information displayed - user=%s, uid=%u, by=%u",
  "group is unknown - group=%s, by=%u",
  "user changing the password for group - group=%s, by=%u",
  "password change aborted - for=%s, by=%u",
  "password modification exceeded max tries, aborted - group=%s, by=%u",
  "failed to change group password - group=%s, by=%u",
  "group password removed - group=%s, by=%u",
  "group password changed - group=%s, by=%u",
  "can't get unique gid in range %u - %u",
  "GID %u is not unique - by=%u",
  "invalid name - group=%s, by=%u",
  "cannot lock group file: already locked",
  "group already exists - group=%s, by=%u",
  "failed to add new group - group=%s, gid=%u, by=%u",
  "new group added - group=%s, gid=%u, by=%u"};

void (*sec_log_fnc) (const char *program, unsigned int id, ...) = NULL;

static void
sec_log_internal (const char *program __attribute__((unused)),
		  unsigned int id, ...)
{
  va_list ap;

  if (id > sizeof (msg_table) / sizeof (char *))
    abort ();

  va_start (ap, id);
#if 0
  char *buf;
  if (asprintf (&buf, "%s: %s", program, msg_table[id]) > 0)
    {
      vsyslog (LOG_INFO, buf, ap);
      free (buf);
    }
  else
    { /* Run out of memory ... */
      char buf2[1024];
      snprintf (buf2, sizeof (buf2), "%s: %s", program, msg_table[id]);
      vsyslog (LOG_INFO, buf2, ap);
    }
#else
  vsyslog (LOG_INFO, msg_table[id], ap);
#endif
  va_end (ap);
}

void
open_sec_log (void)
{
  sec_log_fnc = sec_log_internal;
}
