; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -basic-aa -inline -enable-noalias-to-md-conversion -S < %s | FileCheck %s
; RUN: opt -aa-pipeline=basic-aa -passes=inline -enable-noalias-to-md-conversion -S < %s | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare void @llvm.experimental.noalias.scope.decl(metadata) #0

define void @caller_equals_callee(i32* noalias %p0, i32* noalias %p1, i32 %cnt) {
; CHECK-LABEL: define {{[^@]+}}@caller_equals_callee
; CHECK-SAME: (i32* noalias [[P0:%.*]], i32* noalias [[P1:%.*]], i32 [[CNT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[P0]], i64 2
; CHECK-NEXT:    [[ADD_PTR1:%.*]] = getelementptr inbounds i32, i32* [[P1]], i64 2
; CHECK-NEXT:    tail call void @llvm.experimental.noalias.scope.decl(metadata !0)
; CHECK-NEXT:    tail call void @llvm.experimental.noalias.scope.decl(metadata !3)
; CHECK-NEXT:    store i32 10, i32* [[ADD_PTR]], align 4, !alias.scope !0, !noalias !3
; CHECK-NEXT:    store i32 20, i32* [[ADD_PTR1]], align 4, !alias.scope !3, !noalias !0
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[CNT]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 11, i32* [[P0]], align 4
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    [[ADD_PTR2:%.*]] = getelementptr inbounds i32, i32* [[P1]], i64 1
; CHECK-NEXT:    [[ADD_PTR3:%.*]] = getelementptr inbounds i32, i32* [[P0]], i64 1
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !5)
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !8)
; CHECK-NEXT:    [[ADD_PTR_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR2]], i64 2
; CHECK-NEXT:    [[ADD_PTR1_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR3]], i64 2
; CHECK-NEXT:    tail call void @llvm.experimental.noalias.scope.decl(metadata !10), !noalias !13
; CHECK-NEXT:    tail call void @llvm.experimental.noalias.scope.decl(metadata !14), !noalias !13
; CHECK-NEXT:    store i32 10, i32* [[ADD_PTR_I]], align 4, !alias.scope !16, !noalias !17
; CHECK-NEXT:    store i32 20, i32* [[ADD_PTR1_I]], align 4, !alias.scope !17, !noalias !16
; CHECK-NEXT:    store i32 11, i32* [[ADD_PTR2]], align 4, !alias.scope !5, !noalias !8
; CHECK-NEXT:    store i32 12, i32* [[P1]], align 4
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr inbounds i32, i32* %p0, i64 2
  %add.ptr1 = getelementptr inbounds i32, i32* %p1, i64 2
  tail call void @llvm.experimental.noalias.scope.decl(metadata !0)
  tail call void @llvm.experimental.noalias.scope.decl(metadata !3)
  store i32 10, i32* %add.ptr, align 4, !alias.scope !0, !noalias !3
  store i32 20, i32* %add.ptr1, align 4, !alias.scope !3, !noalias !0
  %cmp = icmp eq i32 %cnt, 0
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i32 11, i32* %p0, align 4
  br label %if.end

if.else:                                          ; preds = %entry
  %add.ptr2 = getelementptr inbounds i32, i32* %p1, i64 1
  %add.ptr3 = getelementptr inbounds i32, i32* %p0, i64 1
  tail call void @caller_equals_callee(i32* nonnull %add.ptr2, i32* nonnull %add.ptr3, i32 0)
  store i32 12, i32* %p1, align 4
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  ret void
}

define void @test01(i32* noalias %p0, i32* noalias %p1, i32 %cnt) {
; CHECK-LABEL: define {{[^@]+}}@test01
; CHECK-SAME: (i32* noalias [[P0:%.*]], i32* noalias [[P1:%.*]], i32 [[CNT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 13, i32* [[P0]], align 4
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[P0]], i64 1
; CHECK-NEXT:    [[ADD_PTR1:%.*]] = getelementptr inbounds i32, i32* [[P1]], i64 1
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !18)
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !21)
; CHECK-NEXT:    [[ADD_PTR_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR]], i64 2
; CHECK-NEXT:    [[ADD_PTR1_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR1]], i64 2
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !23), !noalias !26
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !27), !noalias !26
; CHECK-NEXT:    store i32 10, i32* [[ADD_PTR_I]], align 4, !alias.scope !29, !noalias !30
; CHECK-NEXT:    store i32 20, i32* [[ADD_PTR1_I]], align 4, !alias.scope !30, !noalias !29
; CHECK-NEXT:    [[CMP_I:%.*]] = icmp eq i32 [[CNT]], 0
; CHECK-NEXT:    br i1 [[CMP_I]], label [[IF_THEN_I:%.*]], label [[IF_ELSE_I:%.*]]
; CHECK:       if.then.i:
; CHECK-NEXT:    store i32 11, i32* [[ADD_PTR]], align 4, !alias.scope !18, !noalias !21
; CHECK-NEXT:    br label [[CALLER_EQUALS_CALLEE_EXIT:%.*]]
; CHECK:       if.else.i:
; CHECK-NEXT:    [[ADD_PTR2_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR1]], i64 1
; CHECK-NEXT:    [[ADD_PTR3_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR]], i64 1
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !31), !noalias !26
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !34), !noalias !26
; CHECK-NEXT:    [[ADD_PTR_I_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR2_I]], i64 2
; CHECK-NEXT:    [[ADD_PTR1_I_I:%.*]] = getelementptr inbounds i32, i32* [[ADD_PTR3_I]], i64 2
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !36), !noalias !39
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !40), !noalias !39
; CHECK-NEXT:    store i32 10, i32* [[ADD_PTR_I_I]], align 4, !alias.scope !42, !noalias !43
; CHECK-NEXT:    store i32 20, i32* [[ADD_PTR1_I_I]], align 4, !alias.scope !43, !noalias !42
; CHECK-NEXT:    store i32 11, i32* [[ADD_PTR2_I]], align 4, !alias.scope !44, !noalias !45
; CHECK-NEXT:    store i32 12, i32* [[ADD_PTR1]], align 4, !alias.scope !21, !noalias !18
; CHECK-NEXT:    br label [[CALLER_EQUALS_CALLEE_EXIT]]
; CHECK:       caller_equals_callee.exit:
; CHECK-NEXT:    ret void
;
entry:
  store i32 13, i32* %p0, align 4
  %add.ptr = getelementptr inbounds i32, i32* %p0, i64 1
  %add.ptr1 = getelementptr inbounds i32, i32* %p1, i64 1
  call void @caller_equals_callee(i32* nonnull %add.ptr, i32* nonnull %add.ptr1, i32 %cnt)
  ret void
}

attributes #0 = { inaccessiblememonly nofree nosync nounwind willreturn }

!0 = !{!1}
!1 = distinct !{!1, !2, !"do_store: %p0"}
!2 = distinct !{!2, !"do_store"}
!3 = !{!4}
!4 = distinct !{!4, !2, !"do_store: %p1"}

; CHECK: !0 = !{!1}
; CHECK: !1 = distinct !{!1, !2, !"do_store: %p0"}
; CHECK: !2 = distinct !{!2, !"do_store"}
; CHECK: !3 = !{!4}
; CHECK: !4 = distinct !{!4, !2, !"do_store: %p1"}
; CHECK: !5 = !{!6}
; CHECK: !6 = distinct !{!6, !7, !"caller_equals_callee: %p0"}
; CHECK: !7 = distinct !{!7, !"caller_equals_callee"}
; CHECK: !8 = !{!9}
; CHECK: !9 = distinct !{!9, !7, !"caller_equals_callee: %p1"}
; CHECK: !10 = !{!11}
; CHECK: !11 = distinct !{!11, !12, !"do_store: %p0"}
; CHECK: !12 = distinct !{!12, !"do_store"}
; CHECK: !13 = !{!6, !9}
; CHECK: !14 = !{!15}
; CHECK: !15 = distinct !{!15, !12, !"do_store: %p1"}
; CHECK: !16 = !{!11, !6}
; CHECK: !17 = !{!15, !9}

; CHECK: !18 = !{!19}
; CHECK: !19 = distinct !{!19, !20, !"caller_equals_callee: %p0"}
; CHECK: !20 = distinct !{!20, !"caller_equals_callee"}
; CHECK: !21 = !{!22}
; CHECK: !22 = distinct !{!22, !20, !"caller_equals_callee: %p1"}
; CHECK: !23 = !{!24}
; CHECK: !24 = distinct !{!24, !25, !"do_store: %p0"}
; CHECK: !25 = distinct !{!25, !"do_store"}
; CHECK: !26 = !{!19, !22}
; CHECK: !27 = !{!28}
; CHECK: !28 = distinct !{!28, !25, !"do_store: %p1"}
; CHECK: !29 = !{!24, !19}
; CHECK: !30 = !{!28, !22}
; CHECK: !31 = !{!32}
; CHECK: !32 = distinct !{!32, !33, !"caller_equals_callee: %p0"}
; CHECK: !33 = distinct !{!33, !"caller_equals_callee"}
; CHECK: !34 = !{!35}
; CHECK: !35 = distinct !{!35, !33, !"caller_equals_callee: %p1"}
; CHECK: !36 = !{!37}
; CHECK: !37 = distinct !{!37, !38, !"do_store: %p0"}
; CHECK: !38 = distinct !{!38, !"do_store"}
; CHECK: !39 = !{!32, !35, !19, !22}
; CHECK: !40 = !{!41}
; CHECK: !41 = distinct !{!41, !38, !"do_store: %p1"}
; CHECK: !42 = !{!37, !32, !22}
; CHECK: !43 = !{!41, !35, !19}
; CHECK: !44 = !{!32, !22}
; CHECK: !45 = !{!35, !19}
