/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class AbstractAncestrisContextAction
extends AbstractAncestrisAction
implements LookupListener {
    protected Lookup context;
    protected Lookup.Result<Property> lkpInfo;
    protected List<Property> contextProperties = new ArrayList<Property>(5);

    public AbstractAncestrisContextAction() {
        this.putValue("hideWhenDisabled", true);
        this.context = org.openide.util.Utilities.actionsGlobalContext();
    }

    public AbstractAncestrisContextAction(Gedcom ged, ImageIcon img, String text) {
        this();
        this.setImageText(img, text);
    }

    public final void setImageText(ImageIcon img, String text) {
        super.setImage(img);
        super.setText(text);
        super.setTip(text);
    }

    public Gedcom getGedcom() {
        Context dc;
        Gedcom gedcom = Utilities.getGedcomFromContext(this.context);
        if (gedcom == null && (dc = this.getDefaultContext()) != null) {
            gedcom = dc.getGedcom();
        }
        return gedcom;
    }

    protected Context getDefaultContext() {
        List<Context> gedcontexts = GedcomDirectory.getDefault().getContexts();
        if (gedcontexts.size() >= 1) {
            return gedcontexts.get(0);
        }
        return null;
    }

    protected Context getContext() {
        if (this.contextProperties.isEmpty()) {
            return null;
        }
        Property p = this.contextProperties.get(0);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.add(p.getEntity());
        return new Context(p.getGedcom(), entities, this.contextProperties);
    }

    protected void setContextProperties(Collection<? extends Property> props) {
        this.contextProperties.clear();
        this.contextProperties.addAll(props);
    }

    protected void setContextProperties(Property prop) {
        this.contextProperties.clear();
        this.contextProperties.add(prop);
    }

    @Override
    public boolean isEnabled() {
        this.initLookupListner();
        return super.isEnabled();
    }

    protected void initLookupListner() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.context == null) {
            return;
        }
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(Property.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        Context dc;
        if (this.lkpInfo != null) {
            this.contextProperties.clear();
            this.contextProperties.addAll(this.lkpInfo.allInstances());
        }
        if (this.contextProperties.isEmpty() && (dc = this.getDefaultContext()) != null) {
            List<? extends Property> props = dc.getProperties();
            if (props.isEmpty()) {
                props = dc.getEntities();
            }
            this.contextProperties.addAll(props);
        }
        this.contextChanged();
    }

    protected void contextChanged() {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getGedcom() == null) {
            return;
        }
        this.initLookupListner();
        this.actionPerformedImpl(event);
        this.resultChanged(null);
    }

    protected abstract void actionPerformedImpl(ActionEvent var1);
}

