/*
 * Decompiled with CFR 0.152.
 */
package genj.crypto;

import java.io.IOException;

public abstract class Enigma {
    private static final String IMPL = "genj.crypto.EnigmaImpl";
    private static final String PREFIX = "[private]";
    private static boolean isAvailable = Enigma.getInstance("") != null;

    public static Enigma getInstance(String password) {
        try {
            return ((Enigma)Class.forName(IMPL).newInstance()).init(password);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static boolean isEncrypted(String value) {
        return value.startsWith(PREFIX);
    }

    public String encrypt(String value) throws IOException {
        return PREFIX + this.encryptImpl(value);
    }

    public String decrypt(String value) throws IOException {
        if (!Enigma.isEncrypted(value)) {
            throw new IOException("Not an encrypted value");
        }
        return this.decryptImpl(value.substring(PREFIX.length()));
    }

    protected abstract Enigma init(String var1);

    protected abstract String encryptImpl(String var1) throws IOException;

    protected abstract String decryptImpl(String var1) throws IOException;
}

